/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;

public class PromptUser {
    private NApplyData data;
    private OneOffEntry[] patchesToApply;
    private OneOffEntry[] patchesAgain;

    public PromptUser(NApplyData data) {
        this.data = data;
    }

    public void prompt(NApplyData data) {
        int len = 0;
        boolean miniPatchsetInvolved = false;
        ArrayList<OneOffEntry> patchesToRunAgain = new ArrayList<OneOffEntry>();
        this.patchesToApply = data.getPatchesToApply();
        for (int i2 = 0; i2 < this.patchesToApply.length; ++i2) {
            String id = this.patchesToApply[i2].getID();
            if (data.getConflictPatchesInNApplyList().contains(id) && (!this.patchesToApply[i2].isMiniPatchSet() || OPatchEnv.isIgnoreConflict())) continue;
            patchesToRunAgain.add(this.patchesToApply[i2]);
            if (!this.patchesToApply[i2].isMiniPatchSet() || OPatchEnv.isIgnoreConflict()) continue;
            miniPatchsetInvolved = true;
        }
        len = patchesToRunAgain.size();
        this.patchesAgain = new OneOffEntry[len];
        patchesToRunAgain.toArray(this.patchesAgain);
        String[] list = new String[len];
        for (int i3 = 0; i3 < len; ++i3) {
            list[i3] = this.patchesAgain[i3].getID();
        }
        try {
            NapplyProcessHelper.checkEmptyPatchList(this.patchesAgain);
        }
        catch (RuntimeException e2) {
            StringBuffer buff = new StringBuffer("After skipping conflicting patches, ");
            buff.append("there is no patch to apply.");
            OPatchStateManagerFactory.getInstance().setErrorCode(64);
            throw new RuntimeException(buff.toString());
        }
        if (OPatchEnv.isIgnoreConflict()) {
            this.skipConflict(data);
        } else {
            if (!miniPatchsetInvolved) {
                String cmd = NapplyProcessHelper.getNApplyCmdToRunAgain(list);
                OLogger.onlyLogInfo("OUI-67124", new Object[]{cmd});
                StringBuffer buff = new StringBuffer("NApply stops on user's request.");
                throw new PrereqFailedException(buff.toString());
            }
            if (data.getRollbackFlag() && data.getRollbackPatches().size() != 0) {
                StringBuffer dBuff = new StringBuffer(" has auto-rollback");
                OLogger.debug(dBuff);
                OLogger.warn("OUI-67303", new Object[]{data.getHasAutoRollbackMsg()});
            }
            if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
                StringBuffer dBuff = new StringBuffer(" Stop on user's request.");
                OLogger.debug(dBuff);
                StringBuffer buff = new StringBuffer("NApply stops on user's request.");
                throw new ExitOPatchException(buff.toString());
            }
        }
    }

    private void skipConflict(NApplyData data) {
        StringBuffer dBuff = new StringBuffer("Proceed to apply w/o conflicting patches");
        OLogger.debug(dBuff);
        this.patchesToApply = this.patchesAgain;
        data.setApOneOffs(this.patchesAgain);
        data.setPatchesToApply(this.patchesToApply);
        StringBuffer proceedList = new StringBuffer();
        for (int i2 = 0; i2 < this.patchesAgain.length; ++i2) {
            OneOffEntry oe = this.patchesToApply[i2];
            proceedList.append(oe.getID()).append("  ");
        }
        data.setProceedList(proceedList.toString());
        OneOffEntry[] autoRBList = OPatchUtilHelper.getAutoRollbackOneOffs();
        ArrayList<OneOffEntry> newAutoRBList = new ArrayList<OneOffEntry>();
        OneOffEntry[] patchesToMerge = data.getMergedPatches().getAllElements();
        for (int i3 = 0; i3 < autoRBList.length; ++i3) {
            OneOffEntry rbPatch = autoRBList[i3];
            String autoRBID = rbPatch.getID();
            boolean presentInMergeRequest = false;
            for (int j2 = 0; j2 < patchesToMerge.length; ++j2) {
                String mergeID = patchesToMerge[j2].getID();
                if (!mergeID.equals(autoRBID)) continue;
                presentInMergeRequest = true;
                break;
            }
            if (presentInMergeRequest) continue;
            newAutoRBList.add(rbPatch);
        }
        autoRBList = new OneOffEntry[newAutoRBList.size()];
        newAutoRBList.toArray(autoRBList);
        OPatchUtilHelper.setAutoRollbackOneOffs(autoRBList);
        StringBuffer buff = new StringBuffer("Conflict detected and skipped. OPatch proceeds with patches: ");
        buff.append(proceedList.toString());
        if (autoRBList.length > 0) {
            buff.append("while the following patches will be rolled back: ");
            for (int i4 = 0; i4 < autoRBList.length; ++i4) {
                buff.append(autoRBList[i4].getID()).append("  ");
            }
        }
        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        OUSession.setPrereqResult(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, PrereqResult.ExecuteStatus.PASSED);
    }
}

