/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NApplyDataSerializer {
    public void serializeFileVersion(String serialFilePath, Map<String, String> FV) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (String filename : FV.keySet()) {
            String escapedFilename = new String(filename.replace(" ", "\\ "));
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(FV.get(filename));
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public Map<String, String> deserializeFileVersion(String serialFilePath) throws IOException {
        HashMap<String, String> FV = new HashMap<String, String>();
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        for (Object filename : prop.keySet()) {
            String version = prop.getProperty((String)filename);
            FV.put((String)filename, version);
        }
        return FV;
    }

    public void serializePrereqResult(String serialFilePath, HashMap PR) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (Object prereqname : PR.keySet()) {
            String sep;
            OPatchPatchPrereq pr = (OPatchPatchPrereq)prereqname;
            String pValue = String.valueOf(pr.getValue());
            OPatchTarget.StatusCheck sc = (OPatchTarget.StatusCheck)PR.get(pr);
            String rStatus = String.valueOf(sc.getStatusCode());
            String rResult = sc.getResult();
            if (rResult.contains(sep = System.getProperty("line.separator"))) {
                StringBuilder rResultBuilder = new StringBuilder();
                String[] rResultLines = rResult.split("\\r?\\n");
                for (int i2 = 0; i2 < rResultLines.length - 1; ++i2) {
                    rResultBuilder.append(rResultLines[i2]);
                    rResultBuilder.append("\\n");
                }
                rResultBuilder.append(rResultLines[rResultLines.length - 1]);
                rResult = rResultBuilder.toString();
            }
            buffer.append(pValue);
            buffer.append("=");
            buffer.append(rStatus);
            buffer.append(";");
            buffer.append(rResult);
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public HashMap deserializePrereqResult(String serialFilePath) throws IOException {
        HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> PR = new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>();
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        for (Object prereqname : prop.keySet()) {
            int pValue = Integer.parseInt((String)prereqname);
            if (pValue >= 0 && pValue <= 41) {
                OPatchPatchPrereq prereq = OPatchPatchPrereq.getInstance((int)pValue);
                String[] results = prop.getProperty((String)prereqname).split(";");
                int rStatus = Integer.parseInt(results[0]);
                String rResult = results[1];
                OPatchTarget.StatusCheck sc = new OPatchTarget.StatusCheck(rStatus, rResult);
                PR.put(prereq, sc);
                continue;
            }
            return null;
        }
        return PR;
    }

    public void serializeHashValue(String serialFilePath, IndexPair hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash.getFirstKey());
        buffer.append("\n");
        buffer.append("Pi_hash=");
        buffer.append(hash.getSecondKey());
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public IndexPair deserializeHashValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        IndexPair hash = new IndexPair(prop.getProperty("Poh_hash"), prop.getProperty("Pi_hash"));
        return hash;
    }

    public void serializeOhHashValue(String serialFilePath, String hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public String deserializeOhHashValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String hash = prop.getProperty("Poh_hash");
        return hash;
    }

    public void serializeNoOpCheckResult(String serialFilePath, Vector noOps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("noOp_oneoffs=");
        for (int i2 = 0; i2 < noOps.size(); ++i2) {
            String noopPatchID = (String)noOps.get(i2);
            buffer.append(noopPatchID);
            buffer.append(";");
        }
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public String[] deserializeNoOpCheckResult(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String[] noopPatchIDs = prop.getProperty("noOp_oneoffs").split(";");
        return noopPatchIDs;
    }

    public void serializePiComponents(String serialFilePath, HashSet<IndexPair> comps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (IndexPair comp : comps) {
            buffer.append(comp.getFirstKey());
            buffer.append("=");
            buffer.append(comp.getSecondKey());
            buffer.append("\n");
        }
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public HashSet<IndexPair> deserializePiComponents(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        HashSet<IndexPair> comps = new HashSet<IndexPair>();
        for (Object compName : prop.keySet()) {
            String compVer = prop.getProperty((String)compName);
            IndexPair nameVer = new IndexPair((String)compName, compVer);
            comps.add(nameVer);
        }
        return comps;
    }

    public void serializeTime(String serialFilePath) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("start_time=");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        String formattedDate = dateFormatter.format(new Date());
        buffer.append(formattedDate);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public Date deserializeTime(String serialFilePath) throws IOException {
        Date date;
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String s = prop.getProperty("start_time");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        try {
            date = dateFormatter.parse(s);
        }
        catch (ParseException e2) {
            e2.printStackTrace();
            return null;
        }
        return date;
    }

    public void serializeBackUpStatus(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("do_backup=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public boolean deserializeBackUpStatus(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return false;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String s = prop.getProperty("do_backup");
        return s.equals("true");
    }

    public void serializeCASNapplyStatus(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("cas_napply=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public boolean deserializeCASNapplyStatus(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return false;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String s = prop.getProperty("cas_napply");
        return s.equals("true");
    }

    public void renameCachedFiles(String oldFilePath, String newFilePath) {
        File nf = new File(newFilePath);
        File of = new File(oldFilePath);
        of.renameTo(nf);
    }

    public void removeCachedFiles(String FilePath) {
        File f2 = new File(FilePath);
        if (f2.exists()) {
            f2.delete();
        }
    }

    public void serializeStringValue(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("value=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public String deserializeStringValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(serialFilePath));
        String s = prop.getProperty("value");
        return s;
    }
}

