/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.CompositePatchCategorizer;
import oracle.opatch.conflicttextualinterpreter.GraphHelper;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.IntraConflictException;
import oracle.opatch.conflicttextualinterpreter.InvalidPSUTrainException;
import oracle.opatch.conflicttextualinterpreter.MoreThanTwoPSUTrainException;
import oracle.opatch.conflicttextualinterpreter.MultiCompositeException;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.OPatchValidationException;
import oracle.opatch.conflicttextualinterpreter.PrereqNotExistException;
import oracle.opatch.conflicttextualinterpreter.SubsetOverlaySupersetException;

public class Validation
implements IStep {
    public void process(IConflictMap map, INPatchPlan plan) throws OPatchValidationException {
        Collection<IPatch> pis = map.getPi();
        this.checkMoreThanOnePSU(pis);
        this.checkConflictAmongPatches(map);
        this.checkPrereqLoop(pis);
        this.checkPrereqSatisfied(map);
        this.checkPSURelation(map);
        this.checkMoreThanTwoPSUTrain(map);
        this.checkSubsetOverlaySuperset(map);
    }

    private void checkMoreThanOnePSU(Collection pis) throws OPatchValidationException {
        ArrayList<IPatch> compositePatches = new ArrayList<IPatch>();
        int count = 0;
        for (Object o2 : pis) {
            IPatch pi = (IPatch)o2;
            if (!pi.isComposite()) continue;
            compositePatches.add(pi);
            ++count;
        }
        if (count > 1) {
            throw new MultiCompositeException(compositePatches);
        }
    }

    private void checkConflictAmongPatches(IConflictMap map) throws IntraConflictException {
        Collection<IPatch> pis = map.getPi();
        Iterator<IPatch> iterator = pis.iterator();
        while (iterator.hasNext()) {
            IPatch o2;
            IPatch pi = o2 = iterator.next();
            Collection<NPatchRelation> conflictRelations = map.getRelations(pi).getWholeConflicts();
            for (NPatchRelation conflictRelation : conflictRelations) {
                IPatch poh = conflictRelation.to();
                if (poh.isInOh()) continue;
                throw new IntraConflictException(conflictRelation);
            }
        }
    }

    private void checkPrereqLoop(Collection patches) throws OPatchValidationException {
        GraphHelper gHelper = new GraphHelper();
        if (gHelper.isCycle(patches)) {
            throw new OPatchValidationException(OPatchValidationException.ExceptionCode.PREREQ_OVERLAY_CYCLE);
        }
    }

    private void checkPrereqSatisfied(IConflictMap map) throws OPatchValidationException {
        HashSet<String> allPatchIDs = new HashSet<String>();
        Collection<IPatch> pis = map.getPi();
        for (IPatch pi : pis) {
            if (pi.isComposite()) {
                Collection<IPatch> subpatches = pi.getSubPatches();
                for (IPatch subpatch : subpatches) {
                    allPatchIDs.add(subpatch.getPatchId());
                }
            }
            allPatchIDs.add(pi.getPatchId());
        }
        Collection<IPatch> pohs = map.getPoh();
        for (IPatch poh : pohs) {
            allPatchIDs.add(poh.getPatchId());
        }
        if (!map.isPohExist()) {
            return;
        }
        for (IPatch pi : pis) {
            Collection<String> prereqs = pi.getPrereqsID();
            HashSet<String> nonExistPrereqs = new HashSet<String>();
            for (String prereq : prereqs) {
                if (allPatchIDs.contains(prereq)) continue;
                nonExistPrereqs.add(prereq);
            }
            if (nonExistPrereqs.isEmpty()) continue;
            throw new PrereqNotExistException(pi, nonExistPrereqs);
        }
    }

    private void checkPSURelation(IConflictMap map) throws InvalidPSUTrainException {
        ArrayList<IPatch> compositePatches = new ArrayList<IPatch>();
        Collection<IPatch> pis = map.getPi();
        for (IPatch o2 : pis) {
            IPatch pi = o2;
            Collection<NPatchRelation> relations = map.getRelations(pi).getInvalidPSU();
            if (relations.isEmpty()) continue;
            for (NPatchRelation relation : relations) {
                compositePatches.add(relation.to());
            }
            compositePatches.add(pi);
            throw new InvalidPSUTrainException(compositePatches);
        }
    }

    private void checkMoreThanTwoPSUTrain(IConflictMap map) throws MoreThanTwoPSUTrainException {
        OneOffEntry[] inactivePSUTrain = CompositePatchCategorizer.getInactivePSUTrain();
        if (inactivePSUTrain != null && inactivePSUTrain.length > 0) {
            ArrayList<IPatch> compositePatches = new ArrayList<IPatch>();
            Collection<IPatch> pis = map.getPi();
            for (IPatch o2 : pis) {
                IPatch pi = o2;
                Collection<NPatchRelation> relations = map.getRelations(pi).getSupersetPSU();
                if (relations.isEmpty()) continue;
                for (NPatchRelation relation : relations) {
                    compositePatches.add(relation.to());
                }
                throw new MoreThanTwoPSUTrainException(compositePatches);
            }
        }
    }

    private void checkSubsetOverlaySuperset(IConflictMap map) throws OPatchValidationException {
        Collection beOverlayedPatches;
        Collection<String> overlays;
        for (IPatch pi : map.getPi()) {
            if (pi.isComposite()) continue;
            overlays = pi.getOverlaysID();
            for (String beOverlayID : overlays) {
                beOverlayedPatches = map.getPatches(beOverlayID);
                for (IPatch beOverlayedPatch : beOverlayedPatches) {
                    if (beOverlayedPatch.getBugs().size() < pi.getBugs().size() || !beOverlayedPatch.getBugs().containsAll(pi.getBugs())) continue;
                    throw new SubsetOverlaySupersetException(pi, beOverlayedPatch);
                }
            }
        }
        for (IPatch poh : map.getPoh()) {
            if (poh.isComposite()) continue;
            overlays = poh.getOverlaysID();
            for (String beOverlayID : overlays) {
                beOverlayedPatches = map.getPatches(beOverlayID);
                for (IPatch beOverlayedPatch : beOverlayedPatches) {
                    if (beOverlayedPatch.isInOh() || beOverlayedPatch.getBugs().size() < poh.getBugs().size() || !beOverlayedPatch.getBugs().containsAll(poh.getBugs())) continue;
                    throw new SubsetOverlaySupersetException(poh, beOverlayedPatch);
                }
            }
        }
    }
}

