/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.IPatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Patch
implements IPatch {
    private boolean isInOH = false;
    private boolean isActive = true;
    private boolean isSubSetOfBigPoh = false;
    private boolean isSubSetOfBigPi = false;
    private boolean isECPB = false;
    private boolean removeInactiveSubset = false;
    private OneOffEntry oneOffEntry = null;
    private HashSet<String> bugs = new HashSet();
    private HashSet<String> files = new HashSet();
    private HashSet<String> overlays = new HashSet();
    private HashSet<String> prereqs = new HashSet();
    private HashSet<String> beingOverlays = new HashSet();
    private HashSet<String> beingPrereqs = new HashSet();
    private ArrayList<IPatch> subPatches = new ArrayList();
    private ArrayList<IPatch> activeSubPatches = new ArrayList();
    private IPatch parent = null;

    public Patch(OneOffEntry oneOffEntry, boolean isInOH) {
        this.oneOffEntry = oneOffEntry;
        this.isInOH = isInOH;
    }

    @Override
    public Set<String> getBugs() {
        return this.bugs;
    }

    @Override
    public Set<String> getFiles() {
        return this.files;
    }

    @Override
    public Collection<String> getOverlaysID() {
        return this.overlays;
    }

    @Override
    public Collection<String> getPrereqsID() {
        return this.prereqs;
    }

    @Override
    public Collection<String> getBeingOverlaysID() {
        return this.beingOverlays;
    }

    @Override
    public Collection<String> getBeingPrereqsID() {
        return this.beingPrereqs;
    }

    @Override
    public Collection<IPatch> getSubPatches() {
        return this.subPatches;
    }

    @Override
    public boolean isInOh() {
        return this.isInOH;
    }

    @Override
    public Collection<IPatch> getActiveSubPatches() {
        return this.activeSubPatches;
    }

    @Override
    public boolean isComposite() {
        return this.oneOffEntry.getIsComposite();
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    public void addBug(String bug) {
        this.bugs.add(bug);
    }

    @Override
    public void addSubPatch(IPatch patch) {
        this.subPatches.add(patch);
        ((Patch)patch).setParent(this);
    }

    @Override
    public void addActiveSubPatch(IPatch patch) {
        this.activeSubPatches.add(patch);
    }

    @Override
    public void setInActive() {
        this.isActive = false;
    }

    @Override
    public void setActive() {
        this.isActive = true;
    }

    @Override
    public void addOverlay(String patchId) {
        this.overlays.add(patchId);
    }

    @Override
    public void addPrereq(String patchId) {
        this.prereqs.add(patchId);
    }

    @Override
    public void addBeingPrereq(String patchId) {
        this.beingPrereqs.add(patchId);
    }

    @Override
    public void addBeingOverlay(String patchId) {
        this.beingOverlays.add(patchId);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isTopLevelPSU() {
        return this.isComposite() && this.oneOffEntry.getConstituentActiveField().equals(this.oneOffEntry.getID());
    }

    @Override
    public String getPatchId() {
        return this.oneOffEntry.getID();
    }

    @Override
    public String getTripletId() {
        return this.oneOffEntry.getTripletID();
    }

    @Override
    public OneOffEntry getOneOffEntry() {
        return this.oneOffEntry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.isInOH) {
            result = 17;
        }
        result = 31 * result + (this.oneOffEntry.getTripletID() == null ? 0 : this.oneOffEntry.getTripletID().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Patch other = (Patch)obj;
        return this.oneOffEntry.getTripletID().equals(other.getOneOffEntry().getTripletID()) && this.isInOH == other.isInOH;
    }

    private void setParent(IPatch patch) {
        this.parent = patch;
    }

    @Override
    public IPatch getParent() {
        if (!this.isComposite() || this.isTopLevelPSU()) {
            return this;
        }
        return this.parent;
    }

    @Override
    public boolean isSubSetOfBigPi() {
        return this.isSubSetOfBigPi;
    }

    @Override
    public void setSubSetOfBigPi(boolean isSubSetOfBigPi) {
        this.isSubSetOfBigPi = isSubSetOfBigPi;
    }

    @Override
    public boolean isSubSetOfBigPoh() {
        return this.isSubSetOfBigPoh;
    }

    @Override
    public void setSubSetOfBigPoh(boolean isSubSetOfBigPoh) {
        this.isSubSetOfBigPoh = isSubSetOfBigPoh;
    }

    @Override
    public Set<String> getOverridingUPIs() {
        return this.oneOffEntry.getOverridingUPIs();
    }

    @Override
    public void setECPB(boolean isECPB) {
        this.isECPB = isECPB;
    }

    @Override
    public boolean isECPB() {
        return this.isECPB;
    }

    @Override
    public void setRemoveInactiveSubset(boolean removeInactiveSubset) {
        this.removeInactiveSubset = removeInactiveSubset;
    }

    @Override
    public boolean removeInactiveSubset() {
        return this.removeInactiveSubset;
    }
}

