/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelationDefinition;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMap
implements IConflictMap {
    private Collection<IPatch> pis = null;
    private Collection<IPatch> pohs = null;
    private HashMap<IPatch, NPatchRelations> relationsMap;
    private NPatchRelations empty = new NPatchRelations();
    private boolean isPohExist = true;

    public ConflictMap(Collection<IPatch> pis) {
        this.relationsMap = new HashMap(pis.size());
        this.pis = pis;
    }

    public ConflictMap(Collection<IPatch> pis, Collection<IPatch> pohs) {
        this.pis = pis;
        this.pohs = pohs;
        this.relationsMap = new HashMap(pis.size());
    }

    public ConflictMap(IConflictMap map) {
        this.pis = new ArrayList<IPatch>(map.getOriginalPi());
        this.pohs = new ArrayList<IPatch>(map.getPoh());
        this.isPohExist = map.isPohExist();
        HashMap<IPatch, NPatchRelations> oldRelationsMap = map.getRelationsMap();
        this.relationsMap = new HashMap(oldRelationsMap.size());
        Set<Map.Entry<IPatch, NPatchRelations>> set = oldRelationsMap.entrySet();
        for (Map.Entry<IPatch, NPatchRelations> entry : set) {
            this.relationsMap.put(entry.getKey(), new NPatchRelations(entry.getValue()));
        }
    }

    public ConflictMap(IConflictMap map, Collection<IPatch> tpohs) {
        this.pis = new ArrayList<IPatch>(map.getOriginalPi());
        this.pohs = new ArrayList<IPatch>(tpohs);
        HashMap<IPatch, NPatchRelations> oldRelationsMap = map.getRelationsMap();
        this.relationsMap = new HashMap(oldRelationsMap.size());
        Set<Map.Entry<IPatch, NPatchRelations>> set = oldRelationsMap.entrySet();
        for (Map.Entry<IPatch, NPatchRelations> entry : set) {
            this.relationsMap.put(entry.getKey(), new NPatchRelations(entry.getValue()));
        }
    }

    private void checkAndInitNPatchRelations(IPatch patch) {
        if (!this.relationsMap.containsKey(patch)) {
            this.relationsMap.put(patch, new NPatchRelations());
        }
    }

    protected void setPohs(Collection<IPatch> pohs) {
        this.pohs = pohs;
    }

    protected void addConflictRelation(IPatch from, IPatch to, boolean isBugConflict, ArrayList<String> conflicts) {
        this.addConflictRelation(from, to, isBugConflict, conflicts, false);
    }

    @Override
    public void addConflictRelation(IPatch from, IPatch to, boolean isBugConflict, ArrayList<String> conflicts, boolean iswhole) {
        this.checkAndInitNPatchRelations(from);
        NPatchRelations relations = this.relationsMap.get(from);
        NPatchRelation relation = new NPatchRelation(from, to, new NPatchRelationDefinition(conflicts, isBugConflict, NPatchRelationDefinition.RelationDefinition.CONFLICT));
        relation.setWholeRelation(iswhole);
        relations.addConflict(relation);
    }

    protected void addSupersetRelation(IPatch from, IPatch to, ArrayList<String> conflicts) {
        this.addSupersetRelation(from, to, conflicts, false);
    }

    @Override
    public void addSupersetRelation(IPatch from, IPatch to, ArrayList<String> conflicts, boolean iswhole) {
        this.checkAndInitNPatchRelations(from);
        NPatchRelations relations = this.relationsMap.get(from);
        NPatchRelation relation = new NPatchRelation(from, to, new NPatchRelationDefinition(conflicts, true, NPatchRelationDefinition.RelationDefinition.SUPERSET));
        relation.setWholeRelation(iswhole);
        relations.addSuperset(relation);
    }

    protected void addSubsetRelation(IPatch from, IPatch to, ArrayList<String> conflicts) {
        this.addSubsetRelation(from, to, conflicts, false);
    }

    @Override
    public void addSubsetRelation(IPatch from, IPatch to, ArrayList<String> conflicts, boolean iswhole) {
        this.checkAndInitNPatchRelations(from);
        NPatchRelations relations = this.relationsMap.get(from);
        NPatchRelation relation = new NPatchRelation(from, to, new NPatchRelationDefinition(conflicts, true, NPatchRelationDefinition.RelationDefinition.SUBSET));
        relation.setWholeRelation(iswhole);
        relations.addSubset(relation);
    }

    protected void addGenericRelation(IPatch from, IPatch to, NPatchRelationDefinition.RelationDefinition reldef) {
        this.checkAndInitNPatchRelations(from);
        NPatchRelations relations = this.relationsMap.get(from);
        NPatchRelation relation = new NPatchRelation(from, to, new NPatchRelationDefinition(reldef));
        if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.BETTER)) {
            relations.addBetter(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.DUPLICATE)) {
            relations.addDuplicate(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.WORSE)) {
            relations.addWorse(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.HIGHERPSU)) {
            relations.addHigherPSU(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.LOWERPSU)) {
            relations.addLowerPSU(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.SUPERSET)) {
            relations.addSuperset(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.SUBSET)) {
            relations.addSubset(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.SUBSETPSU)) {
            relations.addSubsetPSU(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.SUPERSETPSU)) {
            relations.addSupersetPSU(relation);
        } else if (reldef.equals((Object)NPatchRelationDefinition.RelationDefinition.INVALIDPSU)) {
            relations.addInvalidPSU(relation);
        }
    }

    protected void collectRelationsToTopLevelPSU() {
        IPatch topLevelPSU = null;
        for (IPatch patch : this.pis) {
            if (!patch.isTopLevelPSU()) continue;
            this.checkAndInitNPatchRelations(patch);
            Collection<IPatch> subPatches = patch.getSubPatches();
            for (IPatch subPatch : subPatches) {
                this.checkAndInitNPatchRelations(subPatch);
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getBetters()) {
                    this.relationsMap.get(patch).addBetter(rel);
                }
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getWorses()) {
                    this.relationsMap.get(patch).addWorse(rel);
                }
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getDuplicates()) {
                    this.relationsMap.get(patch).addDuplicate(rel);
                }
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getConflicts()) {
                    this.relationsMap.get(patch).addConflict(rel);
                }
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getSubsets()) {
                    this.relationsMap.get(patch).addSubset(rel);
                }
                for (NPatchRelation rel : this.relationsMap.get(subPatch).getSupersets()) {
                    this.relationsMap.get(patch).addSuperset(rel);
                }
                this.relationsMap.remove(subPatch);
            }
            topLevelPSU = patch;
        }
    }

    @Override
    public NPatchRelations getRelations(IPatch pi) {
        return this.relationsMap.containsKey(pi) ? this.relationsMap.get(pi) : this.empty;
    }

    @Override
    public Collection<IPatch> getOriginalPi() {
        return this.pis;
    }

    @Override
    public Collection<IPatch> getPi() {
        ArrayList<IPatch> fpis = new ArrayList<IPatch>(this.pis);
        IPatch topLevelPSU = null;
        for (IPatch patch : fpis) {
            if (!patch.isTopLevelPSU()) continue;
            topLevelPSU = patch;
        }
        if (topLevelPSU != null) {
            fpis.removeAll(topLevelPSU.getSubPatches());
        }
        Collections.sort(fpis, new Comparator<IPatch>(){

            @Override
            public int compare(IPatch p1, IPatch p2) {
                int p2Len;
                int p1Len = p1.getPatchId().length();
                if (p1Len < (p2Len = p2.getPatchId().length())) {
                    return -1;
                }
                if (p1Len > p2Len) {
                    return 1;
                }
                return p1.getPatchId().compareTo(p2.getPatchId());
            }
        });
        return fpis;
    }

    @Override
    public Collection<IPatch> getPoh() {
        if (this.pohs == null) {
            return new ArrayList<IPatch>();
        }
        ArrayList<IPatch> fpohs = new ArrayList<IPatch>(this.pohs);
        Collections.sort(fpohs, new Comparator<IPatch>(){

            @Override
            public int compare(IPatch p1, IPatch p2) {
                OneOffEntry o1 = p1.getOneOffEntry();
                OneOffEntry o2 = p2.getOneOffEntry();
                return o2.getAppliedDate().compareTo(o1.getAppliedDate());
            }
        });
        return fpohs;
    }

    @Override
    public HashMap<IPatch, NPatchRelations> getRelationsMap() {
        return this.relationsMap;
    }

    @Override
    public Collection getPatches(String patchID) {
        ArrayList<IPatch> patches = new ArrayList<IPatch>();
        for (IPatch pi : this.pis) {
            if (!pi.getPatchId().equals(patchID)) continue;
            patches.add(pi);
        }
        for (IPatch poh : this.pohs) {
            if (!poh.getPatchId().equals(patchID)) continue;
            patches.add(poh);
        }
        return patches;
    }

    @Override
    public boolean isPohExist() {
        return this.isPohExist;
    }

    @Override
    public void setPohExist(boolean isPohExist) {
        this.isPohExist = isPohExist;
    }

    @Override
    public Collection<IPatch> getPatchByUPI(String upi) {
        ArrayList<IPatch> patches = new ArrayList<IPatch>();
        for (IPatch pi : this.pis) {
            if (!pi.getOneOffEntry().getPSENumber().equals(upi)) continue;
            patches.add(pi);
        }
        for (IPatch poh : this.pohs) {
            if (!poh.getOneOffEntry().getPSENumber().equals(upi)) continue;
            patches.add(poh);
        }
        return patches;
    }
}

