/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import oracle.opatch.Help;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OneOffEntry;
import oracle.opatch.UtilSession;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.opatchcommon.opatchpatch.CompositePatch;
import oracle.opatch.opatchcommon.opatchpatch.CpuPatch;
import oracle.opatch.opatchcommon.opatchpatch.OPatchPatch;
import oracle.opatch.opatchcommon.opatchpatch.OneoffPatch;
import oracle.opatch.opatchcommon.opatchpatch.SystemPatch;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.OPatchPatchFactory;
import oracle.opatch.opatchsdk.patchrepresentation.InvalidPatchPackageException;
import oracle.opatch.opatchsdk.patchrepresentation.PatchType;
import oracle.opatch.opatchsdk.patchrepresentation.PatchVariant;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.patchsdk.PatchPackageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSession
extends OPatchSession
implements Help {
    private List<OPatchPatch> opatchPatchList = new ArrayList<OPatchPatch>();

    UpdateSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String oracleHomePath) {
        LogManager.getLogManager().reset();
        this.opatchPatchList = this.getSwLibraryPatches(OPatchEnv.getSwLibraryDir());
        if (this.opatchPatchList.isEmpty()) {
            System.out.println("There's no patch to be installed inside the software library directory.");
        } else {
            System.out.println("OPatch is installing the following patches:");
            System.out.println(this.getInputPatchInfo());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(OPatchEnv.getLogFileNameAndLocation(OPatchEnv.getOracleHome())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Iterator<OPatchPatch> iterator = this.opatchPatchList.iterator();
        if (iterator.hasNext()) {
            OPatchPatch patch = iterator.next();
            if (fos != null) {
                System.setOut(new PrintStream(fos));
            }
            System.out.println("\nPatch(es) to be processed: " + patch.getPatchLoc());
            try {
                try {
                    patch.setLogFileStream(fos);
                    patch.install();
                }
                catch (Exception exception) {}
                catch (Error error) {}
                finally {
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                OPatchEnv.setPatchloc("");
                OUSession.resetPHBaseDir();
                try {
                    IIPMRWServices rwServices = UtilSession.getRWServices(oracleHomePath);
                    if (rwServices.isLocked() && oracleHomePath != null) {
                        rwServices.release();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.printMessageAndExit();
    }

    private void printMessageAndExit() {
        Set<String> installedPatchIDs = this.getInstalledPatchIDs();
        if (installedPatchIDs == null) {
            System.out.println("\nError occurred during software library update.");
            System.out.println("Please refer to the log files for details.");
            System.exit(1);
        }
        boolean isAllPatchInHome = true;
        StringBuilder sb = new StringBuilder();
        for (OPatchPatch opatchPatch : this.opatchPatchList) {
            if (opatchPatch.isPatchInHome(installedPatchIDs)) continue;
            isAllPatchInHome = false;
            sb.append(opatchPatch.getUnsuccessPatchInfo());
        }
        if (isAllPatchInHome) {
            System.out.println("\nZOP-1000");
            System.exit(0);
        } else {
            System.out.println("\nZOP-1002: " + sb.toString());
            System.exit(1);
        }
    }

    public List<OPatchPatch> getSwLibraryPatches(String swLibraryDir) {
        File[] swLibraryFiles = new File(swLibraryDir).listFiles();
        try {
            for (File f2 : swLibraryFiles) {
                OPatchPatch opatchPatch;
                if (!f2.isDirectory() || !f2.canRead()) continue;
                PatchVariant pv = OPatchPatchFactory.getPatchInstance((String)f2.getAbsolutePath());
                if (pv == null) {
                    List<PatchVariant> subPatchVariants = this.getValidSingletonVariant(f2.listFiles());
                    if (subPatchVariants.size() <= 0) continue;
                    CpuPatch cpuPatch = new CpuPatch();
                    cpuPatch.setPatchVariants(subPatchVariants);
                    cpuPatch.setPatchLoc(f2.getAbsolutePath());
                    for (PatchVariant spv : subPatchVariants) {
                        cpuPatch.addPatchUnitId(spv.getPatchID());
                    }
                    cpuPatch.setPatchId(null);
                    this.opatchPatchList.add(cpuPatch);
                    continue;
                }
                PatchType pt = pv.getPatchType();
                switch (pt) {
                    case COMPOSITE: {
                        opatchPatch = new CompositePatch();
                        opatchPatch.setPatchVariants(Arrays.asList(pv));
                        opatchPatch.addPatchUnitId(pv.getPatchID());
                        break;
                    }
                    case SINGLETON: {
                        opatchPatch = new OneoffPatch();
                        opatchPatch.setPatchVariants(Arrays.asList(pv));
                        opatchPatch.addPatchUnitId(pv.getPatchID());
                        break;
                    }
                    case ENGSYSTEM: {
                        opatchPatch = new SystemPatch();
                        List<PatchVariant> subPatchVariants = this.getValidSingletonVariant(f2.listFiles());
                        for (PatchVariant spv : subPatchVariants) {
                            opatchPatch.addPatchUnitId(spv.getPatchID());
                        }
                        opatchPatch.setPatchVariants(subPatchVariants);
                        break;
                    }
                    default: {
                        opatchPatch = null;
                    }
                }
                opatchPatch.setPatchLoc(f2.getAbsolutePath());
                opatchPatch.setPatchId(pv.getPatchID());
                this.opatchPatchList.add(opatchPatch);
            }
        }
        catch (PatchPackageException patchPackageException) {
        }
        catch (InvalidPatchPackageException invalidPatchPackageException) {
            // empty catch block
        }
        return this.opatchPatchList;
    }

    private List<PatchVariant> getValidSingletonVariant(File[] systemSubDirs) {
        ArrayList<PatchVariant> res = new ArrayList<PatchVariant>();
        for (File subDir : systemSubDirs) {
            try {
                PatchVariant subPv = OPatchPatchFactory.getPatchInstance((String)subDir.getAbsolutePath());
                if (subPv == null || subPv.getPatchType() != PatchType.SINGLETON) continue;
                res.add(subPv);
            }
            catch (PatchPackageException patchPackageException) {
            }
            catch (InvalidPatchPackageException invalidPatchPackageException) {
                // empty catch block
            }
        }
        return res;
    }

    private String getInputPatchInfo() {
        StringBuilder sb = new StringBuilder();
        for (OPatchPatch opatchPatch : this.opatchPatchList) {
            sb.append(opatchPatch.getPatchInfo());
        }
        return sb.toString();
    }

    private Set<String> getInstalledPatchIDs() {
        OneOffEntry[] oneOffs = null;
        try {
            oneOffs = PrereqAPI.getInstalledOneOff(OPatchEnv.getOracleHome());
        }
        catch (Throwable e2) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        for (OneOffEntry oneoff : oneOffs) {
            res.add(oneoff.getID());
        }
        return res;
    }
}

