/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.CopyAction;
import oracle.opatch.Help;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.opatchfafmw.OPatchFmwDS;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.patchverbs.ParserObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySession
extends OPatchSession
implements Help {
    protected QuerySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    private static void printNameVersionPairList(OneOffEntry.NameVersionPair[] in, String inMessage) {
        StringBuffer buff = new StringBuffer("");
        OLogger.printlnOnConsole(inMessage);
        for (int i2 = 0; i2 < in.length; ++i2) {
            String x = in[i2].getName();
            ArrayList yArray = in[i2].getVersions();
            for (int j2 = 0; j2 < yArray.size(); ++j2) {
                buff.append("   ");
                buff.append(x);
                buff.append(":  ");
                buff.append((String)yArray.get(j2));
                buff.append("\n");
            }
        }
        OLogger.printlnOnConsole(buff.toString());
    }

    private static void printPatchDescription(String desc) {
        StringBuffer buff = new StringBuffer("");
        if (desc != null && !desc.equals("")) {
            buff.append(" Patch description: \"" + desc + "\"\n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printPatchModel(String patchModel) {
        StringBuffer buff = new StringBuffer("");
        if (patchModel != null && !patchModel.equals("")) {
            buff.append(" This patch supports the patching model as \"" + patchModel + "\"\n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printPatchLanguage(String patchLanguage) {
        StringBuffer buff = new StringBuffer("");
        if (patchLanguage != null && !patchLanguage.equals("")) {
            buff.append(" This patch supports the language \"" + patchLanguage + "\"\n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printPatchType(String patchType) {
        StringBuffer buff = new StringBuffer("");
        if (patchType != null && !patchType.equals("")) {
            buff.append(" This patch is a \"" + patchType + "\" patch.\n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printProductFamily(String productFamily) {
        StringBuffer buff = new StringBuffer("");
        if (productFamily != null && !productFamily.equals("")) {
            buff.append(" This patch belongs to the \"" + productFamily + "\" product family \n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printSqlPatchDatabaseStartupMode(String startupMode) {
        StringBuffer buff = new StringBuffer("");
        if (startupMode != null && !startupMode.equals("")) {
            buff.append(" This patch is a sql patch, the database startup mode is \"" + startupMode + "\" \n");
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printPatchIds(String[] patchInput, String inMessage) {
        StringBuffer buff = new StringBuffer("");
        OLogger.printlnOnConsole(inMessage);
        buff.append("   ");
        for (int i2 = 0; i2 < patchInput.length; ++i2) {
            buff.append(patchInput[i2]);
            buff.append(" ");
        }
        buff.append("\n");
        OLogger.printlnOnConsole(buff.toString());
    }

    private static void printApplicableProduct(String applicableProduct) {
        StringBuffer buff = new StringBuffer("\n Applicable Product Type is : ");
        if (applicableProduct == null || applicableProduct.equals("")) {
            return;
        }
        buff.append(applicableProduct);
        if (applicableProduct.equals("sa")) {
            buff.append("\n    This patch is a Stand Alone based patch");
        } else if (applicableProduct.equals("oui")) {
            buff.append("\n    This patch is a OUI based patch");
        } else if (applicableProduct.equals("saoui")) {
            buff.append("\n    This patch is a hybrid patch");
        } else {
            buff.append("\n    This patch has an invalid applicable product type");
        }
        buff.append("\n");
        OLogger.printlnOnConsole(buff.toString());
    }

    private static void printBugs(Bug[] bugs) {
        if (bugs != null && bugs.length > 0) {
            StringBuffer buff = new StringBuffer(" List of bugs to be fixed:\n");
            for (int i2 = 0; i2 < bugs.length; ++i2) {
                Bug bug = bugs[i2];
                String ID = bug.getBugID();
                String desc = bug.getDesc();
                buff.append("   ");
                buff.append(ID);
                buff.append(": ");
                buff.append(desc);
                buff.append("\n");
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printExes(String[] exes) {
        if (exes != null && exes.length > 0) {
            StringBuffer buff = new StringBuffer(" List of executables affected:\n");
            for (int i2 = 0; i2 < exes.length; ++i2) {
                String exe = exes[i2];
                buff.append("   ");
                buff.append(exe);
                buff.append("\n");
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printUpdateComponents(String header, UpdateComponent[] comps) {
        if (comps != null && comps.length > 0) {
            StringBuffer buff = new StringBuffer(header);
            for (int i2 = 0; i2 < comps.length; ++i2) {
                UpdateComponent uc = comps[i2];
                String name = uc.getCompName();
                String fromVer = uc.getFromVersion();
                String toVer = uc.getToVersion();
                boolean isRequired = uc.isRequired();
                buff.append("   ");
                buff.append(name);
                buff.append(":  ");
                buff.append(fromVer);
                buff.append(":  ");
                buff.append(toVer);
                buff.append(":  ");
                buff.append(isRequired);
                buff.append("\n");
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printComps(String header, PatchComponent[] comps) {
        if (comps != null && comps.length > 0) {
            StringBuffer buff = new StringBuffer(header);
            for (int i2 = 0; i2 < comps.length; ++i2) {
                PatchComponent c2 = comps[i2];
                String name = c2.getID();
                String ver = c2.getVersion();
                buff.append("   ");
                buff.append(name);
                buff.append(":  ");
                buff.append(ver);
                buff.append("\n");
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printOptionalComps(PatchComponent[] comps) {
        String header = " List of optional components:\n";
        QuerySession.printComps(header, comps);
    }

    private static void printRequiredComps(PatchComponent[] comps) {
        String header = " List of required components:\n";
        QuerySession.printComps(header, comps);
    }

    private static void printCreationTime(String time) {
        if (time != null) {
            StringBuffer buff = new StringBuffer(" Patch created on ");
            buff.append(time);
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printActions(String oracleHomePath, String header, String patchLoc, PatchComponent[] comps, boolean printPrePost) {
        StringBuffer buff = new StringBuffer(header);
        boolean pre = PatchObject.isTherePreScript(patchLoc);
        boolean post = PatchObject.isTherePostScript(patchLoc);
        boolean init = PatchObject.isThereInitScript(patchLoc);
        if (printPrePost) {
            if (pre) {
                buff.append("   Running a pre-script action\n");
            }
            if (post) {
                buff.append("   Running a post-script action\n");
            }
            if (init) {
                buff.append("   Running a init-script action\n");
            }
        }
        if (comps != null && comps.length > 0) {
            for (int i2 = 0; i2 < comps.length; ++i2) {
                PatchComponent c2 = comps[i2];
                PatchAction[] actions = c2.getAllActions();
                for (int j2 = 0; j2 < actions.length; ++j2) {
                    String dst;
                    String src;
                    PatchAction a2 = actions[j2];
                    if (a2 instanceof CopyAction) {
                        CopyAction ca = (CopyAction)a2;
                        src = ca.getSourceFile();
                        dst = ca.getParentFilePath(oracleHomePath);
                        String fileVer = ca.getFileVersion();
                        boolean updateTimeStamp = ca.isUpdateTimeStamp();
                        String diagStr = ca.getFileDiagStr();
                        buff.append("   Copy ");
                        buff.append(src);
                        buff.append(" to ");
                        buff.append(dst);
                        if (fileVer != null && !fileVer.equals("")) {
                            buff.append("\n     With version \"" + fileVer + "\"");
                        }
                        if (updateTimeStamp) {
                            buff.append("\n     Update timestamp of all entries recursively");
                        }
                        if (diagStr != null && !diagStr.equals("")) {
                            buff.append("\n     Diagnostic message: \"" + diagStr + "\"");
                        }
                        buff.append("\n");
                        continue;
                    }
                    if (a2 instanceof JarAction) {
                        JarAction ja = (JarAction)a2;
                        src = ja.getClassName();
                        StringBuffer dstBuff = new StringBuffer(ja.getJarPath());
                        dstBuff.append(File.separator);
                        dstBuff.append(ja.getJarName());
                        dst = dstBuff.toString();
                        buff.append("   Update ");
                        buff.append(dst);
                        buff.append(" with ");
                        buff.append(src);
                        buff.append("\n");
                        continue;
                    }
                    if (a2 instanceof ArchiveAction) {
                        ArchiveAction aa = (ArchiveAction)a2;
                        buff.append(aa.printAction(oracleHomePath));
                        continue;
                    }
                    if (a2 instanceof MakeAction) {
                        MakeAction ma = (MakeAction)a2;
                        StringBuffer chDir = new StringBuffer(oracleHomePath);
                        chDir.append(File.separator);
                        chDir.append(ma.getChangeDirectory());
                        String makeFile = ma.getMakeFile();
                        String makeTarget = ma.getMakeTarget();
                        buff.append("   cd ");
                        buff.append(chDir.toString());
                        buff.append("\n");
                        buff.append("     ; make -f ");
                        buff.append(makeFile);
                        buff.append(" ");
                        buff.append(makeTarget);
                        buff.append(" ORACLE_HOME=");
                        buff.append(oracleHomePath);
                        buff.append("\n");
                        continue;
                    }
                    buff.append(a2.toString());
                    buff.append("\n");
                }
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    private static void printRequiredActions(String oracleHomePath, String patchLoc, PatchComponent[] comps) {
        String header = " List of required actions:\n";
        QuerySession.printActions(oracleHomePath, header, patchLoc, comps, true);
    }

    private static void printOptionalActions(String oracleHomePath, String patchLoc, PatchComponent[] comps) {
        String header = " List of optional actions:\n";
        QuerySession.printActions(oracleHomePath, header, patchLoc, comps, false);
    }

    private static void printPlatforms(Platform[] platforms) {
        if (platforms != null && platforms.length > 0) {
            StringBuffer buff = new StringBuffer(" List of platforms supported:\n");
            for (int i2 = 0; i2 < platforms.length; ++i2) {
                Platform p2 = platforms[i2];
                String ID = p2.getID();
                String ver = p2.getDesc();
                buff.append("   ");
                buff.append(ID);
                buff.append(": ");
                buff.append(ver);
                buff.append("\n");
            }
            OLogger.printlnOnConsole(buff.toString());
        }
    }

    public static void printBooleanFields(String patchLocation, boolean isAll) {
        OneOffEntry oneoff = OPatchSDK.getOneOffEntry(patchLocation);
        boolean rolling = oneoff.isRolling();
        boolean fmwRolling = oneoff.isFmwRolling();
        boolean fmwFeatureBearing = oneoff.isFmwFeatureBearing();
        boolean rollbackable = oneoff.isRollbackable();
        boolean translatable = oneoff.isTranslatable();
        boolean shutdown = oneoff.isInstanceShutdown();
        boolean isPatchsetUpdate = oneoff.isMiniPatchSet();
        boolean isSqlPatch = oneoff.isSqlPatch();
        StringBuffer buff = new StringBuffer("");
        if (isAll) {
            buff.append(" Need to shutdown Oracle instances: ");
            buff.append(shutdown);
            buff.append("\n");
            buff.append(" Patch is roll-backable: ");
            buff.append(rollbackable);
            buff.append("\n");
        }
        if (!OPatchEnv.isNextGen() && (OPatchEnv.isPatchsetUpdate() || isAll)) {
            buff.append(" Patch is a \"Patchset Update\": ");
            buff.append(isPatchsetUpdate);
            buff.append("\n");
        }
        if (OPatchEnv.isRollingPatch() || isAll) {
            buff.append(" Patch is a rolling patch: ");
            buff.append(rolling);
            buff.append("\n");
            buff.append(" Patch is a FMW rolling patch: ");
            buff.append(fmwRolling);
            buff.append("\n");
        }
        if (OPatchEnv.isFMWFeatureBearingPatch() || isAll) {
            buff.append(" Patch is a FMW feature bearing patch: ");
            buff.append(fmwFeatureBearing);
            buff.append("\n");
        }
        if (OPatchEnv.isSqlPatch() || isAll) {
            buff.append(" Patch is a sql patch: ");
            buff.append(isSqlPatch);
            buff.append("\n");
        }
        QuerySession.printPatchObjDepBooleanFields(patchLocation, isAll, buff);
    }

    public static void printPatchObjDepBooleanFields(String patchLocation, boolean isAll, StringBuffer buff) {
        if (buff == null) {
            buff = new StringBuffer("");
        }
        PatchObject po = null;
        try {
            po = new PatchObject(patchLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (OPatchEnv.isSqlAction() || isAll) {
            buff.append(" Patch has sql related actions: ");
            buff.append(po.isSqlRelatedActions());
            buff.append("\n");
        }
        if (OPatchEnv.isOnlinePatch() || isAll) {
            buff.append(" Patch is an online patch: ");
            buff.append(po.isOnlinePatch());
            buff.append("\n");
        }
        if (OPatchEnv.isPortalPatch() || isAll) {
            buff.append(" Patch is a portal patch: ");
            buff.append(po.isPortalPatch());
            buff.append("\n");
        }
        if (OPatchEnv.isAutoPatch() || isAll) {
            buff.append(" Patch is an \"auto-enabled\" patch: ");
            buff.append(po.getPatchInventory().isAuto());
            buff.append("\n");
        }
        if (OPatchEnv.isTranslatablePatch() || isAll) {
            buff.append(" Patch is translatable: ");
            buff.append(po.getPatchInventory().isTranslatable());
            buff.append("\n");
        }
        OLogger.printlnOnConsole(buff.toString());
    }

    public static void printDeploymentDetails(OPatchFmwDS.DeployDS[] deployObj) {
        StringBuffer buff = new StringBuffer("");
        for (int i2 = 0; deployObj != null && i2 < deployObj.length; ++i2) {
            if (i2 == 0) {
                buff.append(" List of J2EE Deployment:\n");
            }
            buff.append(deployObj[i2].toString());
            buff.append("\n");
        }
        OLogger.printlnOnConsole(buff.toString());
    }

    public static void printPatchOneOffEntry(String patchLocation) {
        PatchObject po = null;
        try {
            po = new PatchObject(patchLocation);
            String compsEntry = po.getOneOffEntryInCompsXML();
            OLogger.printlnOnConsole("  Possible XML representation of the patch:");
            OLogger.printlnOnConsole(compsEntry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream("query_help.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{"query_help.txt"});
            OLogger.println(msg);
        }
    }

    @Override
    public void process(String patchLocation) throws RuntimeException {
        if (!OnlinePatchProcessor.isOnlineOnlyPatch(patchLocation)) {
            this.processSingle(patchLocation);
        }
        if (OnlinePatchProcessor.isOnlineOnlyPatch(patchLocation) || OnlinePatchProcessor.isHybridOnlinePatch(patchLocation) && !OPatchEnv.isOnlinePatch()) {
            OnlinePatchProcessor.setHybridPatchPart(patchLocation, PatchObject.HybridPatchPart.ONLINE);
            this.processSingle(patchLocation);
        }
    }

    protected void processSingle(String patchLocation) throws RuntimeException {
        block35: {
            OPatchEnv.setPatchloc(patchLocation);
            String oracleHomePath = "ORACLE_HOME";
            try {
                oracleHomePath = OPatchEnv.getOracleHome();
            }
            catch (NullPointerException e2) {
                oracleHomePath = "ORACLE_HOME";
            }
            String[] patchLocs = new String[1];
            boolean isEsysPatch = false;
            isEsysPatch = OPatchSessionHelper.checkIsEsysPatch(patchLocation);
            if (isEsysPatch) {
                if (OPatchEnv.isEngSystemPatch()) {
                    OLogger.printlnOnConsole("--------------------------------------------------------------------------------");
                    OLogger.println("true");
                    return;
                }
                OLogger.println(OLogger.getString("OUI-68011"));
                OPatchEnv.setOpatchExitCode(21);
                throw new RuntimeException(OLogger.getString("OUI-68011"));
            }
            if (PQSession.isComposite(patchLocation)) {
                OLogger.println(OLogger.getString("OUI-68022"));
                OPatchEnv.setOpatchExitCode(21);
                throw new RuntimeException(OLogger.getString("OUI-68022"));
            }
            boolean validPatch = true;
            patchLocs[0] = patchLocation;
            PrereqResult resObj = PrereqAPI.checkPatchShipHome(patchLocs);
            validPatch = resObj.getResult() == PrereqResult.ExecuteStatus.PASSED;
            if (validPatch) {
                boolean isAll = OPatchEnv.isQueryAll();
                OneOffEntry oneoff = OPatchSDK.getOneOffEntry(patchLocation);
                Bug[] bugs = oneoff.getBugsFixed();
                String[] exes = oneoff.getExecutables();
                PatchComponent[] optComps = oneoff.getOptionalComponents();
                PatchComponent[] reqComps = oneoff.getRequiredComponents();
                UpdateComponent[] updateComps = oneoff.getUpdateCompsList();
                String opackTime = oneoff.getCreationDate();
                Platform[] platforms = oneoff.getSupportedPlatforms();
                String header = "--------------------------------------------------------------------------------";
                String applicableProduct = oneoff.getProductType();
                String patchType = oneoff.getPatchType();
                String productFamily = oneoff.getProductFamily();
                String patchModel = oneoff.getPatchModel();
                String patchDesc = oneoff.getPatchDesc();
                String patchLanguage = oneoff.getPatchLanguage();
                String startupMode = oneoff.getSqlPatchDatabaseStartupMode();
                String[] prereqPatchIds = oneoff.getPrereqPatchIDs();
                String[] coreqPatchIds = oneoff.getCoreqPatchIDs();
                String[] overlayPatchIds = oneoff.getOverLayPatchIDs();
                String[] prereqBugIds = oneoff.getPrereqBugIDs();
                OPatchFmwDS.DeployDS[] deployList = oneoff.getDeployList();
                OneOffEntry.NameVersionPair[] pv = oneoff.getProducts();
                OneOffEntry.NameVersionPair[] sc = oneoff.getSystemComponentList();
                OneOffEntry.NameVersionPair[] as = oneoff.getApplicationShutdownList();
                ArrayList<ParserObject> parserObjects = oneoff.getParserObject();
                String msgShutDown = oneoff.getInstanceShutdownMessage();
                OLogger.printlnOnConsole(header);
                if (OPatchEnv.isDate() || isAll) {
                    QuerySession.printCreationTime(opackTime);
                }
                if (isAll) {
                    QuerySession.printPatchDescription(patchDesc);
                    QuerySession.printApplicableProduct(applicableProduct);
                }
                QuerySession.printBooleanFields(patchLocation, isAll);
                if (OPatchEnv.isOS() || isAll) {
                    QuerySession.printPlatforms(platforms);
                }
                if (prereqPatchIds != null && prereqPatchIds.length != 0 && isAll) {
                    QuerySession.printPatchIds(prereqPatchIds, " List of prereq patches: ");
                }
                if (coreqPatchIds != null && coreqPatchIds.length != 0 && isAll) {
                    QuerySession.printPatchIds(coreqPatchIds, " List of corequisite patches: ");
                }
                if (overlayPatchIds != null && overlayPatchIds.length != 0 && isAll) {
                    QuerySession.printPatchIds(overlayPatchIds, " List of overlay patches: ");
                }
                if (prereqBugIds != null && prereqBugIds.length != 0 && isAll) {
                    QuerySession.printPatchIds(prereqBugIds, " List of prereq bugs: ");
                }
                QuerySession.printDeploymentDetails(deployList);
                if (OPatchEnv.isBaseBug() || isAll) {
                    QuerySession.printBugs(bugs);
                }
                if (OPatchEnv.isEngSystemPatch()) {
                    OLogger.println("false");
                    return;
                }
                if (OPatchEnv.isPatchType() || isAll) {
                    QuerySession.printPatchType(patchType);
                }
                if (OPatchEnv.isProductFamily() || isAll) {
                    QuerySession.printProductFamily(productFamily);
                }
                if (OPatchEnv.isPatchModel() || isAll) {
                    QuerySession.printPatchModel(patchModel);
                }
                if (OPatchEnv.isPatchLanguage() || isAll) {
                    QuerySession.printPatchLanguage(patchLanguage);
                }
                if (isAll) {
                    QuerySession.printExes(exes);
                }
                if (sc != null && sc.length != 0 && isAll) {
                    QuerySession.printNameVersionPairList(sc, " List of system components: ");
                }
                if (as != null && as.length != 0 && isAll) {
                    QuerySession.printNameVersionPairList(as, " Application components shut down list: ");
                }
                if (pv != null && pv.length != 0 && isAll) {
                    QuerySession.printNameVersionPairList(pv, " List of (product,version) pairs: ");
                }
                if (msgShutDown != null && !msgShutDown.equals("") && isAll) {
                    StringBuffer buff = new StringBuffer(" Shut down Message: ");
                    buff.append("\n");
                    buff.append("   ");
                    buff.append(msgShutDown);
                    buff.append("\n");
                    OLogger.printlnOnConsole(buff.toString());
                }
                if (OPatchEnv.isUpdateComponent() || isAll) {
                    if (oneoff.isMiniPatchSet()) {
                        QuerySession.printUpdateComponents(" List of Components to be upgraded (name,fromVersion,toVersion,required): \n", updateComps);
                    } else if (OPatchEnv.isUpdateComponent()) {
                        OLogger.printlnOnConsole(" This is not a Patchset Update. So, there are no components to be upgraded.\n");
                    }
                }
                if ((OPatchEnv.isSqlPatch() || isAll) && oneoff.isSqlPatch()) {
                    QuerySession.printSqlPatchDatabaseStartupMode(startupMode);
                }
                if (OPatchEnv.isComponent() || isAll) {
                    QuerySession.printOptionalComps(optComps);
                    QuerySession.printRequiredComps(reqComps);
                }
                if (!isAll) break block35;
                QuerySession.printRequiredActions(oracleHomePath, patchLocation, reqComps);
                QuerySession.printOptionalActions(oracleHomePath, patchLocation, optComps);
                if (parserObjects != null) {
                    try {
                        QuerySession.printAutomationElements(parserObjects);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                QuerySession.printPatchOneOffEntry(patchLocation);
                OLogger.printlnOnConsole(header);
                break block35;
            }
            OLogger.error("OUI-67075", new Object[]{patchLocation, "Input metadata files are missing."});
            StringBuffer buff = new StringBuffer("Patch Location \"");
            buff.append(patchLocation);
            buff.append("\" doesn't point to a valid patch area.");
            OLogger.printlnOnConsole(buff.toString());
            throw new RuntimeException(buff.toString());
        }
    }

    private static void printAutomationElements(ArrayList<ParserObject> parsers) {
        for (ParserObject parser : parsers) {
            OLogger.printlnOnConsole(parser.toString());
        }
    }
}

