/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.HashMap;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;

public class OnlinePatchProcessor {
    private static HashMap<String, PatchObject.HybridPatchPart> hybridPatchMap = new HashMap();

    public static boolean isOnlinePart(String patchlocation) {
        boolean getOnlinePart = false;
        String canonicalPatchLoc = "";
        try {
            canonicalPatchLoc = new File(patchlocation).getCanonicalPath();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return getOnlinePart;
        }
        if (hybridPatchMap.get(canonicalPatchLoc) == PatchObject.HybridPatchPart.ONLINE) {
            getOnlinePart = true;
        }
        OLogger.debug("check if " + canonicalPatchLoc + " saved in hybrid online patch map: " + getOnlinePart);
        return getOnlinePart;
    }

    public static void setHybridPatchPart(String patchLocation, PatchObject.HybridPatchPart hybridPatchPart) {
        try {
            String canonicalPatchLoc = new File(patchLocation).getCanonicalPath();
            OLogger.debug("Add patch " + canonicalPatchLoc + " to new online patch.");
            hybridPatchMap.put(canonicalPatchLoc, hybridPatchPart);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }

    public static void handleOnlinePatch(String[] patchLocs) {
        String opatchVersion = OPatchSession.getVersion();
        for (int i2 = 0; i2 < patchLocs.length; ++i2) {
            String patchloc = patchLocs[i2];
            if (!OPatchEnv.isOnline()) continue;
            boolean isNewOnline = false;
            boolean isOldOnline = false;
            if (OnlinePatchProcessor.isHybridOnlinePatch(patchloc)) {
                try {
                    OnlinePatchProcessor.setHybridPatchPart(patchloc, PatchObject.HybridPatchPart.ONLINE);
                }
                catch (Exception e2) {
                    OLogger.printStackTrace(e2);
                }
                isNewOnline = true;
            } else {
                File patch = new File(patchloc);
                if (patch.exists() && patch.isDirectory()) {
                    if (patch.getName().equals("online")) {
                        isOldOnline = true;
                    } else {
                        String[] subDirs = patch.list();
                        for (int j2 = 0; subDirs != null && j2 < subDirs.length; ++j2) {
                            String entry = subDirs[j2];
                            if (!entry.equals("online")) continue;
                            patchLocs[i2] = patchLocs[i2] + File.separator + "online";
                            isOldOnline = true;
                            break;
                        }
                    }
                }
            }
            if (isNewOnline || isOldOnline) continue;
            throw new OnlinePatchException(OLogger.getString("OUI-68062", new Object[]{patchloc}));
        }
    }

    protected static boolean isHybridOnlinePatch(String patchloc) {
        File patch = new File(patchloc);
        if (patch.exists() && patch.isDirectory()) {
            String[] subDirs = patch.list();
            boolean has_etc_online = false;
            boolean has_files_online = false;
            for (int j2 = 0; subDirs != null && j2 < subDirs.length; ++j2) {
                String entry = subDirs[j2];
                if (entry.indexOf("etc_online") != -1) {
                    has_etc_online = true;
                    continue;
                }
                if (entry.indexOf("files_online") == -1) continue;
                has_files_online = true;
            }
            if (has_etc_online) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isOnlineOnlyPatch(String patchloc) {
        boolean isOnlineOnly = false;
        File patch = new File(patchloc);
        if (patch.exists() && patch.isDirectory()) {
            String[] subDirs = patch.list();
            boolean has_etc_online = false;
            boolean has_files_online = false;
            boolean has_etc = false;
            boolean has_files = false;
            for (int j2 = 0; subDirs != null && j2 < subDirs.length; ++j2) {
                String entry = subDirs[j2];
                if (entry.indexOf("etc_online") != -1) {
                    has_etc_online = true;
                    continue;
                }
                if (entry.indexOf("files_online") != -1) {
                    has_files_online = true;
                    continue;
                }
                if (entry.indexOf("etc") != -1) {
                    has_etc = true;
                    continue;
                }
                if (entry.indexOf("files") == -1) continue;
                has_files = true;
            }
            if (has_etc_online && has_files_online && !has_etc && !has_files) {
                isOnlineOnly = true;
            }
        }
        return isOnlineOnly;
    }

    protected static boolean isOldOnlinePatch(String patchloc) {
        boolean isOldOnline = false;
        boolean has_online = false;
        boolean has_etc = false;
        boolean has_files = false;
        File patch = new File(patchloc);
        if (patch.exists() && patch.isDirectory()) {
            if (patch.getName().equals("online")) {
                has_online = true;
            }
            String[] subDirs = patch.list();
            for (int j2 = 0; subDirs != null && j2 < subDirs.length; ++j2) {
                String entry = subDirs[j2];
                if (entry.equals("online")) {
                    has_online = true;
                    continue;
                }
                if (entry.equals("etc")) {
                    has_etc = true;
                    continue;
                }
                if (!entry.equals("files")) continue;
                has_files = true;
            }
        }
        if (has_online && has_etc && has_files) {
            isOldOnline = true;
        }
        return isOldOnline;
    }

    public static void cleanHybridPatchMap() {
        hybridPatchMap.clear();
    }

    private static boolean isHybridOnlineSupported(String opatchVersion) {
        int i2;
        String[] version = opatchVersion.split("\\.");
        String[] versionRef = new String[]{"12", "2"};
        boolean bigger = false;
        for (i2 = 0; i2 < 1 && version[i2].equals(versionRef[i2]); ++i2) {
        }
        int result = Integer.valueOf(version[i2]).compareTo(Integer.valueOf(versionRef[i2]));
        if (result >= 0) {
            bigger = true;
        }
        return bigger;
    }
}

