/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import model.common.AbstractBaseTarget;
import model.common.BasePatch;
import model.common.FlexibleDataType;
import model.common.Host;
import model.common.OUIComponent;
import model.common.OracleHome;
import model.common.Patch;
import oracle.opatch.Bug;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.WLSPatch;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;

@XmlRootElement(name="InventoryInstance")
public class InventoryInstance {
    public OracleHome oracleHome = new OracleHome();
    @XmlElement(required=true)
    public FlexibleDataType osPlatform = null;
    @XmlElementWrapper(name="patches")
    public List patch = new ArrayList();
    @XmlElementWrapper(name="components")
    public List component = new ArrayList();
    @XmlElementWrapper(name="patchsets")
    public List patchset = new ArrayList();
    @XmlElementWrapper(name="nodelist")
    public List node = new ArrayList();

    public InventoryInstance() {
    }

    public InventoryInstance(List installedPatches, List installedComponents, List installedPatchsets, List nodeList, OracleHome OH) {
        this.patch = installedPatches;
        this.component = installedComponents;
        this.patchset = installedPatchsets;
        this.node = nodeList;
        this.oracleHome = OH;
    }

    public InventoryInstance(OneOffEntry[] installedPatches, InstalledComponent[] installedComponents) {
        this.populate(installedPatches, installedComponents);
    }

    public InventoryInstance(String oracleHomePath) {
        try {
            IIPMReadServices readServices;
            this.oracleHome = new OracleHome();
            this.oracleHome.setPath(oracleHomePath);
            int modelCode = PatchingModel.returnModelCode(oracleHomePath);
            if (modelCode == 1) {
                this.oracleHome.setPatchingModel("oneoff");
            } else if (modelCode == 2) {
                this.oracleHome.setPatchingModel("snowball");
            } else {
                this.oracleHome.setPatchingModel("invalid");
            }
            this.oracleHome.setInventoryLocation(OPatchEnv.getCentralInvLoc());
            try {
                readServices = PrereqSession.getReadServices(oracleHomePath);
            }
            catch (Throwable e2) {
                throw new RuntimeException("Problem loading inventory in isAutoRollbackable() function.");
            }
            OneOffEntry[] installedPatches = readServices.getInstalledPatches();
            InstalledComponent[] installedComponents = readServices.getInstalledComponents();
            this.populate(installedPatches, installedComponents);
            this.osPlatform = new FlexibleDataType();
            String hostName = IPMUtil.getLocalHostName(true);
            if (hostName == null || "".equals(hostName)) {
                hostName = readServices.getLocalNode();
            }
            this.osPlatform.setHostName(hostName);
            int pi = readServices.getARUID();
            String desc = readServices.getARUIDDescription();
            this.osPlatform.setId(String.valueOf(pi));
            this.osPlatform.setVersion(desc);
        }
        catch (Exception e3) {
            System.out.println(" Exception = " + e3.getMessage());
            e3.printStackTrace();
        }
    }

    public void populate(OneOffEntry[] installedPatches, InstalledComponent[] installedComponents) {
        AbstractBaseTarget instance;
        int k2;
        IIPMReadServices readServices;
        try {
            readServices = PrereqSession.getReadServices(this.oracleHome.getPath());
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading inventory in isAutoRollbackable() function.");
        }
        Rac.RacType racType = Rac.getInstance(readServices);
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        Host local = new Host();
        local.setNodeName(localNode);
        this.node.add(local);
        for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
            Host host = new Host();
            host.setNodeName(remoteNodes[i2]);
            this.node.add(host);
        }
        for (k2 = 0; k2 < installedComponents.length; ++k2) {
            instance = new OUIComponent();
            instance.setId(installedComponents[k2].getID());
            instance.setName(installedComponents[k2].getName());
            instance.setVersion(installedComponents[k2].getVersion());
            instance.setDescription(installedComponents[k2].getDesc());
            Vector languages = installedComponents[k2].getLanguages();
            ArrayList<String> instanceLangs = new ArrayList<String>();
            for (int i3 = 0; i3 < languages.size(); ++i3) {
                instanceLangs.add(((Locale)languages.get(i3)).getLanguage());
            }
            ((OUIComponent)instance).setInstalledLanguage(instanceLangs);
            this.component.add(instance);
            if (installedComponents[k2].getCompInstallID().getCompType() != 4) continue;
            this.patchset.add(instance);
        }
        for (k2 = 0; k2 < installedPatches.length; ++k2) {
            instance = new Patch();
            boolean isSqlPatch = installedPatches[k2].isSqlPatch();
            ((Patch)instance).setSqlPatch(isSqlPatch);
            if (isSqlPatch) {
                ((Patch)instance).setSqlPatchDatabaseStartupMode(installedPatches[k2].getSqlPatchDatabaseStartupMode());
            }
            ((Patch)instance).setUniquePatchID(installedPatches[k2].getPSENumber());
            ((Patch)instance).setAppliedDate(installedPatches[k2].getAppliedDate());
            ((Patch)instance).setPatchLanguage(installedPatches[k2].getPatchLanguage());
            ((Patch)instance).setCreationDate(installedPatches[k2].getCreationDate());
            ((Patch)instance).setRollbackable(installedPatches[k2].isRollbackable());
            ((BasePatch)instance).setPatchID(installedPatches[k2].getID());
            ((Patch)instance).setPatchDescription(installedPatches[k2].getPatchDesc());
            ((Patch)instance).setMinimumOPatchVersion(installedPatches[k2].getMinOPatchVersion());
            ((Patch)instance).setPatchType(installedPatches[k2].getPatchType());
            PatchAction[] patchActions = installedPatches[k2].getPatchActions();
            ArrayList<String> actionsList = new ArrayList<String>();
            for (int i4 = 0; i4 < patchActions.length; ++i4) {
                actionsList.add(patchActions[i4].getRawActionEntry());
            }
            ((Patch)instance).setPatchAction(actionsList);
            if (installedPatches[k2].getIsComposite()) {
                ((Patch)instance).setConstituent(installedPatches[k2].getConstituentActiveField());
            }
            ArrayList<FlexibleDataType> bugsList = new ArrayList<FlexibleDataType>();
            Bug[] bugsFixed = installedPatches[k2].getBugsFixed();
            for (int j2 = 0; j2 < bugsFixed.length; ++j2) {
                FlexibleDataType currentEntry = new FlexibleDataType();
                currentEntry.setDescription(bugsFixed[j2].getDesc());
                currentEntry.setId(bugsFixed[j2].getBugID());
                bugsList.add(currentEntry);
            }
            ((Patch)instance).setBug(bugsList);
            ArrayList<String> prereqPatches = new ArrayList();
            String[] prereqOneoffs = installedPatches[k2].getPrereqPatchIDs();
            prereqPatches = Arrays.asList(prereqOneoffs);
            ((Patch)instance).setPrereqPatch(prereqPatches);
            ArrayList<String> wlsPrereqPatches = new ArrayList<String>();
            WLSPatch[] wlsPrereqOneoffs = installedPatches[k2].getWlsPrereqPatchIDs();
            for (int j3 = 0; j3 < wlsPrereqOneoffs.length; ++j3) {
                wlsPrereqPatches.add(wlsPrereqOneoffs[j3].getPatchID());
            }
            ((Patch)instance).setWlsPrereqPatch(wlsPrereqPatches);
            ArrayList<String> prereqBugs = new ArrayList();
            String[] prereqBugIDs = installedPatches[k2].getPrereqPatchIDs();
            prereqBugs = Arrays.asList(prereqBugIDs);
            ((Patch)instance).setPrereqBug(prereqBugs);
            ArrayList<String> overlayPatches = new ArrayList();
            String[] overlayOneoffs = installedPatches[k2].getOverLayPatchIDs();
            overlayPatches = Arrays.asList(overlayOneoffs);
            ((Patch)instance).setOverlayPatch(overlayPatches);
            ArrayList<String> coreqPatches = new ArrayList();
            String[] coreqOneoffs = installedPatches[k2].getCoreqPatchIDs();
            coreqPatches = Arrays.asList(coreqOneoffs);
            ((Patch)instance).setCoreqPatch(coreqPatches);
            ArrayList<String> executables = new ArrayList();
            String[] patchExecutables = installedPatches[k2].getExecutables();
            executables = Arrays.asList(patchExecutables);
            ((Patch)instance).setExecutable(executables);
            ArrayList<String> filesModified = new ArrayList<String>();
            String[][] filesTouched = installedPatches[k2].getFilesTouched();
            for (int j4 = 0; j4 < filesTouched.length; ++j4) {
                filesModified.add(filesTouched[j4][0]);
            }
            ((Patch)instance).setFile(filesModified);
            ArrayList<FlexibleDataType> requiredComps = new ArrayList<FlexibleDataType>();
            PatchComponent[] requiredComponents = installedPatches[k2].getRequiredComponents();
            for (int j5 = 0; j5 < requiredComponents.length; ++j5) {
                FlexibleDataType currentEntry = new FlexibleDataType();
                currentEntry.setId(requiredComponents[j5].getID());
                currentEntry.setVersion(requiredComponents[j5].getVersion());
                requiredComps.add(currentEntry);
            }
            ((Patch)instance).setRequiredComponent(requiredComps);
            ArrayList<FlexibleDataType> optionalComps = new ArrayList<FlexibleDataType>();
            PatchComponent[] optionalComponents = installedPatches[k2].getOptionalComponents();
            for (int j6 = 0; j6 < optionalComponents.length; ++j6) {
                FlexibleDataType currentEntry = new FlexibleDataType();
                currentEntry.setId(optionalComponents[j6].getID());
                currentEntry.setVersion(optionalComponents[j6].getVersion());
                optionalComps.add(currentEntry);
            }
            ((Patch)instance).setOptionalComponent(optionalComps);
            ArrayList<FlexibleDataType> platforms = new ArrayList<FlexibleDataType>();
            Platform[] patchPlatforms = installedPatches[k2].getSupportedPlatforms();
            for (int j7 = 0; j7 < patchPlatforms.length; ++j7) {
                FlexibleDataType currentEntry = new FlexibleDataType();
                currentEntry.setVersion(patchPlatforms[j7].getDesc());
                currentEntry.setId(patchPlatforms[j7].getID());
                platforms.add(currentEntry);
            }
            ((Patch)instance).setOsPlatform(platforms);
            ((Patch)instance).setOnlinePatch(installedPatches[k2].isOnlinePatch());
            if (installedPatches[k2].isOnlinePatch()) {
                String sidList = OPatchSessionHelper.getInstancesPatched(OPatchEnv.getOracleHome(), installedPatches[k2].getID(), true, "");
                ((Patch)instance).setInstancesPatched(sidList);
            }
            this.patch.add(instance);
        }
    }

    public void printPatches() {
        if (this.patch == null) {
            OLogger.println("The InventoryInstance is null");
        }
        for (int i2 = 0; i2 < this.patch.size(); ++i2) {
            OLogger.println("patch id is: " + ((Patch)this.patch.get(i2)).getPatchID());
        }
    }

    public HashMap getPatchesHashMap() {
        HashMap<String, Patch> hashMapPatches = new HashMap<String, Patch>();
        if (this.patch == null) {
            return hashMapPatches;
        }
        for (int i2 = 0; i2 < this.patch.size(); ++i2) {
            Patch p2 = (Patch)this.patch.get(i2);
            hashMapPatches.put(p2.getPatchID(), p2);
        }
        return hashMapPatches;
    }

    public List getPatchesList() {
        if (this.patch == null) {
            return new ArrayList();
        }
        return this.patch;
    }

    public HashMap getComponentsHashMap() {
        HashMap<String, OUIComponent> hashMapComponents = new HashMap<String, OUIComponent>();
        if (this.component == null) {
            return hashMapComponents;
        }
        for (int i2 = 0; i2 < this.component.size(); ++i2) {
            OUIComponent c2 = (OUIComponent)this.component.get(i2);
            hashMapComponents.put(c2.getId(), c2);
        }
        return hashMapComponents;
    }

    public List getComponentsList() {
        if (this.component == null) {
            return new ArrayList();
        }
        return this.component;
    }

    public HashMap getPatchSetsInOrder() {
        HashMap<String, OUIComponent> hashMapPatchsets = new HashMap<String, OUIComponent>();
        if (this.patchset == null) {
            return hashMapPatchsets;
        }
        for (int i2 = 0; i2 < this.patchset.size(); ++i2) {
            OUIComponent c2 = (OUIComponent)this.patchset.get(i2);
            hashMapPatchsets.put(c2.getId(), c2);
        }
        return hashMapPatchsets;
    }

    public List getPatchSetsListInOrder() {
        ArrayList sortedPatchsets = new ArrayList();
        if (this.patchset == null) {
            return sortedPatchsets;
        }
        for (int i2 = 0; i2 < this.patchset.size(); ++i2) {
            InventoryInstance.insertIntoList((OUIComponent)this.patchset.get(i2), sortedPatchsets);
        }
        return sortedPatchsets;
    }

    public static void insertIntoList(OUIComponent comp, List list) {
        if (list.size() == 0) {
            list.add(comp);
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            OUIComponent currentEntry = (OUIComponent)list.get(i2);
            if (comp.getId().compareTo(currentEntry.getId()) >= 0) continue;
            list.add(i2, comp);
            return;
        }
    }
}

