/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class HelpSession {
    public void process() {
        this.displayHelp();
    }

    public void displayHelp(String helpFileName) {
        StringBuffer helpM = new StringBuffer("\n");
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("/")) continue;
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFileName});
            OLogger.println(msg);
        }
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        if (OPatchEnv.isFmwHelp()) {
            this.displayHelp("fmw_help.txt");
        }
        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && isObrepo) {
            this.displayHelp("obrepo_help.txt");
        } else {
            this.displayHelp("opatch_help.txt");
        }
    }

    public String getVersion() {
        String fileName = "version.txt";
        String ver = "n/a";
        try {
            InputStream is = this.getClass().getResourceAsStream("version.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String entry = null;
            while ((entry = br.readLine()) != null) {
                StringTokenizer st;
                if (!entry.startsWith("OPATCH_VERSION") || !(st = new StringTokenizer(entry, ":")).hasMoreTokens()) continue;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                ver = st.nextToken();
                ver = ver.trim();
                break;
            }
            br.close();
        }
        catch (Throwable t) {
            StringBuffer buff = new StringBuffer("OPatchEnv::getOPatchVersion() cannot read embed version file " + fileName);
            OLogger.debug(buff);
        }
        return ver;
    }
}

