/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.glcm.opatch.content.errors.CasApiNoOpException;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.CASBranchServices;
import oracle.opatch.opatchlogger.OLogger;

public class CreateSession
implements IOPatchSession {
    private boolean hasOUI = false;

    public boolean isOUIBased() {
        return this.hasOUI;
    }

    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.println(MessageFormat.format("CreateSession process on cas_repo \"{0}\"... ", oracleHome));
        String shadowDir = OPatchEnv.getCasViewPath();
        String branchKey = OPatchEnv.getCasViewId();
        try {
            try {
                OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
                CASBranchServices cas = new CASBranchServices();
                cas.createBranch(shadowDir, branchKey);
                OLogger.println(MessageFormat.format("Created view \"{0}\" on \"{1}\". ", branchKey, shadowDir));
            }
            catch (Throwable t) {
                if (t instanceof CasApiNoOpException) {
                    Object var7_7 = null;
                    OPatchOverCAS.INSTANCE.cleanupCAS();
                    return;
                }
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var7_6 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "createview_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

