/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.opatch.Applicable;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.UpdateTimeStamp;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;

public class CopyAction
extends PatchAction
implements Restorable,
Rollbackable,
Applicable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String copyName;
    private String path;
    private String fileName;
    private boolean updateTimeStamp = false;
    private String fileVersion = "";
    private String diagStr = "";
    private boolean retainPermission = false;
    private static HashMap copyActVer = new HashMap();
    private static HashMap iCopyActVer = new HashMap();
    private static HashMap envCopyActVer = new HashMap();
    private static HashMap copyActionPatchIds = new HashMap();
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private boolean snowBallCopyAction = false;
    private boolean hasFileVersion = false;
    private boolean builtFrom101 = false;

    protected CopyAction(PatchComponent pc, String copyName, String path, String fileName, int lineNumber, boolean updateTimeStamp, String fileVersion, String diagStr, boolean retainPermission, boolean hasFileVersion) throws NullPointerException, Exception {
        this(pc, copyName, path, fileName, lineNumber);
        this.updateTimeStamp = updateTimeStamp;
        this.fileVersion = fileVersion;
        this.diagStr = diagStr;
        this.hasFileVersion = hasFileVersion;
        this.retainPermission = retainPermission;
    }

    public CopyAction(PatchComponent pc, String copyName, String path, String fileName, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (copyName == null || path == null || fileName == null) {
            String errMsg = "The copy action is null";
            if (copyName == null) {
                errMsg = errMsg + "The copy name is null";
            }
            if (path == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (fileName == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.copyName = OPatchEnv.stringPool.getValue(copyName);
        String tmp = PatchObjectUtil.filterString(path);
        this.path = OPatchEnv.stringPool.getValue(tmp);
        tmp = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.fileName = OPatchEnv.stringPool.getValue(tmp);
    }

    public boolean isUpdateTimeStamp() {
        return this.updateTimeStamp;
    }

    public boolean isRetainPermission() {
        return this.retainPermission;
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            File copyFile = new File(this.getParentFilePath(oracleHomePath));
            if (copyFile.exists()) {
                buff = new StringBuffer("File \"");
                buff.append(copyFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(File.separator);
        tmpFile.append(this.fileName);
        File copyFile = new File(tmpFile.toString());
        if (!copyFile.exists()) {
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is not present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(copyFile.toString());
        buff.append("\" is present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    public String getCopyName() {
        return this.copyName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public String getFileDiagStr() {
        return this.diagStr;
    }

    public boolean isHasFileVersion() {
        return this.hasFileVersion;
    }

    public void setSnowBallCopyAction(boolean b2) {
        this.snowBallCopyAction = b2;
    }

    public boolean isSnowBallCopyAction() {
        return this.snowBallCopyAction;
    }

    public String getBackupRollbackPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        return path.toString();
    }

    public static void setHashMap(HashMap m2) {
        copyActVer = (HashMap)m2.clone();
    }

    public static void setIHashMap(HashMap m2) {
        iCopyActVer = (HashMap)m2.clone();
    }

    public static void setHashMapEnv(HashMap m2) {
        envCopyActVer = (HashMap)m2.clone();
    }

    protected boolean isBuiltFrom101Home() {
        return this.builtFrom101;
    }

    public void setBuiltFrom101Home(boolean value) {
        this.builtFrom101 = value;
    }

    public String getSourceFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.fileName);
        return buff.toString();
    }

    public long getSpaceNeeded(String patchLocation) {
        File f2 = new File(this.getSourceFile(patchLocation));
        if (f2.exists()) {
            return f2.length();
        }
        return 0L;
    }

    public String getSourceFile() {
        return this.copyName;
    }

    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.copyName);
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.path);
        return buff.toString();
    }

    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getSourceFile(), this.getParentFilePath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[CopyAction: copyName=\"");
        buff.append(this.copyName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName=\"");
        buff.append(this.fileName);
        buff.append("\", updateTimeStamp=\"");
        buff.append(this.updateTimeStamp);
        buff.append("\", fileVersion=\"");
        buff.append(this.fileVersion);
        buff.append("\", fileDiagnosticStr=\"");
        buff.append(this.diagStr);
        buff.append("\", retainPermission=\"");
        buff.append(this.retainPermission);
        buff.append("\", lineNumber=\"");
        buff.append(String.valueOf(this.lineNumber));
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", sourcePath=\"");
        buff.append(this.getSourceFile("%patch_path%"));
        buff.append("\" rawCopyAction=\" ");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("CopyAction::restorable()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer path = new StringBuffer(backupDir);
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(source);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(source);
        File dstFile = new File(dst);
        if (srcFile.exists() && !srcFile.canRead()) {
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile.exists() && parentFile.canWrite();
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::backupForRestore()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String dst = buff.toString();
        File srcFile = new File(source);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("CopyAction::backupForRestore(): source file \"");
            buff.append(source);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            return;
        }
        File dstFile = new File(dst);
        try {
            if (PatchObjectUtil.checkCreateSimlink(this, OPatchEnv.getAutoRollbackList())) {
                StringBuffer temp = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
                temp.append(File.separator);
                temp.append(this.fileName);
                String target = temp.toString();
                String simlinkLoc = dst;
                buff = new StringBuffer("CopyAction::backForRestore(): create simlink \"");
                buff.append(simlinkLoc);
                buff.append("\" to \"");
                buff.append(target);
                buff.append("\"");
                OLogger.debug(buff);
                OLogger.printlnOnLog("Creating simlink at \"" + simlinkLoc + "\"" + " to " + "\"" + target + "\"");
                OUIReplacer.createSimlink(target, simlinkLoc);
                return;
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while trying to create simlink, so reverting back to previous way of copying the file");
        }
        try {
            buff = new StringBuffer("CopyAction::backupForRestore(): back up \"");
            buff.append(source);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::restore()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        buff = new StringBuffer("CopyAction::restore(): restore file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.copyFile(srcFile, dstFile);
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("CopyAction::rollbackable()");
        OLogger.debug(buff);
        if (this.isBuiltFrom101Home()) {
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(File.separator);
            path.append(".patch_storage");
            path.append(File.separator);
            path.append(cookedPatchID);
            path.append(File.separator);
            path.append(this.fileName);
            String preFileName = path.toString() + "_pre_" + cookedPatchID;
            File preF = new File(preFileName);
            if (preF.exists()) {
                if (!preF.canRead()) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" is not readable.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
                if (preF.isDirectory()) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" is a directory.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            } else {
                String newFileName = path.toString() + "_opatch_new_" + cookedPatchID;
                File newF = new File(newFileName);
                if (!newF.exists()) {
                    buff = new StringBuffer("Copy Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" does not exists.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            }
            return true;
        }
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String src = path.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("CopyAction::rollbackable() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (srcFile.exists() && !srcFile.canRead()) {
            buff = new StringBuffer("Copy Action: Source file \"");
            buff.append(srcFile.getAbsolutePath());
            buff.append("\" is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (srcFile.isDirectory()) {
            buff = new StringBuffer("Copy Action: Source file \"");
            buff.append(srcFile.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Copy Action: Directory \"");
            buff.append(new File(psCookedPatchIDPath).getAbsolutePath());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && dstFile.isDirectory()) {
            buff = new StringBuffer("Copy Action: Destination file \"");
            buff.append(dstFile.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists()) {
            if (!srcFile.exists()) {
                buff = new StringBuffer("Dir :");
                buff.append(parentFile.getPath());
                buff.append(" does not exist, and file is a new file, so returning true");
                OLogger.printlnOnLog(buff.toString());
                return true;
            }
            parentFile.mkdirs();
        }
        if (!parentFile.exists()) {
            buff = new StringBuffer("Copy Action: ");
            buff.append("Cannot mkdirs on \"");
            try {
                buff.append(parentFile.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\".");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (!srcFile.exists() && !parentFile.canWrite()) {
            buff = new StringBuffer("Copy Action: Destination directory \"");
            buff.append(parentFile.getAbsolutePath());
            buff.append("\" is not writable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("CopyAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        boolean ok;
        StringBuffer buff = new StringBuffer("CopyAction::backupForRollback()");
        OLogger.debug(buff);
        String src = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        File srcFile = new File(src);
        buff = new StringBuffer("CopyAction::backupForRollback() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!srcFile.exists()) {
            buff = new StringBuffer("CopyAction::backupForRollback() : source ");
            buff.append(", src = \"");
            buff.append(src);
            buff.append("\" does not exist, will not back it up.");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            buff = new StringBuffer("CopyAction::backupForRollback(): source file \"");
            buff.append(src);
            buff.append("\" not exist, so not creating ");
            buff.append(src);
            buff.append(" in the backup area. ");
            OLogger.debug(buff);
            StringBuffer dstFileName = new StringBuffer(this.fileName);
            dstFileName.append("_opatch_");
            dstFileName.append(cookedPatchID);
            path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            path.append(File.separator);
            path.append(dstFileName);
            dst = path.toString();
            path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            path.append(File.separator);
            path.append(this.fileName);
            File dstFile = new File(path.toString());
            if (dstFile.exists()) {
                dstFile.delete();
            }
            return;
        }
        File dstFile = new File(dst);
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists() && !(ok = parentFile.mkdirs())) {
            buff = new StringBuffer("CopyAction::backupForRollback(): cannot mkdirs on ");
            buff.append(parentFile.getPath());
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            buff = new StringBuffer("CopyAction::backupForRollback(): back up ");
            buff.append(src);
            buff.append(" to ");
            buff.append(dst);
            OLogger.debug(buff);
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (RuntimeException e2) {
            this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{src, dst, e2.getMessage()});
            OLogger.println(this.backupForRollbackFailureDesc);
            throw e2;
        }
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer("CopyAction::getRollbackScriptEntry()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer rollbackStr = new StringBuffer("\n");
        File dstFile = new File(dst);
        if (!dstFile.exists()) {
            buff = new StringBuffer(dst);
            buff.append("_opatch_");
            buff.append(cookedPatchID);
            File dstNewFile = new File(buff.toString());
            if (dstNewFile.exists()) {
                if (isWindow) {
                    rollbackStr.append("del ");
                } else {
                    rollbackStr.append("\\rm -f ");
                }
                rollbackStr.append(source);
                return rollbackStr.toString();
            }
            rollbackStr.append(source);
            return rollbackStr.toString();
        }
        if (isWindow) {
            rollbackStr.append("copy /Y ");
        } else {
            rollbackStr.append("\\cp -f ");
        }
        rollbackStr.append(dst);
        rollbackStr.append(" ");
        rollbackStr.append(source);
        return rollbackStr.toString();
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff;
        block6: {
            buff = new StringBuffer("CopyAction::rollback()");
            OLogger.debug(buff);
            buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(File.separator);
            buff.append(this.fileName);
            String src = buff.toString();
            String dst = this.getParentFilePath(oracleHomePath);
            File srcFile = new File(src);
            File dstFile = new File(dst);
            boolean cont = Rules.SystemWrite_continue();
            buff = new StringBuffer(" CopyAction: src=\"");
            buff.append(src);
            buff.append("\", dst=\"");
            buff.append(dst);
            buff.append("\"");
            OLogger.verbose(this, buff);
            try {
                buff = new StringBuffer("CopyAction::rollback(): restore file from \"");
                buff.append(src);
                buff.append("\" to \"");
                buff.append(dst);
                buff.append("\"");
                OLogger.debug(buff);
                if (srcFile.exists() && srcFile.canRead()) {
                    buff = new StringBuffer();
                    buff.append(dst);
                    OLogger.onlyLogInfo("OUI-67047", new Object[]{buff.toString()});
                    if (cont) {
                        this.performCopyOperation(oracleHomePath, srcFile, dstFile);
                    }
                    break block6;
                }
                if (!srcFile.exists()) {
                    OLogger.justlog(OLogger.INFO, "Deleting file \"" + dst + "\"");
                    if (cont && !dstFile.delete()) {
                        buff = new StringBuffer("Unable to delete the file, so doing nothing.");
                        OLogger.printlnOnLog(buff.toString());
                    }
                    break block6;
                }
                throw new RuntimeException(src + "exists but it is not readable.");
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
                buff = new StringBuffer("CopyAction::rollback() failed: \"");
                buff.append(e2.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" CopyAction done");
        OLogger.verbose(this, buff);
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("CopyAction::applicable()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("Copy Action: Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (parentFile.exists() && !parentFile.canRead()) {
            buff = new StringBuffer("Copy Action: Directory is not readable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("Copy Action: Destination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        boolean dirCheck = false;
        if (OPatchEnv.isWindows()) {
            dirCheck = parentFile.exists() && !parentFile.canWrite();
        } else {
            boolean bl = dirCheck = !dstFile.exists() && parentFile.exists() && !parentFile.canWrite();
        }
        if (dirCheck) {
            buff = new StringBuffer("Copy Action: Directory is not writeable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!OPatchEnv.isWindows() && !parentFile.exists()) {
            try {
                File oh = new File(oracleHomePath);
                String ohPath = oh.getCanonicalPath();
                while (true) {
                    if ((parentFile = dstFile.getParentFile()).exists()) {
                        String curPath = parentFile.getCanonicalPath();
                        if (!parentFile.canWrite()) {
                            buff = new StringBuffer("Copy Action: Directory is not writeable: \"");
                            buff.append(parentFile.getPath());
                            buff.append("\"");
                            this.nonApplicableDesc = buff.toString();
                            return false;
                        }
                        if (curPath.equals(ohPath)) break;
                    }
                    dstFile = parentFile;
                }
            }
            catch (Throwable t) {
                buff = new StringBuffer("Copy Action: OPatch failed due to serious exception: ");
                buff.append(t.getMessage());
                this.nonApplicableDesc = buff.toString();
                return false;
            }
        }
        return true;
    }

    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        boolean identical;
        StringBuffer buff = new StringBuffer("CopyAction::verify()");
        OLogger.debug(buff);
        if (this.isSnowBallCopyAction() && this.isHasFileVersion()) {
            int retVal;
            String appVersion = (String)copyActVer.get(this);
            String copyActVersion = this.getFileVersion();
            boolean skip = false;
            if (OPatchEnv.isFATwoPhase()) {
                if (!this.getFileVersion().equals(envCopyActVer.get(this.getFilename()))) {
                    skip = true;
                }
            } else if (appVersion != null && !appVersion.equals("") && (retVal = OPatchSessionHelper.isGreaterDecimal(appVersion, copyActVersion)) >= 0) {
                skip = true;
            }
            if (skip) {
                OLogger.printlnOnLogAndVerbose("Skipping verification for this copy action \"" + this.getParentFilePath(oracleHomePath) + "\"");
                OLogger.printlnOnLogAndVerbose("This is a snowball copy but not updated in OH due to less or equal file versions.");
                return true;
            }
        }
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("\n(C): Comparing file \"");
        buff.append(src);
        buff.append("\" and \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.log(OLogger.FINE, buff.toString());
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists()) {
            buff = new StringBuffer("Source file \"");
            buff.append(src);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        if (!dstFile.exists()) {
            buff = new StringBuffer("Destination file \"");
            buff.append(dst);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        FileInputStream srcStream = new FileInputStream(src);
        FileInputStream dstStream = new FileInputStream(dst);
        boolean bl = identical = this.updateTimeStamp ? true : CopyAction.fileCompare(srcStream, dstStream);
        if (this.updateTimeStamp) {
            OLogger.printlnOnLogAndVerbose("Skip verification for the copy action \"" + this.getParentFilePath(oracleHomePath) + "\" as timestamps are updated for this action");
        }
        ((InputStream)srcStream).close();
        ((InputStream)dstStream).close();
        buff = new StringBuffer("  2 files are identical? ");
        buff.append(String.valueOf(identical).toUpperCase());
        OLogger.log(OLogger.FINE, buff.toString());
        if (!identical) {
            this.printVerificationFailure(this, src, dst);
            OLogger.printlnOnLog(OLogger.INFO, new String("Failed file pair information (copy)::"));
            try {
                StringBuffer srcBuffer = new StringBuffer("Source file name is : " + src);
                srcBuffer.append(",  size is : ");
                srcBuffer.append(new Long(srcFile.length()).toString());
                OLogger.printlnOnLog(OLogger.INFO, srcBuffer.toString());
                StringBuffer destBuffer = new StringBuffer("Destination file name is : " + dst);
                destBuffer.append(",  size is : ");
                destBuffer.append(new Long(dstFile.length()).toString());
                OLogger.printlnOnLog(OLogger.INFO, destBuffer.toString());
            }
            catch (Exception e2) {
                OLogger.printlnOnLog(OLogger.INFO, new String("Some error in recording this file size pair"));
            }
        }
        return identical;
    }

    public void performCopyOperation(String oracleHomePath, File srcFile, File dstFile) {
        if (this.updateTimeStamp && UpdateTimeStamp.isArchive(this.copyName)) {
            long time = System.currentTimeMillis();
            String mySrc = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()) + File.separator + this.copyName;
            OLogger.logTime(new StringBuffer("Updating TimeStamp of all entries recursively for --> \"" + mySrc + "\" at --> "));
            UpdateTimeStamp.updateTime(srcFile.getPath(), mySrc, time);
            OLogger.logTime(new StringBuffer("TimeStamp of all entries updated for --> \"" + mySrc + "\" at --> "));
            SystemCall.copyFile(new File(mySrc), dstFile, this);
            OPatchSessionHelper.deleteRecurse(mySrc);
        } else {
            SystemCall.copyFile(srcFile, dstFile, this);
        }
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CopyAction::apply()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" CopyAction: src=\"");
        buff.append(src);
        buff.append("\", dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        File parentFile = dstFile.getParentFile();
        boolean cont = Rules.SystemWrite_continue();
        if (cont) {
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!parentFile.exists()) {
                buff = new StringBuffer("CopyAction::apply(): cannot mkdirs on parent directory ");
                try {
                    buff.append(parentFile.getCanonicalPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
        }
        if (!srcFile.exists()) {
            buff = new StringBuffer("CopyAction::apply()");
            buff.append(": the src file is not there.  This should not happen because ");
            buff.append("caller has certified that this CopyAction is applicable. src = ");
            buff.append(src);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            String srcVer = "";
            String destVer = "";
            if (cont) {
                boolean doCopy = true;
                boolean intra = false;
                if (!this.isHasFileVersion()) {
                    doCopy = true;
                } else if (!this.isSnowBallCopyAction()) {
                    OLogger.printlnOnLogAndVerbose("This copy action is not part of snowball patch");
                    doCopy = true;
                } else {
                    OLogger.printlnOnLogAndVerbose("This copy has file version & is a snowball copy");
                    if (OPatchEnv.isFATwoPhase()) {
                        if (!this.getFileVersion().equals(envCopyActVer.get(this.getFilename()))) {
                            srcVer = this.getFileVersion();
                            destVer = (String)copyActVer.get(this.getFilename());
                            if (destVer == null) {
                                intra = true;
                                destVer = (String)iCopyActVer.get(this.getFilename());
                            }
                            doCopy = false;
                            this.setApplyFailed();
                        }
                    } else if (envCopyActVer.containsKey(this)) {
                        srcVer = this.getFileVersion();
                        destVer = (String)envCopyActVer.get(this);
                        OLogger.printlnOnLogAndVerbose("To be Applied Version : " + srcVer);
                        OLogger.printlnOnLogAndVerbose("Present Highest Version in OH : " + destVer);
                        int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer);
                        if (retVal == 1) {
                            doCopy = true;
                        } else {
                            doCopy = false;
                            this.setApplyFailed();
                        }
                    } else {
                        doCopy = true;
                    }
                }
                StringBuffer ts = new StringBuffer("Start Copy Action at ");
                OLogger.logTime(ts);
                OLogger.printlnOnLogAndVerbose("Do copy for this action ? --> " + doCopy);
                if (doCopy) {
                    if (this.isHasFileVersion() && this.isSnowBallCopyAction()) {
                        OLogger.info("OUI-67629", new Object[]{this.getParentFilePath(oracleHomePath), this.getFileVersion()});
                        if (!OPatchEnv.isFATwoPhase()) {
                            envCopyActVer.put(this, this.getFileVersion());
                        }
                    } else {
                        OLogger.onlyLogInfo("OUI-67047", new Object[]{this.getParentFilePath(oracleHomePath)});
                    }
                    this.performCopyOperation(oracleHomePath, srcFile, dstFile);
                    if (OPatchEnv.isFATwoPhase()) {
                        Set keys = envCopyActVer.keySet();
                        Iterator itr = keys.iterator();
                        while (itr.hasNext()) {
                            String fileName = (String)itr.next();
                            if (!this.getFilename().equals(fileName)) continue;
                            itr.remove();
                        }
                    }
                } else if (intra) {
                    OLogger.println(OLogger.getString("OUI-67659", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
                } else {
                    OLogger.println(OLogger.getString("OUI-67630", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
                }
                ts = new StringBuffer("Finish Copy Action at ");
                OLogger.logTime(ts);
            } else {
                buff = new StringBuffer("CopyAction::apply() skips copying the file from ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
            }
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
            String retry = OLogger.getString("OUI-67621", new Object[]{oracleHomePath});
            String retryMessage = "\n" + warnMsg + " " + retry;
            OLogger.println(retryMessage);
            String question = OLogger.getString("OUI-67622");
            buff = new StringBuffer("CopyAction::apply() failed: \"");
            buff.append(e2.getMessage());
            buff.append("\"");
            OLogger.debug(buff);
            if (!OPatchEnv.proceedWithOperationDefaultNo(question)) {
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            try {
                retry = OLogger.getString("OUI-67623", new Object[]{dst});
                OLogger.println(retry);
                StringBuffer ts = new StringBuffer("Retry Copy Action at ");
                OLogger.logTime(ts);
                SystemCall.copyFile(srcFile, dstFile, this);
                ts = new StringBuffer("Finish Copy Action at ");
                OLogger.logTime(ts);
            }
            catch (RuntimeException ex) {
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(ex.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" CopyAction done");
        OLogger.verbose(this, buff);
    }

    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComp, src, dst});
        return desc;
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComp, src, dst});
        return desc;
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("CopyAction::conflictDetectable()  ");
        String dst = this.getParentFilePath(oracleHomePath);
        boolean tmpB = dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String dst = this.getParentFilePath(oracleHomePath);
        String[] filesList = new String[]{dst};
        return filesList;
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof CopyAction) {
            String myFileName = this.getFilename();
            String myPath = this.getPath();
            String myCopyName = this.getCopyName();
            CopyAction it = (CopyAction)o2;
            String itFileName = it.getFilename();
            String itPath = it.getPath();
            String itCopyName = it.getCopyName();
            if (myFileName.equals(itFileName) && myPath.equals(itPath) && myCopyName.equals(itCopyName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fileName.length();
        result = 37 * result + this.copyName.length();
        result = 37 * result + this.path.length();
        return result;
    }

    public String getActionName() {
        return "CopyAction";
    }

    public String getActionDesc() {
        return "Copy a file from source to destination.";
    }

    public String getApplyDescription(String oracleHomePath) {
        return "Copy the file to ORACLE_HOME from the patch.";
    }

    public String getChildPath() {
        return "";
    }

    public String getRollbackDescription(String oracleHomePath) {
        return "Copy the file from backup to ORACLE_HOME.";
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 1;
    }

    public void addCopyActToPatchID(String patchID) {
        copyActionPatchIds.put(this, patchID);
    }

    public static HashMap getCopyActionPatchIds() {
        return copyActionPatchIds;
    }
}

