/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import model.common.FlexibleDataType;
import model.common.OUIComponent;
import model.common.Patch;
import oracle.opatch.Bug;
import oracle.opatch.InventoryInstance;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchSession;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareInventorySession
extends OPatchSession {
    String outputFormat = "%-20s%-12s%-25s%-12s";
    String divider = "________________________________________________________________________________";
    HashMap bugMap;

    public CompareInventorySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void initDiffMaps() {
        this.bugMap = new HashMap();
    }

    public CompareOutput process(String fileName1, String fileName2) {
        Class[] allClasses = new Class[]{Patch.class, OUIComponent.class, InventoryInstance.class};
        InventoryInstance firstInstance = null;
        InventoryInstance secondInstance = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])allClasses);
            Unmarshaller u = jc.createUnmarshaller();
            firstInstance = (InventoryInstance)u.unmarshal(new File(fileName1));
            secondInstance = (InventoryInstance)u.unmarshal(new File(fileName2));
        }
        catch (JAXBException e2) {
            throw new RuntimeException(OLogger.getString("OUI-68001"));
        }
        return this.calculateDiff(firstInstance, secondInstance);
    }

    public void process() {
        Class[] allClasses = new Class[]{Patch.class, OUIComponent.class, InventoryInstance.class};
        InventoryInstance firstInstance = null;
        InventoryInstance secondInstance = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])allClasses);
            Unmarshaller u = jc.createUnmarshaller();
            firstInstance = (InventoryInstance)u.unmarshal(new File(OPatchEnv.getXMLCompare_loc1()));
            secondInstance = (InventoryInstance)u.unmarshal(new File(OPatchEnv.getXMLCompare_loc2()));
        }
        catch (JAXBException e2) {
            throw new RuntimeException(OLogger.getString("OUI-68001"));
        }
        PrintStream p2 = new PrintStream(System.out);
        this.calculateDiffAndPrint(firstInstance, secondInstance, p2);
    }

    public void calculateDiffAndPrint(InventoryInstance firstInstance, InventoryInstance secondInstance, PrintStream p2) {
        try {
            this.initDiffMaps();
            boolean isPatchSetsEqual = this.patchsetsCompare(firstInstance, secondInstance, p2);
            if (isPatchSetsEqual) {
                HashMap firstInstanceBugs = this.getInstanceBugs(firstInstance);
                HashMap secondInstanceBugs = this.getInstanceBugs(secondInstance);
                this.printBugTable(firstInstanceBugs, secondInstanceBugs, p2);
            } else {
                p2.printf("Destination Oracle Home does not have the same patchset version installed as the Source Oracle Home. The patching level of the two homes cannot be compared.\n", new Object[0]);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(OLogger.getString("OUI-68002"));
        }
    }

    public CompareOutput calculateDiff(InventoryInstance firstInstance, InventoryInstance secondInstance) {
        try {
            this.initDiffMaps();
            boolean isPatchSetsEqual = this.patchsetsCompare(firstInstance, secondInstance);
            if (isPatchSetsEqual) {
                HashMap firstInstanceBugs = this.getInstanceBugs(firstInstance);
                HashMap secondInstanceBugs = this.getInstanceBugs(secondInstance);
                CompareOutput result = this.categorizeBugs(firstInstanceBugs, secondInstanceBugs);
                return result;
            }
            throw new OPatchException("Patchsets of source and destination OH do not match. Cannot compare the two homes.");
        }
        catch (Exception e2) {
            String exceptionMsg = e2.getMessage() + "\n" + OLogger.getString("OUI-68002");
            throw new RuntimeException(exceptionMsg);
        }
    }

    public boolean patchsetsCompare(InventoryInstance ii, InventoryInstance ii2, PrintStream p2) {
        List patchsets = ii.getPatchSetsListInOrder();
        List patchsets2 = ii2.getPatchSetsListInOrder();
        if (patchsets.size() != patchsets2.size()) {
            this.printPatchSets(patchsets, patchsets2, p2);
            return false;
        }
        for (int i2 = 0; i2 < patchsets.size(); ++i2) {
            OUIComponent curPatchset1 = (OUIComponent)patchsets.get(i2);
            OUIComponent curPatchset2 = (OUIComponent)patchsets2.get(i2);
            if (curPatchset1.getId().equals(curPatchset2.getId()) && curPatchset1.getName().equals(curPatchset2.getName())) continue;
            this.printPatchSets(patchsets, patchsets2, p2);
            return false;
        }
        return true;
    }

    public boolean patchsetsCompare(InventoryInstance ii, InventoryInstance ii2) {
        List patchsets = ii.getPatchSetsListInOrder();
        List patchsets2 = ii2.getPatchSetsListInOrder();
        if (patchsets.size() != patchsets2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < patchsets.size(); ++i2) {
            OUIComponent curPatchset1 = (OUIComponent)patchsets.get(i2);
            OUIComponent curPatchset2 = (OUIComponent)patchsets2.get(i2);
            if (curPatchset1.getId().equals(curPatchset2.getId()) && curPatchset1.getName().equals(curPatchset2.getName())) continue;
            return false;
        }
        return true;
    }

    public void printPatchSets(List patchsets, List patchsets2, PrintStream p2) {
        int i2;
        p2.printf("The source Oracle Home has the following patchsets: \n", new Object[0]);
        String outputString = "";
        for (i2 = 0; i2 < patchsets.size(); ++i2) {
            OUIComponent curPatchset1 = (OUIComponent)patchsets.get(i2);
            outputString = outputString + "," + curPatchset1.getId();
        }
        if (outputString.length() > 0) {
            p2.printf(outputString.substring(1) + "\n", new Object[0]);
        }
        p2.printf("The destination Oracle Home has the following patchsets: \n", new Object[0]);
        outputString = "";
        for (i2 = 0; i2 < patchsets2.size(); ++i2) {
            OUIComponent curPatchset2 = (OUIComponent)patchsets2.get(i2);
            outputString = outputString + "," + curPatchset2.getId();
        }
        if (outputString.length() > 0) {
            p2.printf(outputString.substring(1) + "\n", new Object[0]);
        }
    }

    public HashMap getInstanceBugs(InventoryInstance ii) {
        List patchList = ii.getPatchesList();
        HashMap<String, Bug> output = new HashMap<String, Bug>();
        for (int i2 = 0; i2 < patchList.size(); ++i2) {
            Patch p2 = (Patch)patchList.get(i2);
            String patchID = p2.getPatchID();
            List<FlexibleDataType> patchBugs = p2.getBug();
            for (int j2 = 0; j2 < patchBugs.size(); ++j2) {
                FlexibleDataType currentBug = patchBugs.get(j2);
                Bug newBug = new Bug(currentBug.getId(), currentBug.getDescription());
                output.put(newBug.getBugID(), newBug);
                if (this.bugMap.containsKey(newBug.getBugID())) {
                    ArrayList currentEntry = (ArrayList)this.bugMap.get(newBug.getBugID());
                    boolean isFound = false;
                    for (int k2 = 0; k2 < currentEntry.size(); ++k2) {
                        if (!currentEntry.get(k2).equals(patchID)) continue;
                        isFound = true;
                    }
                    if (isFound) continue;
                    currentEntry.add(patchID);
                    this.bugMap.put(newBug.getBugID(), currentEntry);
                    continue;
                }
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(patchID);
                this.bugMap.put(newBug.getBugID(), newList);
            }
        }
        return output;
    }

    public void printBugTable(HashMap bugTable1, HashMap bugTable2, PrintStream p2) {
        CompareOutput output = this.categorizeBugs(bugTable1, bugTable2);
        this.printBugTable(output, p2);
    }

    public CompareOutput categorizeBugs(HashMap bugTable1, HashMap bugTable2) {
        HashMap table1 = bugTable1;
        HashMap table2 = bugTable2;
        ArrayList<Bug> sourceButNotDest = new ArrayList<Bug>();
        ArrayList<Bug> destButNotSource = new ArrayList<Bug>();
        ArrayList<Bug> both = new ArrayList<Bug>();
        Collection firstCollection = table1.values();
        for (Bug currentBug : firstCollection) {
            if (table2.containsKey(currentBug.getBugID())) {
                both.add(currentBug);
                table2.remove(currentBug.getBugID());
                continue;
            }
            sourceButNotDest.add(currentBug);
        }
        Collection secondCollection = table2.values();
        Iterator secondTableIterator = secondCollection.iterator();
        while (secondTableIterator.hasNext()) {
            destButNotSource.add((Bug)secondTableIterator.next());
        }
        return new CompareOutput(sourceButNotDest, destButNotSource, both, this.bugMap);
    }

    public void printBugTable(CompareOutput output, PrintStream p2) {
        ArrayList<Bug> sourceNotDestination = output.getBugsInSrcNotDest();
        ArrayList<Bug> destinationNotSource = output.getBugsInDestNotSrc();
        ArrayList<Bug> inBoth = output.getBugsInSrcAndDest();
        p2.printf(this.outputFormat, "Bug Present In", "Bug ID", "Bug Description ", "Patch(es) that Fix Bug");
        p2.printf("\n", new Object[0]);
        p2.printf(this.divider + "\n", new Object[0]);
        Collections.sort(sourceNotDestination);
        Collections.sort(destinationNotSource);
        Collections.sort(inBoth);
        this.printBugs(p2, sourceNotDestination, "ONLY_IN_SOURCE");
        this.printBugs(p2, destinationNotSource, "ONLY_IN_DEST");
        this.printBugs(p2, inBoth, "SOURCE_AND_DEST");
    }

    public void printBugs(PrintStream p2, ArrayList<Bug> bugsList, String title) {
        for (int i2 = 0; i2 < bugsList.size(); ++i2) {
            Bug currentEntry = bugsList.get(i2);
            ArrayList patchList = (ArrayList)this.bugMap.get(currentEntry.getBugID());
            String patches = "";
            for (int j2 = 0; j2 < patchList.size(); ++j2) {
                patches = patches + "," + patchList.get(j2);
            }
            patches = patches.substring(1);
            ArrayList descriptionString = this.formatOutput(currentEntry.getDesc(), 20);
            p2.printf(this.outputFormat, title, currentEntry.getBugID(), descriptionString.get(0), patches);
            p2.printf("\n", new Object[0]);
            for (int k2 = 1; k2 < descriptionString.size(); ++k2) {
                p2.printf(this.outputFormat, "", "", descriptionString.get(1), "");
                p2.printf("\n", new Object[0]);
            }
            p2.printf("\n", new Object[0]);
        }
        if (bugsList.size() > 0) {
            p2.printf(this.divider + "\n", new Object[0]);
        }
    }

    public ArrayList formatOutput(String longString, int numChars) {
        int startIndex = 0;
        ArrayList<String> listOfStrings = new ArrayList<String>();
        while (startIndex + numChars < longString.length()) {
            listOfStrings.add(longString.substring(startIndex, startIndex + numChars));
            startIndex += numChars;
        }
        listOfStrings.add(longString.substring(startIndex));
        return listOfStrings;
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "compare_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompareOutput {
        ArrayList<Bug> bugsInSrcNotDest;
        ArrayList<Bug> bugsInDestNotSrc;
        ArrayList<Bug> bugsInSrcAndDest;
        HashMap<String, ArrayList<String>> bugMap;

        public CompareOutput(ArrayList<Bug> bugsInSrcNotDest, ArrayList<Bug> bugsInDestNotSrc, ArrayList<Bug> bugsInSrcAndDest, HashMap bugMap) {
            this.bugsInSrcNotDest = bugsInSrcNotDest;
            this.bugsInDestNotSrc = bugsInDestNotSrc;
            this.bugsInSrcAndDest = bugsInSrcAndDest;
            this.bugMap = bugMap;
        }

        public ArrayList<Bug> getBugsInSrcNotDest() {
            return this.bugsInSrcNotDest;
        }

        public ArrayList<Bug> getBugsInDestNotSrc() {
            return this.bugsInDestNotSrc;
        }

        public ArrayList<Bug> getBugsInSrcAndDest() {
            return this.bugsInSrcAndDest;
        }

        public HashMap<String, ArrayList<String>> getBugMap() {
            return this.bugMap;
        }
    }
}

