/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.SessionOptionsInfo;
import oracle.opatch.opatchlogger.OLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CmdLineOptionsManager {
    private SessionOptionsInfo applyOptions;
    private SessionOptionsInfo rollbackOptions;
    private SessionOptionsInfo lsinvOptions;
    private SessionOptionsInfo queryOptions;
    private SessionOptionsInfo utilOptions;
    private SessionOptionsInfo prereqOptions;
    private SessionOptionsInfo fmwOptions;
    private SessionOptionsInfo versionOptions;
    private SessionOptionsInfo lspOptions;
    private SessionOptionsInfo compareOptions;
    private SessionOptionsInfo updateOptions;
    private SessionOptionsInfo createOptions;
    private SessionOptionsInfo synchOptions;
    private SessionOptionsInfo listOptions;
    private SessionOptionsInfo destroyOptions;
    private SessionOptionsInfo detachOptions;
    private SessionOptionsInfo attachOptions;

    public CmdLineOptionsManager() {
        this.loadCmdLineOptionsXML();
    }

    protected void loadCmdLineOptionsXML() throws RuntimeException {
        try {
            InputStream is = this.getClass().getResourceAsStream("CmdLineOptions.xml");
            if (is == null) {
                StringBuffer buff = new StringBuffer("Cannot load file \"");
                buff.append("CmdLineOptions.xml");
                buff.append("\".");
                throw new Exception(buff.toString());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            this.buildTheOptionsList(doc);
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("CmdLineOptionsManager::loadCmdLineOptionsXML() returns exception"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected void buildTheOptionsList(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        NodeList sessionList = root.getChildNodes();
        for (int i2 = 0; i2 < sessionList.getLength(); ++i2) {
            Node session = sessionList.item(i2);
            String name = session.getNodeName();
            if (name.equals("#text")) continue;
            NamedNodeMap sessionAttrs = session.getAttributes();
            if (sessionAttrs == null) {
                RuntimeException re = new RuntimeException("Unable to parse the CmdLineOptions file.");
                throw re;
            }
            Node sessionNameNode = sessionAttrs.getNamedItem("name");
            String sessionName = sessionNameNode.getNodeValue();
            NodeList sessionOptLists = session.getChildNodes();
            ArrayList[] optionsList = new ArrayList[3];
            int optionsListIndex = 0;
            optionsList[0] = new ArrayList();
            optionsList[1] = new ArrayList();
            optionsList[2] = new ArrayList();
            for (int j2 = 0; j2 < sessionOptLists.getLength(); ++j2) {
                Node optionListNode = sessionOptLists.item(j2);
                name = optionListNode.getNodeName();
                if (name.equals("#text")) continue;
                NodeList optionList = optionListNode.getChildNodes();
                ++optionsListIndex;
                for (int k2 = 0; k2 < optionList.getLength(); ++k2) {
                    String[] opts;
                    Node optName2Node;
                    Node optName1Node;
                    Node optNode = optionList.item(k2);
                    name = optNode.getNodeName();
                    if (name.equals("#text")) continue;
                    NamedNodeMap oAttrs = optNode.getAttributes();
                    if (oAttrs == null) {
                        RuntimeException re = new RuntimeException("Unable to parse the CmdLineOptions file.");
                        throw re;
                    }
                    if (optionsListIndex == 1) {
                        Node optNameNode = oAttrs.getNamedItem("name");
                        optionsList[optionsListIndex - 1].add(optNameNode.getNodeValue());
                        continue;
                    }
                    if (optionsListIndex == 2) {
                        optName1Node = oAttrs.getNamedItem("name1");
                        optName2Node = oAttrs.getNamedItem("name2");
                        opts = new String[]{optName1Node.getNodeValue(), optName2Node.getNodeValue()};
                        optionsList[optionsListIndex - 1].add(opts);
                        continue;
                    }
                    if (optionsListIndex != 3) continue;
                    optName1Node = oAttrs.getNamedItem("name1");
                    optName2Node = oAttrs.getNamedItem("name2");
                    opts = new String[]{optName1Node.getNodeValue(), optName2Node.getNodeValue()};
                    optionsList[optionsListIndex - 1].add(opts);
                }
            }
            if (sessionName.equals("apply")) {
                this.applyOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("rollback")) {
                this.rollbackOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("lsinv") || sessionName.equals("lsinventory")) {
                this.lsinvOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("lspatches")) {
                this.lspOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("compare")) {
                this.compareOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("query")) {
                this.queryOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("util")) {
                this.utilOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("prereq")) {
                this.prereqOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("fmw")) {
                this.fmwOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("version")) {
                this.versionOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("update")) {
                this.updateOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("createview")) {
                this.createOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("synchview")) {
                this.synchOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("lsviews")) {
                this.listOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("destroyview")) {
                this.destroyOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (sessionName.equals("detach")) {
                this.detachOptions = new SessionOptionsInfo(optionsList);
                continue;
            }
            if (!sessionName.equals("attach")) continue;
            this.attachOptions = new SessionOptionsInfo(optionsList);
        }
    }

    protected boolean isValidOption(String opt) {
        String sessionName = OPatchEnv.getSessionType();
        if (sessionName.equals("apply")) {
            return this.applyOptions.isValidOption(opt);
        }
        if (sessionName.equals("rollback")) {
            return this.rollbackOptions.isValidOption(opt);
        }
        if (sessionName.equals("lsinv") || sessionName.equals("lsinventory")) {
            return this.lsinvOptions.isValidOption(opt);
        }
        if (sessionName.equals("lspatches")) {
            return this.lspOptions.isValidOption(opt);
        }
        if (sessionName.equals("compare")) {
            return this.compareOptions.isValidOption(opt);
        }
        if (sessionName.equals("query")) {
            return this.queryOptions.isValidOption(opt);
        }
        if (sessionName.equals("fmw")) {
            return this.fmwOptions.isValidOption(opt);
        }
        if (sessionName.equals("util") || sessionName.equals("napply") || sessionName.equals("nrollback")) {
            return this.utilOptions.isValidOption(opt);
        }
        if (sessionName.equals("prereq")) {
            return this.prereqOptions.isValidOption(opt);
        }
        if (sessionName.equals("version")) {
            return this.versionOptions.isValidOption(opt);
        }
        if (sessionName.equals("help")) {
            return true;
        }
        if (sessionName.equals("update")) {
            return this.updateOptions.isValidOption(opt);
        }
        if (sessionName.equals("createview")) {
            return this.createOptions.isValidOption(opt);
        }
        if (sessionName.equals("synchview")) {
            return this.synchOptions.isValidOption(opt);
        }
        if (sessionName.equals("lsviews")) {
            return this.listOptions.isValidOption(opt);
        }
        if (sessionName.equals("destroyview")) {
            return this.destroyOptions.isValidOption(opt);
        }
        if (sessionName.equals("detach")) {
            return this.detachOptions.isValidOption(opt);
        }
        if (sessionName.equals("attach")) {
            return this.attachOptions.isValidOption(opt);
        }
        return false;
    }

    protected boolean containsMutuallyExclusiveOptions(String[] opts) {
        String sessionName = OPatchEnv.getSessionType();
        if (sessionName.equals("apply")) {
            return this.applyOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("rollback")) {
            return this.rollbackOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("lsinv") || sessionName.equals("lsinventory")) {
            return this.lsinvOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("lspatches")) {
            return this.lspOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("query")) {
            return this.queryOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("util")) {
            return this.utilOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("prereq")) {
            return this.prereqOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("fmw")) {
            return this.fmwOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("version")) {
            return this.versionOptions.containsMutuallyExclusiveOptions(opts);
        }
        if (sessionName.equals("compare")) {
            return this.compareOptions.containsMutuallyExclusiveOptions(opts);
        }
        return sessionName.equals("help");
    }

    protected boolean containsCombinationOptions(String[] opts) {
        String sessionName = OPatchEnv.getSessionType();
        if (sessionName.equals("apply")) {
            return this.applyOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("rollback")) {
            return this.rollbackOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("lsinv") || sessionName.equals("lsinventory")) {
            return this.lsinvOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("lspatches")) {
            return this.lspOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("query")) {
            return this.queryOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("util")) {
            return this.utilOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("prereq")) {
            return this.prereqOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("fmw")) {
            return this.fmwOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("version")) {
            return this.versionOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("compare")) {
            return this.compareOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("help")) {
            return true;
        }
        if (sessionName.equals("update")) {
            return this.updateOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("createview")) {
            return this.createOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("synchview")) {
            return this.synchOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("lsviews")) {
            return this.listOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("destroyview")) {
            return this.destroyOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("detach")) {
            return this.detachOptions.containsCombinationOptions(opts);
        }
        if (sessionName.equals("attach")) {
            return this.attachOptions.containsCombinationOptions(opts);
        }
        return false;
    }
}

