/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import oracle.opatch.OPatchCmdLineParser;
import oracle.opatch.opatchlogger.OLogger;

public class CmdLineHelper {
    protected static void loadRuntimeOption(String className, OPatchCmdLineParser parser, String[][] arguments, OPatchCmdLineParser.Option[][] runtimeOptions) throws ParseException {
        StringBuffer buff = new StringBuffer("CmdLineHelper::loadRuntimeOption() for Class \"");
        buff.append(className);
        buff.append("\"");
        OLogger.debug(buff);
        block8: for (int index = 0; index < arguments.length; ++index) {
            String[] args = arguments[index];
            int len = args.length;
            switch (index) {
                case 0: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing String option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addStringOption(argument);
                    }
                    buff = new StringBuffer(" done init. String arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                case 1: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing Boolean option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addBooleanOption(argument);
                    }
                    buff = new StringBuffer(" done init. Boolean arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                case 2: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing Integer option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addIntegerOption(argument);
                    }
                    buff = new StringBuffer(" done init. Integer arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                case 3: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing StringTeger option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addStringTegerOption(argument);
                    }
                    buff = new StringBuffer(" done init. SringTeger arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                case 4: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing Double option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addDoubleOption(argument);
                    }
                    buff = new StringBuffer(" done init. Double arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                case 5: {
                    String argument;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        buff = new StringBuffer("  initializing RawString option ");
                        buff.append(i2);
                        buff.append(", ");
                        argument = args[i2];
                        buff.append(argument);
                        OLogger.debug(buff);
                        runtimeOptions[index][i2] = parser.addRawStringOption(argument);
                    }
                    buff = new StringBuffer(" done init. RawString arg.");
                    OLogger.debug(buff);
                    continue block8;
                }
                default: {
                    String msg = "CmdLineHelper::loadRuntimeOption(): unknown options " + index;
                    OLogger.println(msg);
                    throw new ParseException(msg, index);
                }
            }
        }
        buff = new StringBuffer("CmdLineHelper::loadRuntimeOption() for Class \"");
        buff.append(className);
        buff.append("\", done.");
        OLogger.debug(buff);
    }

    private static void invoke(String className, String functionName, String functionArg, String defaultMethodName) throws RuntimeException {
        StringBuffer buff = new StringBuffer("CmdLineHeler::invoke() for \"");
        buff.append(className);
        buff.append("\"");
        OLogger.debug(buff);
        try {
            buff = new StringBuffer(" Checking on class ");
            buff.append(className);
            OLogger.debug(buff);
            Class<?> utilClass = Class.forName(className);
            buff = new StringBuffer(" Get list of methods implemented by the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method[] methods = utilClass.getMethods();
            Class[] parameterTypes = new Class[1];
            String stringTypeName = "java.lang.String";
            buff = new StringBuffer(" Get a class of type ");
            buff.append(stringTypeName);
            OLogger.debug(buff);
            parameterTypes[0] = Class.forName(stringTypeName);
            buff = new StringBuffer(" Get the default method of the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method defaultMethod = utilClass.getMethod(defaultMethodName, parameterTypes);
            Object obj = null;
            Object[] args = new Object[]{functionArg};
            boolean invoked = false;
            buff = new StringBuffer(" Begin searching for method \"");
            buff.append(functionName);
            buff.append("\"");
            OLogger.debug(buff);
            for (int i2 = 0; i2 < methods.length; ++i2) {
                Method method = methods[i2];
                String methodName = method.getName();
                if (!methodName.equals(functionName)) continue;
                buff = new StringBuffer("Invoking method \"");
                buff.append(methodName);
                buff.append("\"");
                OLogger.debug(buff);
                method.invoke(obj, args);
                buff.append(", done.");
                OLogger.debug(buff);
                invoked = true;
            }
            if (!invoked) {
                buff = new StringBuffer("Invoking default method ");
                OLogger.debug(buff);
                defaultMethod.invoke(obj, args);
                buff.append(", done.");
                OLogger.debug(buff);
            }
        }
        catch (ClassNotFoundException e2) {
            buff = new StringBuffer("CmdLineHelper::invoke() failed, ClassNotFoundException: ");
            buff.append(e2.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (InvocationTargetException e3) {
            buff = new StringBuffer("CmdLineHelper::invoke() failed, InvocationException: ");
            Throwable t = e3.getTargetException();
            buff.append(t.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        catch (IllegalAccessException e4) {
            buff = new StringBuffer("CmdLineHelper::invoke() failed, IllegalAccessException: ");
            buff.append(e4.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        catch (NoSuchMethodException e5) {
            buff = new StringBuffer("CmdLineHelper::invoke() failed, NoSuchMethodException: ");
            buff.append(e5.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e5.getStackTrace());
            throw re;
        }
        buff = new StringBuffer("CmdLineHeler::invoke() for \"");
        buff.append(className);
        buff.append("\", done.");
        OLogger.debug(buff);
    }

    protected static void processRuntimeOptions(String className, OPatchCmdLineParser parser, String[][] arguments, OPatchCmdLineParser.Option[][] runtimeOptions, String defaultMethodName) {
        StringBuffer buff = new StringBuffer("CmdLineHelper::processRuntimeOptions() for Class ");
        buff.append(className);
        OLogger.debug(buff);
        block20: for (int index = 0; index < arguments.length; ++index) {
            String[] args = arguments[index];
            int len = args.length;
            OPatchCmdLineParser.Option[] options = runtimeOptions[index];
            switch (index) {
                case 0: {
                    String arg;
                    Object obj;
                    OPatchCmdLineParser.Option option;
                    String functionName;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        functionName = args[i2];
                        option = options[i2];
                        buff = new StringBuffer("  processing arg. of String option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        arg = "n/a";
                        try {
                            arg = (String)obj;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    continue block20;
                }
                case 1: {
                    String functionName;
                    OPatchCmdLineParser.Option option;
                    String arg;
                    Object obj;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        option = options[i2];
                        functionName = args[i2];
                        buff = new StringBuffer("  processing arg. of Boolean option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        arg = "n/a";
                        try {
                            arg = (String)obj;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    continue block20;
                }
                case 2: {
                    Integer Int2;
                    String functionName;
                    OPatchCmdLineParser.Option option;
                    String arg;
                    Object obj;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        option = options[i2];
                        functionName = args[i2];
                        buff = new StringBuffer("  processing arg. of Integer option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        arg = "n/a";
                        try {
                            Int2 = (Integer)obj;
                            arg = Int2.toString();
                        }
                        catch (Exception Int2) {
                            // empty catch block
                        }
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    buff = new StringBuffer(" done processing all integer options.");
                    OLogger.debug(buff);
                    continue block20;
                }
                case 3: {
                    Integer Int2;
                    String functionName;
                    OPatchCmdLineParser.Option option;
                    String arg;
                    Object obj;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        option = options[i2];
                        functionName = args[i2];
                        buff = new StringBuffer("  processing arg. of StringTeger option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        arg = "n/a";
                        try {
                            Int2 = (Integer)obj;
                            arg = Int2.toString();
                        }
                        catch (Exception e2) {
                            try {
                                arg = (String)obj;
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    continue block20;
                }
                case 4: {
                    String functionName;
                    OPatchCmdLineParser.Option option;
                    Object obj;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        option = options[i2];
                        functionName = args[i2];
                        buff = new StringBuffer("  processing arg. of Double option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        Double d2 = (Double)obj;
                        String arg = d2.toString();
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    continue block20;
                }
                case 5: {
                    String arg;
                    Object obj;
                    OPatchCmdLineParser.Option option;
                    String functionName;
                    int i2;
                    for (i2 = 0; i2 < len; ++i2) {
                        functionName = args[i2];
                        option = options[i2];
                        buff = new StringBuffer("  processing arg. of RawString option ");
                        buff.append(functionName);
                        OLogger.debug(buff);
                        obj = parser.getOptionValue(option);
                        if (obj == null) continue;
                        arg = "n/a";
                        try {
                            arg = (String)obj;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        buff = new StringBuffer("     reflection on ");
                        buff.append(functionName);
                        buff.append("(");
                        buff.append(arg);
                        buff.append(")");
                        OLogger.debug(buff);
                        CmdLineHelper.invoke(className, functionName, arg, defaultMethodName);
                    }
                    continue block20;
                }
                default: {
                    OLogger.println("CmdLineHelper::processRuntimeOption(): error");
                }
            }
        }
    }
}

