/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.opatch.Applicable;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PrereqSession;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;

public class ArchiveAction
extends PatchAction
implements Applicable,
Restorable,
Rollbackable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String archiveFilename;
    private String archivePath;
    private ArrayList objectNames;
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private long sizeDiff = 0L;
    private boolean builtFrom101 = false;
    private boolean wasClubbed = false;

    public ArchiveAction(PatchComponent pc, String archiveFilename, String archivePath, String objectName, int lineNumber) throws Exception {
        super(pc, lineNumber);
        if (archiveFilename == null || archivePath == null || objectName == null) {
            String errMsg = "The archive actions is null";
            if (archiveFilename == null) {
                errMsg = errMsg + "The archive name is null";
            }
            if (archivePath == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (objectName == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.archiveFilename = archiveFilename;
        this.archivePath = PatchObjectUtil.filterString(archivePath);
        this.objectNames = new ArrayList();
        this.objectNames.add(PatchObjectUtil.getPlatformDependentPath(objectName));
    }

    public void club(ArchiveAction aa) {
        int i2;
        HashSet<String> basenames = new HashSet<String>();
        for (i2 = 0; i2 < this.objectNames.size(); ++i2) {
            basenames.add(this.getObjectBasename(i2));
        }
        for (i2 = 0; i2 < aa.objectNames.size(); ++i2) {
            if (basenames.contains(aa.getObjectBasename(i2))) continue;
            this.objectNames.add(aa.objectNames.get(i2));
        }
        aa.wasClubbed = true;
    }

    public String printAction(String oracleHomePath) {
        StringBuffer buff = new StringBuffer();
        buff.append("   Update ");
        buff.append(this.getParentFilePath(oracleHomePath));
        buff.append(" with ");
        buff.append(this.getChildPath());
        buff.append("\n");
        return buff.toString();
    }

    public String getSourceFile(String patchPath) {
        if (patchPath == null) {
            patchPath = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchPath);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.objectNames.get(0));
        return buff.toString();
    }

    public String getArchiveName() {
        return this.archiveFilename;
    }

    public String getArchiveFilename() {
        return this.archiveFilename;
    }

    public void setArchiveFilename(String archiveFilename) {
        this.archiveFilename = archiveFilename;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public String getRelativeArchivePath() {
        return this.archivePath + File.separator + this.archiveFilename;
    }

    public String getObjectName() {
        return (String)this.objectNames.get(0);
    }

    protected boolean isBuiltFrom101Home() {
        return this.builtFrom101;
    }

    public void setBuiltFrom101Home(boolean value) {
        this.builtFrom101 = value;
    }

    public String getChildPath() {
        return File.separator + this.getObjectBasename(0);
    }

    public String getObjectBasename(int index) {
        return new File((String)this.objectNames.get(index)).getName();
    }

    public String getObjectPath(int index) {
        return (String)this.objectNames.get(index);
    }

    public String getPatchObjectPath(int index, String patchPath) {
        if (patchPath == null) {
            patchPath = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchPath);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.getObjectPath(index));
        return buff.toString();
    }

    public String getRollbackObjectPath(int index, String oracleHomePath, String cookedPatchID) {
        return this.getRollbackObjectPath(this.getObjectBasename(index), oracleHomePath, cookedPatchID);
    }

    public String getRollbackObjectPath(String objectBasename, String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getRelativeArchivePath());
        path.append(File.separator);
        path.append(objectBasename);
        return path.toString();
    }

    public String getRollbackNewObjectPath(String rollbackObjectPath, String cookedPatchID) {
        StringBuffer newName = new StringBuffer(rollbackObjectPath);
        newName.append("_opatch_");
        newName.append(cookedPatchID);
        return newName.toString();
    }

    public String getScratchObjectPath(String runDir, String objectBasename) {
        StringBuffer tmpArchivePath = new StringBuffer(runDir);
        tmpArchivePath.append(File.separator);
        tmpArchivePath.append(objectBasename);
        return tmpArchivePath.toString();
    }

    public String getOHArchivePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.archiveFilename);
        return buff.toString();
    }

    public String getBackupArchivePath(String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.archivePath);
        path.append(File.separator);
        path.append(this.archiveFilename);
        return path.toString();
    }

    private String getVerifyArchivePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageVerifyDirectoryPath(oracleHomePath, this));
        buff.append(File.separator);
        buff.append(this.archivePath);
        buff.append(File.separator);
        buff.append(this.archiveFilename);
        return buff.toString();
    }

    private String getVerifyObjectPath(String verifyArchivePath, int index) {
        StringBuffer buff = new StringBuffer(verifyArchivePath);
        buff.append(File.separator);
        buff.append(this.getObjectBasename(index));
        return buff.toString();
    }

    public String getArchiveExtractOption(String oracleHomePath) {
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            int platformID = PatchObjectUtil.getARU_ID(oracleHomePath, readServices);
            if (platformID == 293) {
                return " -x ";
            }
            return " -xc ";
        }
        catch (Throwable t) {
            OLogger.printStackTrace(new RuntimeException(t));
            return " -xc ";
        }
    }

    public String runArCommand(String runDir, String ar, String options, String libPath, ArrayList objectPaths) throws RuntimeException {
        String baseCommand = ar + " " + options + " " + libPath;
        int ARG_MAX = 4096;
        if (objectPaths == null || objectPaths.size() == 0) {
            return this.runOneCommand(runDir, baseCommand);
        }
        StringBuffer arCommand = new StringBuffer(baseCommand);
        arCommand.append(" " + (String)objectPaths.get(0));
        for (int i2 = 1; i2 < objectPaths.size(); ++i2) {
            String objP = (String)objectPaths.get(i2);
            if (arCommand.length() + objP.length() + 1 > ARG_MAX) {
                this.runOneCommand(runDir, arCommand.toString());
                arCommand = new StringBuffer(baseCommand);
            }
            arCommand.append(" " + objP);
        }
        return this.runOneCommand(runDir, arCommand.toString());
    }

    public String runOneCommand(String runDir, String command) throws RuntimeException {
        String[] systemCommand = new String[]{command};
        OLogger.log(OLogger.FINE, "Executing '" + systemCommand[0] + "'");
        SystemCall.ExecReturn ret = SystemCall.runtimeExec(systemCommand, runDir);
        OLogger.debug(new StringBuffer(ret.toString()));
        if (!ret.isOK()) {
            throw new RuntimeException(ret.getErrorMessage());
        }
        return ret.getNormalMessage();
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.archiveFilename);
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.archivePath);
        return buff.toString();
    }

    public ArrayList getFilesTouched(String oracleHomePath) {
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        if (this.wasClubbed) {
            return a2;
        }
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            String[] s = new String[]{File.separator + this.getObjectBasename(i2), this.getParentFilePath(oracleHomePath)};
            a2.add(s);
        }
        return a2;
    }

    public long getSpaceNeeded(String patchLocation) {
        if (this.wasClubbed) {
            return 0L;
        }
        long space = 0L;
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            File f2 = new File(this.getPatchObjectPath(i2, patchLocation));
            if (!f2.exists()) continue;
            space += f2.length();
        }
        return space;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[ArchiveAction: archiveName=\"");
        buff.append(this.archiveFilename);
        buff.append("\", path=\"");
        buff.append(this.archivePath);
        buff.append("\", objectName=\"");
        buff.append((String)this.objectNames.get(0));
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", childPath=\"");
        buff.append(this.getChildPath());
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", sourcePath=\"");
        buff.append(this.getPatchObjectPath(0, "%patch_path%"));
        buff.append("\" rawArchiveAction=\"");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("ArchiveAction::restorable()");
        OLogger.debug(buff);
        String src = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.archivePath);
        path.append(File.separator);
        path.append(this.archiveFilename);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists() || !srcFile.canRead()) {
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile.exists() && parentFile.canWrite();
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ArchiveAction::backupForRestore()");
        OLogger.debug(buff);
        String src = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.archivePath);
        path.append(File.separator);
        path.append(this.archiveFilename);
        String dst = path.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("ArchiveAction::backupForRestore(): source file \"");
            buff.append(src);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            return;
        }
        buff = new StringBuffer("ArchiveAction::backupForRestore(): copy file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.backupFile(srcFile, dstFile);
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.archivePath);
        buff.append(File.separator);
        buff.append(this.archiveFilename);
        String src = buff.toString();
        buff = new StringBuffer(this.getParentFilePath(oracleHomePath));
        String dst = buff.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        try {
            if (srcFile.exists() && srcFile.canRead()) {
                SystemCall.backupFile(srcFile, dstFile);
            }
        }
        catch (RuntimeException e2) {
            OLogger.warn("OUI-67004", new Object[]{srcFile.toString(), dstFile.toString(), e2.getMessage()});
        }
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String patchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    public String get101BackupRootPath(int index, String oracleHomePath, String cookedPatchID) {
        String justObjectName = this.getObjectBasename(index);
        StringBuffer path = new StringBuffer(oracleHomePath);
        path.append(File.separator);
        path.append(".patch_storage");
        path.append(File.separator);
        path.append(cookedPatchID);
        path.append(File.separator);
        path.append(this.archivePath);
        path.append(File.separator);
        path.append(justObjectName);
        path.append("_");
        path.append(this.archiveFilename);
        return path.toString();
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        if (this.wasClubbed) {
            return true;
        }
        StringBuffer buff = new StringBuffer("ArchiveAction::rollbackable()");
        OLogger.debug(buff);
        String dst = this.getOHArchivePath(oracleHomePath);
        File dstFile = new File(dst);
        buff = new StringBuffer("ArchiveAction::rollbackable() : dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!(dstFile.exists() && dstFile.canRead() && OPatchSessionHelper.CanWrite(oracleHomePath, dstFile))) {
            buff = new StringBuffer("Achive Action: Destination file \"");
            buff.append(dstFile.getAbsolutePath());
            buff.append("\" does not exists or is not writable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && dstFile.isDirectory()) {
            buff = new StringBuffer("Achive Action: Destination file \"");
            buff.append(dstFile.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Achive Action: Directory \"");
            buff.append(new File(psCookedPatchIDPath).getAbsolutePath());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            String preFileName = this.getRollbackObjectPath(i2, oracleHomePath, cookedPatchID);
            String newFileName = this.getRollbackNewObjectPath(preFileName, cookedPatchID);
            if (this.isBuiltFrom101Home()) {
                String fileRoot = this.get101BackupRootPath(i2, oracleHomePath, cookedPatchID);
                preFileName = fileRoot + "_pre_" + cookedPatchID;
                newFileName = fileRoot + "_opatch_new_" + cookedPatchID;
            }
            buff = new StringBuffer("ArchiveAction::rollbackable() : src = \"");
            buff.append(preFileName);
            buff.append("\"");
            OLogger.debug(buff);
            File preF = new File(preFileName);
            if (!preF.exists()) continue;
            if (!preF.canRead()) {
                buff = new StringBuffer("Archive Action: Source file \"");
                buff.append(preF.getAbsolutePath());
                buff.append("\" is not readable.");
                this.nonRollbackableDesc = buff.toString();
                return false;
            }
            if (!preF.isDirectory()) continue;
            buff = new StringBuffer("Archive Action: Source file \"");
            buff.append(preF.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("ArchiveAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) {
        if (this.wasClubbed) {
            return "";
        }
        OLogger.debug(new StringBuffer("ArchiveAction::getRollbackScriptEntry() begins"));
        if (OPatchEnv.isWindows()) {
            return "\n";
        }
        String ohArchivePath = this.getOHArchivePath(oracleHomePath);
        String runDir = this.getParentDirPath(oracleHomePath);
        String ar = this.getLocalArchiveCommand(oracleHomePath);
        StringBuffer rollbackStr = new StringBuffer("\ncd " + runDir);
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            String preFileName = this.getRollbackObjectPath(i2, oracleHomePath, cookedPatchID);
            String newFileName = this.getRollbackNewObjectPath(preFileName, cookedPatchID);
            StringBuffer tmp = new StringBuffer("ArchiveAction::getRollbackScriptEntry() update file \"");
            tmp.append(preFileName);
            tmp.append("\" to archive file \"");
            tmp.append(ohArchivePath);
            tmp.append("\"");
            OLogger.debug(tmp);
            File preFile = new File(preFileName);
            if (preFile.exists()) {
                rollbackStr.append("\n" + ar + " -rc " + ohArchivePath + " " + preFileName);
                continue;
            }
            File newFile = new File(newFileName);
            if (newFile.exists()) {
                rollbackStr.append("\n" + ar + " -d " + ohArchivePath + " " + this.getObjectBasename(i2));
                continue;
            }
            return "\n" + this.archiveFilename + " " + this.getObjectBasename(i2);
        }
        StringBuffer tmp = new StringBuffer("getRollBackScriptEntry() = ");
        tmp.append(rollbackStr.toString());
        OLogger.debug(rollbackStr);
        OLogger.debug(new StringBuffer("ArchiveAction::getRollbackScriptEntry() done"));
        return rollbackStr.toString();
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (this.wasClubbed) {
            return;
        }
        StringBuffer buff = new StringBuffer("ArchiveAction::backupForRollback()");
        OLogger.debug(buff);
        String ohArchivePath = this.getOHArchivePath(oracleHomePath);
        if (OPatchEnv.isWindows()) {
            throw new RuntimeException("OUI-67001");
        }
        String ar = this.getLocalArchiveCommand(oracleHomePath);
        String runDir = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
        List<String> arContents = Arrays.asList(this.runArCommand(runDir, ar, "-t", ohArchivePath, null).split("\n"));
        HashSet<String> allObjects = new HashSet<String>();
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            allObjects.add(this.getObjectBasename(i2));
        }
        HashSet newObjects = (HashSet)allObjects.clone();
        boolean hasUpdates = newObjects.removeAll(arContents);
        if (hasUpdates) {
            HashSet updateObjects = (HashSet)allObjects.clone();
            updateObjects.retainAll(arContents);
            try {
                String extractOption = this.getArchiveExtractOption(oracleHomePath);
                this.runArCommand(runDir, ar, extractOption, ohArchivePath, new ArrayList(updateObjects));
            }
            catch (RuntimeException e2) {
                String blameMe = (String)updateObjects.iterator().next();
                String target = this.getRollbackObjectPath(blameMe, oracleHomePath, cookedPatchID);
                this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{blameMe, target, e2.getMessage()});
                OLogger.println(this.backupForRollbackFailureDesc);
                throw e2;
            }
            for (String objName : updateObjects) {
                String rbObj = this.getRollbackObjectPath(objName, oracleHomePath, cookedPatchID);
                String scratchObj = this.getScratchObjectPath(runDir, objName);
                try {
                    SystemCall.backupFile(new File(scratchObj), new File(rbObj));
                }
                catch (RuntimeException e3) {
                    this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{objName, rbObj, e3.getMessage()});
                    OLogger.println(this.backupForRollbackFailureDesc);
                    throw e3;
                }
            }
        }
        for (String objName : newObjects) {
            String objRBPath = this.getRollbackObjectPath(objName, oracleHomePath, cookedPatchID);
            try {
                File objRBFile = new File(objRBPath);
                if (!objRBFile.exists()) continue;
                objRBFile.delete();
            }
            catch (RuntimeException e4) {
                this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{"(new file)", objRBPath, e4.getMessage()});
                throw e4;
            }
        }
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        RuntimeException re;
        String warnMsg;
        String blameMe;
        int i2;
        if (this.wasClubbed) {
            return;
        }
        String ar = this.getLocalArchiveCommand(oracleHomePath);
        String ohArchivePath = this.getOHArchivePath(oracleHomePath);
        StringBuffer buff = new StringBuffer(" ArchiveAction:rollback() on \"");
        buff.append(ohArchivePath);
        buff.append("\"");
        OLogger.verbose(this, buff);
        ArrayList<String> newObjectNames = new ArrayList<String>();
        ArrayList updateObjects = new ArrayList();
        ArrayList<String> updateObjectPaths = new ArrayList<String>();
        for (int i3 = 0; i3 < this.objectNames.size(); ++i3) {
            String rbObjectPath = this.getRollbackObjectPath(i3, oracleHomePath, cookedPatchID);
            File rbObjectFile = new File(rbObjectPath);
            String rbNewPath = this.getRollbackNewObjectPath(rbObjectPath, cookedPatchID);
            File rbNewFile = new File(rbNewPath);
            if (rbObjectFile.exists() && rbObjectFile.canRead()) {
                updateObjects.add(this.objectNames.get(i3));
                updateObjectPaths.add(rbObjectPath);
                continue;
            }
            if (!rbObjectFile.exists()) {
                newObjectNames.add(this.getObjectBasename(i3));
                continue;
            }
            buff = new StringBuffer("ArchiveAction::rollback() failed: File is present in backup area, but not readable");
            buff.append(" so ");
            buff.append(rbObjectFile.getName());
            buff.append("is not modified");
            OLogger.log(OLogger.INFO, buff.toString());
            String warnMsg2 = OLogger.getString("OUI-67009", new Object[]{rbObjectFile, ohArchivePath, ""});
            throw new RuntimeException(warnMsg2);
        }
        boolean modify = Rules.SystemWrite_continue();
        for (i2 = 0; i2 < newObjectNames.size(); ++i2) {
            String objName = (String)newObjectNames.get(i2);
            buff = new StringBuffer("Deleting \"");
            buff.append(objName);
            buff.append("\" from archive \"");
            buff.append(ohArchivePath);
            buff.append("\"");
            OLogger.log(OLogger.INFO, buff.toString());
        }
        if (modify && newObjectNames.size() > 0) {
            try {
                this.runArCommand(null, ar, "-d", ohArchivePath, newObjectNames);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                buff = new StringBuffer("ArchiveAction::rollback() failed: \"");
                buff.append(e2.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                blameMe = (String)newObjectNames.get(0);
                warnMsg = OLogger.getString("OUI-67009", new Object[]{blameMe, ohArchivePath, ""});
                re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        for (i2 = 0; i2 < updateObjectPaths.size(); ++i2) {
            String objPath = (String)updateObjects.get(i2);
            OLogger.onlyLogInfo("OUI-67049", new Object[]{ohArchivePath, objPath});
        }
        if (modify && updateObjectPaths.size() > 0) {
            try {
                this.runArCommand(null, ar, "-rc", ohArchivePath, updateObjectPaths);
            }
            catch (Exception e3) {
                OLogger.printStackTrace(e3);
                buff = new StringBuffer("ArchiveAction::rollback() failed: \"");
                buff.append(e3.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                blameMe = (String)updateObjectPaths.get(0);
                warnMsg = OLogger.getString("OUI-67009", new Object[]{blameMe, ohArchivePath, ""});
                re = new RuntimeException(warnMsg);
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" Archive Action done");
        OLogger.verbose(this, buff);
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        if (this.wasClubbed) {
            return true;
        }
        OLogger.debug(new StringBuffer("ArchiveAction::applicable()"));
        String ohArchivePath = this.getOHArchivePath(oracleHomePath);
        String osName = OPatchEnv.getOSName();
        if (OPatchEnv.isWindows()) {
            String blameMe = this.getPatchObjectPath(0, patchLocation);
            OLogger.error("OUI-67001", new Object[]{"Archive", blameMe, ohArchivePath, " ", osName});
            OLogger.debug(new StringBuffer("ArchiveAction::applicable() returns false, as action is not applicable"));
            return false;
        }
        try {
            OPatchProperty opp = new OPatchProperty();
            StringBuffer tmp = new StringBuffer("ArchiveAction check on ar cmd. is OK, will be invoked using \"");
            tmp.append(opp.getArchiveCommand());
            tmp.append("\"");
            OLogger.debug(tmp);
        }
        catch (NoSuchMethodException e2) {
            this.nonApplicableDesc = "Cannot locate executable 'ar', so archive actions cannot be performed.";
            OLogger.debug(new StringBuffer(this.nonApplicableDesc));
            return false;
        }
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            File srcFile = new File(this.getPatchObjectPath(i2, patchLocation));
            if (srcFile.exists() && srcFile.canRead()) continue;
            StringBuffer buff = new StringBuffer("ArchiveAction: Source File \"");
            buff.append(srcFile.getPath());
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        File dstFile = new File(ohArchivePath);
        if (!dstFile.exists() || !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            StringBuffer buff = new StringBuffer("ArchiveAction: Destination File \"");
            buff.append(ohArchivePath);
            buff.append("\" does not exists or is not writeable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    void handleMismatch(String src, String dst) {
        File srcFile = new File(src);
        File dstFile = new File(dst);
        OLogger.printlnOnLog(OLogger.INFO, new String("Failed file pair information (archive)::"));
        try {
            StringBuffer srcBuffer = new StringBuffer("Source file name is : " + src);
            srcBuffer.append(",  size is : ");
            srcBuffer.append(new Long(srcFile.length()).toString());
            OLogger.printlnOnLog(OLogger.INFO, srcBuffer.toString());
            StringBuffer destBuffer = new StringBuffer("Destination file name (extracted from Oracle Home) is : " + dst);
            destBuffer.append(",  size is : ");
            destBuffer.append(new Long(dstFile.length()).toString());
            long x = new Long(srcFile.length());
            long y = new Long(dstFile.length());
            long z = Math.abs(y - x);
            if (z == 4L) {
                this.setSizeDiff(z);
            }
            OLogger.printlnOnLog(OLogger.INFO, destBuffer.toString());
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(OLogger.INFO, new String("Some error in recording this file size pair"));
        }
    }

    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        boolean ok;
        StringBuffer buff;
        if (this.wasClubbed) {
            return true;
        }
        OLogger.debug(new StringBuffer("ArchiveAction::verify()"));
        if (OPatchEnv.isWindows()) {
            StringBuffer buff2 = new StringBuffer("This is Windows platform: OPatch will skip ");
            buff2.append("Archive verification.");
            OLogger.log(OLogger.WARNING, buff2.toString());
            return false;
        }
        String ohArchivePath = this.getParentFilePath(oracleHomePath);
        if (!new File(ohArchivePath).exists()) {
            StringBuffer buff3 = new StringBuffer("Destination .a file \"");
            buff3.append(ohArchivePath);
            buff3.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff3.toString());
            return false;
        }
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            String poPath = this.getPatchObjectPath(i2, patchLocation);
            File srcFile = new File(poPath);
            buff = new StringBuffer("\n(A) Comparing object file \"");
            buff.append(poPath);
            buff.append("\" to the object entry \"");
            buff.append(this.getObjectBasename(i2));
            buff.append("\" inside the .a file \"");
            buff.append(ohArchivePath);
            buff.append("\"");
            OLogger.log(OLogger.FINE, buff.toString());
            if (srcFile.exists()) continue;
            StringBuffer tmp = new StringBuffer("Source object file \"");
            tmp.append(poPath);
            tmp.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, tmp.toString());
            return false;
        }
        String vDir = OPatchEnv.getPatchStorageVerifyDirectoryPath(oracleHomePath, this);
        File vFile = new File(vDir);
        if (!vFile.exists() && !(ok = vFile.mkdirs())) {
            buff = new StringBuffer("Not able to create directory \"");
            buff.append(vDir);
            buff.append("\".  Can't verify.");
            throw new IOException(buff.toString());
        }
        String verifyArchivePath = this.getVerifyArchivePath(oracleHomePath);
        File verifyArchiveFile = new File(verifyArchivePath);
        if (!verifyArchiveFile.exists()) {
            if (!verifyArchiveFile.mkdirs()) {
                StringBuffer buff4 = new StringBuffer("Unable to create temporary directory \"");
                buff4.append(verifyArchivePath);
                buff4.append("\".  Can't verify.");
                OLogger.log(OLogger.WARNING, buff4.toString());
                return false;
            }
        } else {
            for (int i3 = 0; i3 < this.objectNames.size(); ++i3) {
                String verifyObjectPath = this.getVerifyObjectPath(verifyArchivePath, i3);
                File verifyObjectFile = new File(verifyObjectPath);
                if (!verifyObjectFile.exists() || verifyObjectFile.delete()) continue;
                StringBuffer buff5 = new StringBuffer("Unable to delete left-over file \"");
                buff5.append(verifyObjectPath);
                buff5.append("\".  Can't verify.");
                OLogger.log(OLogger.WARNING, buff5.toString());
                return false;
            }
        }
        try {
            ArrayList<String> basenames = new ArrayList<String>();
            for (int i4 = 0; i4 < this.objectNames.size(); ++i4) {
                basenames.add(this.getObjectBasename(i4));
            }
            String ar = this.getLocalArchiveCommand(oracleHomePath);
            this.runArCommand(verifyArchivePath, ar, this.getArchiveExtractOption(oracleHomePath), ohArchivePath, basenames);
        }
        catch (Exception e2) {
            StringBuffer buff6 = new StringBuffer("Error verification failed: ");
            buff6.append(e2.getMessage());
            IOException ie = new IOException(buff6.toString());
            ie.setStackTrace(e2.getStackTrace());
            throw ie;
        }
        for (int i5 = 0; i5 < this.objectNames.size(); ++i5) {
            String patchObjectPath = this.getPatchObjectPath(i5, patchLocation);
            String verifyObjectPath = this.getVerifyObjectPath(verifyArchivePath, i5);
            try {
                FileInputStream patchS = new FileInputStream(new File(patchObjectPath));
                FileInputStream verifyS = new FileInputStream(new File(verifyObjectPath));
                boolean identical = ArchiveAction.fileCompare(patchS, verifyS);
                ((InputStream)patchS).close();
                ((InputStream)verifyS).close();
                if (identical) continue;
                this.printVerificationFailure(this, patchObjectPath, ohArchivePath);
                this.handleMismatch(patchObjectPath, verifyObjectPath);
                return false;
            }
            catch (IOException e3) {
                StringBuffer buff7 = new StringBuffer("Error reading files to verify \"");
                buff7.append(patchObjectPath);
                buff7.append("\" == \"");
                buff7.append(verifyObjectPath);
                buff7.append("\".  Can't verify.");
                throw new IOException(buff7.toString());
            }
        }
        return true;
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        if (this.wasClubbed) {
            return;
        }
        OLogger.debug(new StringBuffer("ArchiveAction::apply()"));
        String ohArchivePath = this.getParentFilePath(oracleHomePath);
        boolean modify = Rules.SystemWrite_continue();
        ArrayList<String> patchObjects = new ArrayList<String>();
        for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
            OLogger.onlyLogInfo("OUI-67049", new Object[]{ohArchivePath, this.getObjectPath(i2)});
            String patchObject = this.getPatchObjectPath(i2, patchLocation);
            patchObjects.add(patchObject);
            File patchObjectFile = new File(patchObject);
            if (!(!modify || patchObjectFile.exists() && patchObjectFile.canRead())) {
                throw new RuntimeException("MultiPatchAction::apply() failed: Couldn't read source file \"" + patchObjectFile + "\"");
            }
            StringBuffer buff = new StringBuffer(" ArchiveAction: src = \"");
            buff.append(patchObject);
            buff.append("\", dst = \"");
            buff.append(ohArchivePath);
            buff.append("\"");
            OLogger.verbose(this, buff);
        }
        if (modify) {
            try {
                String ar = this.getLocalArchiveCommand(oracleHomePath);
                this.runArCommand(null, ar, "-rc", ohArchivePath, patchObjects);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                StringBuffer buff = new StringBuffer("ArchiveAction::apply() failed: \"");
                buff.append(e2.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                String blamedObject = this.getPatchObjectPath(0, patchLocation);
                String warnMsg = OLogger.getString("OUI-67010", new Object[]{blamedObject, ohArchivePath, ""});
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        } else {
            StringBuffer buff = new StringBuffer("ArchiveAction::apply() skips running command ");
            buff.append(" on dst ");
            buff.append(ohArchivePath);
            OLogger.debug(buff);
        }
        OLogger.verbose(this, new StringBuffer(" Archive Action done"));
    }

    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getArchiveFilename());
        String src = this.getChildPath();
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67154", new Object[]{owningComp, dst, src});
        return desc;
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getArchivePath());
        dst.append(File.separator);
        dst.append(this.getArchiveFilename());
        String src = this.getChildPath();
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67154", new Object[]{owningComp, dst, src});
        return desc;
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("ArchiveAction::conflictDetectable()  ");
        StringBuffer fbuff = new StringBuffer(this.getParentFilePath(oracleHomePath));
        String src = fbuff.toString();
        String dst = this.getChildPath();
        boolean tmpB = src != null && !src.equals("") && dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String[] filesList = new String[]{this.getOHArchivePath(oracleHomePath), File.separator + this.getObjectBasename(0)};
        return filesList;
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    public void setObjectName(String objectName) {
        this.objectNames.set(0, objectName);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof ArchiveAction) {
            String myName = this.getArchiveName();
            String myPath = this.getArchivePath();
            String myObj = this.getObjectName();
            ArchiveAction aa = (ArchiveAction)o2;
            String itName = aa.getArchiveName();
            String itPath = aa.getArchivePath();
            String itObj = aa.getObjectName();
            if (myName.equals(itName) && myPath.equals(itPath) && myObj.equals(itObj)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + ((String)this.objectNames.get(0)).length();
        result = 37 * result + this.archiveFilename.length();
        result = 37 * result + this.archivePath.length();
        return result;
    }

    public String getActionName() {
        return "ArchiveAction";
    }

    public String getActionDesc() {
        return "Archive an object file into a library.";
    }

    public String getApplyDescription(String oracleHomePath) {
        return "Replace the object file with patch file.";
    }

    public String getRollbackDescription(String oracleHomePath) {
        return "Replace the object file from the backup.";
    }

    protected String getLocalArchiveCommand(String oracleHomePath) {
        OPatchProperty opp = new OPatchProperty();
        String AR = "";
        try {
            AR = opp.getArchiveCommand();
        }
        catch (NoSuchMethodException e2) {
            AR = "ar ";
        }
        return AR;
    }

    protected void setSizeDiff(long size) {
        this.sizeDiff = size;
    }

    protected long getSizeDiff() {
        return this.sizeDiff;
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        int fileNumber = 0;
        if (!this.wasClubbed) {
            String ohArchivePath = this.getOHArchivePath(oracleHomePath);
            if (OPatchEnv.isWindows()) {
                throw new RuntimeException("OUI-67001");
            }
            String ar = this.getLocalArchiveCommand(oracleHomePath);
            String runDir = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
            List<String> arContents = Arrays.asList(this.runArCommand(runDir, ar, "-t", ohArchivePath, null).split("\n"));
            HashSet<String> allObjects = new HashSet<String>();
            for (int i2 = 0; i2 < this.objectNames.size(); ++i2) {
                allObjects.add(this.getObjectBasename(i2));
            }
            HashSet newObjects = (HashSet)allObjects.clone();
            boolean hasUpdates = newObjects.removeAll(arContents);
            if (hasUpdates) {
                HashSet updateObjects = (HashSet)allObjects.clone();
                fileNumber += updateObjects.size();
            }
        }
        return fileNumber;
    }
}

