/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.NameValuePair;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.XMLConverter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ActionsFileParser
extends DefaultHandler {
    protected LinkedList compList = new LinkedList();
    protected int lineNumber = 1;
    protected JarClassLoader oextJarLoader = null;
    protected String patchFilesLocation = null;
    private File actionsFile = null;
    private InputStream actionsStream = null;
    private static HashMap pdtDirMap = new HashMap();

    private ActionsFileParser(JarClassLoader oextJarLoader, String patchFilesLocation) {
        this.oextJarLoader = oextJarLoader;
        this.patchFilesLocation = patchFilesLocation;
    }

    public ActionsFileParser(File actionsFile, JarClassLoader oextJarLoader, String patchFilesLocation) {
        this(oextJarLoader, patchFilesLocation);
        this.actionsFile = actionsFile;
    }

    public ActionsFileParser(InputStream actionsStream, JarClassLoader oextJarLoader, String patchFilesLocation) {
        this(oextJarLoader, patchFilesLocation);
        this.actionsStream = actionsStream;
    }

    protected LinkedList parseActionsContent() throws RuntimeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (this.actionsFile != null) {
                saxParser.parse(this.actionsFile, (DefaultHandler)this);
            } else if (this.actionsStream != null) {
                saxParser.parse(this.actionsStream, (DefaultHandler)this);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof SymbolFailureException) {
                SymbolFailureException se = new SymbolFailureException("Failed to parse action.xml: " + this.actionsFile.getAbsolutePath() + e2.getMessage());
                se.setStackTrace(e2.getStackTrace());
                throw se;
            }
            StringBuilder errMsgBuff = new StringBuilder(this.actionsFile.getAbsolutePath());
            errMsgBuff.append(" with ").append(e2.getMessage());
            RuntimeException re = new RuntimeException(errMsgBuff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return this.compList;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public boolean isActionElement(String name) throws RuntimeException {
        if (name.equals("copy") || name.equals("jar") || name.equals("archive") || name.equals("make")) {
            return true;
        }
        String className = name + "Action";
        Class<?> actionClass = null;
        try {
            actionClass = Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (actionClass == null) {
                try {
                    String classNamePath = "oracle.opatch.opatchactions." + className;
                    actionClass = Class.forName(classNamePath);
                    return true;
                }
                catch (ClassNotFoundException classNamePath) {
                    // empty catch block
                }
            }
            if (this.oextJarLoader != null && actionClass == null) {
                try {
                    actionClass = this.oextJarLoader.loadClass(className);
                    return true;
                }
                catch (ClassNotFoundException e2) {
                    return false;
                }
            }
            return false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("#text")) {
            ++this.lineNumber;
            return;
        }
        if (qName.equals("oneoff_actions")) {
            ++this.lineNumber;
            return;
        }
        if (this.isActionElement(qName)) {
            block72: {
                PatchComponent patchComp = (PatchComponent)this.compList.get(this.compList.size() - 1);
                if (patchComp.isFilter()) {
                    ++this.lineNumber;
                    return;
                }
                if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled() && pdtDirMap.get(patchComp) == null) {
                    throw new SAXException("OPatch gets null product directories for symbol " + patchComp.getSymbolName());
                }
                String[] productDirs = (String[])pdtDirMap.get(patchComp);
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<String> attributeValues = new ArrayList<String>();
                ArrayList<NameValuePair> attributeNameValue = new ArrayList<NameValuePair>();
                int length = attributes.getLength();
                for (int i2 = 0; i2 < length; ++i2) {
                    String name = attributes.getQName(i2);
                    String value = attributes.getValue(i2);
                    NameValuePair nv = new NameValuePair(name, value);
                    attributeNameValue.add(nv);
                }
                StringBuffer rawEntry = new StringBuffer();
                rawEntry.append("<");
                rawEntry.append(qName);
                rawEntry.append(" ");
                for (int k2 = 0; k2 < attributeNameValue.size(); ++k2) {
                    String attrName = ((NameValuePair)attributeNameValue.get(k2)).getAttributeName();
                    rawEntry.append(attrName);
                    rawEntry.append("=\"");
                    String value = ((NameValuePair)attributeNameValue.get(k2)).getAttributeValue();
                    String tmp = XMLConverter.getXMLString(value);
                    rawEntry.append(tmp);
                    if (k2 == attributeNameValue.size() - 1) {
                        rawEntry.append("\" />");
                        continue;
                    }
                    rawEntry.append("\" ");
                }
                String argValue1 = "";
                String argValue2 = "";
                String argValue3 = "";
                String argValue4 = "";
                String argValue5 = "";
                String argValue6 = "";
                String argValue7 = "";
                String aName = qName;
                try {
                    if (aName.equals("copy")) {
                        boolean hasFileVersion = false;
                        for (int k3 = 0; k3 < attributeNameValue.size(); ++k3) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k3);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("update_timestamp")) {
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("diagnostic_string")) {
                                argValue6 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("retain_permission")) continue;
                            argValue7 = nv.getAttributeValue();
                        }
                        if (argValue4 == null || argValue4.equals("")) {
                            argValue4 = "false";
                        }
                        if (argValue7 == null || argValue7.equals("")) {
                            argValue7 = "false";
                        }
                        if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled()) {
                            for (int i3 = 0; i3 < productDirs.length; ++i3) {
                                CopyAction copyAction = new CopyAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i3]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), hasFileVersion);
                                copyAction.setRawActionEntry(rawEntry.toString());
                                patchComp.copyList.add(copyAction);
                            }
                        } else {
                            CopyAction copyAction = new CopyAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), hasFileVersion);
                            copyAction.setRawActionEntry(rawEntry.toString());
                            patchComp.copyList.add(copyAction);
                        }
                        break block72;
                    }
                    if (aName.equals("jar")) {
                        for (int k4 = 0; k4 < attributeNameValue.size(); ++k4) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k4);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("class_name")) continue;
                            argValue3 = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i4 = 0; i4 < productDirs.length; ++i4) {
                                JarAction jarAction = new JarAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i4]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                if (patchComp.jarList.contains(jarAction)) {
                                    jarAction.setDuplicate(true);
                                }
                                patchComp.jarList.add(jarAction);
                                jarAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            JarAction jarAction = new JarAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            if (patchComp.jarList.contains(jarAction)) {
                                jarAction.setDuplicate(true);
                            }
                            patchComp.jarList.add(jarAction);
                            jarAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block72;
                    }
                    if (aName.equals("archive")) {
                        for (int k5 = 0; k5 < attributeNameValue.size(); ++k5) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k5);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("object_name")) continue;
                            argValue3 = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i5 = 0; i5 < productDirs.length; ++i5) {
                                ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i5]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                patchComp.archiveList.add(archiveAction);
                                archiveAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.archiveList.add(archiveAction);
                            archiveAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block72;
                    }
                    if (aName.equals("make")) {
                        for (int k6 = 0; k6 < attributeNameValue.size(); ++k6) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k6);
                            if (nv.getAttributeName().equals("make_file")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("make_target")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("change_dir")) continue;
                            argValue1 = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i6 = 0; i6 < productDirs.length; ++i6) {
                                MakeAction makeAction = new MakeAction(patchComp, argValue1.replace("%SYMBOL%", productDirs[i6]), argValue2, argValue3, this.lineNumber);
                                patchComp.makeList.add(makeAction);
                                makeAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            MakeAction makeAction = new MakeAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.makeList.add(makeAction);
                            makeAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block72;
                    }
                    for (int k7 = 0; k7 < attributeNameValue.size(); ++k7) {
                        NameValuePair nv = (NameValuePair)attributeNameValue.get(k7);
                        attributeNames.add(nv.getAttributeName());
                        attributeValues.add(nv.getAttributeValue());
                    }
                    String className = aName + "Action";
                    Class<?> actionClass = null;
                    try {
                        actionClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException copyAction) {
                        // empty catch block
                    }
                    if (actionClass == null) {
                        try {
                            String classNamePath = "oracle.opatch.opatchactions." + className;
                            actionClass = Class.forName(classNamePath);
                        }
                        catch (ClassNotFoundException classNamePath) {
                            // empty catch block
                        }
                    }
                    if (this.oextJarLoader != null && actionClass == null) {
                        actionClass = this.oextJarLoader.loadClass(className);
                    }
                    if (actionClass != null) {
                        Integer lineNumberObject = new Integer(this.lineNumber);
                        Class[] parameterTypes = new Class[]{patchComp.getClass(), attributeNames.getClass(), attributeValues.getClass(), lineNumberObject.getClass()};
                        Object[] parameterArgs = new Object[]{patchComp, attributeNames, attributeValues, lineNumberObject};
                        attributeNames.add("PATCH_FILES_LOCATION_TAG");
                        attributeValues.add(this.patchFilesLocation);
                        Constructor<?> newActionConst = actionClass.getConstructor(parameterTypes);
                        if (patchComp.hasSymbol()) {
                            for (int i7 = 0; i7 < productDirs.length; ++i7) {
                                for (int j2 = 0; j2 < attributeValues.size(); ++j2) {
                                    String value = attributeValues.get(j2).toString();
                                    String name = attributeNames.get(j2).toString();
                                    if (name.equals("file_name") || name.equals("filename") || name.equals("className")) {
                                        attributeValues.set(j2, patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + value);
                                        continue;
                                    }
                                    if (!value.contains("%SYMBOL%")) continue;
                                    attributeValues.set(j2, value.replace("%SYMBOL%", productDirs[i7]));
                                }
                                Object newAction = newActionConst.newInstance(parameterArgs);
                                patchComp.pluginList.add(newAction);
                                ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            Object newAction = newActionConst.newInstance(parameterArgs);
                            patchComp.pluginList.add(newAction);
                            ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                        }
                        break block72;
                    }
                    StringBuffer buff = new StringBuffer("Class not found \"");
                    buff.append(className);
                    buff.append("\"");
                    ClassNotFoundException ce = new ClassNotFoundException(buff.toString());
                    throw ce;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2);
                    re.setStackTrace(e2.getStackTrace());
                    throw new SAXException(re);
                }
            }
            ++this.lineNumber;
        } else {
            if (attributes == null || attributes.getLength() == 0) {
                RuntimeException re = new RuntimeException("OPatch was not able to find any attributes for an expected component in actions file. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            String name = qName;
            String version = attributes.getValue("version");
            String requireStr = attributes.getValue("opt_req");
            if (version == null || version.equals("")) {
                RuntimeException re = new RuntimeException("Version field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            if (requireStr == null || requireStr.equals("")) {
                RuntimeException re = new RuntimeException("Required/Optional field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            boolean required = requireStr.equalsIgnoreCase("R");
            String symbol = attributes.getValue("symbol");
            String[] rawPatchComp = new String[2];
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(name);
            sb.append(" ");
            sb.append("version");
            sb.append("=\"");
            sb.append(version);
            sb.append("\"");
            sb.append(" ");
            sb.append("opt_req");
            sb.append("=\"");
            sb.append(requireStr);
            sb.append("\"");
            sb.append(" ");
            if (symbol != null && !symbol.equals("")) {
                sb.append("symbol");
                sb.append("=\"");
                sb.append(symbol);
                sb.append("\" ");
            }
            sb.append(">");
            rawPatchComp[0] = sb.toString();
            sb.delete(0, sb.capacity());
            sb.append("</");
            sb.append(name);
            sb.append(">");
            rawPatchComp[1] = sb.toString();
            PatchComponent patchComp = new PatchComponent(name, version, required);
            if (symbol != null && !symbol.equals("") && OPatchEnv.isSymbolResolveEnabled()) {
                try {
                    patchComp.setSymbolName(symbol);
                    if (!pdtDirMap.containsKey(patchComp)) {
                        String oracleHomePath = OPatchEnv.getOracleHome();
                        pdtDirMap.put(patchComp, patchComp.getProductDirectories(oracleHomePath));
                    } else {
                        patchComp.setProductDirectories((String[])pdtDirMap.get(patchComp));
                    }
                }
                catch (SymbolFailureException ex) {
                    patchComp.setSymbolName(null);
                    if (required) {
                        throw ex;
                    }
                    patchComp.setFilter(true);
                }
            }
            patchComp.setRawActionEntry(rawPatchComp);
            this.compList.add(patchComp);
            ++this.lineNumber;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equals("#text") || qName.equals("oneoff_actions") || this.isActionElement(qName))) {
            ++this.lineNumber;
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }
}

