Rem
Rem $Header: duma/admin/upgrade_repository_from_2.0.sql /main/2 2016/01/12 17:43:05 xiaojuya Exp $
Rem
Rem upgrade_repository_from_2.0.sql
Rem
Rem Copyright (c) 2008, 2015, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      upgrade_repository_from_2.0.sql - Upgrades the DMU repository version
Rem                                        from 2.0 to 2.1.1.
Rem
Rem    DESCRIPTION
Rem      This script upgrades the DMU repository database objects from DMU 
Rem      version 2.0 to 2.1.1. It is run by the DMU client itself and it 
Rem      should not be modified or run by the user.
Rem
Rem    NOTES
Rem      It must be run by SYS user.
Rem
Rem    MODIFIED    (MM/DD/YY)
Rem     xiaojuya    12/30/15 - fix bug 22389302
Rem     xiaonili    10/19/15 - creation
Rem
--
-- DUM$DATABASE
--

CREATE TABLE system.DUM$SESSION_HISTORY
(
  SID         NUMBER          -- session ID
, SERIAL#     NUMBER          -- session serial number
, AUDSID      NUMBER          -- auditing session number
, USER#       NUMBER          -- Oracle user ID
, USERNAME    VARCHAR2(128)   -- Oracle username
, SERVER      VARCHAR2(9)     -- server type (DEDICATED|SHARED)
, OSUSER      VARCHAR2(128)   -- client OS username
, PROCESS     VARCHAR2(24)    -- client OS process ID
, MACHINE     VARCHAR2(128)   -- client host name
, TERMINAL    VARCHAR2(128)   -- client terminal name
, PROGRAM     VARCHAR2(128)   -- client program name (DMU Client)
, CON_ID      NUMBER          -- PDB container ID (only >=12c, 0 otherwise)
, LOGON_TIME  DATE            -- logon date and time
, LOGOFF_TIME DATE            -- logoff date and time
, LOG_FILE    VARCHAR2(4000)  -- full path to the DMU Client log file
)
TABLESPACE &&Tablespace_Name;
insert into system.dum$table_profiles(schema_name,table_name,flags) 
            values('SYSTEM','DUM$SESSION_HISTORY',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) 
            values('SYSTEM','DUM$$SESSION_HISTORY',to_number('01','XX'));
alter table system.dum$attributes add (hash number);
alter table system.dum$database add(sdbcs_id number);

update system.dum$attributes a set a.hash = 
       (select ora_hash(sa.name||'^'||sa.length||'^'||sa.properties) 
        from sys.attribute$ sa
        where a.toid= sa.toid and a.name = sa.name);

--
-- update the information about SYS.BOOTSTRAP$ (bug-19617767)
--
delete system.dum$table_profiles  where schema_name='SYS' 
                                        and table_name='BOOTSTRAP$';
delete system.dum$columns dc where dc.obj# = 
       (select obj# from sys.obj$ so, sys.user$ su 
        where so.owner#=su.user# and so.name='BOOTSTRAP$' and su.name='SYS');
delete system.dum$tables dt where dt.obj# = 
       (select obj# from sys.obj$ so, sys.user$ su 
        where so.owner#=su.user# and so.name='BOOTSTRAP$' and su.name='SYS');
insert into system.dum$table_profiles(schema_name, table_name, flags) 
        values('SYS', 'BOOTSTRAP$', to_number('01', 'XX'));

alter table system.dum$sqltext add(env_current_schema VARCHAR2(128 BYTE));
alter table system.dum$sqltext add(env_edition VARCHAR2(128 BYTE));
alter table system.dum$sqltext 
      add(env_nls_length_semantics VARCHAR2(4000 BYTE));
alter table system.dum$sqltext add(env_plscope_settings VARCHAR2(4000 BYTE));
alter table system.dum$sqltext add(env_plsql_ccflags VARCHAR2(4000 BYTE));
alter table system.dum$sqltext add(env_plsql_code_type VARCHAR2(4000 BYTE));
alter table system.dum$sqltext add(env_plsql_debug VARCHAR2(4000 BYTE));
alter table system.dum$sqltext add(env_plsql_optimize_level NUMBER);
alter table system.dum$sqltext add(env_plsql_warnings VARCHAR2(4000 BYTE));

alter table system.dum$tables rename column stime to mtime;

drop type system.dum$ddl_statement_table;
--
-- DUM$DDL_STATEMENT - object type for quering database object creation DDL
--                     text in either CLOB or BLOB format; also includes
--                     DBMS_METADATA's parsed item 'VERB';
--                     261 bytes = LENGTHB('"schema"."name"')
--
CREATE OR REPLACE TYPE system.dum$ddl_statement AS
  OBJECT (verb VARCHAR2(261 BYTE), ddlTextCLOB CLOB, ddlTextBLOB BLOB);

--
-- DUM$DDL_STATEMENT_TABLE - nested table of DUM$DDL_STATEMENT objects
--
CREATE OR REPLACE TYPE system.dum$ddl_statement_table AS
  TABLE OF system.dum$ddl_statement;
