Rem
Rem $Header: duma/admin/create_repository.sql /main/65 2016/01/12 17:43:05 xiaojuya Exp $
Rem
Rem create_repository.sql
Rem
Rem Copyright (c) 2008, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      create_repository.sql - Creates tables, views, and types needed by
Rem                              the Database Migration Assistant for Unicode
Rem
Rem    DESCRIPTION
Rem      This script creates DMU repository database objects. It is run by
Rem      the DMU client itself and it should not be modified or run
Rem      by the user.
Rem
Rem    NOTES
Rem      Must be run by the SYS user.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     xiaojuya   12/18/15 - fix bug 22389302
Rem     xiaojuya   03/13/15 - fix bugs 20114900,20176724; some cleanup
Rem     xiaojuya   02/09/15 - fix bug 20458940
Rem     wenzhli    12/13/14 - fix bug 20086611  
Rem     xiaonili   11/28/14 - fix bug 20093052
Rem     jinchi     11/24/14 - fix bug 20073172
Rem     wenzhli    11/18/14 - fix bug 19927324
Rem     xiaonili   09/29/14 - fix for bug 19681653
Rem     xiaonili   09/29/14 - fix bug 19681653
Rem     xiaojuya   07/14/14 - Fix bug 19148308
Rem     tiadong    04/10/14 - Improvements to DMU Logging
Rem     fangzhan   02/17/14 - Fix bug 18245145
Rem     jinchi     01/06/14 - fix bug 18034435
Rem     tiadong    12/19/13 - add Oracle-supplied schemas in dum$schema_profile
Rem     xiaonili   10/29/13 - fix bug 17428088
Rem     tiadong    09/25/13 - fix bug 17433534
Rem     mtozawa    07/01/13 - add dum$columns.HASH column (bug 12930521)
Rem     tiadong    06/13/13 - bulk cleansing support
Rem     fangzhan   06/08/13 - Fix bug 16882077 - Rename the user-named LOB 
Rem                           segments with $DMU suffix
Rem     fangzhan   01/21/13 - Support trigger conversion
Rem     fangzhan   06/25/12 - Fix bug 13983771
Rem     yilli      05/30/12 - Fix bug 13811254
Rem     qimwang    03/01/12 - Add user_specified_method to system.dum$tables
Rem     jaguo      01/31/12 - Modify adt_varchar2 to support LONG VARCHAR2 type
Rem     fangzhan   11/23/11 - Fix bug 13099036
Rem     mtozawa    09/09/11 - add DUM$SCHEMA_PROFILES
Rem     qimwang    08/16/11 - Add system.dum$segments and system.dum$tablespaces
Rem     fangzhan   06/17/11 - Fix bug 12670175
Rem     yilli      06/15/11 - add archived to system.dum$database
Rem     mtozawa    11/15/10 - fix bug 10294873
Rem     mtozawa    11/12/10 - fix bug 10072094
Rem                           add CONVERT_METHOD column to DUM$TABLE_PROFILES
Rem                           add/modify table and column profile seed data
Rem     mtozawa    09/27/10 - fix bug 10069177
Rem                           moved statement to insert XDB CSX token mgr tables
Rem                           to dbms_duma_sys.refresh_repository()
Rem     fangzhan   09/17/10 - fix bug 9718003
Rem     qma        09/13/10 - Fix bug 10046197: add dum$attributes.name column
Rem     mtozawa    08/17/10 - add REQUIRED_LOGGING and AVAILABLE_LOGGING
Rem     mtozawa    07/12/10 - fix bug 9883509
Rem                           rename CHECK_SUM to CHECKSUM
Rem                           rename CHECK_CODE to VERIFICATION_CODE
Rem                           add EBS V12 ASO.ASO_ORDER_FEEDBACK_T data
Rem                           remove PK from dum$table_profiles
Rem                           test if FND_APPLICATION has a row of ASO
Rem     mtozawa    06/25/10 - fix bug 9590135 and 9853178
Rem     qimwang    06/24/10 - bug9713173
Rem     mtozawa    06/18/10 - fix bug 9704851
Rem     mtozawa    06/04/10 - fix bug 9771947
Rem     qicheng    05/20/10 - Add workaround for bug9590135
Rem     nli        01/21/10 - Add MAXEXTENTS UNLIMITED for dum$exceptions
Rem     fangzhan   01/06/10 - Modify column processing_state to NUMBER and 
Rem			      Add run_number to DUM$SQLTEXT
Rem     qicheng    12/29/09 - Modify column processing_state to varchar as
Rem                           workaround
Rem     qicheng    12/29/09 - Remove test sql for seed db
Rem     mtozawa    12/22/09 - add old_obj# and old_intcol#
Rem                           add DUM$TABLE_CHUNKS
Rem     mtozawa    11/04/09 - delete DUM$COLLTYPES, add DUM$TYPES to examine
Rem                           datatype of child attr in ADT columns
Rem     mtozawa    10/29/09 - rename DUM$TABLE_PROFILE to DUM$TABLE_PROFILES
Rem                           rename DUM$COLUMN_PROFILE to DUM$COLUMN_PROFILES
Rem     mtozawa    10/09/09 - Add DUM$TABLE_PROFILE and DUM$COLUMN_PROFILE
Rem                           tables and their seed data
Rem                           Add DUM$SESSIONS table
Rem     mtozawa    08/25/09 - Add OPERATION, UDBCS_ID to DUM$DATABASE
Rem                           Change datatype of REFRESHED to DATE
Rem                           Remove COL# from DUM$COLUMNS
Rem                           Add CLOB_STORAGE_CLAUSE to DUM$COLUMNS
Rem     mtozawa    07/31/09 - add SCAN_STATUS to DUM$COLUMNS, PROPERTY to
Rem                           DUM$DATABASE
Rem     mtozawa    07/07/09 - Add SCHEDULED_LOSE_DATA to DUM$COLUMNS
Rem                           Add USED_SIZE to DUM$TABLES
Rem     mtozawa    04/14/09 - rename scheduled_type to type_scheduled
Rem     mtozawa    03/23/09 - schema version 0.6
Rem     mtozawa    10/10/08 - Add SCHEDULED_PROPERTY (v0.4)
Rem     mtozawa    10/01/08 - sync with spec v0.3
Rem     mtozawa    03/18/08 - Add object status columns to dum$exceptions
Rem     mtozawa    03/04/08 - Renamed tables to honor scan_table() callout.
Rem                           Added dum$columns.col# for table enumeration.
Rem                           DUMA schema owner is now SYSTEM.
Rem                           no public synonym.
Rem     mtozawa    03/04/08 - Created
Rem
SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
--
-- DUM$DATABASE
--
CREATE TABLE system.dum$database
(
  version              NUMBER NOT NULL           -- repository schema version
, dbid                 NUMBER NOT NULL           -- DB ID unique number
, property             NUMBER DEFAULT 0 NOT NULL -- database properties
                                                 --  (bit flags)
                         -- 0x0001: consider CTAS when ROW MOVEMENT is disabled
                         -- 0x0002: enable ROW MOVEMENT for partitioned tables
                         -- 0x0004: suppress reporting U+FFFD as invalid
                         --         in the validation mode
                         -- 0x0008: consider CTAS with User-named LOB Segments
, operation            NUMBER                    -- operation mode
                                                   -- 1: Unicode migration
                                                   -- 2: Unicode Validation
, sdbcs_id             NUMBER                    -- source database character
                                                 --  set ID
, ddbcs_id             NUMBER NOT NULL           -- declared assumed DB
                                                 --  character set ID
, udbcs_id             NUMBER                    -- target Unicode database
                                                 --  character set
                                                   -- 873: AL32UTF8
                                                   -- 871: UTF8
, refreshed            DATE                      -- time when repository data
                                                 --  was last refreshed
, data_languages       VARCHAR2(4000 BYTE)       -- list of languages supplied
                                                 --  by user
, archived             TIMESTAMP                 -- time when repository was
                                                 --  archived
, scanning_processes   NUMBER                    -- number of scanning processes
, scan_buffer_size     NUMBER                    -- scan buffer size
, converting_processes NUMBER                    -- number of converting proc's
, parallel_degree      NUMBER                    -- degree of parallelism
, readonly_mv_action   NUMBER                    -- handling of read-only
                                                 --  materialized views
                                                   -- 0: Refresh Automatically
                                                   -- after Conversion (default)
                                                   -- 1: Generate SQL Script
                                                   -- 2: Do Nothing
, updatable_mv_action  NUMBER                    -- handling of updatable
                                                 --  materialized views
                                                   -- 0: Refresh Automatically
                                                   --    after Conversion
                                                   -- 1: Generate SQL Script
                                                   -- 2: Do Nothing (default)
, domain_index_action  NUMBER                    -- handling of dropped domain
                                                 --  indexes
                                                   -- 0: Recreate Automatically
                                                   -- after Conversion (default)
                                                   -- 1: Generate SQL Script
                                                   -- 2: Do Nothing
, mv_error_handling    NUMBER                    -- error handling of
                                                 --  materialized views
                                                   -- 0: Suspend Conversion
                                                   --    and Ask (default)
                                                   -- 1: Skip Failing SQL and
                                                   --    Continue
                                                   -- 2: Export Failing SQL to
                                                   --    Script and Continue
, di_error_handling    NUMBER                    -- error handling of dropped
                                                 --  domain indexes
                                                   -- 0: Suspend Conversion
                                                   --    and Ask (default)
                                                   -- 1: Skip Failing SQL and
                                                   --    Continue
                                                   -- 2: Export Failing SQL to
                                                   --    Script and Continue
, oi_error_handling    NUMBER                    -- error handling for
                                                 --  non-domain indexes
                                                   -- 0: Suspend Conversion
                                                   --    and Ask (default)
                                                   -- 1: Skip Failing SQL and
                                                   --    Continue
                                                   -- 2: Export Failing SQL to
                                                   --    Script and Continue
, script_directory     VARCHAR2(4000)            -- directory of the SQL scripts 
, CONSTRAINT dum$database_pk PRIMARY KEY (dbid) DISABLE
)
TABLESPACE &&Tablespace_Name
/

CREATE TABLE system.dum$segments
(
  table_obj#             NUMBER  NOT NULL   -- object # of convertible table
                                            -- or 0 for cluster segment
, table_subobj#          NUMBER             -- object # of IOT overflow table
, segment_obj#           NUMBER  NOT NULL   -- object # of segment
, segment_owner          VARCHAR2(128 BYTE) -- 
, segment_name           VARCHAR2(128 BYTE) --
, partition_name         VARCHAR2(128 BYTE) --
, segment_type           VARCHAR2(21 BYTE)  --
, tablespace_name        VARCHAR2(128 BYTE) --
, total_blocks           NUMBER        
, unused_blocks          NUMBER             -- # of unused blocks
, post_conversion_blocks NUMBER             -- extimated # of used blocks
                                            -- after table is converted
)
TABLESPACE &&Tablespace_Name
/

CREATE TABLE system.dum$tablespaces
(
  tablespace_name    VARCHAR2(128 BYTE)    -- tablespace name
, autoextensible     CHAR(3 BYTE)          -- YES or NO 
, total_blocks       NUMBER                -- total # of blocks allocated
, unused_blocks      NUMBER                -- # of unused blocks
, minimum_extension  NUMBER                -- # of blocks to be extended to
                                           -- accommodate post-conversion tables
, maximum_extension  NUMBER                -- # of blocks to be extended to
                                           -- accommodate post-conversion tables
                                           -- including space of original tables
)
TABLESPACE &&Tablespace_Name
/

--
-- DUM$SESSIONS
--
CREATE TABLE system.dum$sessions
(
  sid              NUMBER NOT NULL -- main session id of DUMA client
, serial#          NUMBER NOT NULL -- serial # of the session
, processing_state NUMBER NOT NULL -- current state of DUMA client
, processing_type  NUMBER          -- type of migration
, processed_object ROWID  -- ROWID of DUM$COLUMNS row of column being migrated
, original_name    VARCHAR2(128 BYTE) -- orignal name of column being processed
)
TABLESPACE &&Tablespace_Name
/

--
-- DUM$SCHEMA_PROFILES
--
CREATE TABLE system.dum$schema_profiles
(
  schema_name      VARCHAR2(128 BYTE) NOT NULL
, flags            NUMBER NOT NULL -- bit flag
                     -- 0x01: data conversion/modification prohibited
                     -- 0x02: schema modification prohibited
)
TABLESPACE &&Tablespace_Name
/

--
-- DUM$TABLE_PROFILE
--
CREATE TABLE system.dum$table_profiles
(
  schema_name VARCHAR2(128 BYTE) NOT NULL
, table_name  VARCHAR2(128 BYTE) NOT NULL
, flags       NUMBER NOT NULL
              -- 0x01 : migrate only CLOB columns
              -- 0x02 : migrate only CLOB columns (table identity to be verified)
              -- 0x04 : exclude from migration (CLOBs are excluded)
, convert_method NUMBER  -- pre-defined conversion method
                 -- NULL: not defined. DMU calculates most appropriate.
                 --    5: UPDATE ALL ROWS
                 --    6: UPDATE ONLY ROWS NEEDING CONVERSION
                 --    7: SCAN AND UPDATE ONLY ROWS NEEDING CONVERSION
                 --  101: SYS.VIEW$ specific
                 --  102: SYS.SOURCE$ and SYS.ARGUMENT$ specific
                 --  103: SYS.ERROR$ specific
, checksum    NUMBER
, verification_code  VARCHAR2(4000 BYTE)
-- remove PK to hold more than one rows for same table with different checksum
--, CONSTRAINT dum$table_profiles_pk PRIMARY KEY (schema_name,table_name)
)
TABLESPACE &&Tablespace_Name
/
--
-- DUM$COLUMN_PROFILES
--
CREATE TABLE system.dum$column_profiles
(
  schema_name VARCHAR2(128 BYTE) NOT NULL
, table_name  VARCHAR2(128 BYTE) NOT NULL
, column_name VARCHAR2(128 BYTE) NOT NULL
, flags       NUMBER NOT NULL
              -- 0x01 : convertible data dictionary table column
, CONSTRAINT dum$column_profiles_pk PRIMARY KEY
             (schema_name,table_name,column_name)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
/
--
-- DUM$TABLES
--
CREATE TABLE system.dum$tables
(
  obj#        NUMBER NOT NULL  -- Object ID of the table
, old_obj#    NUMBER           -- object ID of original table (CTAS)
, owner#      NUMBER NOT NULL  -- owner user id
, dictionary  NUMBER NOT NULL  -- 0 = user table, 1 = Data Dictionary table
, mtime       DATE             -- sys.obj$.mtime
, run_number  NUMBER           -- thread id that scanned the table
, required_logging NUMBER      -- Level of logging for future scan
                               -- NULL: none (default of external tables)
                               --    1: with issues (default of application tables)
                               --    2: all to convert (default of data dictionary tables)
, available_logging NUMBER     -- ROWIDs currently available in DUM$EXCEPTIONS
                               -- NULL: none (default)
                               --    1: with convertibility issues
                               --    2: all requiring conversion 
, used_size   NUMBER           -- used table size (HWM) in bytes
, row_count   NUMBER           -- number of rows
, changeless_rows NUMBER       -- number of rows that remain intact
, changeless  NUMBER           -- aggregate # of changeless cells
, convertible NUMBER           -- aggregate # of onvertible cells
, too_large   NUMBER           -- aggregate # of too large cells
, over_limit  NUMBER           -- aggregate # of over limit cells
, invalid     NUMBER           -- aggregate # of invalid cells
, added_size  NUMBER           -- bytes added in conversion
, scan_start  TIMESTAMP        -- time when the last full table scan started
, scan_end    TIMESTAMP        -- time when the last full table scan finished
, migration_status NUMBER DEFAULT 0 NOT NULL 
                               -- 0:table has never been scanned(default)
                               -- 1:scanned successfully
                               -- 2:partially scanned
                               -- 3:exception data found
                               -- 4:invalidted scan result
                               -- 5:scan failed
, scheduled_changeless  NUMBER -- scheduled aggregate # of changeless cells
, scheduled_convertible NUMBER -- scheduled aggregate # of convertible cells
, scheduled_too_large   NUMBER -- scheduled aggregate # of too large cells
, scheduled_over_limit  NUMBER -- scheduled aggregate # of over limit cells
, scheduled_invalid     NUMBER -- scheduled aggregate # of invalid cells
, convert_status        NUMBER -- conversion status
                               -- 0 : pending
                               -- 1 : started
                               -- 2 : finished - successfully converted
                               -- 3 : finished - conversion failed
, convert_start TIMESTAMP      -- time when the last table conversion started
, convert_end   TIMESTAMP      -- time when the last table conversion finished
, convert_method        NUMBER -- conversion method
                               -- NULL : not known yet
                               -- 1 : excluded from conversion
                               -- 2 : change data type
                               -- 3 : copy data using CTAS
                               -- 5 : update all rows
                               -- 6 : update rows with convertible cells
                               -- 7 : Scan and Update
, user_specified_method   NUMBER -- conversion method set by user
                               -- NULL : not known yet
                               -- 1 : excluded from conversion
                               -- 2 : change data type
                               -- 3 : copy data using CTAS
                               -- 5 : update all rows
                               -- 6 : update rows with convertible cells
                               -- 7 : Scan and Update
, convert_flags NUMBER DEFAULT 0 NOT NULL
                               -- bit flags
                               -- 0x01 : preserve LONG[RAW] position
, target_tablespace VARCHAR2(128 BYTE) -- tablespace of new table (CTAS)
, CONSTRAINT dum$tables_pk PRIMARY KEY (obj#)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
PCTFREE 90 PCTUSED 10
/
--
-- DUM$TABLE_CHUNKS
--
CREATE TABLE system.dum$table_chunks
(
  obj#        NUMBER NOT NULL  -- Object ID of the table
, run_number  NUMBER           -- thread id that scanned the chunk
, min_rowid   ROWID  NOT NULL  -- minimum ROWID of the chunk
, max_rowid   ROWID  NOT NULL  -- maximum ROWID of the chunk
, used_size   NUMBER           -- size of used space in bytes
, scan_start  TIMESTAMP        -- time when the scan started (UTC)
, scan_end    TIMESTAMP        -- time when the scan ended (UTC)
, scan_status NUMBER           -- scan status of the chunk
                               -- 1: scanned successfully
                               -- 2: scan failed
, CONSTRAINT dum$table_chunks_pk PRIMARY KEY (obj#,min_rowid)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
PCTFREE 90 PCTUSED 10
/
--
-- DUM$COLUMNS
--
CREATE TABLE system.dum$columns
(
  obj#        NUMBER NOT NULL  -- Object ID of the table
, hash        NUMBER NOT NULL  -- ora_hash() on selected col$ table columns
, intcol#     NUMBER NOT NULL  -- Internal Column Number
, old_intcol# NUMBER           -- intcol# in the original table (CTAS)
, dccs_id     NUMBER DEFAULT 0 NOT NULL  -- declared column character set ID
, scheduled_no_conversion NUMBER DEFAULT 0 NOT NULL
                               -- 1: marked as 'exclude from conversion'
                               -- 0: otherwise(default)
, scan_id     NUMBER           -- used to filter columns
, scan_status NUMBER default 0 -- scan status
                               -- 0: never been scanned (default)
                               -- 1: scanned successfully
                               -- 2: scan failed
                               -- 3: scan result invalidated
                               -- 4: scanning in progress
, changeless  NUMBER           -- number of changeless cells
, convertible NUMBER           -- number of convertible cells
, too_large   NUMBER           -- number of too large cells
, over_limit  NUMBER           -- number of over limit cells
, invalid     NUMBER           -- number of invalid cells
, max_length  NUMBER           -- maximum post-conversion length in bytes
, max_current_length    NUMBER -- maximum pre-conversion length in bytes
, added_size  NUMBER           -- bytes added in conversion (count all data)
, lob_limit   NUMBER           -- maximum length of a LOB columns
, scan_start  TIMESTAMP        -- time when the last column scan started
, scan_end    TIMESTAMP        -- time when the last column scan finished
, scheduled_lose_data   NUMBER DEFAULT 0
                               -- 1: okay to lose exceptional data
                               -- 0: otherwise (default)
, scheduled_type#       NUMBER -- set of these four values specifies
, scheduled_byte_length NUMBER -- scheduled cleansing:
, scheduled_char_length NUMBER --   * Lengthening column
                               --   * Migrating to larger data type
                               --   * Migrating to binary data type
                               --   * Migrating to char length semantics
, scheduled_property    NUMBER -- bit flags:
                               -- 0x800000=string measured in characters
, scheduled_changeless  NUMBER -- scheduled number of changeless cells
, scheduled_convertible NUMBER -- scheduled number of convertible cells
, scheduled_too_large   NUMBER -- scheduled number of too large cells
, scheduled_over_limit  NUMBER -- scheduled number of over limit cells
, scheduled_invalid     NUMBER -- scheduled number of invalid cells
, clob_storage_clause   VARCHAR2(4000 BYTE) -- storage clause for columns
                                            --  to be migrated to CLOB
, scheduled_tablespace	VARCHAR2(128 BYTE)   -- tablespace for columns
                                            --  to be migrated to CLOB
, CONSTRAINT dum$columns_pk PRIMARY KEY (obj#,hash)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
PCTFREE 90 PCTUSED 10
/
--
-- DUM$ATTRIBUTES
--
CREATE TABLE system.dum$attributes
(
  toid        RAW(16) NOT NULL   -- object TOID
, attribute#  NUMBER             -- attribute identifier number
, name        VARCHAR2(128 BYTE) -- attribute name
                                 -- NULL:     element type
                                 -- NOT NULL: attribute
, scheduled_type#       NUMBER   --
, scheduled_byte_length NUMBER   --
, scheduled_char_length NUMBER   --
, scheduled_property    NUMBER   --
, hash                  NUMBER   -- ora_hash() on the column name, length,
                                 -- properties of sys.attribute
)
TABLESPACE &&Tablespace_Name
PCTFREE 90 PCTUSED 10
/
--
-- DUM$EXCEPTIONS
--
CREATE TABLE system.dum$exceptions
(
  obj#        NUMBER NOT NULL  -- Object ID of the table
, intcol#     NUMBER NOT NULL  -- Internal Column Number
, row_id      UROWID NOT NULL  -- ROWID of the exceptional cell
, type        NUMBER NOT NULL  -- exception type: 1 - convertible
                               -- 2 - too large, 4 - over limit, 8 - invalid
, result      NUMBER NOT NULL  -- original result from the test function
, type_scheduled        NUMBER -- exception type including effects of
                               -- scheduled cleansing (bit flags)
                                 -- 0x01 : CONVERTIBLE
                                 -- 0x02 : TOO_LARGE
                                 -- 0x04 : OVER_LIMIT
                                 -- 0x08 : INVALID
  -- the below 6 values are NULL for scalar columns; the values should be last
  --   in a row so that length bytes can be trimmed
, changeless  NUMBER           -- changeless attributes in an object
, convertible NUMBER           -- convertible attributes in an object
, too_large   NUMBER           -- too large attributes in an object
, over_limit  NUMBER           -- over limit attributes in an object
, invalid     NUMBER           -- invalid binary representation attributes
                               --  in an object
, added_size  NUMBER           -- number of bytes added to an object
                               --  in conversion
, CONSTRAINT dum$exceptions_pk PRIMARY KEY (obj#,intcol#,row_id)
       USING INDEX TABLESPACE &&Tablespace_Name 
)
TABLESPACE &&Tablespace_Name
PCTFREE 0 PCTUSED 90 STORAGE (MAXEXTENTS UNLIMITED)
/
--
-- DUM$SQLTEXT
--
CREATE TABLE system.dum$sqltext
(
  step#       NUMBER NOT NULL  -- internal step # that indicates the
              -- conversion step to which the SQL statement belongs
              -- 100: alter database instance for conversion
              -- 110: disable DDL triggers
              -- 120: disable foreign key constraints
              -- 130: lengthen VARCHAR2 object attribute to VARCHAR2(M BYTE)
              -- 200: convert application tables
              -- 300: convert system tables
              -- 400: alter database character set
              -- 510: convert SYS.VIEW$
              -- 520: convert SYS.SOURCE$ and SYS.ARGUMENT$
              -- 600: alter character semantics object attributes
              -- 700: post conversion tasks for table
              -- 800: enable foreign key constraints
              -- 810: enable DDL triggers
              -- 820: delete histogram statistics
              -- 830: delete AWR performance data
              -- 840: restore database instance parameters
              -- 850: refresh materialized views
, obj#        NUMBER NOT NULL  -- table object # for which the statement is
                               -- issued for converting it to Unicode.
, order#      NUMBER NOT NULL  -- order of the statement to be executed.
                               -- when two or more statements need to be
                               -- executed for one obj# in a same step,
                               -- this value determines the order of
                               -- the statements.
, action_type    NUMBER        -- type of SQL statement
, action_obj#    NUMBER        -- IDs of object on which the statement operates
, action_subobj# NUMBER        --  and of a possible subobject
, action_length  NUMBER            --
, action_schema  VARCHAR2(128 BYTE) -- owner of the object operated upon
, action_name    VARCHAR2(128 BYTE) -- name of the object operated upon
, action_subname VARCHAR2(128 BYTE) -- subname of the object operated upon
, sqltext        BLOB              -- SQL statement in UTF-8 encoding
, objflag        NUMBER            -- object flag value copied from obj$.flags;
                                   --  0x400000 : Oracle-maintained object
  -- PL/SQL settings, edition and current schema to restore before attempting
  --  to recreate or modify a PL/SQL or other editionable object
, env_current_schema        VARCHAR2(128 BYTE)
, env_edition               VARCHAR2(128 BYTE)
, env_nls_length_semantics  VARCHAR2(4000 BYTE)
, env_plscope_settings      VARCHAR2(4000 BYTE)
, env_plsql_ccflags         VARCHAR2(4000 BYTE)
, env_plsql_code_type       VARCHAR2(4000 BYTE)
, env_plsql_debug           VARCHAR2(4000 BYTE)
, env_plsql_optimize_level  NUMBER
, env_plsql_warnings        VARCHAR2(4000 BYTE)
, time_start   TIMESTAMP       -- time SQL statement started executing in UTC
, time_end     TIMESTAMP       -- time SQL statement finished executing in UTC
, run_number  NUMBER           -- converting thread number
, sqlcode     NUMBER           -- execution status of the SQL statement
                               --  NULL : statement hasn't been executed yet
                               --  0 : statement has been successfully executed
                               --  != 0: Oracle error number if it failed
, action_on_error NUMBER       -- the user's choice of action on the failed
                               --  statement
                               --  0 : retry
                               --  1 : export SQL and skip
                               --  2 : skip
, sqlmessage VARCHAR2(4000 BYTE) -- the first 4000 bytes of the error message
, CONSTRAINT dum$sqltext_pk PRIMARY KEY (step#, obj#, order#)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
PCTFREE 0 PCTUSED 90
/
--
-- DUM$INDEXES
--
CREATE TABLE system.dum$indexes
(
  obj#        NUMBER NOT NULL  -- object # of the index
, dataobj#    NUMBER NOT NULL  -- object # of the table on which this index
                               -- is defined
, flag        NUMBER NOT NULL  -- 1 : disable before table conversion, then
                               --     rebuild afterward
                               -- 2 : drop before table conversion, then
                               --     recreate afterward
, CONSTRAINT dum$indexes_pk PRIMARY KEY (obj#,dataobj#)
       USING INDEX TABLESPACE &&Tablespace_Name
)
TABLESPACE &&Tablespace_Name
PCTFREE 0 PCTUSED 90
/

--
-- DUM$SESSION_HISTORY
--
CREATE TABLE system.dum$session_history
(
  sid         NUMBER          -- session ID
, serial#     NUMBER          -- session serial number
, audsid      NUMBER          -- auditing session number
, user#       NUMBER          -- Oracle user ID
, username    VARCHAR2(128)   -- Oracle username
, server      VARCHAR2(9)     -- server type (DEDICATED|SHARED)
, osuser      VARCHAR2(128)   -- client OS username
, process     VARCHAR2(24)    -- client OS process ID
, machine     VARCHAR2(128)   -- client host name
, terminal    VARCHAR2(128)   -- client terminal name
, program     VARCHAR2(128)   -- client program name (DMU Client)
, con_id      NUMBER          -- PDB container ID (only >=12c, 0 otherwise)
, logon_time  DATE            -- logon date and time
, logoff_time DATE            -- logoff date and time
, log_file    VARCHAR2(4000)  -- full path to the DMU Client log file
)
TABLESPACE &&Tablespace_Name
/

--
-- DUM$TYPES temporary table is used by table enumeration algorithm.
-- It holds type OID and typecode of ADTs and collections (VARRAYs,
-- NESTED TABLEs) that are used as table column datatypes.
-- The flag indicates if the ADT or collection has any textual attribute.
--
CREATE GLOBAL TEMPORARY TABLE system.dum$types
(
  toid        RAW(16) NOT NULL -- type OID of collection
, typecode    NUMBER  NOT NULL -- type code
, flag        NUMBER           -- 0: ADT/COLL has no textual attr,
                               -- 1: ADT/COLL has at least one textual attr
, CONSTRAINT dum$types_pk PRIMARY KEY (toid)
)
/

--
-- DUM$TABLE_ID_ARRAY - object type for CTAS package
--
CREATE OR REPLACE TYPE system.dum$table_id_array IS TABLE OF NUMBER
/

--
-- DUM$TABLE_NAME_ARRAY - object type for CTAS package
--
CREATE OR REPLACE TYPE system.dum$table_name_array IS TABLE OF VARCHAR2(128 BYTE)
/

--
-- DUM$ADT_VARCHAR2 - object type for querying VARCHAR2 cells
--                    without character set conversion
--
CREATE OR REPLACE TYPE system.dum$adt_varchar2 AS
  OBJECT (attr1 VARCHAR2(32767 BYTE))
/

--
-- DUM$LONG_UPDATE_INFO - object type for LONG update info
--
CREATE OR REPLACE TYPE system.dum$long_update_info AS
  OBJECT (beginpos NUMBER, modifylen NUMBER, bytes BLOB, insertlen NUMBER)
/

--
-- DUM$LONG_UPDATE_INFO_ARRAY - nested table of objects for long update info
--
CREATE OR REPLACE TYPE system.dum$long_update_info_array AS
  TABLE OF system.dum$long_update_info
/

--
-- DUM$CLOB_UPDATE_INFO - object type for CLOB update info
--
CREATE OR REPLACE TYPE system.dum$clob_update_info AS
  OBJECT (beginpos NUMBER, modifylen NUMBER, bytes BLOB)
/

--
-- DUM$CLOB_UPDATE_INFO_ARRAY - nested table of objects for CLOB update info
--
CREATE OR REPLACE TYPE system.dum$clob_update_info_array AS
  TABLE OF system.dum$clob_update_info
/

--
-- DUM$XMLTYPE_UPDATE_INFO - object type for XMLType update info
--
CREATE OR REPLACE TYPE system.dum$xmltype_update_info AS
  OBJECT (startIndex NUMBER, endIndex NUMBER, content VARCHAR2(4000 BYTE))
/

--
-- DUM$XMLTYPE_UPDATE_INFO_ARRAY - nested table of objects for XMLType update
--                                 info
--
CREATE OR REPLACE TYPE system.dum$xmltype_update_info_array AS
  TABLE OF system.dum$xmltype_update_info
/

--
-- DUM$DDL_STATEMENT - object type for quering database object creation DDL
--                     text in either CLOB or BLOB format; also includes
--                     DBMS_METADATA's parsed item 'VERB';
--                     261 bytes = LENGTHB('"schema"."name"')
--
CREATE OR REPLACE TYPE system.dum$ddl_statement AS
  OBJECT (verb VARCHAR2(261 BYTE), ddlTextCLOB CLOB, ddlTextBLOB BLOB)
/

--
-- DUM$DDL_STATEMENT_TABLE - nested table of DUM$DDL_STATEMENT objects
--
CREATE OR REPLACE TYPE system.dum$ddl_statement_table AS
  TABLE OF system.dum$ddl_statement
/

--
-- DUM$OBJ$ - view masking differences between OBJ$ with and without editions
--
DECLARE
BEGIN
  IF (dbms_db_version.version >= 11) THEN
    EXECUTE IMMEDIATE 'CREATE OR REPLACE VIEW sys.dum$obj$ AS SELECT * FROM sys."_ACTUAL_EDITION_OBJ"';
  ELSE
    EXECUTE IMMEDIATE 'CREATE OR REPLACE VIEW sys.dum$obj$ AS SELECT o.*, CAST(NULL AS VARCHAR2(128 BYTE)) defining_edition FROM sys.obj$ o';
  END IF;
END;
/

--
-- Use / as the statement separator to workaround the shortcoming of
-- the parser of SQLScriptExecutor.java
--
-- ASO.ASO_ORDER_FEEDBACK_T of EBS version 11
--
insert into system.dum$table_profiles(schema_name,table_name,flags,checksum,verification_code)
values('ASO','ASO_ORDER_FEEDBACK_T',to_number('02','XX'),727915749206,
  'declare'
||' v number;'
||'begin'
||' select user# into v from sys.user$ where name=''APPS'' and type#=1;'
||' select user# into v from sys.user$ where name=''APPLSYS'' and type#=1;'
||' select 1 into v from sys.obj$ where name=''FND_APPLICATION'' and type#=2 and owner#=v;'
||' select 1 into v from APPLSYS.FND_APPLICATION where APPLICATION_SHORT_NAME=''ASO'';'
||'end;')
/
--
-- ASO.ASO_ORDER_FEEDBACK_T of EBS version 12
--
insert into system.dum$table_profiles(schema_name,table_name,flags,checksum,verification_code)
values('ASO','ASO_ORDER_FEEDBACK_T',to_number('02','XX'),730501100479,
  'declare'
||' v number;'
||'begin'
||' select user# into v from sys.user$ where name=''APPS'' and type#=1;'
||' select user# into v from sys.user$ where name=''APPLSYS'' and type#=1;'
||' select 1 into v from sys.obj$ where name=''FND_APPLICATION'' and type#=2 and owner#=v;'
||' select 1 into v from APPLSYS.FND_APPLICATION where APPLICATION_SHORT_NAME=''ASO'';'
||'end;')
/
--
-- insert other tables into DUM$TABLE_PROFILES
--
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYS','BOOTSTRAP$',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYS','HISTGRM$',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYS','HIST_HEAD$',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$DATABASE',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$SESSIONS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$TABLES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$COLUMNS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$ATTRIBUTES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$EXCEPTIONS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$INDEXES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$SQLTEXT',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$SCHEMA_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$TABLE_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$COLUMN_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$TYPES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$SEGMENTS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$TABLESPACES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$SESSION_HISTORY',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$DATABASE',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$SESSIONS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$SCHEMA_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$TABLE_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$COLUMN_PROFILES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$TABLES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$TABLE_CHUNKS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$COLUMNS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$ATTRIBUTES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$EXCEPTIONS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$SQLTEXT',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$INDEXES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$SEGMENTS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$TABLESPACES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('SYSTEM','DUM$$SESSION_HISTORY',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$PARAMETERS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$QUERY',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$TABLES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$COLUMNS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$EXTABLES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$ERRORS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$LANGID',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$CHARSETID',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$INDEXES',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$CONSTRAINTS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$TRIGGERS',to_number('01','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags) values('CSMIG','CSM$DICTUSERS',to_number('01','XX'));

--
-- SYS.WRI$_OPTSTAT_%_HISTORY tables are excluded from enumeration as
-- they are truncated by executing DBMS_STATS.PURGE_STATS(SYSTIMESTAMP)
-- before the migrated database is used.
--
insert into system.dum$table_profiles(schema_name,table_name,flags)
       values('SYS','WRI$_OPTSTAT_OPR',to_number('04','XX'));
insert into system.dum$table_profiles(schema_name,table_name,flags)
       select u.name, o.name, to_number('04','XX')
         from sys.obj$ o, sys.user$ u
        where u.name = 'SYS'
          and o.owner# = u.user#
          and o.type# = 2
          and o.name like 'WRI$\_OPTSTAT\_%\_HISTORY' escape '\';
-- 
-- Populate data dictionary table columns information for which DMU knows
-- how to convert.
--
-- The conversion method is assigned according to the following rule:
--  1) assign " 101: SYS.VIEW$ specific"                           for SYS.VIEW$
--  2) assign " 102: PL/SQL data dictionary tables specific"       for SYS.SOURCE$, SYS.ARGUMENT$, SYS.IDL_CHAR$,
--                                                                 SYS.PROCEDUREINFO$, and SYS.PLSCOPE_IDENTIFIER$
--  3) assign " 103: SYS.ERROR$ specific" for SYS.ERROR$
--  4) assign "   7: SCAN AND UPDATE ONLY ROWS NEEDING CONVERSION" for CTXSYS.DR$INDEX_VALUE and SYS.COM$
--  5) assign "   6: UPDATE ONLY ROWS NEEDING CONVERSION"          if table does not have CLOB colunm
--  6) assign "NULL: not defined. DMU calculates most appropriate" otherwise (ie. table has CLOB column)
--
insert into system.dum$table_profiles  values('CTXSYS','DR$INDEX_VALUE',0,7,null,null);
insert into system.dum$column_profiles values('CTXSYS','DR$INDEX_VALUE','IXV_VALUE',1);

insert into system.dum$table_profiles  values('CTXSYS','DR$STOPWORD',0,5,null,null);
insert into system.dum$column_profiles values('CTXSYS','DR$STOPWORD','SPW_WORD',1);

insert into system.dum$table_profiles  values('CTXSYS','DR$USER_EXTRACT_RULE',0,6,null,null);
insert into system.dum$column_profiles values('CTXSYS','DR$USER_EXTRACT_RULE','ERL_COMMENTS',1);

insert into system.dum$table_profiles  values('CTXSYS','DR$USER_EXTRACT_STOP_ENTITY',0,6,null,null);
insert into system.dum$column_profiles values('CTXSYS','DR$USER_EXTRACT_STOP_ENTITY','ESE_COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','ARGUMENT$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','ARGUMENT$','PROCEDURE$',1);
insert into system.dum$column_profiles values('SYS','ARGUMENT$','ARGUMENT',1);
insert into system.dum$column_profiles values('SYS','ARGUMENT$','DEFAULT$',1);

insert into system.dum$table_profiles  values('SYS','AUD$',0,null,null,null);
insert into system.dum$column_profiles values('SYS','AUD$','COMMENT$TEXT',1);

insert into system.dum$table_profiles  values('SYS','COM$',0,7,null,null);
insert into system.dum$column_profiles values('SYS','COM$','COMMENT$',1);

insert into system.dum$table_profiles  values('SYS','DUC$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','DUC$','COM',1);

insert into system.dum$table_profiles  values('SYS','FGA_LOG$',0,null,null,null);
insert into system.dum$column_profiles values('SYS','FGA_LOG$','COMMENT$TEXT',1);

insert into system.dum$table_profiles  values('SYS','FGR$_FILE_GROUPS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','FGR$_FILE_GROUPS','USER_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','FGR$_FILE_GROUP_FILES',0,6,null,null);
insert into system.dum$column_profiles values('SYS','FGR$_FILE_GROUP_FILES','USER_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','FGR$_FILE_GROUP_VERSIONS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','FGR$_FILE_GROUP_VERSIONS','USER_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','HS$_FDS_CLASS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','HS$_FDS_CLASS','FDS_CLASS_COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','HS$_FDS_INST',0,6,null,null);
insert into system.dum$column_profiles values('SYS','HS$_FDS_INST','FDS_INST_COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','IDL_CHAR$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','IDL_CHAR$','PIECE',1);

insert into system.dum$table_profiles  values('SYS','JOB$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','JOB$','NLSENV',1);

insert into system.dum$table_profiles  values('SYS','LOGMNRG_PROPS$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','LOGMNRG_PROPS$','COMMENT$',1);

insert into system.dum$table_profiles  values('SYS','PENDING_TRANS$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','PENDING_TRANS$','TRAN_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','PLSCOPE_IDENTIFIER$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','PLSCOPE_IDENTIFIER$','SYMREP',1);

insert into system.dum$table_profiles  values('SYS','PROCEDUREINFO$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','PROCEDUREINFO$','PROCEDURENAME',1);

insert into system.dum$table_profiles  values('SYS','PROPS$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','PROPS$','COMMENT$',1);

insert into system.dum$table_profiles  values('SYS','RECO_SCRIPT$',0,null,null,null);
insert into system.dum$column_profiles values('SYS','RECO_SCRIPT$','SCRIPT_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','RECO_SCRIPT_BLOCK$',0,null,null,null);
insert into system.dum$column_profiles values('SYS','RECO_SCRIPT_BLOCK$','BLOCK_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','REGISTRY$HISTORY',0,6,null,null);
insert into system.dum$column_profiles values('SYS','REGISTRY$HISTORY','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','REG_SNAP$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','REG_SNAP$','COMMENT$',1);

insert into system.dum$table_profiles  values('SYS','RULE$',0,null,null,null);
insert into system.dum$column_profiles values('SYS','RULE$','R_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','RULE_EC$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','RULE_EC$','EC_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','RULE_MAP$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','RULE_MAP$','RM_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','RULE_SET$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','RULE_SET$','RS_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','RULE_SET_IEUAC$',0,6,null,null);
insert into system.dum$column_profiles values('SYS','RULE_SET_IEUAC$','CLI_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_CHAIN',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_CHAIN','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_CLASS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_CLASS','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_CREDENTIAL',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_CREDENTIAL','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_DESTINATIONS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_DESTINATIONS','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_FILE_WATCHER',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_FILE_WATCHER','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_JOB',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_JOB','COMMENTS',1);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_JOB','NLS_ENV',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_PROGRAM',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_PROGRAM','COMMENTS',1);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_PROGRAM','NLS_ENV',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_SCHEDULE',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_SCHEDULE','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_WINDOW',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_WINDOW','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SCHEDULER$_WINDOW_GROUP',0,6,null,null);
insert into system.dum$column_profiles values('SYS','SCHEDULER$_WINDOW_GROUP','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','SOURCE$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','SOURCE$','SOURCE',1);

insert into system.dum$table_profiles  values('SYS','STREAMS$_STMT_HANDLERS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','STREAMS$_STMT_HANDLERS','HANDLER_COMMENT',1);

insert into system.dum$table_profiles  values('SYS','VIEW$',0,101,null,null);
insert into system.dum$column_profiles values('SYS','VIEW$','TEXT',1);

insert into system.dum$table_profiles  values('SYS','TRIGGER$',0,102,null,null);
insert into system.dum$column_profiles values('SYS','TRIGGER$','ACTION#',1);
insert into system.dum$column_profiles values('SYS','TRIGGER$','DEFINITION',1);
insert into system.dum$column_profiles values('SYS','TRIGGER$','WHENCLAUSE',1); 

insert into system.dum$table_profiles  values('SYS','ERROR$',0,103,null,null);
insert into system.dum$column_profiles values('SYS','ERROR$','TEXT',1);

insert into system.dum$table_profiles  values('SYS','WRR$_CAPTURES',0,6,null,null);
insert into system.dum$column_profiles values('SYS','WRR$_CAPTURES','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','WRR$_REPLAYS',0,6,null,null);
insert into system.dum$column_profiles values('SYS','WRR$_REPLAYS','COMMENTS',1);

insert into system.dum$table_profiles  values('SYS','XSTREAM$_SERVER',0,6,null,null);
insert into system.dum$column_profiles values('SYS','XSTREAM$_SERVER','USER_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','AQ$_QUEUES',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','AQ$_QUEUES','QUEUE_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','AQ$_QUEUE_TABLES',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','AQ$_QUEUE_TABLES','TABLE_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','LOGMNR_PROPS$',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','LOGMNR_PROPS$','COMMENT$',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_COLUMN_GROUP',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_COLUMN_GROUP','GROUP_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_PRIORITY_GROUP',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_PRIORITY_GROUP','PRIORITY_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REFRESH_TEMPLATES',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REFRESH_TEMPLATES','TEMPLATE_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REPCAT',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REPCAT','SCHEMA_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REPCATLOG',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REPCATLOG','A_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REPOBJECT',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REPOBJECT','OBJECT_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REPPROP',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REPPROP','PROPAGATE_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_REPSCHEMA',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_REPSCHEMA','MASTER_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_RESOLUTION',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_RESOLUTION','RESOLUTION_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_SNAPGROUP',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_SNAPGROUP','GROUP_COMMENT',1);

insert into system.dum$table_profiles  values('SYSTEM','REPCAT$_TEMPLATE_TARGETS',0,6,null,null);
insert into system.dum$column_profiles values('SYSTEM','REPCAT$_TEMPLATE_TARGETS','TARGET_COMMENT',1);

--
-- APEX_PUBLIC_USER and APEX_<version> schemas
--
insert into system.dum$schema_profiles(schema_name,flags)
       select u.name, to_number('02','XX') from sys.user$ u
        where u.type# = 1 and u.name like 'APEX\_%' escape '\';
--
-- insert other Oracle supplied schemas into DUM$SCHEMA_PROFILES 
--
insert into system.dum$schema_profiles(schema_name,flags) values('ANONYMOUS',            to_number('02','XX'));
--insert into system.dum$schema_profiles(schema_name,flags) values('APEX_030200',          to_number('02','XX'));
--insert into system.dum$schema_profiles(schema_name,flags) values('APEX_PUBLIC_USER',     to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('APPQOSSYS',            to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('CTXSYS',               to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('DBSNMP',               to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('DIP',                  to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('DMSYS',                to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('EXFSYS',               to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('FLOWS_FILES',          to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('LBACSYS',              to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('MDDATA',               to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('MDSYS',                to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('MGMT_VIEW',            to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('OLAPSYS',              to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('ORACLE_OCM',           to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('ORDDATA',              to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('ORDPLUGINS',           to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('ORDSYS',               to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('OUTLN',                to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('OWBSYS',               to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('OWBSYS_AUDIT',         to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SI_INFORMTN_SCHEMA',   to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SPATIAL_CSW_ADMIN_USR',to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SPATIAL_WFS_ADMIN_USR',to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SYS',                  to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SYSMAN',               to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('SYSTEM',               to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('WKSYS',                to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('WMSYS',                to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('XDB',                  to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('XS$NULL',              to_number('03','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('GSMADMIN_INTERNAL',    to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('DVSYS',                to_number('02','XX'));
insert into system.dum$schema_profiles(schema_name,flags) values('OJVMSYS',              to_number('02','XX'));

commit;

