package oracle.jaccelerator.server;

import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.sql.SQLException;

import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;

class Dumper {

  public static void main(String argv[]) {
  }

  public static String dumpClass (ClassHandle h, 
                             String name,
                             String schema)
       throws SQLException, IOException
  {
    // ClassHandle h = Handle.lookupClass(name, Schema.lookup(schema));

    String fname  = 
      "__ncomp__" + 
      File.separator + 
      // if you want schemas as separate dirs:
      //schema + File.separator + 
      name + ".class";

    FileOutputStream file = openFileOutputStream(fname);

    copy(h, file);
    file.close();
      
    return "got: " + h;
  }

  public static String dumpResource (ResourceHandle h, 
                                     String name,
                                     String schema)
       throws SQLException, IOException
  {
    String fname  = 
      "__ncomp__" + 
      File.separator + 
      // if you want schemas as separate dirs:
      //schema + File.separator + 
      name;

    FileOutputStream file = openFileOutputStream(fname);

    copy(h, file);
    file.close();
    return "got: " + name;
  }

  static PrintWriter openFileWriter(String fname)
    throws IOException
  {
    return new PrintWriter(openFileOutputStream(fname));
  }

  static FileOutputStream openFileOutputStream(String fname)
    throws IOException
  {
    FileOutputStream file;
    try {
      file = new FileOutputStream(fname);
    } catch (IOException ee) {
      try {
        new File(new File(fname).getParent()).mkdirs();
        file = new FileOutputStream(fname);
      } catch (IOException ex) {
        throw new Error("Can't open output file " + fname);
      }
    }
    return file;
  }

  static FileInputStream openFileInputStream(String fname)
    throws IOException
  {
    FileInputStream file;
    try {
      file = new FileInputStream(fname);
    } catch (IOException ee) {
      try {
        new File(new File(fname).getParent()).mkdirs();
        file = new FileInputStream(fname);
      } catch (IOException ex) {
        throw new Error("Can't open input file " + fname);
      }
    }
    return file;
  }

  static void copy(Handle h, OutputStream out) throws IOException, SQLException {
    if ( h == null ) {
      throw new SQLException("no such java schema object");
    }
    InputStream in = h.inputStream();
    copy(in, out);
  }
    
  static void copy(InputStream in, OutputStream out) throws IOException {
    byte[] buffer = new byte[8*1024] ;
    for ( int n = in.read(buffer) ; n > 0 ; n = in.read(buffer) ) {
      out.write(buffer, 0, n);
    }
    out.close();
  }

  static void copy(Reader in, Writer out) throws IOException {
    char[] buffer = new char[8*1024] ;
    for ( int n = in.read(buffer) ; n > 0 ; n = in.read(buffer) ) {
      out.write(buffer, 0, n);
    }
    out.close();
  }

  protected static void warning (String s) {
    System.out.println(s);
  }

  public static String parseKeywordValuePair (String fileName, String keyword) {
    String value = null;
    try {
      value = parseKeywordValuePair(new FileInputStream(fileName), keyword);
    } catch (Exception e) {}
    return value;
  }

  public static String parseKeywordValuePair (InputStream input, String keyword) {
    String value  = null;
    try {
      StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(input)));
      st.wordChars('_', '_');
      int token = 0;
      int count  = 0;
      while ((token = st.nextToken()) != -1 && count < 10) {
        if (st.ttype == st.TT_WORD) {
          String val = st.sval;
          //System.out.println("-- val: " + val);
          count++;
          if (val.equals(keyword)) {
            if (st.nextToken() != -1 && st.ttype == st.TT_WORD) {
              value = st.sval;
              break;
            }
          }
        }
      }
    } catch (Exception e) {}
    return value;
  }
}

