#!/usr/bin/perl

BEGIN{
 my @modules=('Sys::Hostname',' File::Basename','Cwd','File::Find','File::Copy','File::Path','Getopt::Long','File::stat','Pod::Usage');
  foreach my $moduleName (@modules) {
    my $moduleDefined=eval "use $moduleName; 1" ?1:0;
    if($moduleDefined==0){
       print("\n$moduleName  module not present/module is not accessible\n");
       exit(2);
    }
  }
}

#Stick to perl version v5.x.x
use v5.8.8;
use Sys::Hostname;
use File::Basename qw(dirname basename);
use Cwd  qw(abs_path);
use lib dirname(abs_path($0));
use POSIX qw(uname);
use strict;
use warnings;
    
#Command line parsing module getting used.
use module::CommandOptions qw(addOpt removeOpt removeAllOpt getArgumentCnt getArguments getOptValue optExists  isDescSession isActionSession isApplySession isRollbackSession isResumeSession processArgs);
use module::DBUtilServices qw(getActiveUser getFileOwner getJavaHomePath getJreMemoryOptions removeDirectory getFileOwner getFileOwnerGroup changeFileOwner changeFilePermission removeFile openFile closeFile writeFile readFile findFilePattern);
use module::DBValidationUtil qw(validateUserLocalSession validateUserRemoteSession validateOPatchIsTriggeredFromOneOfOH isDirectoryExists);
use module::OPatchAutoCommandOptions qw();
use module::ClassPathLib qw(setBaseDir setDetectOH setCP setSrvmLibPath getSystemInfoGeneratorCP getTopologyCreatorCP getOpatchAutoCP);
use module::ExportPath qw(exportSudoPath);

#Dumping additional args which does not have mapping.
foreach my $key (@ARGV) {
  processArgs($key);
}

my $path=exportSudoPath();
 $ENV{'PATH'}=$path;

my $scriptDir=dirname(abs_path($0));
my $opatchAutoDBDir=dirname($scriptDir);
my  $opatchAutoDir=dirname($opatchAutoDBDir);
my $BASE=dirname($opatchAutoDir);
setBaseDir($BASE);
my $DETECT_OH=dirname($BASE);
setDetectOH($DETECT_OH);

#Checking whether OPATCH_DEBUG environment variable is set 
my  $_debugMode=0;
my $DEBUGVAL="false";
if(defined $ENV{'OPATCH_DEBUG'} && $ENV{'OPATCH_DEBUG'} eq 'true' && isDescSession()==0){
  $_debugMode=1;
  $DEBUGVAL="true";
  removeOpt('logLevel');
  addOpt('logLevel',"FINEST");
}

#Checking whether $OPATCH_SPACE_AUTO environment variable is set
my  $OPATCH_AUTO_MSG="opatchauto";
if(defined $ENV{'OPATCH_SPACE_AUTO'} && $ENV{'OPATCH_SPACE_AUTO'} eq 'true'){
	$OPATCH_AUTO_MSG="opatch auto";
}

#Setting oracle ocm services if it is set in environment
my $oracleOcmService="";
if(defined $ENV{'ORACLE_OCM_SERVICE'}){
	$oracleOcmService="-Docm.endpoint=".$ENV{'ORACLE_OCM_SERVICE'};
}

my $currentUser=getActiveUser();
my $currentHomeOwner=getFileOwner($DETECT_OH."/oraInst.loc");

my $remoteSession=0;
my $validateUser=0;

#Checking whether ORACLE_HOME environment variable is set
my  $ORACLE_HOME="";
if(defined $ENV{'ORACLE_HOME'}){
	$ORACLE_HOME=$ENV{'ORACLE_HOME'};
}

if(isDescSession()==0){
   if(isApplySession()==1 || isRollbackSession()==1){
     $remoteSession=optExists('remote');
     $validateUser=1;
   }elsif(isResumeSession()==1){
      $validateUser=1;
      my $patchingMode="";
      my $filename = $opatchAutoDir."/dbtmp/patchingmode.txt";
     if(-e $filename){
      if (open(my $fh, $filename)) {
        $patchingMode = <$fh>; 
        close $fh;
      }else {
        warn "Could not open file '$filename' $!";
      }
      if($patchingMode eq "remote"){
        $remoteSession=1;
      }
    }
  } 
}
#Validating user if its local session then it has to be root/home owner.
#If its using -remote option then it can only be home owner.
if($validateUser==1){
  if($remoteSession==1 && validateUserRemoteSession($currentUser,$currentHomeOwner)==1){
   print("\nMulti node patching not supported as '$currentUser'. Please run as '$currentHomeOwner' user.\n");
    print("opatchauto returns with error code = 2\n");
   exit(2);
  }elsif(validateUserLocalSession($currentUser,$currentHomeOwner)==1){
   print("\nCannot run as '$currentUser'. Please run as 'root' user.\n");
    print("opatchauto returns with error code = 2\n");
   exit(2);
  }
}
if(optExists('oh')==1){
  my $ohOptStr=getOptValue('oh');

  my $valid=validateOPatchIsTriggeredFromOneOfOH($DETECT_OH,$ohOptStr);
  my @ohList = split(/,/, $ohOptStr);
  if(isDescSession()==0 && $valid==1){
   print("\nopatchauto must run from one of the homes specified\n");
   print("opatchauto returns with error code = 2\n");
   exit(2);
  }
  $ORACLE_HOME=$ohList[0];
}elsif(length $ORACLE_HOME > 0 && $ORACLE_HOME ne $DETECT_OH){
   my $valid=validateOPatchIsTriggeredFromOneOfOH($DETECT_OH,$ORACLE_HOME);
   if($valid==1){
    print("\nopatchauto must run from one of the homes specified\n");
    print("opatchauto returns with error code = 2\n");
    exit(2);
   }
   if($ORACLE_HOME =~ /^ *$/){
     $ORACLE_HOME=$DETECT_OH;
   }
}else{
     $ORACLE_HOME=$DETECT_OH;
}
  if(!isDirectoryExists( $ORACLE_HOME)){
    print("\nThe Oracle Home $ORACLE_HOME does not exist. Please give a proper home and retry\n");
    print("opatchauto returns with error code = 2\n");
    exit(2);
  }
  if(!isDirectoryExists( $ORACLE_HOME."/oui") && isDescSession()==0){
    print("\nThe Oracle Home $ORACLE_HOME is not an OUI based home. Please give a proper home and retry\n");
    print("opatchauto returns with error code = 2\n");
    exit(2);
  }

 my @uname = uname();
 my $PLATFORM="$uname[0]";
 my $OLRLOC="";
 my $LD_LIBRARY_PATH="";
 if($PLATFORM eq 'Linux'){
   $OLRLOC="/etc/oracle/olr.loc";
   my $ld_lib_path=getEnv('LD_LIBRARY_PATH');
   $LD_LIBRARY_PATH=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib";
  if(length $ld_lib_path > 0){
     $LD_LIBRARY_PATH=$LD_LIBRARY_PATH.":".$ld_lib_path;
   }
   my $unameSize=@uname;
   my $ARCH=$uname[$unameSize-1];
   if($ARCH eq "ppc64" || $ARCH eq "s390x"){
       $LD_LIBRARY_PATH=$ORACLE_HOME."/lib32:".$ORACLE_HOME."/srvm/lib32:".$LD_LIBRARY_PATH
   }
   $ENV{'LD_LIBRARY_PATH'} = $LD_LIBRARY_PATH;
 }elsif($PLATFORM eq 'HP-UX'){
   $OLRLOC="/var/opt/oracle/olr.loc";
   $LD_LIBRARY_PATH=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib";
   $ENV{'LD_LIBRARY_PATH'}=$LD_LIBRARY_PATH;
   $ENV{'SHLIB_PATH'}="";
 }elsif($PLATFORM eq 'AIX'){
  my $libPath=getEnv('LIBPATH');
  $OLRLOC="/etc/oracle/olr.loc";
  my $LIBPATH=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib";
  if(length $libPath > 0){
    $LIBPATH=$LIBPATH.":".$libPath;
  }
  $LD_LIBRARY_PATH=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib:".$LIBPATH;
  $ENV{'LIBPATH'}=$LIBPATH;
  $ENV{'OBJECT_MODE'}="32_64";
 }elsif($PLATFORM eq 'SunOS'){
  $OLRLOC="/var/opt/oracle/olr.loc";
  my $ld_lib_path_64=getEnv('LD_LIBRARY_PATH_64');
  my $LD_LIBRARY_PATH_64=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib";
  if(length $ld_lib_path_64 > 0){
    $LD_LIBRARY_PATH_64=$LD_LIBRARY_PATH_64.":".$ld_lib_path_64;
  }
  $ENV{'LD_LIBRARY_PATH_64'} = $LD_LIBRARY_PATH_64;
  $LD_LIBRARY_PATH=$ORACLE_HOME."/lib:".$ORACLE_HOME."/srvm/lib:".$LD_LIBRARY_PATH;
  $ENV{'LD_LIBRARY_PATH'}=$LD_LIBRARY_PATH;
 }else{
  print("\nERROR: $PLATFORM is not supported. opatchauto cannot proceed!\n");
  print("opatchauto returns with error code = 2\n");
  exit(2);
 }
 
 my $crsHome="";
if (-e $OLRLOC){
 open my $fh, '<', $OLRLOC or die "Could not open '$OLRLOC' $!\n";
 while (my $line = <$fh>){
  if($line=~s/crs_home=//){
    $crsHome=$line;
    last;
  }
 } 
 close $fh;
}
my $isOper=isApplySession() || isRollbackSession();
if(isDescSession()==0 && $isOper==1){
  if(optExists('database')==1){
    if(findFilePattern($ORACLE_HOME."/bin/","crsctl")==1){
       print("\nopatchauto cannot run from Grid Home when patching database home. Please retry it inside database home\n");
       print("opatchauto returns with error code = 2\n");
       exit(2);
    }
  }elsif(optExists('oh')==0){
   if(optExists('sdb')==0 && optExists('dg')==0 && optExists('shardgroup')==0 && optExists('shardspace')==0){
     if(findFilePattern($ORACLE_HOME."/bin/","crsctl")==0){
        print("\nopatchauto must run from Grid Home with current arguments. Please retry it inside Grid Home\n");
        print("opatchauto returns with error code = 2\n");
       exit(2);
     }
   }elsif($crsHome ne "" && $ORACLE_HOME ne $crsHome ){
      print("\nThe running Oracle Home is not a valid Grid Home. Please check it and retry\n");
      print("opatchauto returns with error code = 2\n");
      exit(2);
   }
  }
}

my $ouiLoc=getOptValue('oui');

if(optExists('oui')==0 || ! -d getOptValue('oui')){
  $ouiLoc=$ORACLE_HOME."/oui";
  if(! -d $ouiLoc){
   $ouiLoc="";
  }
}

my $userSuppliedInventory = getOptValue('invPtrLoc');
if(optExists('invPtrLoc')==1 && optExists('remote')==1){
  print("\nERROR: Supplied inventory $userSuppliedInventory will not be used in case of multi node execution.\n");
  print("Central inventory will be used in case of multi node execution.\n");
  print("opatchauto returns with error code = 2\n");
  exit(2);
}

if(-e $ORACLE_HOME."/oraInst.loc" && optExists('remote')==0 && optExists('invPtrLoc')==0 && isDescSession()==0 && $isOper==1){
  addOpt('invPtrLoc',$ORACLE_HOME."/oraInst.loc");
}

my $jreOpt="";
if(optExists('jre')==1){
 $jreOpt=getOptValue('jre');
}
my $JAVA_HOME=getJavaHomePath($DETECT_OH,$jreOpt);
my $JAVA=$JAVA_HOME."/bin/java";
removeOpt('jre');

my $JRE_MEMORY_OPTIONS="";
if(defined $ENV{'JRE_MEMORY_OPTIONS'}){
 $JRE_MEMORY_OPTIONS=$ENV{'JRE_MEMORY_OPTIONS'};
}
$JRE_MEMORY_OPTIONS=getJreMemoryOptions($ouiLoc."/oraparam.ini",$JRE_MEMORY_OPTIONS,$JAVA);

my $CLASSPATH="";
if(length($ouiLoc) >0){
 $CLASSPATH=$ouiLoc."/jlib";
}else{
  $CLASSPATH=$DETECT_OH."/oui/jlib";
}
setCP($CLASSPATH);

my $result = 0;
my $SRVM_JLIB=$DETECT_OH."/jlib";
setSrvmLibPath($SRVM_JLIB);
my $orginalArgs=getArguments();
if(optExists('help')==1 && optExists('sdb')==1){
 my $sdbHelpCP=getSystemInfoGeneratorCP();
 my $sdbHelpJavaInvocation=$JAVA." "." -cp ".$sdbHelpCP."  com.oracle.glcm.patch.auto.db.utils.PrintHelp  ".$orginalArgs;
 $result = system($sdbHelpJavaInvocation);
 $result = $result >> 8;
 exit($result);
}

my $JAVA_VM_OPTION="";
if(defined $ENV{'JAVA_VM_OPTION'}){
  $JAVA_VM_OPTION=$ENV{'JAVA_VM_OPTION'};
}

my $host = hostname();
$host = (split('\.', $host))[0];
if(optExists('help')==0 && isResumeSession()==1){
  if(optExists('session')==0){
    my $sessionId="";
    my $sessionStoreHandlerArgs="";
    my $filename = $opatchAutoDir."/dbsessioninfo/localSessionInfoFile_".$host.".txt";
   if (open(my $fh, $filename)) {
     $sessionId = <$fh>; 
     addOpt('session',$sessionId);
     close $fh;
    }else {
      print("\n\nERROR: There was no previous session information found to resume opatchauto.\n");
      print("opatchauto cannot proceed.\n\n");
      exit(2);
   }
   
   if(optExists('parentId')==1){
     my $parentSessionId=getOptValue('parentId');
     $sessionStoreHandlerArgs=" ".$filename." ".$parentSessionId;
   }else{
     $sessionStoreHandlerArgs=" ".$filename." verify ".$sessionId;
   }
   
    my $sessionStoreHandlerProps=" -DOPatchAuto.HOME=".$DETECT_OH;
    my $sessionStoreHandleCP=getOpatchAutoCP();
    my $sessionStoreHandleJavaInvocation=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp   ".$sessionStoreHandleCP." ".$sessionStoreHandlerProps." ".$sessionStoreHandlerProps." com.oracle.glcm.patch.auto.db.utils.SessionStoreHandler  ".$sessionStoreHandlerArgs;
    $result = system($sessionStoreHandleJavaInvocation);
    $result = $result >> 8;
    if($result!=0){
      if(optExists('parentId')==1){
       print("\nUnable to extract the session ID. $OPATCH_AUTO_MSG failed with error code $$result.\n");
       exit($$result);
      }else{
       print("\n$OPATCH_AUTO_MSG failed with error code $result. Unable to resume opatchauto from local home.\n");
		exit($result);
      }
    }
  }else{
    print("\nERROR: The argument specified is invalid: -session\n");
    removeAllOpt();
    addOpt('resume',"arg");
    addOpt('help',"switch");
  }
}
$orginalArgs=getArguments();
my $isActionSession=isActionSession();
my $operationType="";
if(isApplySession()==1){
 $operationType="apply";
}elsif(isRollbackSession()==1){
 $operationType="rollback";
}

my $PATCH_TRACKING_DATA="";
my $PATCH_WITH="";
my $ROOT_CRS_TMP="";
my $HOME_PATH="";
my $PATCHWORK="";
if(isDescSession()==0){
   my $Args_Edited=$orginalArgs;
   $Args_Edited="\"".$Args_Edited."\"";
   my $JRE_MEMORY_OPTIONS_EDITED=$JRE_MEMORY_OPTIONS;
   $JRE_MEMORY_OPTIONS_EDITED=~s/\ /#/g;
   $ENV{'ORACLE_HOME'} = $DETECT_OH;
   
   if($_debugMode==1){
      print("\nOriginal::$orginalArgs\n");
      print("\nEdited::$Args_Edited\n");
    }
  if(optExists('sdb')==0 && optExists('sidbonly')==0 && optExists('dg')==0 && optExists('shardgroup')==0 && optExists('shardspace')==0 ){
     if($isOper == 1  || $isActionSession == 1){
       my $systemInFoGeneratorCP=getSystemInfoGeneratorCP();
       my $additionalArgs="-DETECT_OH=".$DETECT_OH." -isOper=".$isOper." -DEBUGVAL=".$DEBUGVAL." -JAVA=".$JAVA." -JAVA_VM_OPTION=".$JAVA_VM_OPTION." -JRE_MEMORY_OPTIONS=".$JRE_MEMORY_OPTIONS_EDITED." -CP=".$CLASSPATH." -BASE=".$BASE." -operationType=".$operationType." -LD_LIBRARY_PATH=".$LD_LIBRARY_PATH." -OH=".$ORACLE_HOME." -isActionSession=".$isActionSession." -oracleOcmService=".$oracleOcmService." -ARGS ".$Args_Edited;
       my $systemInfoGeneratorJavaInvocation=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp ".$systemInFoGeneratorCP." com.oracle.glcm.patch.auto.db.util.SystemInfoGenerator ".$additionalArgs;
       if($_debugMode==1){
        print("\n$systemInfoGeneratorJavaInvocation\n");
       }
       $result = system($systemInfoGeneratorJavaInvocation);
       $result = $result >> 8;
       if($result!=0 && $result!=53){
         print("\n$OPATCH_AUTO_MSG bootstrapping failed with error code $result.\n");
         exit($result);
       }else{
        $result=0;
       }
    }
  }
   my $OPATCHAUTOTEMP=$DETECT_OH."/OPatch/auto/dbtmp/bootstrap_".$host;
   $PATCHWORK=$OPATCHAUTOTEMP."/patchwork";
   $PATCH_TRACKING_DATA=$opatchAutoDir."/dbsessioninfo";
   my $fh="";
   my $LD_LIB_TMP=$DETECT_OH."/lib";
   if($result==0){
       if(optExists('sdb')==0 && optExists('topology')==0){
	    if( -e $PATCHWORK."/patchutil.txt"){
			 $fh=openFile($PATCHWORK."/patchutil.txt",0);
			 $PATCH_WITH=readFile($fh);
			 closeFile($fh);
		 }
         if($_debugMode==1){
          print("\nPatch With::$PATCH_WITH\n");
         }
         if( -e $PATCHWORK."/homepath.txt"){
           $fh=openFile($PATCHWORK."/homepath.txt",0);
           $HOME_PATH=readFile($fh);
           closeFile($fh);
         }
         $SRVM_JLIB=$HOME_PATH."/jlib";
         $LD_LIB_TMP=$HOME_PATH."/lib";
         if( -e $PATCHWORK."/patchutil.txt"){
           if($PATCH_WITH eq "patch"){
             $SRVM_JLIB=$PATCHWORK."/jlib";
       	     $ROOT_CRS_TMP=$PATCHWORK."/crs/install";
       	     $LD_LIB_TMP=$PATCHWORK."/lib";
           }
         }
       }
       
        if($_debugMode==1){
          print("\nSRVM_JLIB: $SRVM_JLIB\n");
          print("\nROOT_CRS_TMP: $ROOT_CRS_TMP\n");
          print("\nLD_LIB_TMP: $LD_LIB_TMP\n");
        }
    }
 
 if($PLATFORM eq 'Linux'){ 
   $LD_LIBRARY_PATH=$LD_LIB_TMP.":".$ENV{'LD_LIBRARY_PATH'};
   $ENV{'LD_LIBRARY_PATH'} = $LD_LIBRARY_PATH;
 }elsif($PLATFORM eq 'HP-UX'){
   $LD_LIBRARY_PATH=$LD_LIB_TMP.":".$ENV{'LD_LIBRARY_PATH'};
   $ENV{'LD_LIBRARY_PATH'} = $LD_LIBRARY_PATH;
 }elsif($PLATFORM eq 'AIX'){
  my $LIBPATH=$LD_LIB_TMP.":".$ENV{'LIBPATH'};
  $ENV{'LIBPATH'} = $LIBPATH;
 }elsif($PLATFORM eq 'SunOS'){
   my $LD_LIBRARY_PATH_64=$LD_LIB_TMP.":".$ENV{'LD_LIBRARY_PATH_64'};
   $ENV{'LD_LIBRARY_PATH_64'} = $LD_LIBRARY_PATH_64;
   my $LD_LIBRARY_PATH=$LD_LIB_TMP.":".$ENV{'LD_LIBRARY_PATH'};
   $ENV{'LD_LIBRARY_PATH'} = $LD_LIBRARY_PATH;
 }else{
  print("\nERROR: $PLATFORM is not supported. opatchauto cannot proceed!\n");
  exit(2);
 } 
  setSrvmLibPath($SRVM_JLIB);
  if(optExists('sdb')==0 && optExists('topology')==0 && isDescSession==0 && $isOper == 1){
      my $topologyCreatorCP=getTopologyCreatorCP();
      my $additionalArgs=" -DOPatch.OUI_LOCATION=".$ouiLoc." -DOPatch.ORACLE_HOME=".$DETECT_OH." ".$oracleOcmService;
      my $topologyCreatorJavaInvocation=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp ".$topologyCreatorCP." ".$additionalArgs." com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.TopologyCreator ".$orginalArgs;
      if($_debugMode==1){
       print("\n$topologyCreatorJavaInvocation\n");
      }
      $result = system($topologyCreatorJavaInvocation);
      $result = $result >> 8;
      
      if($_debugMode==1){
        print("\nResult: $result\n");
      }
      
      if($result!=0){
       print("\nTopology creation failed.\n");
       exit($result);
      }
  }
}
my $TEST_REBOOT_PATCHING = "";
if(defined $ENV{'TEST_REBOOT_PATCHING'}){
   $TEST_REBOOT_PATCHING=$ENV{'TEST_REBOOT_PATCHING'};
}
my $opatchAutoSystemProps=" -DOPatch.ORACLE_HOME=".$DETECT_OH." -DOPatchAuto.HOME=".$DETECT_OH." -DOPatch.DEBUG=".$DEBUGVAL." -DOPatchauto.TEST_REBOOT_PATCHING=".$TEST_REBOOT_PATCHING." -DOPatch.RUNNING_DIR=".$BASE." -DOPatch.OUI_LOCATION=".$ouiLoc." -DOPatchauto.GI_INFO_LOC=".$DETECT_OH." -DOPatchauto.PATCH_WITH_FILES_FROM_LOC=".$PATCH_WITH." -DOPatchauto.ROOTCRS_PL_FILE_TEMP_LOC=".$ROOT_CRS_TMP."  -DOPatchauto.GI_HOME_PATH=".$HOME_PATH." -DPATCHWORK_PATH=".$PATCHWORK." -Dopatchauto.tracking.sessions.dir=".$PATCH_TRACKING_DATA." ".${oracleOcmService};
my $opatchAutoCP=getOpatchAutoCP();
my $opatchAutoJavaInvocation=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp ".$opatchAutoCP." ".$opatchAutoSystemProps." com.oracle.glcm.patch.auto.OPatchAuto  ".$orginalArgs;
if($_debugMode==1){
       print("\n$opatchAutoJavaInvocation\n");
}
$result = system($opatchAutoJavaInvocation);
$result = $result >> 8;

if($result >= 5 && $result <= 7){
 print("\n $OPATCH_AUTO_MSG stopped on request.\n");
 $result=0;
}elsif( $result == 8){
 print("\n $OPATCH_AUTO_MSG completed with warnings.\n");
 $result=0;
}elsif( $result == 4){
 print("\n $OPATCH_AUTO_MSG analysis reports error(s).\n");
 $result=0;
}elsif( $result != 0){
  my $OPATCHAUTO_OWNER=getFileOwner($opatchAutoDir);
  my $OPATCHAUTO_GROUP=getFileOwnerGroup($opatchAutoDir);
  my $mode="local";
  if($remoteSession == 1){
   $mode="remote";
  }
  removeFile($opatchAutoDir."/dbtmp/patchingmode.txt");
  my $fh=openFile($opatchAutoDir."/dbtmp/patchingmode.txt",1);
  writeFile($fh,$mode);
  closeFile($fh);
  changeFileOwner($OPATCHAUTO_OWNER,$OPATCHAUTO_GROUP,$opatchAutoDir."/dbtmp/patchingmode.txt");
  changeFilePermission($opatchAutoDir."/dbtmp/patchingmode.txt","0775");  
  print("\n $OPATCH_AUTO_MSG failed with error code $result\n");
}else{
 removeFile($opatchAutoDir."/dbtmp/patchingmode.txt");
}
exit($result);
print("\n");

sub getEnv{
 my $envName=$_[0];
 my $envVal="";
 if(defined $ENV{$envName}){
     $envVal=$ENV{$envName};
  }
  return $envVal;
}
