Rem
Rem $Header: rdbms/admin/xdbud121.sql /st_rdbms_12.2.0.1.0/1 2016/07/29 11:44:13 qyu Exp $
Rem
Rem xdbud121.sql
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      xdbud121.sql - XDB Upgrade Dependent objects from 12.1.0
Rem
Rem    DESCRIPTION
Rem      This script upgrades the XDB dependent objects from release 12.1.0
Rem      to the current release.
Rem
Rem    NOTES
Rem     It is invoked by xdbud.sql, and invokes the xdbudNNN script for the 
Rem     subsequent release.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    qyu         07/25/16 - add file metadata
Rem    huiz        12/12/14 - bug# 18857697: annotate XDBFolderListing.xsd 
Rem    hxzhang     06/04/14 - bug#18857697, annotate XDB schema
Rem    raeburns    05/14/14 - move xdb$ttset changes to xdbuo121.sql
Rem                         - drop obsolete migr9202status table
Rem    pyam        04/29/14 - back out huiz_bug-18406799, huiz_bug-18609669
Rem    huiz        04/17/14 - bug 18609669: make fix of bug 18406799 and
Rem                           18490650 in major release upgrade script 
Rem    raeburns    04/13/14 - move 121 actions post reload
Rem    raeburns    10/25/13 - XDB upgrade restructure
Rem    raeburns    10/25/13 - Created
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/xdbud121.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/xdbud121.sql 
Rem    SQL_PHASE: XDBUD121 
Rem    SQL_STARTUP_MODE: UPGRADE 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/xdbud.sql 
Rem    END SQL_FILE_METADATA

Rem ================================================================
Rem BEGIN XDB Dependent Object Upgrade from 12.1.0
Rem ================================================================

-- migr9202status no longer used
-- must be restored for downgrade in xdeud121.sql
DROP TABLE xdb.migr9202status;

-- First remove XDBFolderListing.xsd and then re-register it with genTables false
declare
 c NUMBER;
 csxxinurl VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/XDBFolderListing.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = csxxinurl;

  if c > 0 then
    dbms_xmlschema.deleteschema(csxxinurl, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then raise;
end;
/

declare
  FLXSD VARCHAR2(4000) :=
  '<schema 
     targetNamespace="http://xmlns.oracle.com/xdb/XDBFolderListing.xsd"
     xmlns="http://www.w3.org/2001/XMLSchema"
     xmlns:xdb="http://xmlns.oracle.com/xdb"
     xmlns:l="http://xmlns.oracle.com/xdb/XDBFolderListing.xsd"
     version="1.0" elementFormDefault="qualified">

    <complexType name="ListingTyp" xdb:SQLType="FolderListingTyp">
      <sequence>
        <element name="ChildName" type="string" maxOccurs="unbounded" xdb:SQLCollType="ChildNameCollTyp" />
      </sequence>
      <attribute name="name" type="string"/>
      <attribute name="size" type="integer"/>
    </complexType>

    <element name="Folder" type="l:ListingTyp"/>

   </schema>';

  FLURL VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/XDBFolderListing.xsd';

begin

xdb.dbms_xmlschema.registerSchema(FLURL, FLXSD, FALSE, TRUE, FALSE, FALSE, FALSE, 'XDB');

end;
/

-- First remove stats.xsd and then re-register it
declare
 c NUMBER;
 inurl VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/stats.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
    where s.xmldata.schema_url = inurl;

  if c > 0 then
    dbms_xmlschema.deleteschema(inurl, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then raise;
end;
/

/* --------------------------------------------------------------------------*/
/* register statistics schema
/* --------------------------------------------------------------------------*/
declare
  STATSXSD VARCHAR2(4000) := 
'<schema xmlns="http://www.w3.org/2001/XMLSchema"
        xmlns:xdb="http://xmlns.oracle.com/xdb"
        xmlns:st="http://xmlns.oracle.com/xdb/stats.xsd"
        targetNamespace="http://xmlns.oracle.com/xdb/stats.xsd"
        elementFormDefault="qualified">
   <simpleType name="OIDType"> <restriction base="hexBinary"> <maxLength value="32"/> </restriction> </simpleType>
   <element name="ContainerStats" xdb:defaultTable="XDB$STATS" xdb:SQLType="ContainerStatsTyp" xdb:columnProps="constraint stats_pk PRIMARY KEY(xmldata.RESOID)">
     <complexType xdb:SQLType="ContainerStatsTyp">
       <sequence>
         <element name="TotalRows" type="double"/>
         <element name="TotalContainers" type="double"/>
         <element name="FanOut" type="integer"/>
         <element name="ImmediateContainers" type="integer"/>
         <element name="LastAnalyzedDate" type="dateTime"/>
       </sequence>
       <attribute name="ResOid" type="st:OIDType" xdb:SQLName="RESOID"/>
     </complexType>
   </element>
</schema>';

  STATSURL VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/stats.xsd';
  n integer;
begin
  select count(*) into n from xdb.xdb$schema s
  where s.xmldata.schema_url = 'http://xmlns.oracle.com/xdb/stats.xsd';

  if (n = 0) then
    xdb.dbms_xmlschema.registerSchema(STATSURL, STATSXSD, FALSE, TRUE,
                                      FALSE, TRUE, FALSE, 'XDB');
  end if;
end;
/

Rem ================================================================
Rem END XDB Dependent Object Upgrade from 12.1.0
Rem ================================================================

Rem ================================================================
Rem BEGIN XDB Dependent Object Upgrade from the next release
Rem ================================================================

-- Uncomment for next release
--@@xdbud122.sql

