@@?/rdbms/admin/sqlsessstart.sql
DECLARE
  blobval BLOB;
  clobval CLOB;
  nclobval NCLOB;
  fpval    NUMBER;
BEGIN
  DBMS_LOB.CREATETEMPORARY(blobval,TRUE);
  DBMS_LOB.CREATETEMPORARY(clobval,TRUE);
  DBMS_LOB.CREATETEMPORARY(nclobval,TRUE);

  DBMS_LOB.WRITE(blobval, 10, 1, UTL_RAW.CAST_TO_RAW('[redacted]'));
  DBMS_LOB.WRITE(clobval, 10, 1, '[redacted]');
  DBMS_LOB.WRITE(nclobval, 10, 1, N'[redacted]');
  
  select fpver into fpval from sys.radm_fptm_lob$;
  
  if fpval = 0 then
    update sys.radm_fptm_lob$
    set blobcol=blobval,
        clobcol=clobval,
        nclobcol=nclobval,
        fpver=1
    where fpver=0;

    commit;
  end if;

  DBMS_LOB.FREETEMPORARY(blobval);
  DBMS_LOB.FREETEMPORARY(clobval);
  DBMS_LOB.FREETEMPORARY(nclobval);
EXCEPTION
  when too_many_rows then
    delete from sys.radm_fptm_lob$
    where fpver < 2;

    insert into sys.radm_fptm_lob$ 
    values (blobval,
            clobval,
            nclobval,
            1);
    commit;
    
    DBMS_LOB.FREETEMPORARY(blobval);
    DBMS_LOB.FREETEMPORARY(clobval);
    DBMS_LOB.FREETEMPORARY(nclobval);
  when no_data_found then
    insert into sys.radm_fptm_lob$ 
    values (blobval,
            clobval,
            nclobval,
            1);
    commit;
    DBMS_LOB.FREETEMPORARY(blobval);
    DBMS_LOB.FREETEMPORARY(clobval);
    DBMS_LOB.FREETEMPORARY(nclobval);
END;
/
CREATE OR REPLACE LIBRARY dbms_redact_lib wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
16
2b 61
Q7rRMxW3WwEtyoW5JnbNK7R/NR4wg04I9Z7AdBjDWqGXYkqW8i6hWdH0cvpZCee9nrLLUjLM
pXQr58tSdAj1Ycmmpnu6skg=

/
CREATE OR REPLACE PACKAGE dbms_redact_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
16a5 3f9
dR2HptA5OrRiUT53FBt+qBF9Dewwg81UDNDrfC+LaA/u71rn+4ArdnYXg+x7YUPGuZ+Wb0t2
V937M7WZ2vrfUrZJ0Uyzyk2fKKTXwUKqM8Pgwmr9Z/5PvHP1JLxoquTkj7w/qmdUZCvnYh5y
tQxs54kr+xUBKRpwiYrtBGvBUc6m21cuYWk49c5pSuItZrrYGTwjlroAStVnEeZkrdq6ZDYu
jo1Anj/YsWaa7YBoZTwO43BhBl6wrg7coA1hbjZMFzPTZrpEQ1TNpEM53w7h5VbFzY6JdXXq
Hu6909W7LftjgooVO8MOgYyc+nThxkRtJbilruc5zqb+sP0BazU+u5s70hyIu8ty13BtCcqI
G4+gzIkgwMwJEScj7l/JpS4280ZUY6m2dak0SsqU35EFASNhSfxO8AODHtyRvmTBEVhfazw/
Ug2XBK8JvVh/1ljvda03xieh6pbXrkcfIPN0AvStQa/YOih0BXz/rW4NcTNY7NKqkFz/RT3c
6UzIr03Lv3LAoVabYb4WnP9T99n2kzo865jUupdjKkhiibvUPuGgyaIgDjxun/BYkHTFdf6G
fZ9LqhUOVrW6FXuGYB7mYcLbOXHKQ6cOHaix3PwbvWgrAk8MliP1GvcO7knsPySY9htL3vdV
IbEloXE+fnUHq7Tuq97TH8DHpcLURL3mxz9h3hBGy61iN4Ytr8icia8EH/10U4mv5+qxPhiW
WouGgkUH5VJAKw6y4l10udRo6QgyU/0nYYHq9UlXdj3Q9GYzglqLcxQddvoVCARUsaj7iobc
pA4RJ+OsafCnK5gfoYJ/HVKiNGoq3uQ1gmpD7ev4sZtU+IelCUH6C9kitU51kMZ3QacTNKG1
0bMonZgCofozc7SQ8zgm+lWF1PLsmE/Xuwwmy9rRr2ar1ZcKOYZA2uZlCq0oJW6xEf9kIACQ
Xhwy7eNA9lnccH3e7/0pQYnce5IbhTrBpDipPVo1gSyyeomZMDG1iMr1wT0DD7SgNNI=

/
show errors;
CREATE OR REPLACE PACKAGE BODY dbms_redact_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
3774 9d2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/
show errors;
CREATE OR REPLACE PACKAGE BODY dbms_redact wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
4282 865
RsNa8pPLlSVZ5jxIfqz/iNZKZ8cwg82jDCCG3y+5rZ2sB+H0N+lQzS01bw4+eyvvzOHpbAiH
RmEFC5Z5tSTy/JXEopefBjINBwKCbtBOj3TpPwm9s4LPFXC6FFulzf6d+d75+U4FIKrkmXAy
HWehmUa37OCmtxo+bVbpW9E5j+K0+Rjz9sWgxq02hp2JqR9asxwlTxL6ltCpd5M8USKBFuHH
dKm2PSkyp6yB03Go7KdWYlrjH02F/G5Z1yI3GKANCr3TRbLaiVQDDS69GgcbbHQkOMVp+t9k
qxi247Rz/0FrRokSR3w74YoGxPEG5as00skvtlPXoCFf+ZTpQO7nwQOCo4bL6b7ZIGz+41K/
WhE5Eo6VATnzSMVgXpuOGMVtxQHyV/90PzzKROYqY3XKevs6odZdyGvtR9JfIP35qsWSkW1P
CSUYJZAx/d494d+pzVKwHWcyTbmNPW/5aP2k3z0B0A/bdLLFMAQgirlh4nwoTkMz63kffPZG
XZ+C3F32eiL3ZWY9AHPGPY3zDFV+sibi8FpusPOt3Igtd6TJce/TwSk1SutgdqbtQ8OpZWZS
QeiGV61REZi6rhHE7wnr60hxXiwtL8kKoUYi4BNlRS5/PdBULwMFFKJKVMoDmhSFBMzlZz5S
uFmuTZsbLgYb8rdS5deE+B0XlCKTEvbv9v1keTRhCL4FVN9loc4L5O7Jz0Ha5Q96d5nJJLRq
HLW5pFEV2C0uTIE43VntYW1BewwfnbB7wrOcUToSVi7GSkKLJaBiP7+UI9TBPVJE7VbELAmx
uxOEF/3jD5vDPbmx8WRaEcw5L2/8c9GpJucUxVkNtxm214W8jP+Z2j6AOc7zQ7vaPla6zIk4
WqQoDfx7sf5NuJZwDZgP8o2ruihHzjX+4foJ43VCY71RZpUcBc0lxlCwnAxG3PdKtcesTles
AMsyo2U9iq+3zWvMui53YIb2aeJo8GhWVxLpwhtSbvouejjTDKxWGmdRvchE0sYJmwuIcmFf
39rz15sZcd7D/kVKNvac4kxFnyktTPzgbpKbsSjeSAlIAWDqydJqdcwgkIMQUyUa1S4jQyEm
wA5l9CWg0yA+wc4YBFEhRmtXluknxvUQVt71X5yEkN7i/YG07SFPY3JR4/jKl4rYlN6AMjJE
iKQGlXeMi77MSphlwR9G/L4K24mJKvafREO/OYCTlCpe1Dvuy3PhA6uYGAl17r+Mi4gscUPn
iiP1YtaLS0Nlrm3FBCDZ7IZmPeVwUCVzLLAnRNZKHDaxzDb8zeZdELg995vsz/UleO4pK27t
5Ea//6s+ZNk2ZWjn4u0o3GnnO5BKIlPvMrxDgOfRq9/Z3OGKqoOfNC760dXKHvfxa0hjt1Ma
Tem6YWf0HhqHblSYs9lvSRSmRzoxlvimDSYnKEp9OemHzzkybkhpj885KnGY3KPP5mUsLAqO
w20L3krVOU7AOf6XvCcIoWj2lzPNT4/2NUstP5MtPXOO8UIk9wKENVdRHQUypaYXh3tTRc9h
JNjL7vAWRIRk/NfdXCE3UWOJP7BsRO+xjD2QU6hNrDUMZGXiY705Yu3jAh7lcHclS+YMlHSj
IzfAYj4Ew9KjXcXsZycmjbEnPqx/k4PCbZEmrH+T6G/A3ikqd+g1831otDAcw6dV/kNc6gCp
FRQgn2zZqjbkZQWcW52xAMVeNLlS+DbPr9IITjaYa5TcblX7xVb261m0K83FDYh5U2ozp430
5lnQjW8XXN1Gr/Mc4AxiilfHAAlUw0m9TOrCUFaIX/FNV/qbZ/TTPr10MqDaub1S3wJZtP3u
a97NeHVX9llo3cLGHP1IJ7Rj4Du9cRe4dagweARhJmm3slvSLvqqDXNXWfMntmLE9CMTFjwb
rRUWiNjxLwPNLE2FTomyB8EmgmeZUNx34+BrVZo18B9+v6cw7CRONL4TOHiJMQ271qSABUSA
UfqmF4SJsceEOIsBQ3fa2SlLkG95ez3+xbkall1KQmJJ8rOcEv47uSP2uGXdDTlyo9a8aPid
ass73aZmn4sD7qUJdTs3DM+CIM8//K4iVtmKDicq2C+AX/7OxTL51cyaYDhvr5tzOGX5gqpe
joE6cg1csJYINCIFBo0e0qVqqiquyfA=

/
show errors;
@?/rdbms/admin/sqlsessend.sql
