Rem
Rem $Header: rdbms/admin/olsrle.sql /main/1 2012/02/14 21:27:35 aramappa Exp $
Rem
Rem olsrle.sql
Rem
Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      olsrle.sql - Recompile Lbac_Events package
Rem
Rem    DESCRIPTION
Rem      Validate lbac_events on which OLS DDL triggers depend. If not 
Rem      validated here these triggers fire when utlrp is invoked with
Rem      lbac_events still in an invalid package state.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aramappa    02/03/12 - bug 13653782:validate lbac_events package
Rem    aramappa    02/03/12 - Created
Rem

SET ECHO ON

DECLARE
  objid NUMBER;
BEGIN
  IF dbms_registry.is_loaded('OLS') IS NOT NULL THEN
  BEGIN
    SELECT object_id into objid from dba_objects WHERE
           object_name='LBAC_EVENTS' AND status = 'INVALID' 
           AND object_type='PACKAGE BODY';
    dbms_utility.validate(objid);
    EXCEPTION
    WHEN OTHERS THEN
      RETURN;
    END;
  END IF; 
END;
/
