Rem
Rem $Header: rdbms/admin/dpload.sql /main/18 2016/07/06 07:18:21 rapayne Exp $
Rem
Rem dpload.sql
Rem
Rem Copyright (c) 2013, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dpload.sql - load entire Data Pump utility.
Rem
Rem    DESCRIPTION
Rem      load entire Data Pump utility (including the metadata layer).
Rem
Rem    NOTES
Rem      When there are changes to any of the following Data Pump files it
Rem      is necessary to unload and then reload the entire Data Pump utility.
Rem         src/server/datapump/services/prvtkupc.sql
Rem         src/server/datapump/ddl/prvtmetd.sql
Rem         admin/catmeta.sql
Rem         admin/catmettypes.sql
Rem         admin/catmetviews.sql
Rem         admin/catmetinsert.sql
Rem
Rem      This must be executed as SYS.
Rem
Rem    ISSUES
Rem      This script leaves ~100 packages in an invalid state (i.e., presumably
Rem      consumers of datapump/metdata apis). These packages simply need to be
Rem      recompiled. However, running utlrp.sql is 'expensive'.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rapayne     06/30/16 - Bug 23640417: in upgrade mode dropping ku$noexp_tab
Rem                           results in an error. Add error to ignorable metadata
Rem                           until a better solution is found.
Rem    rapayne     03/28/16 - Bug 22879025: correctly handle modules which 
Rem                           dont exist is older versions.
Rem    dvekaria    02/12/16 - Bug 22607194: Fix ORA-01775 and PLS-00201 errors.
Rem    sdipirro    11/19/15 - Add prvthdpi and prvtbdpi
Rem    sogugupt    11/26/15 - Bug 22245383: Add metadata SQL_IGNORABLE_ERRORS
Rem    mjangir     11/19/15 - bug 22222697: Move prvth*.plb utilities package
Rem                           header before prvtmet*.plb
Rem    tbhukya     09/02/15 - Bug 21776925: Use '@@' for file run
Rem    dgagne      08/13/15 - Fix loading of prvtdputh.plb
Rem    dgagne      08/11/15 - backout approot txn
Rem    rapayne     07/15/15 - Fix loading of prvtdputh.plb
Rem    tbhukya     06/12/15 - Bug 21137821: Run files directly instead of a
Rem                           script with relative paths.
Rem    rapayne     04/19/15 - lrg 15977957: remove connect string from the
Rem                           generated loadutl script.
Rem    rapayne     03/15/15 - bug 20680092: disable spooling
Rem    tmontgom    10/31/14 - Move prvtkupc.plb the Utilities package header
Rem                           (depends on types in prvtkupc.plb), mimic order
Rem                           of catproc.sql
Rem    surman      10/16/14 - Update phase
Rem    rapayne     05/14/14 - make changes to accommodate readonly admin dirs.
Rem                           Bug 17039620.
Rem    rapayne     09/17/13 - update sql_file_metadata tags as per sqlpatch team
Rem                           request.
Rem    rapayne     07/10/13 - Created
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: rdbms/admin/dpload.sql
Rem    SQL_SHIPPED_FILE: rdbms/admin/dpload.sql
Rem    SQL_PHASE: DPLOAD
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: ORA-04043, ORA-00942, ORA-01921, ORA-00955, ORA-14452
Rem    SQL_CALLING_FILE: NONE
Rem    END SQL_FILE_METADATA

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 300
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 300
SET VERIFY off
SET SERVEROUTPUT ON

--
-- Check specified version for a file
--
CREATE OR REPLACE FUNCTION for_version (
           v_filename IN VARCHAR2,
           v_begin    IN VARCHAR2 DEFAULT NULL,
           v_until    IN VARCHAR2 DEFAULT NULL)
  RETURN VARCHAR2 AS
  l_version VARCHAR2(10);
BEGIN
  SELECT substr(dbms_registry.version('CATPROC'), 1, 10)
    INTO l_version
    FROM dual;

  IF (v_begin is null or l_version >= v_begin) AND
     (v_until is null or l_version < v_until)
  THEN
    RETURN v_filename;
  ELSE
    RETURN dbms_registry.nothing_script;
  END IF;

END for_version;
/ 

-- Drop Data Pump and Metadata views/types.
@@catnodp.sql
@@catdpb.sql

-- Metadata package definitions
@@dbmsmeta.sql
@@dbmsmetb.sql
@@dbmsmetd.sql
@@dbmsmeti.sql
@@dbmsmetu.sql
@@dbmsmet2.sql
@@utlcxml.sql
@@dbmsxml.sql

@@dbmsdp.sql
@@prvthpp.plb
@@prvthpd.plb
@@prvthpdi.plb
@@prvthpvi.plb
@@prvthpv.plb
@@prvtkupc.plb
@@prvthpu.plb
@@prvthpui.plb

-- DBMS_DATAPUMP_UTL package body
COLUMN fname new_val file_name

select for_version('prvthdpi.plb','12.2.0.0') AS fname FROM dual;
@@&file_name

-- Metadata Types
SELECT for_version('catmettypes.sql','12.1.0.1') AS fname FROM dual;
@@&file_name
-- Metadata Views
SELECT for_version('catmetviews.sql','12.1.0.1') AS fname FROM dual;
@@&file_name
-- Metadata Grants 1
SELECT for_version('catmetgrant1.sql','12.1.0.1') AS fname FROM dual;
@@&file_name
-- Metadata Grants 2
SELECT for_version('catmetgrant2.sql','12.1.0.1') AS fname FROM dual;
@@&file_name
-- Inserts on metadata dictionary tables
SELECT for_version('catmetinsert.sql','12.1.0.1') AS fname FROM dual;
@@&file_name

-- Metadata Types, Views, Grants and Inserts in 12.1.0.1 and lower versions
SELECT for_version('catmeta.sql',v_until=>'12.1.0.1') AS fname FROM dual;
@@&file_name

--
-- Now generate the rest of the common load files.
--
@@prvthpc.plb
@@prvthpci.plb
@@prvthpw.plb
@@prvthpm.plb
@@prvthpfi.plb
@@prvthpf.plb

-- DBMS_METADATA_INT package body: Dependent on prvtpbui
@@prvtmeti.plb
-- DBMS_METADATA_UTIL package body: dependent on prvthpdi
@@prvtmetu.plb
-- DBMS_METADATA_BUILD package body
@@prvtmetb.plb
-- DBMS_METADATA_DPBUILD package body
@@prvtmetd.plb
-- DBMS_METADATA_DIFF package body
@@prvtmet2.plb

-- UTL_XML: PL/SQL wrapper around CORE LPX facility: C-based XML/XSL parsing
@@prvtcxml.plb
@@prvtbpu.plb
@@prvtbpui.plb

-- DBMS_DATAPUMP public package body
@@prvtdp.plb

-- DBMS_DATAPUMP_UTL package body (note: pkg def was split out in 12.1)
SELECT for_version('prvtdputh.plb','12.1.0.1') AS fname FROM dual;
@@&file_name
@@prvtdput.plb

-- DBMS_DATAPUMP_INT definers private package body
SELECT for_version('prvtbdpi.plb','12.2.0.0') AS fname FROM dual;
@@&file_name
-- KUPC$QUEUE invokers private package body
@@prvtbpc.plb
-- KUPC$QUEUE_INT definers private package body
@@prvtbpci.plb
-- KUPW$WORKER private package body
@@prvtbpw.plb
-- KUPM$MCP private package body: Dependent on prvtbpui
@@prvtbpm.plb
-- DBMS_METADATA package body: Dependent on dbmsxml.sql
@@prvtmeta.plb
-- KUPF$FILE_INT private package body
@@prvtbpfi.plb
-- KUPF$FILE private package body
@@prvtbpf.plb
-- KUPP$PROC private package body
@@prvtbpp.plb
-- KUPD$DATA invokers private package body
@@prvtbpd.plb
-- KUPD$DATA_INT private package body
@@prvtbpdi.plb
-- KUPV$FT private package body
@@prvtbpv.plb
-- KUPV$FT_INT private package body
@@prvtbpvi.plb

-- Create queue tables, default dirobj, and load catmet2.sql
@@catdph.sql
@@dbmspump.sql

-- Cleanup
drop function for_version;