Rem
Rem $Header: rdbms/admin/dbmstypu.sql /main/6 2014/02/20 12:45:43 surman Exp $
Rem
Rem dbmstypu.sql
Rem
Rem Copyright (c) 2000, 2014, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmstypu.sql - Type Utility
Rem
Rem    DESCRIPTION
Rem      Provides routines to compile all types and reset type version
Rem      during downgrade.
Rem
Rem    NOTES
Rem     This package must be executed by the DBA only.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/dbmstypu.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/dbmstypu.sql
Rem SQL_PHASE: DBMSTYPU
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/29/13 - 13922626: Update SQL metadata
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    skabraha    02/15/02 - add delete_constructor_keyword
Rem    gviswana    05/24/01 - CREATE OR REPLACE SYNONYM
Rem    thoang      06/27/00 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

CREATE OR REPLACE PACKAGE dbms_type_utility AS 

  --
  PROCEDURE Upgrade_All_Tables;
  PROCEDURE Upgrade_All_Tables (ownername IN VARCHAR2);

  --
  PROCEDURE Compile_All_Types; 
  PROCEDURE Compile_All_Types (ownername IN VARCHAR2); 

  --
  PROCEDURE Reset_All_Types;
  PROCEDURE Reset_All_Types (ownername IN VARCHAR2);

  --
  PROCEDURE Delete_Constructor_Keyword;

END dbms_type_utility;
/

CREATE OR REPLACE PUBLIC SYNONYM DBMS_TYPE_UTILITY FOR DBMS_TYPE_UTILITY;


@?/rdbms/admin/sqlsessend.sql
