Rem
Rem $Header: rdbms/admin/dbmsfcp.sql /st_rdbms_12.2.0.1.0/1 2016/08/09 22:28:46 shvmalik Exp $
Rem
Rem dbmsfcp.sql
Rem
Rem Copyright (c) 2015, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmsfcp.sql - dbms Fix Control Persistence framework
Rem
Rem    DESCRIPTION
Rem      This package provides an infrastructure to persist and restore 
Rem      fix-control environemnt
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/dbmsfcp.sql 
Rem    SQL_SHIPPED_FILE:rdbms/admin/dbmsfcp.sql 
Rem    SQL_PHASE: DBMSFCP
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shvmalik    06/30/16 - #23721669: porting FCP fix #20228468
Rem

@@?/rdbms/admin/sqlsessstart.sql

CREATE OR REPLACE PACKAGE dbms_fix_control_persistence AS
---------------------------------------------------------------------------
--
-- PACKAGE NOTES
-- This package is created to persist fix control environment and make 
-- use of the same to manage fixes which were enabled prior to applying
-- bundle patch but got disabled as part of bundle patch.
--
-- Background: Fixes having fix_control are included in exadata bundle patches
-- starting 11.2.0.4 BP12 , these fixes are disabled by default and explicitly 
-- enabled by the customer using the dbms_optim_bundle package.
--
-- Issue:  Fix control state for bug fixes present in the DB environment prior 
-- to bundle patch apply is not persisted after bundle patch apply.  A simple 
-- example to illustrate this issue:
--
-- Current environment:       11.2.0.4 BP11  + patch having fix_control 1234 
--                            enabled by default
-- After BP 12 is applied:    11.2.0.4 BP12 (patch 1234 is now disabled as 
--                            it is included in BP12)
--
-- In the above example patch 1234 is disabled in the DB environment after 
-- the customer applies BP12.  The issue is specific to bugs that are now 
-- part of the bundle patch, while being present in the DB environment as 
-- one-off patches previously.
--
--  This package provides a framework to manage (enable/disable) such fixes
--  to their previous value which was there before applying bundle patch
--
--
-- USAGE:
-- Only to be used internally via post-install scripts of bundle patches
-- having fixes containing fix_controls
--
---------------------------------------------------------------------------

-- Inserts initial data in FCP Table. It is invoked once during feature 
-- installation as part of its post-install script.
PROCEDURE insert_initial_data;

-- Modifies modify_at_startup flag in Fix-Control Persistence Table
-- and then triggers 'alter system' command to restore the required
-- fix_controls in current environment with scope=memory.
-- User of this procedure is post-install script of each subsequent 
-- bundle patch which has fixes having fix_controls.
PROCEDURE modify_FCPT_alter_FC(startbundleId IN varchar2,
                               endbundleId   IN varchar2,
                               series        IN varchar2,
                               patchMode     IN varchar2,
                               patchId       IN varchar2,
                               patchUID      IN varchar2);

-- Perform sync between current fix-control environment and fix-control
-- persistence table. Also triggers 'alter system' command to restore 
-- required fix_controls in current environment with scope=memory.
-- This is done during each database startup. 
-- User of this Procedure is qksbgnfy() which does this after database
-- is successfully opened.
PROCEDURE sync_FCPT_alter_FC (performAlter IN NUMBER);

--Function to get default value of a fix_control at given OFE 
FUNCTION get_default(bugno IN PLS_INTEGER,
                     ofe IN PLS_INTEGER,
                     lvl IN PLS_INTEGER) RETURN PLS_INTEGER;
END dbms_fix_control_persistence;
/

show errors;

@?/rdbms/admin/sqlsessend.sql
