Rem
Rem $Header: rdbms/admin/dbmsaudutl.sql /main/3 2016/05/26 19:02:30 amunnoli Exp $
Rem
Rem dbmsaudutl.sql
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmsaudutl.sql - DBMS AUDit UTiLity package
Rem
Rem    DESCRIPTION
Rem      The package provides utilities related to audit data and audit trail
Rem      management (future)
Rem
Rem    NOTES
Rem      Must be run as SYSDBA
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/dbmsaudutl.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/dbmsaudutl.sql
Rem    SQL_PHASE: CATPDBMS_MAIN
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    amunnoli    05/18/16 - Bug 23305193:do not grant execute 
Rem                           on dbms_audit_util to execute_catalog_role
Rem    risgupta    04/27/16 - Bug 23189437: Update decode functions to include
Rem                           CURRENT_USER column in audit trails
Rem    nkgopal     07/25/14 - Proj 35931: Add DBMS_AUDIT_UTIL package
Rem    nkgopal     07/25/14 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE dbms_audit_util AUTHID CURRENT_USER AS

  -- Cursor types for the four audit trail types
  TYPE cursor_atrail_std IS REF CURSOR RETURN SYS.DBA_AUDIT_TRAIL%ROWTYPE;
  TYPE cursor_atrail_fga IS REF CURSOR RETURN SYS.DBA_FGA_AUDIT_TRAIL%ROWTYPE;
  TYPE cursor_atrail_xml IS REF CURSOR RETURN SYS.V$XML_AUDIT_TRAIL%ROWTYPE;
  TYPE cursor_atrail_uni IS REF CURSOR RETURN SYS.UNIFIED_AUDIT_TRAIL%ROWTYPE;

  -- RECORD types for return from decode_rls_info()
  -- 1. DBA_AUDIT_TRAIL RECORD type
  TYPE record_atrail_std IS RECORD (
       OS_USERNAME               SYS.DBA_AUDIT_TRAIL.OS_USERNAME%TYPE,
       USERNAME                  SYS.DBA_AUDIT_TRAIL.USERNAME%TYPE,
       USERHOST                  SYS.DBA_AUDIT_TRAIL.USERHOST%TYPE,
       TERMINAL                  SYS.DBA_AUDIT_TRAIL.TERMINAL%TYPE,
       TIMESTAMP                 SYS.DBA_AUDIT_TRAIL.TIMESTAMP%TYPE,
       OWNER                     SYS.DBA_AUDIT_TRAIL.OWNER%TYPE,
       OBJ_NAME                  SYS.DBA_AUDIT_TRAIL.OBJ_NAME%TYPE,
       RLS_POLICY_TYPE           VARCHAR2(30),
       RLS_POLICY_NAME           SYS.DBA_POLICIES.POLICY_NAME%TYPE,
       RLS_POLICY_OWNER          SYS.DBA_POLICIES.PF_OWNER%TYPE,
       RLS_PREDICATE             VARCHAR2(32767),  -- max in kzrtpd
       ACTION                    SYS.DBA_AUDIT_TRAIL.ACTION%TYPE,
       ACTION_NAME               SYS.DBA_AUDIT_TRAIL.ACTION_NAME%TYPE,
       NEW_OWNER                 SYS.DBA_AUDIT_TRAIL.NEW_OWNER%TYPE,
       NEW_NAME                  SYS.DBA_AUDIT_TRAIL.NEW_NAME%TYPE,
       OBJ_PRIVILEGE             SYS.DBA_AUDIT_TRAIL.OBJ_PRIVILEGE%TYPE,
       SYS_PRIVILEGE             SYS.DBA_AUDIT_TRAIL.SYS_PRIVILEGE%TYPE,
       ADMIN_OPTION              SYS.DBA_AUDIT_TRAIL.ADMIN_OPTION%TYPE,
       GRANTEE                   SYS.DBA_AUDIT_TRAIL.GRANTEE%TYPE,
       AUDIT_OPTION              SYS.DBA_AUDIT_TRAIL.AUDIT_OPTION%TYPE,
       SES_ACTIONS               SYS.DBA_AUDIT_TRAIL.SES_ACTIONS%TYPE,
       LOGOFF_TIME               SYS.DBA_AUDIT_TRAIL.LOGOFF_TIME%TYPE,
       LOGOFF_LREAD              SYS.DBA_AUDIT_TRAIL.LOGOFF_LREAD%TYPE,
       LOGOFF_PREAD              SYS.DBA_AUDIT_TRAIL.LOGOFF_PREAD%TYPE,
       LOGOFF_LWRITE             SYS.DBA_AUDIT_TRAIL.LOGOFF_LWRITE%TYPE,
       LOGOFF_DLOCK              SYS.DBA_AUDIT_TRAIL.LOGOFF_DLOCK%TYPE,
       COMMENT_TEXT              SYS.DBA_AUDIT_TRAIL.COMMENT_TEXT%TYPE,
       SESSIONID                 SYS.DBA_AUDIT_TRAIL.SESSIONID%TYPE,
       ENTRYID                   SYS.DBA_AUDIT_TRAIL.ENTRYID%TYPE,
       STATEMENTID               SYS.DBA_AUDIT_TRAIL.STATEMENTID%TYPE,
       RETURNCODE                SYS.DBA_AUDIT_TRAIL.RETURNCODE%TYPE,
       PRIV_USED                 SYS.DBA_AUDIT_TRAIL.PRIV_USED%TYPE,
       CLIENT_ID                 SYS.DBA_AUDIT_TRAIL.CLIENT_ID%TYPE,
       ECONTEXT_ID               SYS.DBA_AUDIT_TRAIL.ECONTEXT_ID%TYPE,
       SESSION_CPU               SYS.DBA_AUDIT_TRAIL.SESSION_CPU%TYPE,
       EXTENDED_TIMESTAMP        SYS.DBA_AUDIT_TRAIL.EXTENDED_TIMESTAMP%TYPE,
       PROXY_SESSIONID           SYS.DBA_AUDIT_TRAIL.PROXY_SESSIONID%TYPE,
       GLOBAL_UID                SYS.DBA_AUDIT_TRAIL.GLOBAL_UID%TYPE,
       INSTANCE_NUMBER           SYS.DBA_AUDIT_TRAIL.INSTANCE_NUMBER%TYPE,
       OS_PROCESS                SYS.DBA_AUDIT_TRAIL.OS_PROCESS%TYPE,
       TRANSACTIONID             SYS.DBA_AUDIT_TRAIL.TRANSACTIONID%TYPE,
       SCN                       SYS.DBA_AUDIT_TRAIL.SCN%TYPE,
       SQL_BIND                  SYS.DBA_AUDIT_TRAIL.SQL_BIND%TYPE,
       SQL_TEXT                  SYS.DBA_AUDIT_TRAIL.SQL_TEXT%TYPE,
       OBJ_EDITION_NAME          SYS.DBA_AUDIT_TRAIL.OBJ_EDITION_NAME%TYPE,
       DBID                      SYS.DBA_AUDIT_TRAIL.DBID%TYPE,
       CURRENT_USER              SYS.DBA_AUDIT_TRAIL.CURRENT_USER%TYPE);
  TYPE records_atrail_std IS TABLE OF record_atrail_std;

  -- 2. DBA_FGA_AUDIT_TRAIL RECORD type
  TYPE record_atrail_fga IS RECORD (
       OS_USER                   SYS.DBA_FGA_AUDIT_TRAIL.OS_USER%TYPE,
       DB_USER                   SYS.DBA_FGA_AUDIT_TRAIL.DB_USER%TYPE,
       EXT_NAME                  SYS.DBA_FGA_AUDIT_TRAIL.EXT_NAME%TYPE,
       USERHOST                  SYS.DBA_FGA_AUDIT_TRAIL.USERHOST%TYPE,
       TIMESTAMP                 SYS.DBA_FGA_AUDIT_TRAIL.TIMESTAMP%TYPE,
       OBJECT_SCHEMA             SYS.DBA_FGA_AUDIT_TRAIL.OBJECT_SCHEMA%TYPE,
       OBJECT_NAME               SYS.DBA_FGA_AUDIT_TRAIL.OBJECT_NAME%TYPE,
       RLS_POLICY_TYPE           VARCHAR2(30),
       RLS_POLICY_NAME           SYS.DBA_POLICIES.POLICY_NAME%TYPE,
       RLS_POLICY_OWNER          SYS.DBA_POLICIES.PF_OWNER%TYPE,
       RLS_PREDICATE             VARCHAR2(32767),  -- max in kzrtpd
       POLICY_NAME               SYS.DBA_FGA_AUDIT_TRAIL.POLICY_NAME%TYPE,
       STATEMENT_TYPE            SYS.DBA_FGA_AUDIT_TRAIL.STATEMENT_TYPE%TYPE,
       COMMENT$TEXT              SYS.DBA_FGA_AUDIT_TRAIL.COMMENT$TEXT%TYPE,
       SESSION_ID                SYS.DBA_FGA_AUDIT_TRAIL.SESSION_ID%TYPE,
       ENTRYID                   SYS.DBA_FGA_AUDIT_TRAIL.ENTRYID%TYPE,
       STATEMENTID               SYS.DBA_FGA_AUDIT_TRAIL.STATEMENTID%TYPE,
       CLIENT_ID                 SYS.DBA_FGA_AUDIT_TRAIL.CLIENT_ID%TYPE,
       ECONTEXT_ID               SYS.DBA_FGA_AUDIT_TRAIL.ECONTEXT_ID%TYPE,
       EXTENDED_TIMESTAMP      SYS.DBA_FGA_AUDIT_TRAIL.EXTENDED_TIMESTAMP%TYPE,
       PROXY_SESSIONID           SYS.DBA_FGA_AUDIT_TRAIL.PROXY_SESSIONID%TYPE,
       GLOBAL_UID                SYS.DBA_FGA_AUDIT_TRAIL.GLOBAL_UID%TYPE,
       INSTANCE_NUMBER           SYS.DBA_FGA_AUDIT_TRAIL.INSTANCE_NUMBER%TYPE,
       OS_PROCESS                SYS.DBA_FGA_AUDIT_TRAIL.OS_PROCESS%TYPE,
       TRANSACTIONID             SYS.DBA_FGA_AUDIT_TRAIL.TRANSACTIONID%TYPE,
       SCN                       SYS.DBA_FGA_AUDIT_TRAIL.SCN%TYPE,
       SQL_BIND                  SYS.DBA_FGA_AUDIT_TRAIL.SQL_BIND%TYPE,
       SQL_TEXT                  SYS.DBA_FGA_AUDIT_TRAIL.SQL_TEXT%TYPE,
       OBJ_EDITION_NAME          SYS.DBA_FGA_AUDIT_TRAIL.OBJ_EDITION_NAME%TYPE,
       DBID                      SYS.DBA_FGA_AUDIT_TRAIL.DBID%TYPE,
       CURRENT_USER              SYS.DBA_FGA_AUDIT_TRAIL.CURRENT_USER%TYPE);
  TYPE records_atrail_fga IS TABLE OF record_atrail_fga;

  -- 3. V$XML_AUDIT_TRAIL RECORD type
  TYPE record_atrail_xml IS RECORD (
       AUDIT_TYPE                SYS.V$XML_AUDIT_TRAIL.AUDIT_TYPE%TYPE,
       OS_USER                   SYS.V$XML_AUDIT_TRAIL.OS_USER%TYPE,
       DB_USER                   SYS.V$XML_AUDIT_TRAIL.DB_USER%TYPE,
       OS_HOST                   SYS.V$XML_AUDIT_TRAIL.OS_HOST%TYPE,
       TERMINAL                  SYS.V$XML_AUDIT_TRAIL.TERMINAL%TYPE,
       OBJECT_SCHEMA             SYS.V$XML_AUDIT_TRAIL.OBJECT_SCHEMA%TYPE,
       OBJECT_NAME               SYS.V$XML_AUDIT_TRAIL.OBJECT_NAME%TYPE,
       RLS_POLICY_TYPE           VARCHAR2(30),
       RLS_POLICY_NAME           SYS.DBA_POLICIES.POLICY_NAME%TYPE,
       RLS_POLICY_OWNER          SYS.DBA_POLICIES.PF_OWNER%TYPE,
       RLS_PREDICATE             VARCHAR2(32767),  -- max in kzrtpd
       POLICY_NAME               SYS.V$XML_AUDIT_TRAIL.POLICY_NAME%TYPE,
       ACTION                    SYS.V$XML_AUDIT_TRAIL.ACTION%TYPE,
       NEW_OWNER                 SYS.V$XML_AUDIT_TRAIL.NEW_OWNER%TYPE,
       NEW_NAME                  SYS.V$XML_AUDIT_TRAIL.NEW_NAME%TYPE,
       STATEMENT_TYPE            SYS.V$XML_AUDIT_TRAIL.STATEMENT_TYPE%TYPE,
       SES_ACTIONS               SYS.V$XML_AUDIT_TRAIL.SES_ACTIONS%TYPE,
       COMMENT_TEXT              SYS.V$XML_AUDIT_TRAIL.COMMENT_TEXT%TYPE,
       SESSION_ID                SYS.V$XML_AUDIT_TRAIL.SESSION_ID%TYPE,
       ENTRYID                   SYS.V$XML_AUDIT_TRAIL.ENTRYID%TYPE,
       STATEMENTID               SYS.V$XML_AUDIT_TRAIL.STATEMENTID%TYPE,
       RETURNCODE                SYS.V$XML_AUDIT_TRAIL.RETURNCODE%TYPE,
       AUTH_PRIVILEGES           SYS.V$XML_AUDIT_TRAIL.AUTH_PRIVILEGES%TYPE,
       GRANTEE                   SYS.V$XML_AUDIT_TRAIL.GRANTEE%TYPE,
       PRIV_USED                 SYS.V$XML_AUDIT_TRAIL.PRIV_USED%TYPE,
       OS_PRIVILEGE              SYS.V$XML_AUDIT_TRAIL.OS_PRIVILEGE%TYPE,
       CLIENTIDENTIFIER          SYS.V$XML_AUDIT_TRAIL.CLIENTIDENTIFIER%TYPE,
       EXT_NAME                  SYS.V$XML_AUDIT_TRAIL.EXT_NAME%TYPE,
       ECONTEXT_ID               SYS.V$XML_AUDIT_TRAIL.ECONTEXT_ID%TYPE,
       EXTENDED_TIMESTAMP        SYS.V$XML_AUDIT_TRAIL.EXTENDED_TIMESTAMP%TYPE,
       PROXY_SESSIONID           SYS.V$XML_AUDIT_TRAIL.PROXY_SESSIONID%TYPE,
       GLOBAL_UID                SYS.V$XML_AUDIT_TRAIL.GLOBAL_UID%TYPE,
       INSTANCE_NUMBER           SYS.V$XML_AUDIT_TRAIL.INSTANCE_NUMBER%TYPE,
       OS_PROCESS                SYS.V$XML_AUDIT_TRAIL.OS_PROCESS%TYPE,
       TRANSACTIONID             SYS.V$XML_AUDIT_TRAIL.TRANSACTIONID%TYPE,
       SCN                       SYS.V$XML_AUDIT_TRAIL.SCN%TYPE,
       SQL_BIND                  SYS.V$XML_AUDIT_TRAIL.SQL_BIND%TYPE,
       SQL_TEXT                  SYS.V$XML_AUDIT_TRAIL.SQL_TEXT%TYPE,
       OBJ_EDITION_NAME          SYS.V$XML_AUDIT_TRAIL.OBJ_EDITION_NAME%TYPE,
       DBID                      SYS.V$XML_AUDIT_TRAIL.DBID%TYPE,
       CURRENT_USER              SYS.V$XML_AUDIT_TRAIL.CURRENT_USER%TYPE);
  TYPE records_atrail_xml IS TABLE OF record_atrail_xml;

  -- 4. UNIFIED_AUDIT_TRAIL RECORD type
  TYPE record_atrail_uni IS RECORD (
       AUDIT_TYPE                SYS.UNIFIED_AUDIT_TRAIL.AUDIT_TYPE%TYPE,
       SESSIONID                 SYS.UNIFIED_AUDIT_TRAIL.SESSIONID%TYPE,
       PROXY_SESSIONID           SYS.UNIFIED_AUDIT_TRAIL.PROXY_SESSIONID%TYPE,
       OS_USERNAME               SYS.UNIFIED_AUDIT_TRAIL.OS_USERNAME%TYPE,
       USERHOST                  SYS.UNIFIED_AUDIT_TRAIL.USERHOST%TYPE,
       TERMINAL                  SYS.UNIFIED_AUDIT_TRAIL.TERMINAL%TYPE,
       INSTANCE_ID               SYS.UNIFIED_AUDIT_TRAIL.INSTANCE_ID%TYPE,
       DBID                      SYS.UNIFIED_AUDIT_TRAIL.DBID%TYPE,
       AUTHENTICATION_TYPE
                             SYS.UNIFIED_AUDIT_TRAIL.AUTHENTICATION_TYPE%TYPE,
       DBUSERNAME                SYS.UNIFIED_AUDIT_TRAIL.DBUSERNAME%TYPE,
       DBPROXY_USERNAME          SYS.UNIFIED_AUDIT_TRAIL.DBPROXY_USERNAME%TYPE,
       EXTERNAL_USERID           SYS.UNIFIED_AUDIT_TRAIL.EXTERNAL_USERID%TYPE,
       GLOBAL_USERID             SYS.UNIFIED_AUDIT_TRAIL.GLOBAL_USERID%TYPE,
       CLIENT_PROGRAM_NAME   SYS.UNIFIED_AUDIT_TRAIL.CLIENT_PROGRAM_NAME%TYPE,
       DBLINK_INFO               SYS.UNIFIED_AUDIT_TRAIL.DBLINK_INFO%TYPE,
       XS_USER_NAME              SYS.UNIFIED_AUDIT_TRAIL.XS_USER_NAME%TYPE,
       XS_SESSIONID              SYS.UNIFIED_AUDIT_TRAIL.XS_SESSIONID%TYPE,
       ENTRY_ID                  SYS.UNIFIED_AUDIT_TRAIL.ENTRY_ID%TYPE,
       STATEMENT_ID              SYS.UNIFIED_AUDIT_TRAIL.STATEMENT_ID%TYPE,
       EVENT_TIMESTAMP           SYS.UNIFIED_AUDIT_TRAIL.EVENT_TIMESTAMP%TYPE,
       ACTION_NAME               SYS.UNIFIED_AUDIT_TRAIL.ACTION_NAME%TYPE,
       RETURN_CODE               SYS.UNIFIED_AUDIT_TRAIL.RETURN_CODE%TYPE,
       OS_PROCESS                SYS.UNIFIED_AUDIT_TRAIL.OS_PROCESS%TYPE,
       TRANSACTION_ID            SYS.UNIFIED_AUDIT_TRAIL.TRANSACTION_ID%TYPE,
       SCN                       SYS.UNIFIED_AUDIT_TRAIL.SCN%TYPE,
       EXECUTION_ID              SYS.UNIFIED_AUDIT_TRAIL.EXECUTION_ID%TYPE,
       OBJECT_SCHEMA             SYS.UNIFIED_AUDIT_TRAIL.OBJECT_SCHEMA%TYPE,
       OBJECT_NAME               SYS.UNIFIED_AUDIT_TRAIL.OBJECT_NAME%TYPE,
       RLS_POLICY_TYPE           VARCHAR2(30),
       RLS_POLICY_NAME           SYS.DBA_POLICIES.POLICY_NAME%TYPE,
       RLS_POLICY_OWNER          SYS.DBA_POLICIES.PF_OWNER%TYPE,
       RLS_PREDICATE             VARCHAR2(32767),  -- max in kzrtpd
       SQL_TEXT                  SYS.UNIFIED_AUDIT_TRAIL.SQL_TEXT%TYPE,
       SQL_BINDS                 SYS.UNIFIED_AUDIT_TRAIL.SQL_BINDS%TYPE,
       APPLICATION_CONTEXTS
                             SYS.UNIFIED_AUDIT_TRAIL.APPLICATION_CONTEXTS%TYPE,
       CLIENT_IDENTIFIER         
                             SYS.UNIFIED_AUDIT_TRAIL.CLIENT_IDENTIFIER%TYPE,
       NEW_SCHEMA                SYS.UNIFIED_AUDIT_TRAIL.NEW_SCHEMA%TYPE, 
       NEW_NAME                  SYS.UNIFIED_AUDIT_TRAIL.NEW_NAME%TYPE, 
       OBJECT_EDITION            SYS.UNIFIED_AUDIT_TRAIL.OBJECT_EDITION%TYPE,
       SYSTEM_PRIVILEGE_USED     
                            SYS.UNIFIED_AUDIT_TRAIL.SYSTEM_PRIVILEGE_USED%TYPE,
       SYSTEM_PRIVILEGE          SYS.UNIFIED_AUDIT_TRAIL.SYSTEM_PRIVILEGE%TYPE,
       AUDIT_OPTION              SYS.UNIFIED_AUDIT_TRAIL.AUDIT_OPTION%TYPE, 
       OBJECT_PRIVILEGES    SYS.UNIFIED_AUDIT_TRAIL.OBJECT_PRIVILEGES%TYPE, 
       ROLE                      SYS.UNIFIED_AUDIT_TRAIL.ROLE%TYPE,
       TARGET_USER               SYS.UNIFIED_AUDIT_TRAIL.TARGET_USER%TYPE,
       EXCLUDED_USER             SYS.UNIFIED_AUDIT_TRAIL.EXCLUDED_USER%TYPE,
       EXCLUDED_SCHEMA           SYS.UNIFIED_AUDIT_TRAIL.EXCLUDED_SCHEMA%TYPE,
       EXCLUDED_OBJECT           SYS.UNIFIED_AUDIT_TRAIL.EXCLUDED_OBJECT%TYPE,
       CURRENT_USER              SYS.UNIFIED_AUDIT_TRAIL.CURRENT_USER%TYPE,
       ADDITIONAL_INFO           SYS.UNIFIED_AUDIT_TRAIL.ADDITIONAL_INFO%TYPE,
       UNIFIED_AUDIT_POLICIES
                           SYS.UNIFIED_AUDIT_TRAIL.UNIFIED_AUDIT_POLICIES%TYPE,
       FGA_POLICY_NAME           SYS.UNIFIED_AUDIT_TRAIL.FGA_POLICY_NAME%TYPE,
       XS_INACTIVITY_TIMEOUT 
                           SYS.UNIFIED_AUDIT_TRAIL.XS_INACTIVITY_TIMEOUT%TYPE,
       XS_ENTITY_TYPE            SYS.UNIFIED_AUDIT_TRAIL.XS_ENTITY_TYPE%TYPE,
       XS_TARGET_PRINCIPAL_NAME  
                         SYS.UNIFIED_AUDIT_TRAIL.XS_TARGET_PRINCIPAL_NAME%TYPE,
       XS_PROXY_USER_NAME        
                           SYS.UNIFIED_AUDIT_TRAIL.XS_PROXY_USER_NAME%TYPE,
       XS_DATASEC_POLICY_NAME 
                           SYS.UNIFIED_AUDIT_TRAIL.XS_DATASEC_POLICY_NAME%TYPE,
       XS_SCHEMA_NAME            SYS.UNIFIED_AUDIT_TRAIL.XS_SCHEMA_NAME%TYPE,
       XS_CALLBACK_EVENT_TYPE 
                           SYS.UNIFIED_AUDIT_TRAIL.XS_CALLBACK_EVENT_TYPE%TYPE,
       XS_PACKAGE_NAME           SYS.UNIFIED_AUDIT_TRAIL.XS_PACKAGE_NAME%TYPE,
       XS_PROCEDURE_NAME         
                           SYS.UNIFIED_AUDIT_TRAIL.XS_PROCEDURE_NAME%TYPE,
       XS_ENABLED_ROLE           SYS.UNIFIED_AUDIT_TRAIL.XS_ENABLED_ROLE%TYPE,
       XS_COOKIE                 SYS.UNIFIED_AUDIT_TRAIL.XS_COOKIE%TYPE,
       XS_NS_NAME                SYS.UNIFIED_AUDIT_TRAIL.XS_NS_NAME%TYPE,
       XS_NS_ATTRIBUTE           SYS.UNIFIED_AUDIT_TRAIL.XS_NS_ATTRIBUTE%TYPE,
       XS_NS_ATTRIBUTE_OLD_VAL 
                         SYS.UNIFIED_AUDIT_TRAIL.XS_NS_ATTRIBUTE_OLD_VAL%TYPE,
       XS_NS_ATTRIBUTE_NEW_VAL 
                         SYS.UNIFIED_AUDIT_TRAIL.XS_NS_ATTRIBUTE_NEW_VAL%TYPE,
       DV_ACTION_CODE            SYS.UNIFIED_AUDIT_TRAIL.DV_ACTION_CODE%TYPE,
       DV_ACTION_NAME            SYS.UNIFIED_AUDIT_TRAIL.DV_ACTION_NAME%TYPE,
       DV_EXTENDED_ACTION_CODE 
                         SYS.UNIFIED_AUDIT_TRAIL.DV_EXTENDED_ACTION_CODE%TYPE,
       DV_GRANTEE                SYS.UNIFIED_AUDIT_TRAIL.DV_GRANTEE%TYPE,
       DV_RETURN_CODE            SYS.UNIFIED_AUDIT_TRAIL.DV_RETURN_CODE%TYPE,
       DV_ACTION_OBJECT_NAME     
                         SYS.UNIFIED_AUDIT_TRAIL.DV_ACTION_OBJECT_NAME%TYPE,
       DV_RULE_SET_NAME          SYS.UNIFIED_AUDIT_TRAIL.DV_RULE_SET_NAME%TYPE,
       DV_COMMENT                SYS.UNIFIED_AUDIT_TRAIL.DV_COMMENT%TYPE,
       DV_FACTOR_CONTEXT 
                           SYS.UNIFIED_AUDIT_TRAIL.DV_FACTOR_CONTEXT%TYPE,
       DV_OBJECT_STATUS          SYS.UNIFIED_AUDIT_TRAIL.DV_OBJECT_STATUS%TYPE,
       OLS_POLICY_NAME           SYS.UNIFIED_AUDIT_TRAIL.OLS_POLICY_NAME%TYPE,
       OLS_GRANTEE               SYS.UNIFIED_AUDIT_TRAIL.OLS_GRANTEE%TYPE,
       OLS_MAX_READ_LABEL 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_MAX_READ_LABEL%TYPE,
       OLS_MAX_WRITE_LABEL       
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_MAX_WRITE_LABEL%TYPE,
       OLS_MIN_WRITE_LABEL 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_MIN_WRITE_LABEL%TYPE,
       OLS_PRIVILEGES_GRANTED 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_PRIVILEGES_GRANTED%TYPE,
       OLS_PROGRAM_UNIT_NAME 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_PROGRAM_UNIT_NAME%TYPE,
       OLS_PRIVILEGES_USED 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_PRIVILEGES_USED%TYPE,
       OLS_STRING_LABEL 
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_STRING_LABEL%TYPE,
       OLS_LABEL_COMPONENT_TYPE 
                         SYS.UNIFIED_AUDIT_TRAIL.OLS_LABEL_COMPONENT_TYPE%TYPE,
       OLS_LABEL_COMPONENT_NAME 
                         SYS.UNIFIED_AUDIT_TRAIL.OLS_LABEL_COMPONENT_NAME%TYPE,
       OLS_PARENT_GROUP_NAME     
                           SYS.UNIFIED_AUDIT_TRAIL.OLS_PARENT_GROUP_NAME%TYPE,
       OLS_OLD_VALUE             SYS.UNIFIED_AUDIT_TRAIL.OLS_OLD_VALUE%TYPE,
       OLS_NEW_VALUE             SYS.UNIFIED_AUDIT_TRAIL.OLS_NEW_VALUE%TYPE,
       RMAN_SESSION_RECID        
                           SYS.UNIFIED_AUDIT_TRAIL.RMAN_SESSION_RECID%TYPE,
       RMAN_SESSION_STAMP 
                           SYS.UNIFIED_AUDIT_TRAIL.RMAN_SESSION_STAMP%TYPE,
       RMAN_OPERATION            SYS.UNIFIED_AUDIT_TRAIL.RMAN_OPERATION%TYPE,
       RMAN_OBJECT_TYPE          SYS.UNIFIED_AUDIT_TRAIL.RMAN_OBJECT_TYPE%TYPE,
       RMAN_DEVICE_TYPE          SYS.UNIFIED_AUDIT_TRAIL.RMAN_DEVICE_TYPE%TYPE,
       DP_TEXT_PARAMETERS1 
                           SYS.UNIFIED_AUDIT_TRAIL.DP_TEXT_PARAMETERS1%TYPE, 
       DP_BOOLEAN_PARAMETERS1 
                           SYS.UNIFIED_AUDIT_TRAIL.DP_BOOLEAN_PARAMETERS1%TYPE,
       DIRECT_PATH_NUM_COLUMNS_LOADED
                   SYS.UNIFIED_AUDIT_TRAIL.DIRECT_PATH_NUM_COLUMNS_LOADED%TYPE
       );
  TYPE records_atrail_uni IS TABLE OF record_atrail_uni;

  ----------------------------------------------------------------------------
  -- decode_rls_info_atrail_std - Decodes RLS_INFO column of DBA_AUDIT_TRAIL
  --
  -- INPUT PARAMETERS
  --   in_cursor      - Cursor referring to the query of DBA_AUDIT_TRAIL
  --
  -- RETURNS (PIPELINED)
  --   A piped row with decoded values of DBA_AUDIT_TRAIL.RLS_INFO column
  --

  FUNCTION decode_rls_info_atrail_std(in_cursor cursor_atrail_std) 
  RETURN records_atrail_std PIPELINED;

  ----------------------------------------------------------------------------
  -- decode_rls_info_atrail_fga - Decodes RLS_INFO column of 
  --                              DBA_FGA_AUDIT_TRAIL
  --
  -- INPUT PARAMETERS
  --   in_cursor      - Cursor referring to the query of DBA_FGA_AUDIT_TRAIL
  --
  -- RETURNS (PIPELINED)
  --   A piped row with decoded values of DBA_FGA_AUDIT_TRAIL.RLS_INFO column
  --

  FUNCTION decode_rls_info_atrail_fga(in_cursor cursor_atrail_fga)
  RETURN records_atrail_fga PIPELINED;

  ----------------------------------------------------------------------------
  -- decode_rls_info_atrail_xml - Decodes RLS_INFO column of V$XML_AUDIT_TRAIL
  --
  -- INPUT PARAMETERS
  --   in_cursor      - Cursor referring to the query of V$XML_AUDIT_TRAIL
  --
  -- RETURNS (PIPELINED)
  --   A piped row with decoded values of V$XML_AUDIT_TRAIL.RLS_INFO column
  --

  FUNCTION decode_rls_info_atrail_xml(in_cursor cursor_atrail_xml)
  RETURN records_atrail_xml PIPELINED;

  ----------------------------------------------------------------------------
  -- decode_rls_info_atrail_uni - Decodes RLS_INFO column of 
  --                              UNIFIED_AUDIT_TRAIL
  --
  -- INPUT PARAMETERS
  --   in_cursor      - Cursor referring to the query of UNIFIED_AUDIT_TRAIL
  --
  -- RETURNS (PIPELINED)
  --   A piped row with decoded values of UNIFIED_AUDIT_TRAIL.RLS_INFO column
  --

  FUNCTION decode_rls_info_atrail_uni(in_cursor cursor_atrail_uni)
  RETURN records_atrail_uni PIPELINED;

END dbms_audit_util;
/

CREATE OR REPLACE PUBLIC SYNONYM dbms_audit_util FOR sys.dbms_audit_util
/

GRANT EXECUTE ON sys.dbms_audit_util TO AUDIT_ADMIN
/
GRANT EXECUTE ON dbms_audit_util TO AUDIT_ADMIN
/
GRANT EXECUTE ON sys.dbms_audit_util TO AUDIT_VIEWER
/
GRANT EXECUTE ON dbms_audit_util TO AUDIT_VIEWER
/

------------------------------------------------------------------------------

@?/rdbms/admin/sqlsessend.sql
