Rem
Rem $Header: rdbms/admin/cmpupxdk.sql /main/2 2013/07/09 15:04:34 jerrede Exp $
Rem
Rem cmpupxdk.sql
Rem
Rem Copyright (c) 2006, 2013, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      cmpupxdk.sql - CoMPonent UPgrade xdk components
Rem
Rem    DESCRIPTION
Rem      Upgrade Spatial
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jerrede     06/17/13 - Fix Error Logging
Rem    jerrede     04/13/13 - parallel upgrade 
Rem    jerrede     04/13/13 - Created
Rem

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;

Rem check instance version and status; set session attributes
EXECUTE dbms_registry.check_server_instance;

Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script 
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;

Rem Setup component script filename variables
COLUMN dbmig_name NEW_VALUE dbmig_file NOPRINT;
VARIABLE dbinst_name VARCHAR2(256)
COLUMN :dbinst_name NEW_VALUE dbinst_file NOPRINT

set serveroutput off

Rem =====================================================================
Rem Upgrade Java XDK
Rem =====================================================================

Rem Set identifier to XML for errorlogging
SET ERRORLOGGING ON TABLE SYS.REGISTRY$ERROR IDENTIFIER 'XML';

SELECT dbms_registry_sys.time_stamp_display('XML') AS timestamp FROM DUAL;
SELECT dbms_registry_sys.dbupg_script('XML') AS dbmig_name FROM DUAL;

@&dbmig_file

Rem If Intermedia upgrade, first install XML if it is not loaded
BEGIN
   IF dbms_registry.is_loaded('XML') IS NULL AND
      (dbms_registry.is_loaded('ORDIM') IS NOT NULL OR
       dbms_registry.is_loaded('SDO') IS NOT NULL) THEN
     :dbinst_name := dbms_registry_server.XML_path || 'initxml.sql';
     INSERT INTO sys.registry$log -- indicate start time
                (cid, namespace, operation, optime) 
            VALUES ('XML', SYS_CONTEXT('REGISTRY$CTX','NAMESPACE'), 
                       -1, SYSTIMESTAMP);
     COMMIT;  
  ELSE
     :dbinst_name := dbms_registry.nothing_script;
  END IF;
END;
/

SELECT :dbinst_name FROM DUAL;
@&dbinst_file

SELECT dbms_registry_sys.time_stamp('XML') AS timestamp FROM DUAL;
