Rem
Rem $Header: rdbms/admin/catfcp.sql /st_rdbms_12.2.0.1.0/1 2016/08/09 22:28:46 shvmalik Exp $
Rem
Rem catfcp.sql
Rem
Rem Copyright (c) 2000, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      catfcp.sql - catproc FCP table creation file
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catfcp.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catfcp.sql
Rem SQL_PHASE: CATFCP
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catptabs.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shvmalik    06/30/16 - FCP tables
Rem    shvmalik    06/30/16 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

-------------------------------------------------------------------------------
--Abbreviations:
--FCP  --> Fix-Control Persistence
--FCPT --> Fix Control Persistence Table
--
--create Fix Control Persistence Table (FCPT) and populate it.
--columns information:
--   fix_control:       bug's fix_control , maps to bugno from 
--                      sys.gv$system_fix_control
--   effective_value:   fix_control's current value at the time of insertion 
--                      to FCPT. Currently it is not being used anywhere in 
--                      restore logic. 
--   default_value:     fix_control's default value as per base/default OFE
--   ofe:               ofe to which this fix_control was tied to during 
--                      installation of FCP framework. Once inserted to FCPT 
--                      during installation, it is never changed. Details 
--                      given later in this section.
--   initfile_flag:     flag to indicate if fix_control has been set by user 
--                      explicitly in init.ora or spfile. Details given later
--                      in this section.
--   modify_at_startup: flag to indicate this fix_control needs to be restored
--                      during each startup
--   other_data:        column for maintaining any other extra information for
--                      future purpose
--
--Details on initfile_flag:
--initfile_flag has bitwise values
--  last bit is used as fix_control bit
--  second-last bit is used as ofe bit
--Based on above, all possible values of initfile_flags are:
--0: flag is not set
--1: only fix_control bit is set
--2: only ofe bit is set
--3: both bits are set
--
--For fixes having initfile_flag !=0, we will not trigger alter system 
--command to restore the fixes in memory.
--
--Significance of both the bits:
--1) fix_control bit:
--    If a fix_control is specified in init.ora or spfile, then this bit 
--    will be set.
--2) ofe bit:
--   If user has set any different optimizer_features_enable value, then bugs
--   which got disabled due to this new setting will have this bit set.
--   As an example, say default ofe=11204, current ofe setting=11203 and
--   say 13329748 is a bug tied to ofe=11204, then with ofe=11203, it will
--   be disabled, then this fix_control will have this ofebit set in 
--   initfile_flag.
--   This has been done to avoid triggering un-necessary 'alter system' command
--   to enable/restore such fix_control in current environment where these 
--   should be disabled by current ofe setting itself.
--
--   Say as an example 13329748 bug was applied as on-off patch with default 
--   enabled. And then BP was applied having this fix disabled. It will 
--   trigger setting modify_at_startup as TRUE. But during next startup,
--   customer has changed setting to ofe=11203, now in absence of this ofebit 
--   logic, fix control persistence framework will trigger alter system to 
--   enable this bug in memory. But due to ofe setting to 11203, customer will
--   expect this fix to be disabled, but this framework will enable it. To 
--   avoid this, ofebit is introduced. If this bit is set, alter system will 
--   not be triggered. Once customer resets ofe setting to default ofe or any 
--   other ofe, this bit will be cleared if eligible for clearing, and FCP 
--   framework will start triggering alter system to enable this bug in 
--   current memory scope.
--
--
--Details on ofe column
--  This will give optimizer_features_enable to which this fix_control was
--  tied to during FCPT creation. Once we install BP which has this fix_control
--  disabled by default, we will get ofe as QKSCEV_NONE(NULL) always. Hence we
--  maintain this to get the original ofe to which it was tied to before BP 
--  installation from the point this framework is installed. It is used in
--  setting/resetting ofe bit initFile_flag.
-------------------------------------------------------------------------------------

--
-- FCP table
--
create table sys.ora_bundle_fixcontrol_state$
                      (
                         fix_control       NUMBER,
                         effective_value   NUMBER,
                         default_value     NUMBER,
                         ofe               VARCHAR2(25),
                         initfile_flag     NUMBER,
                         modify_at_startup NUMBER,
                         other_data CLOB,
                         CONSTRAINT unique_fix_control UNIQUE (fix_control)
                       ) tablespace SYSAUX;

--
-- FCP param table
--
create table sys.ora_fcp_params$
                      (
                         parameter         VARCHAR2(80),
                         value             CLOB,
                         CONSTRAINT unique_parameter UNIQUE (parameter)
                       ) tablespace SYSAUX;

insert /*+ ignore_row_on_dupkey_index(ora_fcp_params$, unique_parameter) */
       into sys.ora_fcp_params$ values('pending_patch_activity', 'false');

@@?/rdbms/admin/sqlsessend.sql

