#!/usr/local/bin/perl
#
# catconst.pm
#
# Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      catconst.pm - Declare Build Constants.
#
#    DESCRIPTION
#      catconst.pm is created from catcommon.pl.
#      catconst.pm declares constants shared by datapatch
#      and upgrade.
#
#    NOTES
#      Currently used for Version Information
#
#    MODIFIED   (MM/DD/YY)
#    surman      12/14/15 - 19219946: Add CATCONST_CURRENT_YEAR
#    jerrede     06/25/15 - Generate User Tablespaces SQL
#    jerrede     08/21/14 - Added CATCONST_MAXPDBS
#    jerrede     08/21/14 - Create catconst.pm
#    jerrede     08/21/14 - Creation
#

package catconst;

use strict;
use warnings;
require Exporter;

#
# Export the Constants
#
our @ISA = qw( Exporter );
our @EXPORT = qw( CATCONST_BUILD_VERSION
                  CATCONST_BUILD_STATUS
                  CATCONST_BUILD_LABEL
                  CATCONST_MAXPDBS
                  CATCONST_CURRENT_YEAR );

#
# Database Release Version
#
use constant CATCONST_BUILD_VERSION => '12.2.0.1.0';
#
# Database Release or Beta Status
#
use constant CATCONST_BUILD_STATUS  => 'production';
#
# Database Build Label
#
use constant CATCONST_BUILD_LABEL   => 'RDBMS_12.2.0.1.0_NT_170210';
#
# Max Number of PDBs
#
use constant CATCONST_MAXPDBS       => 4098;
#
# Current year as defined by the Makefile
#
use constant CATCONST_CURRENT_YEAR  => 2017;

1;
