# 
# $Header: has/install/crsconfig/s_oraolr.pm /nt/2 2015/04/22 10:07:10 xyuan Exp $
#
# s_oraolr.pm
# 
# Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      s_oraolr.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sbezawad    01/20/15 - Bug 20019354: Migrate OCR and OLR to new framework
#    sbezawad    01/20/15 - Creation
# 

package oraClusterwareComp::oraolr;

use parent 'oraClusterwareComp';

use strict;
use Win32;
use Win32::NetAdmin qw(DOMAIN_ALIAS_RID_ADMINS GetAliasFromRID
                       LocalGroupIsMember GroupIsMember);
use Win32::TieRegistry (Delimiter => '/');
use Win32::Service;
use Win32API::File  qw(DeleteFile);
use File::Spec::Functions;
use File::Path;
use File::Temp qw/ tempfile /;
use Cwd;

use crsutils;
use s_crsutils;

#
# Private methods
#

sub s_validate_olrconfig
#------------------------------------------------------------------------------
# Function: Creates local olr config file if it does not exists.
#           It also validates/sets up OLR config if does not exist
# Args    : [0] Complete path of OLR location
#           [1] CRS Home
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $olrlocation = shift;
  my $crshome     = shift;
  my $OLRLOC      = $CFG->params('OLRLOC');

  trace ("Validating OLR registry keys for OLR location " . $olrlocation);

  ## @todo Check existing OLR_LOC. If it exists, then check value of
  #olrconfig_loc property. If it's same as the one passed on the call then go
  #ahead. Else, throw an error msg and quit the installation.
  my $idx = rindex ($OLRLOC, '/') + 1;
  my $parentkey = substr ($OLRLOC, 0, $idx);
  my $key = substr ($OLRLOC, $idx);
  trace ("OLRLOC=$OLRLOC parentkey=$parentkey key=$key");
  $Registry->{"LMachine/$parentkey"} = {
      "$key/" => {
      "/olrconfig_loc" => "$olrlocation",
      "/crs_home" => "$crshome",
      },
  };

  return SUCCESS;
}

sub s_ResetOLR
#------------------------------------------------------------------------------
# Function: Reset OLR
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $olrdisk = s_get_config_key("olr", "olrconfig_loc");
  trace("Removing OLR disk: $olrdisk");

  s_remove_file($olrdisk);

  # remove olr registry key
  my $OLRLOC = $CFG->params('OLRLOC');
  my $value  = delete $Registry->{"LMachine/$OLRLOC/"};
}


sub s_createOldOLR
#------------------------------------------------------------------------------
# Function: Create the olr.loc file pointing to the old home during downgrade
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $crshome     = $CFG->oldcrshome;
  my $host        = tolower_host();
  $host           = $host . ".olr";
  my $olrlocation = catfile($crshome, "cdata", $host);

  # example of $CFG->params('OLRLOC'):
  # OLRLOC=Software/Oracle/olr
  my $OLRLOC = $CFG->params('OLRLOC');

  trace ("Creating OLR registry keys for OLR location " . $olrlocation .
         "CRS HOME ". $crshome);

  my $idx = rindex ($OLRLOC, '/') + 1;
  my $parentkey = substr ($OLRLOC, 0, $idx);
  my $key = substr ($OLRLOC, $idx);
  trace ("OLRLOC=$OLRLOC parentkey=$parentkey key=$key");
  $Registry->{"LMachine/$parentkey"} = {
      "$key/" => {
      "/olrconfig_loc" => "$olrlocation",
      "/crs_home" => "$crshome",
      },
  };

  return TRUE;
}

1;
