/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchutil.OPatchFmwPointer;
import oracle.opatch.opatchutil.OUSession;

public class checkComponents {
    public static void checkComponents(String srcHome, String[] patchLocations) throws RuntimeException {
        int i2;
        boolean isAll = true;
        String mwHome = "";
        String[] oracleHomes = OPatchFmwPointer.getValidOracleHomesFromMwHome(srcHome, isAll, mwHome);
        StringBuffer buff = new StringBuffer("oracle.opatch.opatchutil::checkComponents()");
        OLogger.debug(buff);
        PatchObject[] po = null;
        po = new PatchObject[patchLocations.length];
        ArrayList<String> patches = new ArrayList<String>();
        for (int i3 = 0; i3 < po.length; ++i3) {
            try {
                po[i3] = new PatchObject(patchLocations[i3]);
                patches.add(po[i3].getPatchID());
                continue;
            }
            catch (Exception e2) {
                RuntimeException t = new RuntimeException(e2.getMessage());
                t.setStackTrace(e2.getStackTrace());
                throw t;
            }
        }
        buff = new StringBuffer();
        ArrayList<String> passedHomes = new ArrayList<String>();
        ArrayList<String> failedHomes = new ArrayList<String>();
        try {
            OPatchACL.releaseLock(new checkComponents());
        }
        catch (Throwable t) {
            RuntimeException e3 = new RuntimeException(t.getMessage());
            e3.setStackTrace(t.getStackTrace());
            throw e3;
        }
        for (i2 = 0; i2 < oracleHomes.length; ++i2) {
            String homePath = oracleHomes[i2];
            StringBuffer debugBuff = new StringBuffer("Testing applicability of Patch(es) \"" + patches.toString() + "\" on Oracle Home \"" + homePath + "\"...");
            OLogger.debug(debugBuff);
            PrereqResult applicableRes = PrereqAPI.checkComponents(homePath, po);
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff.append("\n\"checkComponents\" failed for Oracle Home \"" + homePath + "\" and the given patch(es) input.");
                buff.append(applicableRes.toString());
                failedHomes.add(homePath);
            } else {
                buff.append("\n\"checkComponents\" passed for Oracle Home \"" + homePath + "\" and the given patch(es) input.");
                buff.append(applicableRes.toString());
                passedHomes.add(homePath);
            }
            try {
                OPatchACL.releaseLock(new checkComponents());
                continue;
            }
            catch (Throwable t) {
                RuntimeException e4 = new RuntimeException(t.getMessage());
                e4.setStackTrace(t.getStackTrace());
                throw e4;
            }
        }
        if (passedHomes.size() == 0) {
            throw new RuntimeException("None of the Oracle Homes registered in central inventory are applicable for the input patch(es).");
        }
        OLogger.printlnOnLog(buff.toString());
        buff = new StringBuffer();
        if (passedHomes.size() > 0) {
            buff.append("\n\nThe input patch(es) \"" + patches.toString() + "\" can be applied to the following homes (" + passedHomes.size() + "):");
            for (i2 = 0; i2 < passedHomes.size(); ++i2) {
                buff.append("\n" + passedHomes.get(i2));
            }
        }
        StringBuffer logBuffer = new StringBuffer("");
        if (failedHomes.size() > 0) {
            logBuffer.append("\n\nThe input patch(es) cannot be applied to any of following homes.");
            for (int i4 = 0; i4 < failedHomes.size(); ++i4) {
                logBuffer.append("\n" + failedHomes.get(i4));
            }
        }
        OLogger.log(OLogger.FINE, logBuffer.toString());
        if (passedHomes.size() > 0) {
            buff.append("\n\nThe input patch(es) \"" + patches.toString() + "\" can be applied to the passed homes by the following command(s):");
            for (int i5 = 0; i5 < passedHomes.size(); ++i5) {
                String home = (String)passedHomes.get(i5);
                String phBaseDir = OUSession.getPatchBaseDir();
                String phBaseFile = OUSession.getPatchBaseFile();
                String ph = "";
                if (patchLocations.length == 1) {
                    ph = patchLocations[0];
                }
                String addStr = "";
                if (phBaseDir != null && !phBaseDir.equals("")) {
                    addStr = phBaseDir;
                } else if (phBaseFile != null && !phBaseFile.equals("")) {
                    addStr = "-phbasefile " + phBaseFile;
                } else if (ph != null && !ph.equals("")) {
                    addStr = ph;
                }
                buff.append("\n" + srcHome + File.separator + "OPatch" + File.separator + "opatch napply " + addStr + " " + "-oh " + home);
                if (OPatchEnv.isWindows()) continue;
                buff.append(" -invptrLoc " + home + File.separator + "oraInst.loc");
            }
        }
        OLogger.println(buff.toString());
    }
}

