/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class DeploySOAResourceBundle
implements Operation {
    DeploySOAResourceBundle() {
    }

    public void run(FMWContext c2) {
        SOACompositeManager scm = c2.getDomain().getSOACompositeManager();
        SOAComposite sc = c2.getSOAComposite();
        String path = sc.getPath();
        String errorMsg = "";
        boolean report = OPatchEnv.isReport();
        if (!Util.existFile(path)) {
            errorMsg = "Resource Bundle [" + path + "] does not exist";
            RuntimeException re = new RuntimeException(errorMsg);
            OPatchStepAdapter checkPath = new OPatchStepAdapter(OPatchFAStep.CHECK_PATH_EXISTS);
            checkPath.setStepDescription("Check if the path of the Resource Bundle exists");
            checkPath.setSuccess(false);
            checkPath.setErrorMessage(errorMsg);
            c2.getContextBuilder().addExecutionStep(checkPath);
            Logger.loge(errorMsg);
            Logger.loge(re);
            throw re;
        }
        if (report) {
            OPatchSOAStep connectPromptStep = new OPatchSOAStep(OPatchFAStep.SOA_WLST_SERVER_CONNECT);
            connectPromptStep.setStepDescription("[Connects WLST to a WebLogic Server instance as online model, this step is need by following WLST commands but not done here]");
            connectPromptStep.setSuccess(true);
            c2.getContextBuilder().addExecutionStep(connectPromptStep);
        }
        Logger.logi("[SOA RESOURCE BUNDLE] Deploying Resource Bundle [" + path + "]");
        OPatchSOAStep deployRbStep = new OPatchSOAStep(OPatchFAStep.SOA_RB_DEPLOY);
        deployRbStep.setStepDescription("Deploy Resource Bundle");
        deployRbStep.setSarFile(path);
        try {
            if (!report) {
                scm.deployComposite(path, null);
            } else {
                deployRbStep.setStepDescription("Skip Deploy Resource Bundle");
            }
            deployRbStep.setSuccess(true);
            c2.getContextBuilder().addExecutionStep(deployRbStep);
        }
        catch (Throwable t) {
            errorMsg = "Error in deploying SOA Resource Bundle.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            RuntimeException re = new RuntimeException(t);
            deployRbStep.setSuccess(false);
            deployRbStep.setErrorMessage(errorMsg);
            deployRbStep.setExceptionObject(re);
            Logger.loge(errorMsg);
            Logger.loge(re);
            throw re;
        }
    }
}

