/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OneOffEntry;
import oracle.opatch.napplyhelper.NApplyData;

public class BuildComposite {
    private NApplyData data;
    private OneOffEntry[] patchesToApply;

    public BuildComposite(NApplyData data) {
        this.data = data;
    }

    public void build(NApplyData data) {
        this.checkComposite(data);
        this.buildCompositeArray(data);
    }

    public void checkComposite(NApplyData data) {
        this.patchesToApply = data.getPatchesToApply();
        ArrayList startIndexComposite = new ArrayList();
        ArrayList endIndexComposite = new ArrayList();
        ArrayList compositeIndices = CompositePatchObject.determineCompositeIndices(this.patchesToApply);
        if (compositeIndices.size() < 1) {
            data.setIsComposite(false);
        }
        for (int i2 = 0; i2 < compositeIndices.size(); ++i2) {
            if (i2 % 2 == 0) {
                startIndexComposite.add(compositeIndices.get(i2));
            } else {
                endIndexComposite.add(compositeIndices.get(i2));
            }
            if (startIndexComposite.size() == 1 && endIndexComposite.size() == 1) {
                data.setIsComposite(true);
                data.setCompositeStartIndex((Integer)startIndexComposite.get(0));
                data.setCompositeEndIndex((Integer)endIndexComposite.get(0));
                data.setActivePatch(this.patchesToApply[data.getCompositeEndIndex()].getID());
                continue;
            }
            if (startIndexComposite.size() <= 1 && endIndexComposite.size() <= 1) continue;
            String errorMsg = "We do not allow more than 1 composite applied at a time.";
            throw new RuntimeException(errorMsg);
        }
    }

    public void buildCompositeArray(NApplyData data) {
        OneOffEntry[] compositeSubArray = null;
        int compositeSize = 0;
        if (data.isComposite()) {
            int compositeStartIndex = data.getCompositeStartIndex();
            int compositeEndIndex = data.getCompositeEndIndex();
            data.setCompositeSize(compositeEndIndex - compositeStartIndex + 1);
            compositeSize = data.getCompositeSize();
            compositeSubArray = new OneOffEntry[compositeSize];
            for (int i2 = compositeStartIndex; i2 <= compositeEndIndex; ++i2) {
                compositeSubArray[i2 - compositeStartIndex] = this.patchesToApply[i2];
            }
            CompositePatchObject.checkUIDs(compositeSubArray);
            data.setCompositeSubArray(compositeSubArray);
        } else {
            data.setCompositeSubArray(null);
        }
    }
}

