/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.FileMap;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentHigherVersionFound;
import oracle.opatch.PatchComponentMissing;
import oracle.opatch.PatchComponentMissingLang;
import oracle.opatch.PatchComponentMissingProductDirectories;
import oracle.opatch.PatchComponentMissingSymbol;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.ipm.CookedInventory;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.OHILock;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

class IPMReadServices
implements IIPMReadServices {
    private static IPMReadServices instance = null;
    protected static OHILock lock = null;
    protected static RawInventory rawInventory = null;
    protected static CookedInventory cookedInventory = null;

    protected IPMReadServices() {
    }

    protected static synchronized IPMReadServices getInstance() {
        if (instance == null) {
            instance = new IPMReadServices();
        }
        return instance;
    }

    public void lock(String oracleHomePath) throws RuntimeException {
        if (lock != null) {
            OLogger.debug(new StringBuffer("IPMReadServices::init() IIPMReadServices has been already initialized"));
        } else {
            try {
                lock = OHILock.lock(oracleHomePath, true);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Unable to acquire OHI Read Lock: "));
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    public void release() {
        if (lock != null) {
            lock.release();
            lock = null;
        }
    }

    public void destroy() {
        this.release();
        if (cookedInventory != null) {
            cookedInventory.clearInventory();
            cookedInventory = null;
        }
        if (rawInventory != null) {
            rawInventory.clearInventory();
            rawInventory = null;
        }
        instance = null;
    }

    private boolean isLockedAsRO() {
        return lock != null && !lock.isWriterLock();
    }

    public boolean isLocked() {
        return lock != null;
    }

    protected CookedInventory getCookedInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::getCookedInventory()");
        OLogger.debug(buff);
        if (cookedInventory == null) {
            try {
                if (rawInventory == null) {
                    if (this.isLocked()) {
                        rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                    } else {
                        throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
                    }
                }
                cookedInventory = CookedInventory.getInstance(rawInventory);
            }
            catch (Throwable t) {
                buff = new StringBuffer("IPMReadServices::getCookedInventory() gets an error: ");
                buff.append(t.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        return cookedInventory;
    }

    protected RawInventory getRawInventory() {
        StringBuffer buff = new StringBuffer("IPMReadServices::getRawInventory()");
        OLogger.debug(buff);
        if (rawInventory == null) {
            if (this.isLocked()) {
                try {
                    rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                }
                catch (Throwable t) {
                    buff = new StringBuffer("IPMReadServices::getRawInventory() gets an error: ");
                    buff.append(t.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            } else {
                throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
            }
        }
        return rawInventory;
    }

    public void reloadInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::clear()");
        OLogger.debug(buff);
        rawInventory = this.getRawInventory().reload();
        cookedInventory = this.getCookedInventory().reload(rawInventory);
    }

    public boolean isInInventory(OneOffEntry entry) {
        return false;
    }

    public void haveComponents(UpdateComponent[] componentsToCheck) throws RuntimeException {
    }

    public PatchComponent[] haveComponents(PatchComponent[] componentsToCheck) throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::haveComponents()");
        OLogger.debug(buff);
        if (componentsToCheck == null) {
            buff.append(" gets a null parameter componentsToCheck");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (componentsToCheck.length == 0) {
            buff.append(" gets an empty list.  Nothing to do, return empty list back.");
            OLogger.debug(buff);
            return componentsToCheck;
        }
        OracleHomeInventory gdrInv = null;
        int size = componentsToCheck.length;
        PatchComponent[] presentComponents = new PatchComponent[size];
        buff = new StringBuffer("  there are ");
        buff.append(size);
        buff.append(" components to check.");
        OLogger.debug(buff);
        for (int i2 = 0; i2 < size; ++i2) {
            PatchComponentMissing missingPC;
            PatchComponent pc = componentsToCheck[i2];
            if (pc == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() gets a null entry inside array componentsToCheck");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            buff = new StringBuffer("  Patch Component (component to check) is \"");
            buff.append(compName);
            buff.append("\", \"");
            buff.append(searchVersion);
            buff.append("\", required = \"");
            buff.append(required);
            buff.append("\"");
            OLogger.debug(buff);
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oracleHomeIndex);
            if (compEntries == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() : ");
                buff.append("the home has no inventory");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            if (compEntries.size() == 0) {
                missingPC = new PatchComponentMissing(compName, searchVersion, required);
                presentComponents[i2] = missingPC;
                continue;
            }
            buff = new StringBuffer("IPMReadServices::haveComponents() : ");
            buff.append("getRawInventory().getCompInvEntries() on \"");
            buff.append(compName);
            buff.append("\", homeIndex = \"");
            buff.append(oracleHomeIndex);
            buff.append("\" returns ");
            buff.append(compEntries.size());
            buff.append(" components.");
            OLogger.debug(buff);
            for (int j2 = 0; j2 < compEntries.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiVersion orgVersion = null;
                OiiiCompInstallID id = null;
                OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)compEntries.elementAt(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        orgVersion = id.getVersion();
                        buff = new StringBuffer("    \nProcess installed component \"");
                        buff.append(id.getName());
                        buff.append("\", version \"");
                        if (IPMReadServices.checkIfMiniPatchsetFunctional()) {
                            if (cie.getPatchInvEntry() != null) {
                                comVersion = id.getVersion();
                                buff.append(comVersion);
                            } else {
                                comVersion = cie.getHighestCompVersion();
                                id.setVersion(comVersion);
                                buff.append(comVersion);
                            }
                        } else {
                            comVersion = id.getVersion();
                            buff.append(comVersion.getVerString());
                        }
                        buff.append("\"");
                        OLogger.debug(buff);
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            buff = new StringBuffer("    Check installed product: ");
                            buff.append("name=\"");
                            buff.append(id.getName());
                            buff.append("\", ver=\"");
                            buff.append(comVersion);
                            buff.append("\"");
                            OLogger.debug(buff);
                            buff = new StringBuffer("    Installed Comp >< Patch Comp: \n");
                            buff.append("      Installed Comp Version later than Patch Comp = ");
                            buff.append(comVersion.laterThan(refCid.getVersion()));
                            buff.append("\n");
                            buff.append("      Installed Comp can replace Patch Comp = ");
                            buff.append(id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()));
                            OLogger.debug(buff);
                            boolean installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            buff = new StringBuffer("      Install Comp Version equals ");
                            buff.append("or is later than Patch Comp: ");
                            buff.append(installedIDEqualOrLater);
                            OLogger.debug(buff);
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || cie.getVersion().laterThan(oVersion))) {
                                buff = new StringBuffer("    Found a laterThan ");
                                buff.append("(or the same) of \"");
                                buff.append(searchVersion);
                                buff.append("\" as \"");
                                buff.append(cie.getVersion());
                                buff.append("\".  Save this version \"");
                                oVersion = comVersion;
                                buff.append(oVersion);
                                buff.append("\"");
                                OLogger.debug(buff);
                            }
                        } else {
                            buff = new StringBuffer("   It's not of type OiiiCompType.COMPONENT or OiiiCompType.COMPONENT, skip.");
                            OLogger.debug(buff);
                        }
                    } else {
                        buff = new StringBuffer("IPMReadServices::haveComponents() ");
                        buff.append("got a null OiiiCompInstallID from InstalledComponent entry.");
                        OLogger.debug(buff);
                    }
                } else {
                    buff = new StringBuffer("IPMReadServices::haveComponents() ");
                    buff.append("got a null OiiiCompInvEntry cie entry.");
                    OLogger.debug(buff);
                }
                id.setVersion(orgVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    boolean isSnowBall;
                    buff = new StringBuffer("inventoryHasThisComponent(): component/version found");
                    buff.append("\nBut, let's check if it is language compatible");
                    OLogger.debug(buff);
                    Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
                    boolean bl = isSnowBall = PatchingModel.returnModelCode(this.getRawInventory().getOracleHomePath()) == 2;
                    if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                        if (oLang.containsAll(patchLangs)) {
                            presentComponents[i2] = pc;
                            continue;
                        }
                        PatchComponentMissingLang missingLangPC = new PatchComponentMissingLang(compName, foundVersion, required, pc.getLanguage(), oLang);
                        presentComponents[i2] = missingLangPC;
                        continue;
                    }
                    if (pc.hasSymbol()) {
                        try {
                            gdrInv = NGOUIInventoryFactory.getOracleHomeInventory(this.getRawInventory().getOracleHomePath());
                        }
                        catch (Exception e2) {
                            buff = new StringBuffer("IPMReadServices::haveComponents() can't get the GDR inventory.");
                            OLogger.debug(buff);
                            throw new RuntimeException(buff.toString(), e2);
                        }
                        Component ngComp = null;
                        try {
                            ngComp = gdrInv.getInstalledComponent(compName, searchVersion);
                        }
                        catch (Exception e3) {
                            buff = new StringBuffer("IPMReadServices::haveComponents() failed to get installed component from GDR inventory.");
                            OLogger.debug(buff);
                            throw new RuntimeException(buff.toString(), e3);
                        }
                        if (ngComp == null) {
                            buff = new StringBuffer("IPMReadServices::haveComponents() gets a null installed component envtry from GDR inventory.");
                            OLogger.debug(buff);
                            throw new RuntimeException(buff.toString());
                        }
                        List fileMap = new ArrayList();
                        try {
                            fileMap = ngComp.getFileMaps();
                        }
                        catch (Exception e4) {
                            buff = new StringBuffer("IPMReadServices::haveComponents() failed to get filemaps for installed component.");
                            OLogger.debug(buff);
                            throw new RuntimeException(buff.toString(), e4);
                        }
                        boolean symbolExists = false;
                        for (int j3 = 0; j3 < fileMap.size(); ++j3) {
                            FileMap fm = (FileMap)fileMap.get(j3);
                            if (!fm.getSymbol().equals(pc.getSymbolName())) continue;
                            symbolExists = true;
                            break;
                        }
                        if (!symbolExists) {
                            PatchComponentMissingSymbol missingSymbol = new PatchComponentMissingSymbol(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingSymbol;
                            continue;
                        }
                        if (pc.getProductDirectories(this.getRawInventory().getOracleHomePath()) == null || pc.getProductDirectories(this.getRawInventory().getOracleHomePath()).length == 0) {
                            PatchComponentMissingProductDirectories missingPD = new PatchComponentMissingProductDirectories(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingPD;
                            continue;
                        }
                    }
                    presentComponents[i2] = pc;
                    continue;
                }
                buff = new StringBuffer("inventoryHasThisComponent() found the component with higher version: ");
                buff.append("searchVersion = \"");
                buff.append(searchVersion);
                buff.append("\", foundVersion = \"");
                buff.append(foundVersion);
                buff.append("\" --> declare not found then.");
                PatchComponentHigherVersionFound higherPC = new PatchComponentHigherVersionFound(compName, searchVersion, foundVersion, required);
                presentComponents[i2] = higherPC;
                continue;
            }
            missingPC = new PatchComponentMissing(compName, searchVersion, required);
            presentComponents[i2] = missingPC;
        }
        return presentComponents;
    }

    public OneOffEntry[] getInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatches();
    }

    public OneOffEntry[] getAllInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getAllInstalledPatches();
    }

    public OneOffEntry[] getInactivePatches() throws RuntimeException {
        return this.getCookedInventory().getInactivePatches();
    }

    public InstalledComponent[] getInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getInstalledComponents();
    }

    public InstalledComponent[] getTopLevelInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getTopLevelInstalledComponents();
    }

    public boolean isDesiredHome() throws RuntimeException {
        return this.getCookedInventory().isDesiredHome();
    }

    public InstalledComponent[] getNextGenInstalledDistributions() {
        return this.getCookedInventory().getNextGenInstalledDistributions();
    }

    public InstalledComponent[] getNextGenInstalledComponents() {
        return this.getCookedInventory().getNextGenInstalledComponents();
    }

    public Vector getHomes() throws RuntimeException {
        return this.getRawInventory().getHomes();
    }

    public String getGUID(String oracleHomePath) throws RuntimeException {
        return this.getRawInventory().getGUID(oracleHomePath);
    }

    public OPatchSDK.OracleHome[] getOracleHomes() throws RuntimeException {
        return this.getRawInventory().getOracleHomes();
    }

    public boolean isOracleHomeInfoExist() throws RuntimeException {
        return this.getRawInventory().isOracleHomeInfoExist();
    }

    public boolean isCRSHome() throws RuntimeException {
        return this.getRawInventory().isCRSHome();
    }

    public String getOracleHomeName() throws RuntimeException {
        return this.getRawInventory().getOracleHomeName();
    }

    public String getLocalNode() throws RuntimeException {
        return this.getRawInventory().getLocalNode();
    }

    public Integer getARUID() throws RuntimeException {
        return this.getRawInventory().getARUID();
    }

    public String getARUIDDescription() throws RuntimeException {
        return this.getRawInventory().getARUIDDescription();
    }

    public String getLocation() throws RuntimeException {
        return this.getRawInventory().getLocation();
    }

    public Vector getNodeList() throws RuntimeException {
        return this.getRawInventory().getNodeList();
    }

    protected Integer getIndex() throws RuntimeException {
        this.getRawInventory();
        return RawInventory.getIndex();
    }

    public String getAdditionalOracleHomeProperty(String propertyName) throws RuntimeException {
        return this.getRawInventory().getAdditionalOracleHomeProperty(propertyName);
    }

    public boolean isCRSHomePresent() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        return home != null;
    }

    public String findCRSHomeLocation() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getLocation();
        }
        return null;
    }

    public String findCRSHomeName() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getName();
        }
        return null;
    }

    private OiiiOracleHomeInfo getCRSHome() {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!home.isCRSHome()) continue;
            return home;
        }
        return null;
    }

    public String findGridHomeLocation() throws RuntimeException {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!IPMUtil.isGridHome(home.getLocation())) continue;
            return home.getLocation();
        }
        return null;
    }

    public boolean isGridHome(String oracleHomePath) throws RuntimeException {
        Vector homes = this.getHomes();
        for (Object home : homes) {
            OiiiOracleHomeInfo oh = (OiiiOracleHomeInfo)home;
            if (!oh.getLocation().equals(oracleHomePath) || !IPMUtil.isGridHome(oracleHomePath)) continue;
            return true;
        }
        return false;
    }

    public String getOracleHomePath() throws RuntimeException {
        return this.getRawInventory().getOracleHomePath();
    }

    public String getXMLInvLocation(String patchID) throws RuntimeException {
        return this.getRawInventory().getXMLInvLocation(patchID);
    }

    public OneOffEntry getLatestTranslationPatch(String patchID, String language) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            String origPatchID = oneoffList[i2].getPatchID();
            String oneOffLanguage = oneoffList[i2].getPatchLanguage();
            if (!oneoffList[i2].couldBeTranslation() || !oneOffLanguage.equals(language) || !origPatchID.equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    private static boolean checkIfMiniPatchsetFunctional() {
        if (OPatchEnv.isNextGen()) {
            return false;
        }
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry");
            if (chkClass != null) {
                chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallInventory");
                Method[] methods = chkClass.getMethods();
                boolean foundFlag = false;
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("isComponentInPatchSetUpdate")) continue;
                    foundFlag = true;
                    break;
                }
                return foundFlag;
            }
            return false;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public OneOffEntry getPatchFromInv(String patchID, String upi) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            if (!oneoffList[i2].getPSENumber().equals(upi) || !oneoffList[i2].getID().equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    public void populatePatchInventoryAndComps(String oracleHome, String patchID, PatchInventory patchInventory, LinkedList compsList) throws RuntimeException {
        OiiiInstallOneoffInvEntry oEntry = null;
        try {
            oEntry = this.getRawInventory().getOneoffInvEntry(patchID, new Vector(), "", this.getRawInventory().getOracleHomeName());
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        Vector bugsFixedVector = oEntry.getBugs();
        for (int bIter = 0; bIter < bugsFixedVector.size(); ++bIter) {
            Bug bug = new Bug((String)bugsFixedVector.get(bIter), "No description available.");
            patchInventory.bugsToFix.add(bug);
        }
        patchInventory.patchID = patchID;
        patchInventory.setCreationTime("", "", "", "", "");
        patchInventory.setRawCreationDate("");
        patchInventory.setFormatCreationDate("");
        Platform platform = new Platform("Generic", "0");
        patchInventory.supportedPlatforms.add(platform);
        Vector files = oEntry.getFilesPatched();
        PatchComponent patchComp = new PatchComponent("Unknown", "0.0", true);
        for (int j2 = 0; j2 < files.size(); ++j2) {
            OiiiFileMapFileEntry entry = (OiiiFileMapFileEntry)files.get(j2);
            String child = entry.getFilePath();
            String parent = entry.getOwnerFilePath();
            String parentDirPath = entry.getParentDirPath();
            StringBuffer buff = null;
            if (parent != null) {
                buff = new StringBuffer("Processing entry - Parent :");
                buff.append(parent);
                buff.append("   child :\n");
                buff.append(child);
                OLogger.debug(buff);
                if (parent.endsWith(File.separator)) {
                    parent = parent.substring(0, parent.length() - 1);
                }
                int index = parent.lastIndexOf(File.separator);
                String name = "";
                String path = "";
                if (index != -1) {
                    name = parent.substring(index + 1);
                    path = parent.substring(oracleHome.length(), index);
                }
                if (!child.startsWith(File.separator)) {
                    child = File.separator + child;
                }
                String childName = path + File.separator + name + child;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" child: \"");
                    buff.append(childName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    if (childName.endsWith("o") && name.endsWith("a")) {
                        ArchiveAction aa = new ArchiveAction(null, name, path, childName, j2);
                        aa.setBuiltFrom101Home(true);
                        patchComp.archiveList.add(aa);
                        continue;
                    }
                    JarAction ja = new JarAction(null, name, path, childName, j2);
                    ja.setBuiltFrom101Home(true);
                    patchComp.jarList.add(ja);
                    continue;
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage());
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
            }
            if (parentDirPath != null) {
                int index;
                buff = new StringBuffer("Processing entry - ParentDirPath : ");
                buff.append(parentDirPath);
                buff.append("   child : ");
                buff.append(child);
                OLogger.debug(buff);
                String name = "";
                String path = parentDirPath;
                if (child.endsWith(File.separator)) {
                    child = child.substring(0, child.length() - 1);
                }
                if ((index = child.lastIndexOf(File.separator)) != -1) {
                    name = child.substring(index + 1);
                }
                String fileName = path + File.separator + name;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" fileName: \"");
                    buff.append(fileName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    CopyAction ca = new CopyAction(null, name, path, fileName, j2);
                    ca.setBuiltFrom101Home(true);
                    patchComp.copyList.add(ca);
                    continue;
                }
                catch (Exception e4) {
                    RuntimeException re = new RuntimeException(e4.getMessage());
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
            }
            RuntimeException re = new RuntimeException("Unable to get the files touched entry properly.");
            throw re;
        }
        compsList.add(patchComp);
    }

    public boolean isInventoryLoaded() {
        return rawInventory != null;
    }

    public void loadInventory(String oracleHomePath) throws RuntimeException {
        if (rawInventory != null && !this.getOracleHomePath().equals(oracleHomePath)) {
            StringBuffer buff = new StringBuffer("IPMReadServices::loadInventory() is called for different OH");
            OLogger.debug(buff);
            rawInventory = null;
            cookedInventory = null;
        }
        this.getRawInventory();
    }

    public OneOffEntry[] getInactivePSUTrain() throws RuntimeException {
        return this.getCookedInventory().getInactivePSUTrain();
    }

    public OneOffEntry[] getInstalledPatchesIncludeInactive() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatchesIncludeInactive();
    }
}

