/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.opatch.conflicttextualinterpreter.CompositePatchCategorizer;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilderUtil;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.Patch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictMapBuilder
implements IConflictMapBuilder {
    private static IConflictMapBuilder conflictMapBuilder;
    private final int DEFAULT_BUGS_SIZE = 64;
    private final int DEFAULT_FILES_SIZE = 512;
    private HashMap<String, HashSet<IPatch>> checkBugsMap;
    private HashMap<String, HashSet<IPatch>> checkFilesMap;
    private HashMap<String, HashSet<IPatch>> bugConflictsMap;
    private HashMap<String, HashSet<IPatch>> fileConflictMap;
    private Collection<IPatch> oldPi;
    private boolean container = false;

    public static IConflictMapBuilder getInstance() {
        if (conflictMapBuilder == null) {
            conflictMapBuilder = new ConflictMapBuilder();
        }
        return conflictMapBuilder;
    }

    private ConflictMapBuilder() {
    }

    private void collectContainerFilesMap(String file, IPatch patch) {
        Set<Map.Entry<String, HashSet<IPatch>>> filesSet = this.checkFilesMap.entrySet();
        Iterator<Map.Entry<String, HashSet<IPatch>>> filesIter = filesSet.iterator();
        String newFile = "";
        boolean copyOnly = false;
        HashMap temp = new HashMap();
        while (filesIter.hasNext()) {
            Map.Entry<String, HashSet<IPatch>> fileEntry = filesIter.next();
            String key = fileEntry.getKey();
            if (!key.contains(":") && !file.contains(":")) {
                copyOnly = true;
            }
            if (!copyOnly && (file.endsWith(".a") || file.endsWith(".o") || file.endsWith(".class") || file.endsWith(".jar") || file.endsWith(".ear") || file.endsWith(".war"))) {
                HashSet<IPatch> tempPatchIds;
                if (file.length() != key.length() && file.startsWith(key)) {
                    newFile = file.substring(0, key.length());
                    this.container = true;
                    this.checkFilesMap.get(newFile).add(patch);
                    if (!temp.containsKey(file)) {
                        tempPatchIds = new HashSet<IPatch>();
                        for (IPatch tmp : this.checkFilesMap.get(newFile)) {
                            tempPatchIds.add(tmp);
                        }
                        temp.put(file, tempPatchIds);
                    }
                } else if (file.length() != key.length() && key.startsWith(file)) {
                    newFile = new String(key);
                    this.container = true;
                    this.checkFilesMap.get(newFile).add(patch);
                    if (!temp.containsKey(file)) {
                        tempPatchIds = new HashSet();
                        for (IPatch tmp : this.checkFilesMap.get(newFile)) {
                            tempPatchIds.add(tmp);
                        }
                        temp.put(file, tempPatchIds);
                    }
                }
            }
            copyOnly = false;
        }
        Set tempSet = temp.entrySet();
        for (Map.Entry tEntry : tempSet) {
            String key = (String)tEntry.getKey();
            HashSet<IPatch> addPatchIds = new HashSet<IPatch>();
            for (IPatch t : (HashSet)temp.get(key)) {
                addPatchIds.add(t);
            }
            this.checkFilesMap.put(file, addPatchIds);
        }
    }

    private void collectBugsAndFilesMap(Collection<IPatch> pis, boolean fromOH) {
        for (IPatch patch : pis) {
            HashSet<IPatch> belongPatchIds;
            Set<String> bugs = patch.getBugs();
            Set<String> files = patch.getFiles();
            for (String bug : bugs) {
                if (fromOH && this.checkBugsMap.containsKey(bug)) {
                    this.checkBugsMap.get(bug).add(patch);
                    continue;
                }
                if (fromOH) continue;
                if (this.checkBugsMap.containsKey(bug)) {
                    this.checkBugsMap.get(bug).add(patch);
                    continue;
                }
                belongPatchIds = new HashSet<IPatch>();
                belongPatchIds.add(patch);
                this.checkBugsMap.put(bug, belongPatchIds);
            }
            for (String file : files) {
                if (fromOH) {
                    if (this.checkFilesMap.containsKey(file)) {
                        this.checkFilesMap.get(file).add(patch);
                    }
                    this.collectContainerFilesMap(file, patch);
                    continue;
                }
                if (fromOH) continue;
                if (this.checkFilesMap.containsKey(file)) {
                    this.checkFilesMap.get(file).add(patch);
                }
                this.collectContainerFilesMap(file, patch);
                if (this.checkFilesMap.containsKey(file)) continue;
                belongPatchIds = new HashSet();
                belongPatchIds.add(patch);
                this.checkFilesMap.put(file, belongPatchIds);
            }
        }
    }

    private void initConflictMapBuilder(Collection<IPatch> pis) {
        if (this.oldPi == null) {
            this.checkBugsMap = new HashMap(pis.size() * 64);
            this.checkFilesMap = new HashMap(pis.size() * 512);
            this.bugConflictsMap = new HashMap(pis.size());
            this.fileConflictMap = new HashMap(pis.size());
            this.collectBugsAndFilesMap(pis, false);
        } else if (this.oldPi != pis) {
            this.checkBugsMap.clear();
            this.checkFilesMap.clear();
            this.bugConflictsMap.clear();
            this.fileConflictMap.clear();
            this.collectBugsAndFilesMap(pis, false);
        }
        this.oldPi = pis;
    }

    private boolean canIgnoreConflict(IPatch pi, IPatch pc) {
        boolean ignore = pi.getOverlaysID().contains(pc.getPatchId());
        if (!ignore && pi.isComposite()) {
            ignore = pc.getOverlaysID().contains(pi.getPatchId());
        }
        if (!ignore && pi.getPatchId().equals(pc.getPatchId())) {
            ignore = true;
        }
        return ignore;
    }

    private void buildBugsConflict(Collection<IPatch> pis, ConflictMap conflictMap, boolean inter) {
        for (IPatch pi : pis) {
            HashSet<IPatch> conflictPatches;
            String tripletId = pi.getTripletId();
            Set<String> bugs = pi.getBugs();
            for (String bug : bugs) {
                conflictPatches = this.checkBugsMap.get(bug);
                if (conflictPatches.size() <= 1) continue;
                if (this.bugConflictsMap.containsKey(tripletId)) {
                    this.bugConflictsMap.get(tripletId).addAll(conflictPatches);
                    continue;
                }
                this.bugConflictsMap.put(tripletId, conflictPatches);
            }
            if (!this.bugConflictsMap.containsKey(tripletId)) continue;
            conflictPatches = this.bugConflictsMap.get(tripletId);
            for (IPatch conflictPatch : conflictPatches) {
                if (conflictPatch == pi || pi.isComposite() && conflictPatch.isComposite()) continue;
                HashSet<String> sameBugs = new HashSet<String>(pi.getBugs());
                sameBugs.retainAll(conflictPatch.getBugs());
                int piLen = pi.getBugs().size();
                int pcLen = conflictPatch.getBugs().size();
                int prLen = sameBugs.size();
                if (prLen > 0 && prLen < piLen && prLen < pcLen) {
                    NPatchRelations relations = conflictMap.getRelations(pi);
                    if (relations.isGenericRelation(conflictPatch)) continue;
                    ArrayList<String> sameBugsArr = new ArrayList<String>(sameBugs);
                    conflictMap.addConflictRelation(pi, conflictPatch, true, sameBugsArr);
                    if (!conflictPatch.isInOh()) continue;
                    conflictMap.addConflictRelation(conflictPatch, pi, true, sameBugsArr);
                    continue;
                }
                if (prLen <= 0) continue;
                ArrayList<String> sameBugsArr = new ArrayList<String>(sameBugs);
                if (piLen > pcLen) {
                    conflictMap.addSupersetRelation(pi, conflictPatch, sameBugsArr);
                    if (!conflictPatch.isInOh()) continue;
                    conflictMap.addSubsetRelation(conflictPatch, pi, sameBugsArr);
                    continue;
                }
                if (piLen >= pcLen) continue;
                conflictMap.addSubsetRelation(pi, conflictPatch, sameBugsArr);
                if (!conflictPatch.isInOh()) continue;
                conflictMap.addSupersetRelation(conflictPatch, pi, sameBugsArr);
            }
        }
    }

    private void buildFilesConflict(Collection<IPatch> pis, ConflictMap conflictMap, boolean inter) {
        for (IPatch pi : pis) {
            HashSet<IPatch> conflictPatches;
            String tripletId = pi.getTripletId();
            Set<String> files = pi.getFiles();
            for (String file : files) {
                conflictPatches = this.checkFilesMap.get(file);
                if (conflictPatches.size() <= 1) continue;
                if (this.fileConflictMap.containsKey(tripletId)) {
                    this.fileConflictMap.get(tripletId).addAll(conflictPatches);
                    continue;
                }
                this.fileConflictMap.put(tripletId, conflictPatches);
            }
            if (!this.fileConflictMap.containsKey(tripletId)) continue;
            conflictPatches = this.fileConflictMap.get(tripletId);
            for (IPatch conflictPatch : conflictPatches) {
                NPatchRelations relations;
                int prLen;
                if (conflictPatch == pi || pi.isComposite() && conflictPatch.isComposite()) continue;
                HashSet<String> sameFiles = new HashSet<String>(pi.getFiles());
                sameFiles.retainAll(conflictPatch.getFiles());
                if (this.container) {
                    Set<String> myFiles = pi.getFiles();
                    for (String myFile : myFiles) {
                        Set myPatches = this.checkFilesMap.get(myFile);
                        if (!myPatches.contains(pi) || !myPatches.contains(conflictPatch)) continue;
                        sameFiles.add(myFile);
                    }
                }
                if ((prLen = sameFiles.size()) <= 0 || (relations = conflictMap.getRelations(pi)).isGenericRelation(conflictPatch) || relations.isConflictOf(conflictPatch)) continue;
                ArrayList<String> sameFilesArr = new ArrayList<String>(sameFiles);
                conflictMap.addConflictRelation(pi, conflictPatch, false, sameFilesArr);
                if (!conflictPatch.isInOh()) continue;
                conflictMap.addConflictRelation(conflictPatch, pi, false, sameFilesArr);
            }
        }
    }

    @Override
    public IConflictMap build(String mapFile) {
        return null;
    }

    @Override
    public void generate(String mapFile, IConflictMap map) {
    }

    @Override
    public IConflictMap build(Collection<IPatch> pis) {
        ConflictMap conflictMap = new ConflictMap(pis);
        this.initConflictMapBuilder(pis);
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        builderUtil.selectBetterPatchAgainstOH(pis, new ArrayList<IPatch>(), conflictMap);
        builderUtil = null;
        this.buildBugsConflict(pis, conflictMap, false);
        this.buildFilesConflict(pis, conflictMap, false);
        conflictMap.collectRelationsToTopLevelPSU();
        conflictMap.setPohExist(false);
        return conflictMap;
    }

    @Override
    public IConflictMap build(Collection<IPatch> pis, Collection<IPatch> pohs) {
        OracleHomeConflictMap instance = OracleHomeConflictMap.getInstance();
        HashMap<IPatch, Collection<IPatch>> inactivePatchesMap = new HashMap<IPatch, Collection<IPatch>>();
        if (instance != null) {
            for (IPatch inactivePatch : instance.getSubsetIPatches()) {
                Patch patch = new Patch(inactivePatch.getOneOffEntry(), true);
                inactivePatchesMap.put(patch, instance.getSupersetPatches(inactivePatch));
                pohs.add(patch);
            }
        }
        ConflictMap conflictMap = new ConflictMap(pis, pohs);
        this.initConflictMapBuilder(pis);
        this.collectBugsAndFilesMap(pohs, true);
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        builderUtil.selectBetterPatchAgainstOH(pis, pohs, conflictMap);
        builderUtil = null;
        this.buildBugsConflict(pis, conflictMap, true);
        this.buildFilesConflict(pis, conflictMap, true);
        this.buildInactiveRelations(inactivePatchesMap, pohs, conflictMap);
        conflictMap.collectRelationsToTopLevelPSU();
        conflictMap.setPohExist(true);
        return conflictMap;
    }

    @Override
    public IConflictMap buildOH(Collection<IPatch> pohs) {
        ArrayList<IPatch> psus = new ArrayList<IPatch>();
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        builderUtil.addSubPatchToPSU(pohs, new HashMap<String, IPatch>(pohs.size()));
        ArrayList<IPatch> subPatchList = new ArrayList<IPatch>();
        for (IPatch poh : pohs) {
            if (!poh.isTopLevelPSU()) continue;
            psus.add(poh);
            for (IPatch subPatch : poh.getSubPatches()) {
                poh.getBugs().addAll(subPatch.getBugs());
                poh.getFiles().addAll(subPatch.getFiles());
                subPatchList.add(subPatch);
            }
        }
        pohs.removeAll(subPatchList);
        ConflictMap conflictMap = new ConflictMap(pohs);
        this.initConflictMapBuilder(pohs);
        this.buildBugsConflict(pohs, conflictMap, false);
        this.buildFilesConflict(pohs, conflictMap, false);
        if (psus.size() >= 2) {
            IPatch[] psusArray = new IPatch[2];
            psus.toArray(psusArray);
            CompositePatchCategorizer.buildPSURelation(psusArray, conflictMap);
        }
        return conflictMap;
    }

    private void buildInactiveRelations(Map<IPatch, Collection<IPatch>> inactivePatchesMap, Collection<IPatch> pohs, ConflictMap conflictMap) {
        for (IPatch inactivePatch : inactivePatchesMap.keySet()) {
            for (IPatch supersetPatch : inactivePatchesMap.get(inactivePatch)) {
                for (IPatch poh : pohs) {
                    if (!poh.getPatchId().equals(supersetPatch.getPatchId())) continue;
                    conflictMap.addSubsetRelation(inactivePatch, poh, new ArrayList<String>());
                    conflictMap.addSupersetRelation(poh, inactivePatch, new ArrayList<String>());
                }
            }
        }
    }
}

