/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASFileServices {
    public void build() {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.buildCasStore(false);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("buildCasStore error: " + t.getMessage());
        }
    }

    public void create(String soh, Map<Path, String> copy, Map<Path, String> hardlink) {
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            String tagKey = null;
            casFileServices.createBranchOH(soh, branchKey, tagKey, copy, null, hardlink);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("createBranchOH error: " + t.getMessage());
        }
    }

    public void destroy(String soh) {
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.destroyBranchOH(branchKey, soh, false);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("destroyBranchOH error: " + t.getMessage());
        }
    }

    public void begin(OPatchPatchKey opKey) {
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            ICASFileServices.PatchKey patchKey = opKey.getCASKey();
            casFileServices.beginPatchBranch(branchKey, patchKey);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("beginPatchBranch error: " + t.getMessage());
        }
    }

    public void end(OPatchPatchKey opKey, Map<Path, String> remove) {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            ICASFileServices.PatchKey patchKey = opKey.getCASKey();
            casFileServices.endPatchBranch(patchKey, remove);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("endPatchBranch error: " + t.getMessage());
        }
    }

    public void copyOh() {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.copyHardLinkOH(null, null);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("copyOh error: " + t.getMessage());
        }
    }

    public void normalizeOH() {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            Collection newFiles = casFileServices.checkNewFiles(null);
            casFileServices.normalizeOH(newFiles, null);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("normalizeOH error: " + t.getMessage());
        }
    }

    public void commit(OPatchPatchKey opKey, Map<Path, String> ignore) {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            String branchKey = OPatchEnv.getBranchKey();
            if (opKey == null) {
                casFileServices.pushFromBranch(branchKey, null, ignore);
                return;
            }
            ICASFileServices.PatchKey key = opKey.getCASKey();
            casFileServices.pushFromBranch(branchKey, key, ignore);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("commit error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public void restore() {
        try {
            ICASFileServices.PatchKey latestKey = null;
            ICASFileServices casFileServices = CASServices.getFileServices();
            latestKey = casFileServices.getLatestPatch(null);
            if (latestKey != null) {
                Path path = null;
                casFileServices.restorePatchMemento(latestKey, path);
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("restore error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }
}

