/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.errors.CasApiNoOpException;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.opatch.cas.BranchInfo;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASBranchServices {
    public void createBranch(String shadowDir, String branchKey) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.buildCasStore(false);
            this.verifyBranch(shadowDir);
            this.verifyKey(branchKey);
            String tagKey = null;
            casFileServices.createBranchOH(shadowDir, branchKey, tagKey);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("createBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Cannot createview \"{0}\" on \"{1}\": {2}", branchKey, shadowDir, t.getMessage()));
            throw t;
        }
    }

    private void verifyBranch(String shadowDir) {
        File f2 = new File(shadowDir);
        boolean ok = true;
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            StringBuffer tBuff = new StringBuffer("Please specify a valid view directory. The given directory \"");
            tBuff.append(shadowDir);
            tBuff.append("\" does not exist and OPatch cannot create the view.");
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
    }

    private void verifyKey(String branchKey) {
        if (branchKey != null && !branchKey.isEmpty()) {
            if (branchKey.matches("[a-zA-Z0-9]+")) {
                return;
            }
            StringBuffer tBuff = new StringBuffer("The given view id \"");
            tBuff.append(branchKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("Please specify view id containing only alphanumeric characters.");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("Please specify a valid view id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    public void synchBranch(String branchKey) {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.syncLatestToBranch(branchKey);
        }
        catch (Throwable t) {
            OLogger.println(t.getMessage());
            OLogger.printlnOnLog("synchBranch error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public void destroyBranch(String branchKey) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            String branchdir = this.getBranchDir(branchKey);
            if (branchdir == null) {
                StringBuffer tBuff = new StringBuffer("Please specify a valid view id. The given view id \"");
                tBuff.append(branchKey);
                tBuff.append("\" doesn't exist.");
                OLogger.printlnOnLog(tBuff.toString());
                CasApiNoOpException e2 = new CasApiNoOpException(null, new String(tBuff));
                throw e2;
            }
            casFileServices = CASServices.getFileServices();
            casFileServices.destroyBranchOH(branchKey, branchdir, false);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("destroyBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Cannot destroyview \"{0}\" : {1}", branchKey, t.getMessage()));
            throw t;
        }
    }

    private String getBranchDir(String branchKey) {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.listBranch(keys, values);
            if (keys.size() == 0) {
                OLogger.printlnOnLog("No branch is created, cannot get branch directory.");
                return null;
            }
            for (String key : keys) {
                if (!key.equals(branchKey)) continue;
                LinkedList mKeys = new LinkedList();
                Path p2 = casFileServices.listBranchInfo(key, mKeys);
                return p2.toString();
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("getBranchDir error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return null;
    }

    public LinkedList<BranchInfo> listBranch(List<String> keys, List<Path> values) {
        this.validate();
        ICASFileServices casFileServices = null;
        LinkedList<BranchInfo> bis = new LinkedList<BranchInfo>();
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.listBranch(keys, values);
            if (keys.size() == 0) {
                OLogger.printlnOnLog("No branch is created");
            }
            for (String key : keys) {
                LinkedList<String> mKeys = new LinkedList<String>();
                Path p2 = casFileServices.listBranchInfo(key, mKeys);
                LinkedHashMap<String, String> pidMap = new LinkedHashMap();
                pidMap = this.extractPatchInfo(mKeys);
                LinkedList<String> list = this.getPatchInfoList(pidMap);
                bis.add(new BranchInfo(p2, list));
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("listBranch error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return bis;
    }

    private Map<String, String> extractPatchInfo(LinkedList<String> keys) {
        LinkedHashMap<String, String> pidMap = new LinkedHashMap<String, String>();
        Collections.reverse(keys);
        for (String key : keys) {
            int first = key.indexOf("_");
            int second = key.indexOf("_", first + 1);
            int last = key.lastIndexOf("_");
            String id = key.substring(0, second);
            String time = key.substring(second + 1, last);
            if (key.endsWith("napply")) {
                pidMap.put(id, time);
                continue;
            }
            if (!key.endsWith("nrollback")) continue;
            pidMap.remove(id);
        }
        return pidMap;
    }

    private LinkedList<String> getPatchInfoList(Map<String, String> map) {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] ids = entry.getKey().split("_");
            StringBuffer buff = new StringBuffer("Patch ");
            buff.append(ids[0]);
            buff.append(": applied on ");
            buff.append(entry.getValue());
            buff.append("\nUnique Patch ID: ");
            buff.append(ids[1]);
            list.add(buff.toString());
        }
        Collections.reverse(list);
        return list;
    }

    public void detachMain() throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.detachCasStore();
        }
        catch (Throwable t) {
            if (t instanceof CasApiNoOpException) {
                OLogger.printlnOnLog("detachMain info: " + t.getMessage());
            } else {
                OLogger.printlnOnLog("detachMain error: " + t.getMessage());
                OLogger.printStackTrace(t);
            }
            throw t;
        }
    }

    public void attachMain() throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.attachCasStore();
        }
        catch (Throwable t) {
            if (t instanceof CasApiNoOpException) {
                OLogger.printlnOnLog("attachMain info: " + t.getMessage());
            } else {
                OLogger.printlnOnLog("attachMain error: " + t.getMessage());
                OLogger.printStackTrace(t);
            }
            throw t;
        }
    }

    private void validate() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch doesn't support ZDT commands");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
    }
}

