/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchInfo {
    private Path branchDir;
    private LinkedList<String> patchIDs;

    private BranchInfo() {
    }

    public BranchInfo(Path branchDir, LinkedList<String> patchIDs) {
        this.branchDir = branchDir;
        this.patchIDs = new LinkedList();
        for (String id : patchIDs) {
            this.patchIDs.add(id);
        }
    }

    public int hashCode() {
        int firstHash = this.branchDir != null ? this.branchDir.toString().hashCode() : 0;
        int prime = 31;
        int secondHash = 1;
        for (String s : this.patchIDs) {
            secondHash = secondHash * 31 + s.hashCode();
        }
        return (firstHash + secondHash) * secondHash + firstHash;
    }

    public boolean equals(Object other) {
        if (other instanceof BranchInfo) {
            BranchInfo otherBranch = (BranchInfo)other;
            boolean firstEquals = this.branchDir == otherBranch.branchDir || this.branchDir != null && otherBranch.branchDir != null && this.branchDir.equals(otherBranch.branchDir);
            boolean secondEquals = false;
            if (this.patchIDs.size() != otherBranch.patchIDs.size()) {
                secondEquals = false;
            }
            for (String sec : this.patchIDs) {
                for (String oth : otherBranch.patchIDs) {
                    if (sec == oth || sec != null && oth != null && sec.equals(oth)) {
                        secondEquals = true;
                        continue;
                    }
                    secondEquals = false;
                }
            }
            return firstEquals && secondEquals;
        }
        return false;
    }

    public Path getBranchDir() {
        return this.branchDir;
    }

    public void setBranchDir(Path branchDir) {
        this.branchDir = branchDir;
    }

    public LinkedList<String> getPatchIDs() {
        return this.patchIDs;
    }

    public void setPatchIDs(LinkedList<String> patchIDs) {
        this.patchIDs = patchIDs;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("View path: ");
        buff.append(this.branchDir);
        buff.append("\n");
        buff.append("Installed patches: \n");
        for (int i2 = 0; i2 < this.patchIDs.size(); ++i2) {
            buff.append(this.patchIDs.get(i2) + "\n");
        }
        return buff.toString();
    }
}

