/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import oracle.opatch.BusyFileProcessor;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OUIReplacer;
import oracle.opatch.ReaderThread;
import oracle.opatch.Rules;
import oracle.opatch.StdoutStatus;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiix.OiixFileOps;

public class SystemCall {
    private static final long ONE_MB = 0x40000000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x780000000L;
    static Thread mainThread = Thread.currentThread();
    private static String suCommandPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fastCopy(File srcFile, File destFile) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = ((FileChannel)input).size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), pos, count)) {
                count = size - pos > 0x780000000L ? 0x780000000L : size - pos;
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            output.close();
            fos.close();
            input.close();
            fis.close();
            throw throwable;
        }
        output.close();
        fos.close();
        input.close();
        fis.close();
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void oldCopy(File src, File dst) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)in).close();
            ((OutputStream)out).close();
            throw throwable;
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static ExecReturn MkDirs(String dirsPath) {
        String[] cmd = new String[]{"mkdir -p on Unix, mkdir on Windows using Java File::mkdirs()"};
        ExecReturn ret = new ExecReturn(cmd);
        boolean cont = Rules.SystemWrite_continue();
        if (!cont) {
            File test = new File(dirsPath);
            if (!test.exists()) {
                if (OPatchEnv.isWindows()) {
                    StringBuffer tmp = new StringBuffer("REPORT: mkdir ");
                    tmp.append(dirsPath);
                    OLogger.log(OLogger.FINE, tmp.toString());
                } else {
                    StringBuffer tmp = new StringBuffer("REPORT: mkdir -p ");
                    tmp.append(dirsPath);
                    OLogger.log(OLogger.FINE, tmp.toString());
                }
            }
            ret.setErrorMessage("");
            ret.setNormalMessage("Ops. not executed because no system mod. is requested");
            ret.setReturnCode(0);
            return ret;
        }
        File dirs = new File(dirsPath);
        boolean ok = dirs.mkdirs();
        if (ok) {
            ret.setReturnCode(0);
        } else {
            ret.setReturnCode(-1);
        }
        if (!dirs.exists()) {
            ret.setReturnCode(-1);
            StringBuffer tmp = new StringBuffer("mkdir fails for ");
            tmp.append(dirs.getAbsolutePath());
            ret.setErrorMessage(tmp.toString());
            ret.setNormalMessage("");
        }
        return ret;
    }

    public static ExecReturn runtimeExec(String systemCommand) {
        String[] systemCommands = new String[]{systemCommand};
        String runDir = null;
        return SystemCall.runtimeExec(systemCommands, runDir);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String runDir) {
        String[] envp = null;
        return SystemCall.runtimeExec(systemCommand, envp, runDir);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String[] envp, String runDir) {
        return SystemCall.runtimeExec(systemCommand, envp, runDir, null, false);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String[] envp, String runDir, String inputString, boolean coroutineLogging) {
        ExecReturn ret = null;
        StringBuffer buff = new StringBuffer();
        boolean passEnvp = true;
        Properties opatchProperty = OPatchEnv.getOPatchProperties();
        String ohValue = "";
        try {
            ohValue = OPatchEnv.getOracleHome();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            ohValue = "";
        }
        String pathValue = opatchProperty.getProperty("OPatch.PATH");
        String[] specialEnvp = new String[2];
        buff = new StringBuffer("ORACLE_HOME");
        buff.append("=");
        buff.append(ohValue);
        specialEnvp[0] = buff.toString();
        buff = new StringBuffer("PATH");
        buff.append("=");
        buff.append(pathValue);
        specialEnvp[1] = buff.toString();
        if (systemCommand == null) {
            String[] tmp = new String[]{"Null Command given by caller"};
            ret = new ExecReturn(tmp);
            ret.setErrorMessage("");
            ret.setNormalMessage("");
            ret.setReturnCode(0);
            return ret;
        }
        ret = new ExecReturn(systemCommand);
        if (envp != null) {
            for (int eIter = 0; eIter < envp.length; ++eIter) {
                String src = envp[eIter];
                int index = src.indexOf("=");
                int len = src.length();
                String key = src.substring(0, index);
                String value = src.substring(index + 1, len);
                buff = new StringBuffer("Setting env with key=\"");
                buff.append(key);
                buff.append(", value=\"");
                buff.append(value);
                buff.append("\"");
                OLogger.debug(buff);
                OUIReplacer.setEnv(key, value);
            }
        }
        if (ohValue != null && !ohValue.equals("")) {
            OUIReplacer.setEnv("ORACLE_HOME", ohValue);
        }
        if (pathValue != null && !pathValue.equals("")) {
            OUIReplacer.setEnv("PATH", pathValue);
        }
        String opatchTestOUIEnvApi = "TRUE";
        OUIReplacer.setEnv("OPATCH_TEST_ENV_API", opatchTestOUIEnvApi);
        String opatchTestOUIEnvApiRead = OUIReplacer.getEnv("OPATCH_TEST_ENV_API");
        if (opatchTestOUIEnvApi.equals(opatchTestOUIEnvApiRead)) {
            passEnvp = false;
        }
        if (passEnvp) {
            Properties p2 = OPatchEnv.getEnvInfo();
            if (p2 != null) {
                Enumeration<?> e3 = p2.propertyNames();
                int arrayCount = 0;
                int count = 0;
                String[] newEnvp = null;
                if (envp != null) {
                    arrayCount = envp.length;
                }
                if (specialEnvp != null) {
                    arrayCount += specialEnvp.length;
                }
                newEnvp = new String[arrayCount += p2.size()];
                while (e3.hasMoreElements()) {
                    String key = "";
                    try {
                        key = (String)e3.nextElement();
                    }
                    catch (Exception excep) {
                        continue;
                    }
                    String value = "";
                    value = key.trim().equals("ORACLE_HOME") && ohValue != null && !ohValue.equals("") ? ohValue : (key.trim().equals("PATH") && pathValue != null && !pathValue.equals("") ? pathValue : p2.getProperty(key));
                    if (value == null) {
                        StringBuffer valueBuff = new StringBuffer("");
                        value = valueBuff.toString();
                    }
                    StringBuffer input = new StringBuffer(key);
                    input.append("=");
                    input.append(value);
                    newEnvp[count++] = input.toString();
                }
                if (envp != null) {
                    for (int i2 = 0; i2 < envp.length; ++i2) {
                        newEnvp[count++] = envp[i2];
                    }
                }
                if (specialEnvp != null) {
                    for (int i3 = 0; i3 < specialEnvp.length; ++i3) {
                        newEnvp[count++] = specialEnvp[i3];
                    }
                }
                envp = newEnvp;
            } else {
                passEnvp = true;
            }
        }
        int retValue = -1;
        try {
            Process process = null;
            if (coroutineLogging) {
                OPatchACL.invokeOLogger(new SystemCall(), "closeDiskLogFile", null);
            }
            if (runDir != null) {
                File tmpF = new File(runDir);
                process = passEnvp ? SystemCall.exec(systemCommand, envp, tmpF) : SystemCall.exec(systemCommand, null, tmpF);
            } else {
                process = passEnvp ? SystemCall.exec(systemCommand, envp) : SystemCall.exec(systemCommand);
            }
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream");
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream");
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING to start thread to read Input Stream"));
            rinput.start();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Started thread to read Input Stream"));
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING to start thread to read Error Stream"));
            rerror.start();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Started thread to read Error Stream"));
            if (inputString != null) {
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Piping inputString to stdin"));
                PrintWriter pw = new PrintWriter(process.getOutputStream());
                pw.print(inputString);
                pw.print(System.getProperty("line.separator"));
                pw.flush();
            }
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING into process.waitFor()"));
            retValue = process.waitFor();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): process.waitFor() is OVER"));
            try {
                rerror.join();
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Error stream thread joined successfully"));
                rinput.join();
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Input stream thread joined successfully"));
                ret.setNormalMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        return ret;
    }

    private static Process exec(String[] systemCommand, String[] envp, File tmpF) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0], envp, tmpF);
        }
        return runTime.exec(systemCommand, envp, tmpF);
    }

    private static Process exec(String[] systemCommand, String[] envp) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0], envp);
        }
        return runTime.exec(systemCommand, envp);
    }

    private static Process exec(String[] systemCommand) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0]);
        }
        return runTime.exec(systemCommand);
    }

    public static void checkSuCommand() {
        if (suCommandPath != null) {
            return;
        }
        if (new File(StringResource.BIN_PATH + File.separator + "su").exists()) {
            suCommandPath = StringResource.BIN_PATH + File.separator + "su";
        } else if (new File(StringResource.USR_BIN_PATH + File.separator + "su").exists()) {
            suCommandPath = StringResource.USR_BIN_PATH + File.separator + "su";
        } else {
            ExecReturn ret = SystemCall.runtimeExec("which su");
            if (ret.isOK()) {
                suCommandPath = "su";
            } else {
                RuntimeException re = new RuntimeException("'su' command could not be found in system path environment, command execution will be failed.");
                throw re;
            }
        }
    }

    public static ExecReturn process(String command) {
        return SystemCall.process(command, null);
    }

    public static ExecReturn process(String command, String username) {
        ExecReturn ret = null;
        StringBuffer buff = new StringBuffer();
        Properties opatchProperty = OPatchEnv.getOPatchProperties();
        String ohValue = "";
        try {
            ohValue = OPatchEnv.getOracleHome();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            ohValue = "";
        }
        String pathValue = opatchProperty.getProperty("OPatch.PATH");
        String[] specialEnvp = new String[2];
        buff = new StringBuffer("ORACLE_HOME");
        buff.append("=");
        buff.append(ohValue);
        specialEnvp[0] = buff.toString();
        buff = new StringBuffer("PATH");
        buff.append("=");
        buff.append(pathValue);
        specialEnvp[1] = buff.toString();
        if (ohValue != null && !ohValue.equals("")) {
            OUIReplacer.setEnv("ORACLE_HOME", ohValue);
        }
        if (pathValue != null && !pathValue.equals("")) {
            OUIReplacer.setEnv("PATH", pathValue);
        }
        if (suCommandPath == null) {
            SystemCall.checkSuCommand();
        }
        if (command == null) {
            String[] tmp = new String[]{"Null Command given by caller"};
            ret = new ExecReturn(tmp);
            ret.setErrorMessage("");
            ret.setNormalMessage("");
            ret.setReturnCode(0);
            return ret;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        if (username != null) {
            cmds.add(suCommandPath);
            cmds.add(username);
            cmds.add("-m");
            cmds.add("-c");
            cmds.add(command);
        } else {
            cmds.addAll(Arrays.asList(command.split("\\s")));
        }
        ret = new ExecReturn(cmds.toArray(new String[cmds.size()]));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream");
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream");
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING to start thread to read Input Stream"));
            rinput.start();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Started thread to read Input Stream"));
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING to start thread to read Error Stream"));
            rerror.start();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Started thread to read Error Stream"));
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING into process.waitFor()"));
            retValue = process.waitFor();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): process.waitFor() is OVER"));
            try {
                rerror.join();
                OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Error stream thread joined successfully"));
                rinput.join();
                OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Input stream thread joined successfully"));
                ret.setNormalMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        return ret;
    }

    public static void copyFile(File src, File dst) throws RuntimeException {
        SystemCall.copyFile(src, dst, null);
    }

    public static void copyFile(File src, File dst, CopyAction copyAction) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::copyFile()");
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        boolean updateTimeStamp = false;
        boolean retainPermission = false;
        if (copyAction != null) {
            updateTimeStamp = copyAction.isUpdateTimeStamp();
            retainPermission = copyAction.isRetainPermission();
        }
        boolean dstNotExist = false;
        if (!dst.exists()) {
            dstNotExist = true;
            try {
                dst.getParentFile().mkdirs();
                dst.createNewFile();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        OLogger.debug(tmp);
        tmp.append(": copy file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        int finalPerm = 0;
        try {
            block32: {
                if (!OPatchEnv.isWindows()) {
                    if (retainPermission && !dstNotExist) {
                        try {
                            finalPerm = OUIReplacer.getPermission(dst.toString());
                        }
                        catch (RuntimeException e3) {
                            tmp = new StringBuffer("Getting permission of destination file \"");
                            tmp.append(dst.toString());
                            tmp.append("\" failed. ");
                            OLogger.debug(tmp.toString());
                            OLogger.warn("OUI-67729", new Object[]{dst.toString()});
                        }
                    } else {
                        finalPerm = OUIReplacer.getPermission(src.toString());
                    }
                }
                if (BusyFileProcessor.canDoRenameCopy(dst)) {
                    File renameFile = new File(dst.getAbsolutePath() + ".bk");
                    if (dst.renameTo(renameFile)) {
                        try {
                            renameFile.delete();
                        }
                        catch (Exception exception) {
                            OLogger.log("Failed to delete backup file \" {0} \"" + new Object[]{renameFile.getAbsolutePath()}, new Object[0]);
                        }
                    }
                    OLogger.log("Rename File \"{0}\" to \"{1}\"", dst.getAbsolutePath(), renameFile.getAbsolutePath());
                }
                SystemCall.fastCopy(src, dst);
                if (!OPatchEnv.isWindows()) {
                    try {
                        OUIReplacer.changePermission(dst.toString(), finalPerm);
                    }
                    catch (RuntimeException e4) {
                        if (!retainPermission) break block32;
                        tmp = new StringBuffer("Changing permission of file \"");
                        tmp.append(src.toString());
                        tmp.append("\" failed.");
                        OLogger.debug(tmp.toString());
                        OLogger.warn("OUI-67729", new Object[]{dst.toString()});
                    }
                }
            }
            if (!updateTimeStamp) {
                long time = src.lastModified();
                dst.setLastModified(time);
            }
        }
        catch (Throwable t) {
            tmp = new StringBuffer("SystemCall::copyFile() failed, ");
            tmp.append(t.getMessage());
            OLogger.debug(tmp);
            if (OPatchEnv.isAIXPlatform() || OPatchEnv.isHPUXPlatform()) {
                if (!dstNotExist) {
                    if (OPatchEnv.isAIXPlatform()) {
                        dst.delete();
                    } else {
                        File renameFile = new File(dst.getAbsolutePath() + ".bk");
                        if (dst.renameTo(renameFile)) {
                            try {
                                renameFile.delete();
                            }
                            catch (Exception exception) {
                                OLogger.log("Failed to delete backup file \" {0} \"" + new Object[]{renameFile.getAbsolutePath()}, new Object[0]);
                            }
                        }
                    }
                }
                try {
                    block33: {
                        int len;
                        FileInputStream in = new FileInputStream(src);
                        FileOutputStream out = new FileOutputStream(dst);
                        byte[] buf = new byte[1024];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        ((InputStream)in).close();
                        ((OutputStream)out).close();
                        try {
                            OUIReplacer.changePermission(dst.toString(), finalPerm);
                        }
                        catch (RuntimeException e5) {
                            if (!retainPermission) break block33;
                            tmp = new StringBuffer("Changing permission of file \"");
                            tmp.append(src.toString());
                            tmp.append("\" failed.");
                            OLogger.debug(tmp.toString());
                            OLogger.warn("OUI-67729", new Object[]{dst.toString()});
                        }
                    }
                    if (!updateTimeStamp) {
                        long time = src.lastModified();
                        dst.setLastModified(time);
                    }
                }
                catch (Throwable th) {
                    RuntimeException re = new RuntimeException(th.getMessage());
                    re.setStackTrace(th.getStackTrace());
                    throw re;
                }
            }
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public static void backupFile(File src, File dst) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::backupFile()");
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        if (!dst.exists()) {
            try {
                dst.getParentFile().mkdirs();
                dst.createNewFile();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        OLogger.debug(tmp);
        tmp.append(": back up file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        try {
            SystemCall.fastCopy(src, dst);
            if (!OPatchEnv.isWindows()) {
                int perm = OUIReplacer.getPermission(src.toString());
                OUIReplacer.changePermission(dst.toString(), perm);
            }
            long time = src.lastModified();
            dst.setLastModified(time);
        }
        catch (Throwable t) {
            tmp = new StringBuffer("SystemCall::backupFile() failed, ");
            tmp.append(t.getMessage());
            OLogger.debug(tmp);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    protected static void copyInventoryFile(File src, File dst) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::copyInventoryFile()");
        OLogger.debug(tmp);
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        tmp.append(": copy file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        try {
            SystemCall.fastCopy(src, dst);
            if (!OPatchEnv.isWindows()) {
                int perm = OUIReplacer.getPermission(src.toString());
                OUIReplacer.changePermission(dst.toString(), perm);
            }
            long time = src.lastModified();
            dst.setLastModified(time);
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public static boolean chownRecurse(String dir, String owner, String group) {
        if (OPatchEnv.isWindows()) {
            return true;
        }
        File top = new File(dir);
        try {
            OiixFileOps.chown((String)dir, (String)owner, (String)group);
        }
        catch (IOException e2) {
            return false;
        }
        if (top.isFile()) {
            return true;
        }
        File[] subFiles = top.listFiles();
        for (int i2 = 0; i2 < subFiles.length; ++i2) {
            SystemCall.chownRecurse(subFiles[i2].getAbsolutePath(), owner, group);
        }
        return true;
    }

    protected static void copyRecurse(File src, File dst, boolean debug) throws RuntimeException {
        SystemCall.copyRecurse(src, dst, debug, true);
    }

    protected static boolean copyRecurse(File src, File dst, boolean debug, boolean errorOut) throws RuntimeException {
        boolean errorHasHappened;
        StringBuffer tmpSb;
        block13: {
            boolean cont;
            StringBuffer tmp = new StringBuffer("SystemCall::copyRecurse()");
            tmpSb = null;
            String srcPath = src.getPath();
            String dstPath = dst.getPath();
            errorHasHappened = false;
            if (debug) {
                tmp.append(": from ");
                tmp.append(srcPath);
                tmp.append(" to ");
                tmp.append(dstPath);
                OLogger.debug(tmp);
            }
            if (!(cont = true)) {
                if (debug) {
                    tmp = new StringBuffer("REPORT: Users request no system modification, skip recursive copy from ");
                    tmp.append(srcPath);
                    tmp.append("  to  ");
                    tmp.append(dstPath);
                    OLogger.log(OLogger.FINE, tmp.toString());
                }
                return errorHasHappened;
            }
            try {
                if (!src.isDirectory() && !dst.isDirectory()) {
                    SystemCall.copyFile(src, dst);
                    return errorHasHappened;
                }
                if (!src.isDirectory() && dst.isDirectory()) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(src.getName());
                    SystemCall.copyFile(src, new File(tmpSb.toString()));
                    return errorHasHappened;
                }
            }
            catch (Throwable e2) {
                errorHasHappened = true;
                if (!errorOut) break block13;
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (src.isDirectory() && !dst.isDirectory()) {
            return errorHasHappened;
        }
        if (src.isDirectory() && dst.isDirectory()) {
            File[] lfiles = src.listFiles();
            File tmpF = null;
            for (int i2 = 0; i2 < lfiles.length; ++i2) {
                if (lfiles[i2].isDirectory()) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(lfiles[i2].getName());
                    tmpF = new File(tmpSb.toString());
                    if (!tmpF.exists() && !tmpF.mkdir()) {
                        return errorHasHappened;
                    }
                } else {
                    tmpF = dst;
                }
                boolean retVal = SystemCall.copyRecurse(lfiles[i2], tmpF, false, errorOut);
                errorHasHappened = errorHasHappened ? true : retVal;
            }
            return errorHasHappened;
        }
        return errorHasHappened;
    }

    protected static void backupRecurse(File src, File dst, boolean debug) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::backupRecurse()");
        StringBuffer tmpSb = null;
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        if (debug) {
            tmp.append(": from ");
            tmp.append(srcPath);
            tmp.append(" to ");
            tmp.append(dstPath);
            OLogger.debug(tmp);
        }
        if (!src.isDirectory() && !dst.isDirectory()) {
            SystemCall.copyFile(src, dst);
            return;
        }
        if (!src.isDirectory() && dst.isDirectory()) {
            tmpSb = new StringBuffer(dst.toString());
            tmpSb.append(File.separator);
            tmpSb.append(src.getName());
            SystemCall.copyFile(src, new File(tmpSb.toString()));
            return;
        }
        if (src.isDirectory() && !dst.isDirectory()) {
            return;
        }
        if (src.isDirectory() && dst.isDirectory()) {
            File[] lfiles = src.listFiles();
            File tmpF = null;
            for (int i2 = 0; i2 < lfiles.length; ++i2) {
                if (lfiles[i2].isDirectory()) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(lfiles[i2].getName());
                    tmpF = new File(tmpSb.toString());
                    if (!tmpF.exists() && !tmpF.mkdir()) {
                        return;
                    }
                } else {
                    tmpF = dst;
                }
                SystemCall.copyRecurse(lfiles[i2], tmpF, false);
            }
            return;
        }
    }

    protected static void deleteRecurse(String oracleHomePath, String cookedPatchID, File src, boolean debug) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::deleteRecurse(): ");
        tmp.append(src.toString());
        if (debug) {
            OLogger.debug(tmp);
        }
        String srcPath = src.getPath();
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        File patchStorateFile = new File(patchStorage);
        StringBuffer strCheck = new StringBuffer(patchStorateFile.getPath());
        if (debug) {
            tmp = new StringBuffer("SystemCall::deleteRecurse() check if the dir. to be deleted is ");
            tmp.append("a sub-directory of ");
            tmp.append(strCheck.toString());
            OLogger.debug(tmp);
        }
        if (!srcPath.startsWith(strCheck.toString())) {
            if (debug) {
                tmp = new StringBuffer("SystemCall::deleteRecurse() is called to delete ");
                tmp.append("some dir. outside OH/.patch_storage/<ID>.  Ignore delete request.");
                OLogger.debug(tmp);
            }
            return;
        }
        SystemCall.deleteRecurse(src, debug);
    }

    protected static void deleteRecurse(File src, boolean debug) {
        StringBuffer tmp = new StringBuffer("SystemCall::deleteRecurse(): ");
        tmp.append(src.toString());
        if (debug) {
            OLogger.debug(tmp);
        }
        StringBuffer tmpSb = null;
        if (!src.exists()) {
            return;
        }
        if (!src.isDirectory()) {
            src.delete();
            return;
        }
        if (src.isDirectory()) {
            File[] lfiles = src.listFiles();
            File tmpF = null;
            for (int i2 = 0; i2 < lfiles.length; ++i2) {
                tmpSb = new StringBuffer(src.toString());
                tmpSb.append(File.separator);
                tmpSb.append(lfiles[i2].getName());
                tmpF = new File(tmpSb.toString());
                SystemCall.deleteRecurse(tmpF, debug);
            }
            src.delete();
            return;
        }
    }

    protected static void touch(String filePath) {
        StringBuffer buff = new StringBuffer("SystemCall::touch(");
        buff.append(filePath);
        buff.append(")");
        OLogger.debug(buff);
        File file = new File(filePath);
        if (file.exists() && file.canWrite() && file.isFile()) {
            long lastModTime = file.lastModified();
            Date date = new Date(lastModTime);
            buff = new StringBuffer(filePath);
            buff.append(" old time: ");
            buff.append(date.toString());
            OLogger.debug(buff);
            long newModTime = System.currentTimeMillis();
            if (!file.setLastModified(newModTime)) {
                OLogger.error("SystemCaller::touch(): Can't change modified time of file" + filePath);
            } else {
                Date newDate = new Date(file.lastModified());
                buff = new StringBuffer(filePath);
                buff.append(" new time: ");
                buff.append(newDate.toString());
                OLogger.debug(buff);
            }
        }
    }

    protected static ExecReturn runArchive(String oracleHomePath, String src, String dst) {
        boolean cont = Rules.SystemWrite_continue();
        OPatchProperty opp = new OPatchProperty();
        StringBuffer archiveCommand = null;
        try {
            archiveCommand = new StringBuffer(opp.getArchiveCommand());
        }
        catch (Exception exception) {
            // empty catch block
        }
        archiveCommand.append(" -rc");
        archiveCommand.append(" ");
        archiveCommand.append(dst);
        archiveCommand.append(" ");
        archiveCommand.append(src);
        String cmd = archiveCommand.toString();
        StringBuffer buff = new StringBuffer("SystemCall::runArchive(), set archive command to \"");
        buff.append(cmd);
        buff.append("\"");
        OLogger.debug(buff);
        OLogger.log(OLogger.FINE, "Executing '" + cmd + "'");
        String[] cmds = new String[]{cmd};
        ExecReturn ret = new ExecReturn(cmds);
        if (OPatchEnv.isWindows()) {
            StringBuffer winCmd = new StringBuffer("SystemCall::runArchive() on Windows: skip invoking \"");
            winCmd.append(buff.toString());
            winCmd.append("\"");
            OLogger.debug(winCmd);
            return ret;
        }
        if (cont) {
            buff = new StringBuffer("SystemCall::runArchive() on Unix, invoking \"");
            buff.append(cmd);
            buff.append("\"");
            OLogger.debug(buff);
            ret = SystemCall.runtimeExec(cmd);
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(cmd);
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    protected static ExecReturn runMake(StdoutStatus caller, String makeCmd, String runDirPath) throws RuntimeException {
        boolean cont = Rules.SystemWrite_continue();
        StringBuffer buff = new StringBuffer("SystemCall::runMake(): \"");
        buff.append(makeCmd);
        buff.append("\" under \"");
        buff.append(runDirPath);
        buff.append("\"");
        OLogger.debug(buff);
        String[] cmds = new String[]{makeCmd};
        ExecReturn ret = new ExecReturn(cmds);
        OLogger.debug(buff);
        if (cont) {
            ret = SystemCall.runtimeExec(cmds, runDirPath);
            caller.printStdout(ret);
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(makeCmd);
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    protected static ExecReturn runPatchGen(String patchgenCmd) {
        boolean cont = Rules.SystemWrite_continue();
        StringBuffer buff = new StringBuffer("SystemCall::runPatchGen(): \"");
        buff.append(patchgenCmd);
        buff.append("\"");
        OLogger.debug(buff);
        String[] cmds = new String[]{patchgenCmd.toString()};
        ExecReturn ret = new ExecReturn(cmds);
        OLogger.debug(buff);
        if (cont) {
            ret = SystemCall.runtimeExec(patchgenCmd.toString());
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(patchgenCmd.toString());
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    public static boolean createNewFile(String filePath) throws RuntimeException {
        File newFile = new File(filePath);
        String parentDirName = newFile.getParent();
        File parentFile = new File(parentDirName);
        if (!newFile.exists()) {
            try {
                boolean ok;
                if (!parentFile.exists() && !(ok = parentFile.mkdirs())) {
                    StringBuffer buff = new StringBuffer("SystemCall::createNewFile(String) cannot mkdirs on ");
                    buff.append(parentFile.getPath());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
                newFile.createNewFile();
                return true;
            }
            catch (Exception e2) {
                StringBuffer buff = new StringBuffer("SystemCall::createNewFile(String) failed to create file  ");
                buff.append(filePath);
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
        }
        return false;
    }

    public static boolean isClusterwareUp(String oracleHomePath) {
        return SystemCall.isClusterwareUp(oracleHomePath, null);
    }

    public static boolean isClusterwareUp(String oracleHomePath, String nodeName) {
        ExecReturn rt;
        boolean isUp = false;
        String crsCmd = oracleHomePath + File.separator + StringResource.CRS_STACK_CHECK_COMMAND;
        if (nodeName != null) {
            crsCmd = crsCmd + " -n " + nodeName;
        }
        if ((rt = SystemCall.runtimeExec(crsCmd)).isOK()) {
            String msg = rt.getNormalMessage();
            boolean all = true;
            for (int i2 = 0; i2 < StringResource.CRS_STACK_UP_MSGS.length; ++i2) {
                if (msg.contains(StringResource.CRS_STACK_UP_MSGS[i2])) continue;
                all = false;
            }
            if (all) {
                isUp = true;
            }
        }
        return isUp;
    }

    public static boolean isDatabaseUp(String oracleHomePath, String nodeName) {
        String[] env;
        boolean isUp = false;
        String stfile = oracleHomePath + File.separator + StringResource.HOME_STATUS_FILE;
        File statf = new File(stfile);
        if (statf.exists()) {
            statf.delete();
        }
        String srvctlCmd = oracleHomePath + File.separator + StringResource.HOME_STATUS_COMMAND;
        srvctlCmd = nodeName != null && !nodeName.equals("") ? srvctlCmd + " -o " + oracleHomePath + " -s " + stfile + " -n " + nodeName : srvctlCmd + " -o " + oracleHomePath + " -s " + stfile;
        String[] cmds = new String[]{srvctlCmd};
        ExecReturn rt = SystemCall.runtimeExec(cmds, env = new String[]{"ORACLE_HOME=" + oracleHomePath}, null, null, false);
        if (rt.isOK() && !rt.getNormalMessage().equals("")) {
            isUp = true;
        }
        return isUp;
    }

    public static boolean isDBInstanceUp(String oracleHome, String dbname, String nodename) {
        boolean up = false;
        StringBuffer command = new StringBuffer(oracleHome);
        command.append(File.separator).append(StringResource.INSTANCE_STATUS_COMMAND);
        command.append(" -db ").append(dbname);
        command.append(" -node ").append(nodename);
        String[] cmds = new String[]{command.toString()};
        String[] env = new String[]{"ORACLE_HOME=" + oracleHome};
        ExecReturn rt = SystemCall.runtimeExec(cmds, env, null, null, false);
        if (rt.isOK()) {
            int index = rt.getNormalMessage().indexOf("not running");
            if (index < 0) {
                up = true;
            }
        } else {
            OLogger.debug("ERROR: " + rt.getErrorMessage());
        }
        return up;
    }

    public static void setOPatchLogOutput(boolean value) {
        ReaderThread.printOnLog = value;
    }

    public static void setConsoleOutput(boolean value) {
        ReaderThread.printConsole = value;
    }

    public static class ExecReturn {
        String[] systemCommand;
        String errorMessage;
        String normalMessage;
        int retCode;
        boolean ok;

        public ExecReturn(String[] cmd) {
            this.systemCommand = cmd;
            this.errorMessage = "";
            this.normalMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public String getCommand() {
            if (this.systemCommand != null) {
                StringBuffer cmd = new StringBuffer();
                for (int i2 = 0; i2 < this.systemCommand.length; ++i2) {
                    cmd.append(this.systemCommand[i2]);
                    cmd.append("\n");
                }
                return cmd.toString();
            }
            return "Command not intialized";
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNormalMessage() {
            return this.normalMessage;
        }

        public int getReturnCode() {
            return this.retCode;
        }

        public boolean isOK() {
            return this.ok;
        }

        protected void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        protected void setNormalMessage(String msg) {
            this.normalMessage = msg;
        }

        protected void setReturnCode(int c2) {
            this.retCode = c2;
            this.ok = this.retCode == 0;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[SystemCall.ExecReturn: ");
            buff.append("systemCommand= (");
            if (this.systemCommand == null) {
                buff.append("null");
            } else {
                for (int i2 = 0; i2 < this.systemCommand.length; ++i2) {
                    String cmd = this.systemCommand[i2];
                    if (cmd == null) continue;
                    buff.append("\"");
                    buff.append(cmd);
                    buff.append("\"");
                    if (i2 == this.systemCommand.length - 1) continue;
                    buff.append(", ");
                }
                buff.append(")");
            }
            buff.append(", errMsg= ");
            buff.append(this.errorMessage);
            buff.append(", normalMsg= ");
            buff.append(this.normalMessage);
            buff.append(", return code= ");
            buff.append(this.retCode);
            buff.append(", exec. ok= ");
            buff.append(this.ok);
            buff.append("]");
            return buff.toString();
        }
    }
}

