/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rac;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchFmwPointer;

public class Rules {
    public static boolean shouldSetMakeActionFailed(MakeAction ma, boolean noRelink) {
        return false;
    }

    public static boolean shouldErrorOnBugSuperset() {
        boolean noBugSuperset = OPatchEnv.isNoBugSuperset();
        return noBugSuperset;
    }

    public static boolean shouldSkipSubset() {
        return OPatchEnv.isSkipSubset();
    }

    public static boolean shouldSkipDuplicate() {
        return OPatchEnv.isSkipDuplicate();
    }

    public static boolean shouldIgnoreConflict() {
        boolean ignoreConflict = OPatchEnv.isIgnoreConflict();
        return ignoreConflict;
    }

    public static boolean shouldPromptInCaseOfConflict(String oracleHomePath) {
        boolean force = OPatchEnv.isForce();
        boolean forceConflict = OPatchEnv.isForceConflict();
        return !force && !forceConflict;
    }

    public static boolean shouldCreateProductByForceSilent() {
        boolean forceSilent = OPatchEnv.isForce() && OPatchEnv.isSilent();
        return !forceSilent;
    }

    public static boolean shouldCreateProductBySilent() {
        boolean forcesilent = OPatchEnv.isSilent() && !OPatchEnv.isForce();
        return !forcesilent;
    }

    public static boolean shouldContinueInCaseOfPrePostError(String msg) {
        boolean result = true;
        result = OPatchEnv.isForce() ? OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer(msg)) : OPatchEnv.proceedWithOperationDefaultNo(new StringBuffer(msg));
        return result;
    }

    public static boolean shouldIgnoreErrorToContinue() {
        return false;
    }

    public static boolean OUIRead_continue() {
        return true;
    }

    public static boolean OUIWrite_continue() {
        boolean report = OPatchEnv.isReport();
        return !report;
    }

    public static boolean SystemWrite_continue() {
        boolean report = OPatchEnv.isReport();
        return !report;
    }

    public static boolean shouldSwitchONAutoRollback(String oracleHomePath) {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 1) {
            return true;
        }
        return modelCode != 2;
    }

    public static boolean shouldMergedOneOffsInHand(String oracleHomePath) {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        return modelCode != 2;
    }

    public static boolean shouldErrorOnConflict(OneOffEntry incomingPatch, OneOffEntry insidePatch, String oracleHomePath) {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            String incomingPatchType = incomingPatch.getPatchType();
            String insidePatchType = insidePatch.getPatchType();
            boolean ignoreConflict = incomingPatchType.equals("snowball") && insidePatchType.equals("snowball") || incomingPatchType.equals("singleton") && insidePatchType.equals("snowball");
            return !ignoreConflict;
        }
        return true;
    }

    public static boolean shouldErrorOnConflictAmongPatches(OneOffEntry incomingPatch, OneOffEntry insidePatch, String oracleHomePath) {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            String incomingPatchType = incomingPatch.getPatchType();
            String insidePatchType = insidePatch.getPatchType();
            boolean ignoreConflict = incomingPatchType.equals("snowball") && insidePatchType.equals("snowball") || incomingPatchType.equals("singleton") && insidePatchType.equals("snowball") || insidePatchType.equals("singleton") && incomingPatchType.equals("snowball");
            return !ignoreConflict;
        }
        return true;
    }

    public static boolean isPatchingDiffForJarAction(PatchObject po, JarAction ja, String oracleHomePath) {
        if (ja.isMultiLevel()) {
            return false;
        }
        HashMap hm = po.clubbedJars;
        if (hm.isEmpty() || hm.size() == 0) {
            return false;
        }
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(ja.getJarPath());
        dst.append(File.separator);
        dst.append(ja.getJarName());
        ArrayList myList = (ArrayList)hm.get(dst.toString());
        return myList != null && myList.size() > 1;
    }

    public static boolean isMkPatchRequired() {
        long minLongVersion;
        long curLongVersion;
        if (OPatchEnv.isWindows()) {
            return false;
        }
        String rawCurVersion = OPatchEnv.getCallerVersion();
        String curVersion = rawCurVersion.replaceAll("\\.", "");
        String minVersion = "11.2.0.1.1";
        minVersion = minVersion.replaceAll("\\.", "");
        try {
            curLongVersion = Long.parseLong(curVersion);
            minLongVersion = Long.parseLong(minVersion);
        }
        catch (NumberFormatException e2) {
            OLogger.printStackTrace(e2);
            return true;
        }
        return curLongVersion < minLongVersion;
    }

    public static boolean SystemRead_continue() {
        return true;
    }

    public static boolean shouldReadPatchFromInv(String inID) {
        return true;
    }

    public static RacPatchOrder getRacPatchOrder(Rac.RacType racType, boolean local, boolean rolling, boolean minDowntime, boolean allNode, boolean silent) {
        if (local) {
            return RacPatchOrder.LOCAL;
        }
        if (racType == Rac.RacType.NO_RAC || racType == Rac.RacType.SINGLE_NODE) {
            return RacPatchOrder.LOCAL;
        }
        if (allNode || OPatchEnv.isUserSuppliedNodes()) {
            return RacPatchOrder.ALL_NODES;
        }
        if (minDowntime) {
            if (silent) {
                return RacPatchOrder.ALL_NODES;
            }
            return RacPatchOrder.MIN_DOWN_TIME;
        }
        if (rolling) {
            if (silent) {
                return RacPatchOrder.ALL_NODES;
            }
            return RacPatchOrder.ROLLING;
        }
        return RacPatchOrder.ALL_NODES;
    }

    protected static boolean printHomes(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail) {
        return optAll;
    }

    protected static boolean printByBugsFixed(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail, boolean optBugsFixed) {
        return optBugsFixed;
    }

    protected static boolean printLangPatch(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail, boolean transPatch) {
        return transPatch;
    }

    protected static boolean printAllProducts(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail) {
        return !optPatch && optDetail;
    }

    protected static boolean printTopLevelProducts(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail) {
        return !optPatch;
    }

    protected static boolean printOneOffs(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail, boolean optBugsFixed, boolean optLangPatch) {
        return !optBugsFixed && !optLangPatch;
    }

    protected static boolean printDetails(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail, boolean optBugsFixed, boolean optLangPatch) {
        return optDetail && !optBugsFixed && !optLangPatch;
    }

    protected static boolean printMatchedProducts(boolean optAll, boolean optProduct, boolean optMatch, boolean optPatch, boolean optDetail) {
        return optMatch;
    }

    protected static boolean printInstalledPatchInfo(boolean specifiedID, boolean specifiedLoc, boolean required, boolean bugs, boolean verify, boolean queryFile) {
        return !specifiedLoc && !verify && !queryFile;
    }

    protected static boolean printStagedPatchInfo(boolean specifiedID, boolean specifiedLoc, boolean required, boolean bugs, boolean verify, boolean queryFile) {
        return specifiedLoc && !verify;
    }

    protected static boolean shouldVerifyPatchExist(boolean specifiedID, boolean specifiedLoc, boolean required, boolean bugs, boolean verify, boolean queryFile) {
        return verify && specifiedID;
    }

    protected static boolean shouldQueryFile(boolean specifiedID, boolean specifiedLoc, boolean required, boolean bugs, boolean verify, boolean queryFile) {
        return queryFile;
    }

    protected static boolean verifyStagedPatch(boolean specifiedID, boolean specifiedLoc, boolean required, boolean bugs, boolean verify, boolean queryFile) {
        return specifiedLoc && verify;
    }

    protected static boolean shouldWarnAboutBackupForRestoreDelay(int nComponents) {
        return nComponents > 0;
    }

    protected static boolean shouldWarnAboutBackupForRollbackDelay(int nComponents) {
        return nComponents > 0;
    }

    protected static boolean shouldNotSupportAutoRollback(boolean bugSuperset, boolean bugConflict, boolean fileConflict, Rac rac, Rac.RacType racType, PatchObject patchObject) {
        StringBuffer buff = new StringBuffer("shouldNotSupportAutoRollback() returns false");
        OLogger.debug(buff);
        return false;
    }

    public static boolean shouldDoMiddlewareHomeOCM() {
        String mwHome = OPatchEnv.getMiddlewareHome();
        StringBuffer registryFilePath = new StringBuffer(mwHome);
        registryFilePath.append(File.separator);
        registryFilePath.append("registry.dat");
        File registryFile = new File(registryFilePath.toString());
        if (!registryFile.exists()) {
            return false;
        }
        boolean noMwInstall = OPatchFmwPointer.isFmwUserOptionsError(OPatchFmwEnv.isUserSpecifiedMWH() ? 4 : 0);
        return mwHome != null && !mwHome.equals("") && !noMwInstall;
    }

    protected static boolean shouldNotSupportAutoRollback(Rac.RacType racType, PatchObject patchObject) {
        return false;
    }

    protected static boolean shouldCheckRACPrereq() {
        return true;
    }

    protected static boolean shouldRunMake() {
        if (OPatchEnv.isWindows()) {
            return false;
        }
        if (OPatchEnv.isNolink()) {
            return false;
        }
        boolean systemWrite = Rules.SystemWrite_continue();
        return systemWrite;
    }

    protected static boolean shouldWarnAboutRemoteRelink(String oracleHomePath, PatchObject po) {
        if (!Rules.shouldRunMake()) {
            return false;
        }
        return po.hasApplicableMakeActions(oracleHomePath);
    }

    public static boolean shouldSearchOrInvokeFuser(String[] executables) {
        StringBuffer buff = new StringBuffer("Rules::shouldSearchOrInvokeFuser()");
        OLogger.debug(buff);
        boolean userSetOPATCH_NO_FUSER = OPatchEnv.isOPATCH_NO_FUSER();
        if (OPatchEnv.isWindows()) {
            buff = new StringBuffer("  This is Windows, return false.");
            OLogger.debug(buff);
            return false;
        }
        if (userSetOPATCH_NO_FUSER) {
            buff = new StringBuffer("  user set OPATCH_NO_FUSER, return false.");
            OLogger.debug(buff);
            return false;
        }
        if (executables == null || executables.length <= 0) {
            buff = new StringBuffer("  user didn't set OPATCH_NO_FUSER but ");
            buff.append("executable list is either null or empty, return false.");
            OLogger.debug(buff);
            return false;
        }
        buff = new StringBuffer("  user didn't set OPATCH_NO_FUSER and ");
        buff.append("executable list is > 0, return true.");
        OLogger.debug(buff);
        return true;
    }

    protected static boolean shouldCreateRacFile() {
        boolean isCreateRacFile = OPatchEnv.isCreateRacFile();
        boolean isReport = OPatchEnv.isReport();
        return isCreateRacFile;
    }

    public static boolean shouldTryToErrorOutOnRunSql() {
        return !OPatchEnv.isForce();
    }

    public static boolean isAutomatable(PatchObject po) {
        String productFamily = po.getProductFamily();
        if (!productFamily.equalsIgnoreCase("fmw") && !productFamily.equalsIgnoreCase("fusionapps")) {
            return false;
        }
        return po.getPatchInventory().isAuto();
    }

    protected static boolean shouldPauseOnErrorOnNodes(String[] nodes) {
        return true;
    }

    public static int isErrorTagPresentInMakeStdErr(String stderrMsg) {
        if (stderrMsg != null && !stderrMsg.equals("")) {
            String toLowerMsg = stderrMsg.toLowerCase();
            int keyIndex = 0;
            for (int i2 = 0; i2 < StringResource.ERROR_STRINGS.length; ++i2) {
                if ((keyIndex = toLowerMsg.indexOf(StringResource.ERROR_STRINGS[i2], keyIndex)) == -1) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean shouldSkipLoadChecksumXmlForOHPatches() {
        String sessionType = OPatchEnv.getSessionType();
        return sessionType.equals("util") || sessionType.equals("apply") || sessionType.equals("rollback");
    }

    public String toString() {
        boolean ouiRead = Rules.OUIRead_continue();
        boolean ouiWrite = Rules.OUIWrite_continue();
        boolean systemWrite = Rules.SystemWrite_continue();
        boolean systemRead = Rules.SystemRead_continue();
        boolean optAll = OPatchEnv.isLsinv_all();
        boolean optXML = OPatchEnv.isLsinv_xml();
        boolean optMatch = OPatchEnv.isLsinv_match();
        boolean optPatch = OPatchEnv.isLsinv_patch();
        boolean optDetail = OPatchEnv.isLsinv_detail();
        boolean optBugsFixed = OPatchEnv.isSortByBugsFixed();
        boolean optLangPatch = OPatchEnv.isTransPatch();
        boolean printHome = Rules.printHomes(optAll, optXML, optMatch, optPatch, optDetail);
        boolean printAllProduct = Rules.printAllProducts(optAll, optXML, optMatch, optPatch, optDetail);
        boolean printTopLevel = Rules.printTopLevelProducts(optAll, optXML, optMatch, optPatch, optDetail);
        boolean printMatchedProduct = Rules.printMatchedProducts(optAll, optXML, optMatch, optPatch, optDetail);
        boolean printPatch = Rules.printOneOffs(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optLangPatch);
        boolean printDetail = Rules.printDetails(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optLangPatch);
        boolean printByBugsFixed = Rules.printByBugsFixed(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed);
        boolean printLanguagePatches = Rules.printLangPatch(optAll, optXML, optMatch, optPatch, optDetail, optLangPatch);
        StringBuffer buff = new StringBuffer("[Rules: ");
        buff.append(", read from OUI= ");
        buff.append(ouiRead);
        buff.append(", write to OUI= ");
        buff.append(ouiWrite);
        buff.append(", read from system= ");
        buff.append(systemRead);
        buff.append(", write to system= ");
        buff.append(systemWrite);
        buff.append(", -all= ");
        buff.append(optAll);
        buff.append(", -xml= ");
        buff.append(optXML);
        buff.append(", -match= ");
        buff.append(optMatch);
        buff.append(", -patch= ");
        buff.append(optPatch);
        buff.append(", -detail= ");
        buff.append(optDetail);
        buff.append(", print patch = ");
        buff.append(printPatch);
        buff.append(", print all prods = ");
        buff.append(printAllProduct);
        buff.append(", print top-level prod = ");
        buff.append(printTopLevel);
        buff.append(", print detail = ");
        buff.append(printDetail);
        buff.append(", print by-bugs fixed = ");
        buff.append(printByBugsFixed);
        buff.append(", print translation patches = ");
        buff.append(printLanguagePatches);
        buff.append(" ]");
        return buff.toString();
    }

    public static void main(String[] args) {
        System.out.println("Rules::main()");
        Rules rule = new Rules();
        String str = rule.toString();
        System.out.println(str);
    }

    public static class RacPatchOrder {
        String order;
        public static final RacPatchOrder LOCAL = new RacPatchOrder("LOCAL");
        public static final RacPatchOrder MIN_DOWN_TIME = new RacPatchOrder("MIN_DOWN_TIME");
        public static final RacPatchOrder ROLLING = new RacPatchOrder("ROLLING");
        public static final RacPatchOrder ALL_NODES = new RacPatchOrder("ALL_NODES");

        private RacPatchOrder(String order) {
            this.order = order;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(this.order);
            boolean silent = OPatchEnv.isSilent();
            if (silent) {
                buff.append(" [-silent used, patch order was changed to ");
                buff.append("ALL_NODES");
                buff.append("]");
            }
            return buff.toString();
        }
    }
}

