/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;
import oracle.opatch.Bug;
import oracle.opatch.Platform;
import oracle.opatch.TargetEntity;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.opatchlogger.OLogger;

public class PatchInventory {
    public String patchID;
    private String pseNumber = "";
    private String tmpPseNumber = "";
    public LinkedList bugsToFix;
    public LinkedList supportedPlatforms;
    LinkedList executablesList;
    boolean instanceShutdown = false;
    boolean rollingPatch = false;
    boolean rollbackable = true;
    boolean auto = false;
    boolean cannotAutoRollback = false;
    boolean sqlPatch = false;
    String sqlPatchDatabaseStartupMode = "";
    boolean isFmwRolling = false;
    boolean isFmwFeatureBearing = false;
    boolean inHouseTestingPatch = false;
    private String patchLanguage = "en";
    private String patchModel = "one-off";
    boolean translatable = false;
    boolean translation = false;
    boolean exitIfPreScriptError = false;
    private String patchDescription = "";
    private String bundleDescription = "";
    private String rawCreationDate;
    private String formatCreationDate;
    protected String creationYear = "";
    protected String creationMonth = "";
    protected String creationDay = "";
    protected String creationTime = "";
    protected String creationZone = "";
    protected ArrayList prereqOneOffs;
    protected ArrayList coreqOneOffs;
    protected ArrayList overLayOneOffs;
    protected ArrayList wlsPrereqOneOffs;
    protected ArrayList prereqBugsList;
    protected String eSysPatchID = "";
    protected String minOPatchVersion = "";
    protected String instanceShutdownMessage = "";
    protected String patchType = "singleton";
    protected String applicableProductType = "";
    protected String productFamily = "";
    protected ArrayList systemComponentList;
    protected ArrayList applicationShutdownList;
    protected ArrayList productsList;
    protected boolean sqlMigrate = false;
    protected boolean isMiniPatchSet = false;
    protected ArrayList updateComps;
    public String constituentActiveField = null;
    protected ArrayList targetEntities;
    protected String[] dateTimeFormatStrings = new String[]{"dd MMM yyyy, HH:mm:ss 'hrs'", "dd MMM yyyy, HH:mm:ss"};

    public PatchInventory() {
        this.bugsToFix = new LinkedList();
        this.supportedPlatforms = new LinkedList();
        this.executablesList = new LinkedList();
        this.prereqOneOffs = new ArrayList();
        this.wlsPrereqOneOffs = new ArrayList();
        this.prereqBugsList = new ArrayList();
        this.coreqOneOffs = new ArrayList();
        this.overLayOneOffs = new ArrayList();
        this.systemComponentList = new ArrayList();
        this.applicationShutdownList = new ArrayList();
        this.productsList = new ArrayList();
        this.updateComps = new ArrayList();
        this.targetEntities = new ArrayList();
    }

    public void setCreationTime(String year, String month, String day, String time, String zone) {
        this.creationYear = year;
        this.creationMonth = month;
        this.creationDay = day;
        this.creationTime = time;
        this.creationZone = zone;
    }

    protected void setProductsList(ArrayList pList) {
        this.productsList = pList;
    }

    protected void setAuto(boolean in) {
        this.auto = in;
    }

    protected void setTranslatable(boolean in) {
        this.translatable = in;
    }

    protected void setExitIfPreScriptError(boolean in) {
        this.exitIfPreScriptError = in;
    }

    protected void couldBeTranslation(boolean in) {
        this.translation = in;
    }

    protected void setPatchModel(String patchModel) {
        this.patchModel = patchModel;
    }

    protected void setPatchLanguage(String patchLanguage) {
        this.patchLanguage = patchLanguage;
    }

    protected void setUpdateCompsList(ArrayList compList) {
        this.updateComps = compList;
    }

    protected void setPatchDescription(String desc) {
        this.patchDescription = desc;
    }

    protected void setBundleDescription(String desc) {
        this.bundleDescription = desc;
    }

    protected void setPSENumber(String inNumber) {
        this.pseNumber = inNumber;
    }

    protected void setTmpPSENumber(String inNumber) {
        this.tmpPseNumber = inNumber;
    }

    public void setFormatCreationDate(String s) {
        this.formatCreationDate = s;
    }

    public void setRawCreationDate(String s) {
        this.rawCreationDate = s;
    }

    protected String getMinOPatchVersion() {
        return this.minOPatchVersion;
    }

    protected void setMinOPatchVersion(String s) {
        this.minOPatchVersion = s;
    }

    protected String getFormatCreationDate() {
        return this.formatCreationDate;
    }

    protected String getRawCreationDate() {
        return this.rawCreationDate;
    }

    protected String getCreationZone() {
        return this.creationZone;
    }

    protected Date parseDateTime(String dateString, String zone) {
        for (String formatString : this.dateTimeFormatStrings) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(formatString, Locale.ENGLISH);
                df.setTimeZone(TimeZone.getTimeZone(zone));
                return df.parse(dateString);
            }
            catch (ParseException df) {
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
        }
        return null;
    }

    public long convertToUnixTime(String time, String zone) {
        long unixtime = 0L;
        Date date = this.parseDateTime(time, zone);
        if (date != null) {
            unixtime = date.getTime();
        }
        return unixtime;
    }

    public String getPSENumber() {
        if (this.pseNumber == "") {
            return this.getTmpPSENumber();
        }
        return this.pseNumber;
    }

    protected String getTmpPSENumber() {
        if (this.tmpPseNumber == "") {
            long unix = this.convertToUnixTime(this.getRawCreationDate(), this.getCreationZone());
            return Long.toString(unix * -1L);
        }
        return this.tmpPseNumber;
    }

    public String getPatchLanguage() {
        return this.patchLanguage;
    }

    public String getPatchDescription() {
        return this.patchDescription;
    }

    protected String getBundleDescription() {
        return this.bundleDescription;
    }

    public String getPatchModel() {
        return this.patchModel;
    }

    public ArrayList getUpdateCompsList() {
        return this.updateComps;
    }

    public boolean isMiniPatchSet() {
        return this.isMiniPatchSet;
    }

    public boolean isAuto() {
        return this.auto;
    }

    protected boolean isTranslatable() {
        return this.translatable;
    }

    protected boolean isExitIfPreScriptError() {
        return this.exitIfPreScriptError;
    }

    public boolean mayBeTranslation() {
        return this.translation;
    }

    protected void setMiniPatchSet(boolean in) {
        this.isMiniPatchSet = in;
    }

    protected String[] getPrereqOneOffs() {
        String[] oneOffs = new String[this.prereqOneOffs.size()];
        this.prereqOneOffs.toArray(oneOffs);
        return oneOffs;
    }

    protected WLSPatch[] getWlsPrereqOneOffs() {
        WLSPatch[] wp = new WLSPatch[this.wlsPrereqOneOffs.size()];
        for (int i2 = 0; i2 < wp.length; ++i2) {
            wp[i2] = (WLSPatch)this.wlsPrereqOneOffs.get(i2);
        }
        return wp;
    }

    protected String getESysPatchID() {
        return this.eSysPatchID;
    }

    protected void setESysPatchID(String eSysPatchID) {
        this.eSysPatchID = eSysPatchID;
    }

    protected TargetEntity[] getTargetEntities() {
        TargetEntity[] te = new TargetEntity[this.targetEntities.size()];
        for (int i2 = 0; i2 < te.length; ++i2) {
            te[i2] = (TargetEntity)this.targetEntities.get(i2);
        }
        return te;
    }

    protected String[] getPrereqBugList() {
        String[] bugList = new String[this.prereqBugsList.size()];
        this.prereqBugsList.toArray(bugList);
        return bugList;
    }

    protected String[] getCoreqOneOffs() {
        String[] oneOffs = new String[this.coreqOneOffs.size()];
        this.coreqOneOffs.toArray(oneOffs);
        return oneOffs;
    }

    protected String[] getOverLayOneOffs() {
        String[] oneOffs = new String[this.overLayOneOffs.size()];
        this.overLayOneOffs.toArray(oneOffs);
        return oneOffs;
    }

    public boolean isSqlMigrate() {
        return this.sqlMigrate;
    }

    public String toString() {
        NameVersionPair p2;
        Object oneoff;
        Object obj;
        StringBuffer sb = new StringBuffer();
        sb.append("[PatchInventory: PatchID= ");
        sb.append(this.patchID);
        sb.append(", isMiniPatchSet = ");
        sb.append(this.isMiniPatchSet);
        sb.append(", CreationDate = ");
        sb.append(this.formatCreationDate);
        sb.append(", [ Bug = ");
        ListIterator iter = this.bugsToFix.listIterator();
        if (!iter.hasNext() && !iter.hasPrevious()) {
            sb.append(" No bug ");
        }
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof Bug)) continue;
            Bug bug = (Bug)obj;
            sb.append(bug.toString());
            sb.append(", ");
        }
        sb.append("], [ Platform = ");
        iter = this.supportedPlatforms.listIterator();
        if (!iter.hasNext() && !iter.hasPrevious()) {
            sb.append(" No platform ");
        }
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof Platform)) continue;
            Platform plf = (Platform)obj;
            sb.append(plf.toString());
            sb.append(", ");
        }
        sb.append(", [ Executables = ");
        iter = this.executablesList.listIterator();
        if (!iter.hasNext() && !iter.hasPrevious()) {
            sb.append(" No executables ");
        }
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof String)) continue;
            String exe = (String)obj;
            sb.append(" (");
            sb.append(exe);
            sb.append("), ");
        }
        sb.append("], Instance_shutdown = ");
        sb.append(Boolean.toString(this.instanceShutdown));
        sb.append("], Instance shutdown message = ");
        sb.append(this.instanceShutdownMessage);
        sb.append(", Online_rac_installable= ");
        sb.append(Boolean.toString(this.rollingPatch));
        sb.append(", sql_patch= ");
        sb.append(Boolean.toString(this.sqlPatch));
        sb.append(", sql_patch_database_startup_mode= ");
        sb.append(this.sqlPatchDatabaseStartupMode);
        sb.append(", fmw_rolling= ");
        sb.append(Boolean.toString(this.isFmwRolling));
        sb.append(", fmw_feature_bearing= ");
        sb.append(Boolean.toString(this.isFmwFeatureBearing));
        sb.append(", SQl_migrate= ");
        sb.append(Boolean.toString(this.sqlMigrate));
        sb.append("], Patch Type : ");
        sb.append(this.patchType);
        sb.append("], Product Family : ");
        sb.append(this.productFamily);
        sb.append("], Patching Model : ");
        sb.append(this.patchModel);
        sb.append("], Language Supported by the Patch : ");
        sb.append(this.patchLanguage);
        sb.append("], Translatable? : ");
        sb.append(this.translatable);
        sb.append("], Patch Description : ");
        sb.append(this.patchDescription);
        sb.append("}, Unique Patch Identifier : ");
        sb.append(this.pseNumber);
        sb.append("], Applicable Product Type : ");
        sb.append(this.applicableProductType);
        sb.append("]");
        sb.append(", [ Prereq Bugs = ");
        iter = this.prereqBugsList.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof String)) continue;
            oneoff = (String)obj;
            sb.append((String)oneoff);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", [ Prereq Oneoffs = ");
        iter = this.prereqOneOffs.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof String)) continue;
            oneoff = (String)obj;
            sb.append((String)oneoff);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", [ WLS Prereq Oneoffs = ");
        iter = this.wlsPrereqOneOffs.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof WLSPatch)) continue;
            oneoff = (WLSPatch)obj;
            sb.append("[");
            sb.append(((WLSPatch)oneoff).getPatchID());
            sb.append(" Required=" + ((WLSPatch)oneoff).isRequired());
            sb.append("] ");
        }
        sb.append("]");
        sb.append(", [ Coreq Oneoffs = ");
        iter = this.coreqOneOffs.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof String)) continue;
            oneoff = (String)obj;
            sb.append((String)oneoff);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", [ Overlay Oneoffs = ");
        iter = this.overLayOneOffs.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof String)) continue;
            oneoff = (String)obj;
            sb.append((String)oneoff);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", [ System component List = ");
        iter = this.systemComponentList.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            p2 = (NameVersionPair)obj;
            sb.append(" [ Name : ");
            sb.append(p2.getName());
            sb.append(" ] , [ Version : ");
            sb.append(p2.getVersions().toString());
            sb.append(" ] , [Shutdown : ");
            sb.append(p2.isShutdown());
            sb.append(" ] ");
        }
        sb.append("]");
        sb.append(", [ Application shutdown List = ");
        iter = this.applicationShutdownList.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            p2 = (NameVersionPair)obj;
            sb.append(" [ Name : ");
            sb.append(p2.getName());
            sb.append(" ] , [ Version : ");
            sb.append(p2.getVersions().toString());
            sb.append(" ] ");
        }
        sb.append("]");
        sb.append(", [ Products = ");
        iter = this.productsList.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            p2 = (NameVersionPair)obj;
            sb.append(" [ Name : ");
            sb.append(p2.getName());
            sb.append(" ] , [ Version : ");
            sb.append(p2.getVersions().toString());
            sb.append(" ] ");
        }
        sb.append("]");
        sb.append(", [ Components to be upgraded = ");
        iter = this.updateComps.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            UpdateComponent uc = (UpdateComponent)obj;
            sb.append("[ upgrade " + uc.getCompName());
            sb.append(" from  " + uc.getFromVersion());
            sb.append(" to " + uc.getToVersion() + " ] ");
        }
        sb.append("]");
        sb.append(", [ Applicable Target Entities = ");
        iter = this.targetEntities.listIterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof TargetEntity)) continue;
            TargetEntity te = (TargetEntity)obj;
            sb.append("[TargeType = ");
            sb.append(te.getTargetType());
            sb.append(" TargetVersion = " + te.getTargetVersion());
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }

    public NameVersionPair getNameVersionPairObject(String name, String ver) {
        return new NameVersionPair(name, ver);
    }

    public NameVersionPair getNameVersionPairObject(String name, ArrayList ver) {
        return new NameVersionPair(name, ver);
    }

    public NameVersionPair getNameVersionPairObject(String name, String ver, boolean shutdown) {
        return new NameVersionPair(name, ver, shutdown);
    }

    public NameVersionPair getNameVersionPairObject(String name, ArrayList ver, boolean shutdown) {
        return new NameVersionPair(name, ver, shutdown);
    }

    public boolean isInHouseTestingPatch() {
        return this.inHouseTestingPatch;
    }

    public class NameVersionPair {
        private String name;
        private ArrayList version;
        private boolean shutdown;

        public NameVersionPair(String name, String ver) {
            this.name = name;
            this.version = new ArrayList();
            this.version.add(ver);
            this.shutdown = false;
        }

        public NameVersionPair(String name, String ver, boolean shutdown) {
            this.name = name;
            this.version = new ArrayList();
            this.version.add(ver);
            this.shutdown = shutdown;
        }

        public NameVersionPair(String name, ArrayList ver) {
            this.name = name;
            this.version = ver;
            this.shutdown = false;
        }

        public NameVersionPair(String name, ArrayList ver, boolean shutdown) {
            this.name = name;
            this.version = ver;
            this.shutdown = shutdown;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList getVersions() {
            return this.version;
        }

        protected void setName(String val) {
            this.name = val;
        }

        protected void setVersions(ArrayList ver) {
            this.version = ver;
        }

        protected void addVersion(String ver) {
            this.version.add(ver);
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public boolean equals(Object nv) {
            NameVersionPair check = (NameVersionPair)nv;
            if (!this.getName().equals(check.getName())) {
                return false;
            }
            if (check.getVersions().size() == 1) {
                return this.getVersions().equals(check.getVersions());
            }
            return false;
        }
    }
}

