/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import oracle.glcm.opatch.content.api.CasApiException;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.api.IOracleHome;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.TwoPhaseMatchType;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.TwoPhaseOperations;
import oracle.opatch.twophase.TwoPhasePatching;
import oracle.sysman.oii.oiic.OiicInventoryOperationHelper;
import oracle.sysman.oii.oiix.OiixFunctionOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OPatchOverCAS {
    INSTANCE;

    private boolean init = false;
    private String oh = OPatchEnv.getOracleHome();
    private OPatchCASOracleHome coh;

    private void initialize() {
        if (this.init) {
            return;
        }
        this.coh = new OPatchCASOracleHome(this.oh, ".cas");
        this.init = true;
    }

    public void serializeData(String oh, OPatchPatch[] pis) {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            OneOffEntry[] oneoffs = new OneOffEntry[pis.length];
            for (int i2 = 0; i2 < pis.length; ++i2) {
                oneoffs[i2] = pis[i2].getOneOffEntry();
            }
            IndexPair data = OPatchSessionHelper.getHashCodes(oh, oneoffs);
            serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "main_oh_hash.txt", data.getFirstKey());
            serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "pi_cas_key.txt", data.getSecondKey());
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("serialize data error");
            e2.printStackTrace();
        }
    }

    public IndexPair deserializeData(String oh) {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            String ohHash = serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "main_oh_hash.txt");
            String keyHash = serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "pi_cas_key.txt");
            IndexPair data = new IndexPair(ohHash, keyHash);
            return data;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("deserialize data error");
            e2.printStackTrace();
            return null;
        }
    }

    public void initializeCAS(String oracleHomePath) {
        OLogger.printlnOnLogAndVerbose("OPatchOverCAS::Start CAS Initialization for NApply.");
        try {
            OPatchCASOracleHome coh = new OPatchCASOracleHome(oracleHomePath, ".cas");
            CASServices.Initialize((IOracleHome)coh);
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("initialize CAS error");
            e2.printStackTrace();
        }
    }

    public void cleanupCAS() {
        OLogger.printlnOnLogAndVerbose("OPatchOverCAS::Start CAS Cleanup for NApply.");
        try {
            CASServices.Cleanup();
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("cleanup CAS error");
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void prepareSnowballPatching() throws CasApiException {
        block22: {
            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                tBuff = new StringBuffer("OPatch cannot run CAS NApply");
                tBuff.append("in the env that is not CAS enabled. ");
                OLogger.println(tBuff.toString());
                re = new RuntimeException(tBuff.toString());
                throw re;
            }
            OLogger.printlnOnLogAndVerbose("OPatchOverCAS::Start CAS NApply phase1.");
            cas = new CASFileServices();
            branchKey = "";
            try {
                block21: {
                    this.initialize();
                    branchKey = OPatchEnv.getBranchKey();
                    if (branchKey.equals("SDK")) {
                        this.initializeCAS(this.oh);
                    }
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS::enable CAS/buildCasStore.");
                    cas.build();
                    soh = this.coh.getCASStoragePath() + File.separator + branchKey;
                    sohPath = this.oh + File.separator + soh;
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS::destroy previous branch.");
                    cas.destroy(soh);
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS::create Shadow OH/createBranchOH, soh path is " + sohPath);
                    copy = new HashMap<Path, String>();
                    inv = Paths.get("inventory", new String[0]);
                    copy.put(inv, "inventory");
                    others = this.getCopiedFiles(sohPath);
                    for (Map.Entry<Path, String> entry : others.entrySet()) {
                        copy.put(entry.getKey(), entry.getValue());
                    }
                    OLogger.printlnOnLog("OPatchOverCAS: copy list to shadow home is: " + copy);
                    cas.create(sohPath, copy, null);
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS::attachhome for Shadow OH");
                    props = System.getProperties();
                    props.setProperty("oracle.installer.scratchPath", "/tmp");
                    isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(true);
                    }
                    try {
                        strArgs = "";
                        strArgs = strArgs.concat(" -force ");
                        strArgs = strArgs.concat(" -nogenerateGUID ");
                        params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
                        OiicInventoryOperationHelper.attachHome((String)sohPath, (String)"soh", (String[])params);
                        var13_18 = null;
                        ** if (isConsoleOutputDisabled) goto lbl-1000
                    }
                    catch (Throwable var12_20) {
                        var13_19 = null;
                        if (!isConsoleOutputDisabled) {
                            OLogger.enableConsoleOutput(true);
                        }
                        throw var12_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        OLogger.enableConsoleOutput(true);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block21;
                        catch (Exception e) {
                            e.printStackTrace();
                            var13_18 = null;
                            if (!isConsoleOutputDisabled) {
                                OLogger.enableConsoleOutput(true);
                            }
                        }
                    }
                }
                OLogger.printlnOnLogAndVerbose("OPatchOverCAS::copy over comps.xml from origianl OH to Shadow OH after attachhome");
                oComps = new File(IPMUtil.getCompsXMLLocation(this.oh));
                sComps = new File(IPMUtil.getCompsXMLLocation(sohPath));
                SystemCall.copyFile(oComps, sComps);
                if (branchKey.equals("SDK")) {
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS::copy over cached files from origianl OH to Shadow OH for SDK");
                    oOneoffs = new File(OPatchEnv.getPrereqResultFileLoc(this.oh));
                    sOneoffs = new File(OPatchEnv.getPrereqResultFileLoc(sohPath));
                    this.copyCachedFiles(oOneoffs, sOneoffs);
                }
                pis = OPatchUtilHelper.getPatchesToApply(sohPath, null, OPatchEnv.getNApplySessionName());
                key = new OPatchPatchKey(pis[0], "napply");
                OLogger.printlnOnLogAndVerbose("OPatchOverCAS::beginPatchBranch with patchkey = " + key.toString());
                cas.begin(key);
                OLogger.printlnOnLogAndVerbose("OPatchOverCAS::NApply to shadow OH");
                props.setProperty("oracle.installer.attachHome", "false");
                NApply.legacy_process(sohPath);
                OLogger.printlnOnLogAndVerbose("OPatchOverCAS::endPatchBranch");
                cas.end(key, null);
                var15_22 = null;
            }
            catch (Throwable var14_26) {
                var15_23 = null;
                OPatchEnv.setPrereqResult(OPatchEnv.getPrereqResultFileLoc(this.oh));
                if (branchKey.equals("SDK")) {
                    try {
                        this.cleanupCAS();
                    }
                    catch (Exception e) {
                        OLogger.printlnOnLog("OPatchOverCAS: NApply Phase1 cleanup CAS error");
                        e.printStackTrace();
                    }
                }
                throw var14_26;
            }
            OPatchEnv.setPrereqResult(OPatchEnv.getPrereqResultFileLoc(this.oh));
            if (branchKey.equals("SDK")) {
                try {
                    this.cleanupCAS();
                }
                catch (Exception e) {
                    OLogger.printlnOnLog("OPatchOverCAS: NApply Phase1 cleanup CAS error");
                    e.printStackTrace();
                }
            }
            break block22;
            {
                catch (Exception e) {
                    re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void commitSnowballPatching() throws CasApiException {
        block24: {
            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                StringBuffer tBuff = new StringBuffer("OPatch cannot run CAS NApply");
                tBuff.append("in the env that is not CAS enabled. ");
                OLogger.println(tBuff.toString());
                RuntimeException re = new RuntimeException(tBuff.toString());
                throw re;
            }
            OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: start CAS NApply phase2.");
            CASFileServices cas = new CASFileServices();
            String branchKey = "";
            IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
            try {
                block23: {
                    this.initialize();
                    branchKey = OPatchEnv.getBranchKey();
                    if (branchKey.equals("SDK")) {
                        this.initializeCAS(this.oh);
                    }
                    ProcessFileVersions proc = new ProcessFileVersions();
                    OneOffEntry[] pohs = new OneOffEntry[]{};
                    OneOffEntry[] pis = new OneOffEntry[]{};
                    String soh = this.coh.getCASStoragePath();
                    soh = soh + File.separator + branchKey;
                    String sohPath = this.oh + File.separator + soh;
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS: Begin check match OH and Pi!");
                    TwoPhaseMatchType t = TwoPhaseMatchType.SAME;
                    if (branchKey.equals("CLI")) {
                        t = TwoPhaseMatchType.SAME;
                    } else {
                        try {
                            pohs = PrereqAPI.getInstalledOneOff(this.oh);
                            pis = OPatchUtilHelper.getPatchesToApply(this.oh, OPatchEnv.getNApplySessionName());
                        }
                        catch (Throwable e2) {
                            OLogger.printlnOnLog("Converting Throwable to RuntimeException");
                            RuntimeException re = new RuntimeException(e2.getMessage());
                            re.setStackTrace(e2.getStackTrace());
                        }
                        t = proc.checkMatchType(this.oh, pohs, pis);
                    }
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: CAS 2-phase match type is " + (Object)((Object)t));
                    if (t == TwoPhaseMatchType.SAME) {
                        OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: match type is SAME, commit everything.");
                        cas.commit(null, new HashMap<Path, String>());
                        break block23;
                    }
                    if (t == TwoPhaseMatchType.NOCOLLISION) {
                        OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: match type is NOCOLLISION, commit everything except for inventory");
                        HashMap<Path, String> ignore = new HashMap<Path, String>();
                        Path inv = Paths.get("inventory", new String[0]);
                        ignore.put(inv, "inventory");
                        cas.commit(null, ignore);
                        OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: match type is NOCOLLISION, call IPM savePatch to update inventory");
                        PatchObject[] merge = new PatchObject[]{};
                        merge = this.getPatchesToMergeInv(sohPath);
                        if (!rwServices.isLocked()) {
                            try {
                                rwServices.lock(this.oh);
                                if (!rwServices.isInventoryLoaded()) {
                                    rwServices.loadInventory(this.oh);
                                }
                            }
                            catch (RuntimeException e3) {
                                OLogger.printlnOnLog("Lock inventory error");
                                e3.printStackTrace();
                            }
                        }
                        for (PatchObject po : merge) {
                            rwServices.add(po);
                            rwServices.savePatch(po);
                        }
                        break block23;
                    }
                    if (t != TwoPhaseMatchType.DIFFERENT) break block23;
                    OLogger.printlnOnLogAndVerbose("OPatchOverCAS:: match type is DIFFERENT, re-run CAS phase1");
                    this.prepareSnowballPatching();
                    cas.commit(null, new HashMap<Path, String>());
                }
                Object var18_25 = null;
            }
            catch (Throwable throwable) {
                Object var18_26 = null;
                rwServices.release();
                if (branchKey.equals("SDK")) {
                    try {
                        this.cleanupCAS();
                    }
                    catch (Exception e4) {
                        OLogger.printlnOnLog("cleanup CAS error");
                        e4.printStackTrace();
                    }
                }
                throw throwable;
            }
            rwServices.release();
            if (branchKey.equals("SDK")) {
                try {
                    this.cleanupCAS();
                }
                catch (Exception e4) {
                    OLogger.printlnOnLog("cleanup CAS error");
                    e4.printStackTrace();
                }
            }
            break block24;
            {
                catch (Exception e5) {
                    OLogger.printlnOnLog("OPatchOverCAS: NApply Phase2 commit error");
                    e5.printStackTrace();
                    RuntimeException re = new RuntimeException(e5.getMessage());
                    re.setStackTrace(e5.getStackTrace());
                    OLogger.printlnOnLogAndVerbose("Restore original OH if commit fails.");
                    this.restoreOH();
                    throw re;
                }
                catch (Throwable t) {
                    OLogger.printlnOnLog("Converting Throwable to RuntimeException");
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            }
        }
    }

    private PatchObject[] getPatchesToMergeInv(String oracleHomePath) {
        File oneoffsDir = new File(IPMUtil.getOneoffsLocation(oracleHomePath));
        File[] listOfFiles = oneoffsDir.listFiles();
        ArrayList<PatchObject> installedList = new ArrayList<PatchObject>();
        try {
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File fv = listOfFiles[i2];
                if (!fv.isDirectory()) continue;
                String tripletID = fv.getName();
                PatchObject patchObject = null;
                try {
                    patchObject = new PatchObject(oracleHomePath, tripletID);
                    installedList.add(patchObject);
                    continue;
                }
                catch (Exception e2) {
                    StringBuffer buff = new StringBuffer("Unable to create patchObject\n");
                    RuntimeException re = new RuntimeException(buff.toString(), e2);
                    throw re;
                }
            }
        }
        catch (Exception e3) {
            OLogger.printlnOnLog("get patches to merge error");
            e3.printStackTrace();
            return null;
        }
        PatchObject[] installed = new PatchObject[installedList.size()];
        installedList.toArray(installed);
        return installed;
    }

    private void copyCachedFiles(File srcDir, File dstDir) {
        File[] listOfFiles = srcDir.listFiles();
        try {
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File fv = listOfFiles[i2];
                if (!fv.isFile() || fv.isDirectory() || !dstDir.isDirectory() || !fv.getName().endsWith(".txt")) continue;
                StringBuffer tmpSb = new StringBuffer(dstDir.toString());
                tmpSb.append(File.separator);
                tmpSb.append(fv.getName());
                SystemCall.copyFile(fv, new File(tmpSb.toString()));
            }
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("copy cached files error");
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void prepareOneoffPatching(TwoPhaseOperations op) {
        block25: {
            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                tBuff = new StringBuffer("OPatch cannot run CAS NApply");
                tBuff.append("in the env that is not CAS enabled. ");
                OLogger.println(tBuff.toString());
                re = new RuntimeException(tBuff.toString());
                throw re;
            }
            OLogger.printlnOnLog("Enter OPatchOverCAS prepare(TwoPhaseOperations op)");
            tp = new TwoPhasePatching();
            rollbackPatches = null;
            applyPatches = null;
            branchKey = "";
            try {
                this.initialize();
                branchKey = OPatchEnv.getBranchKey();
                if (branchKey.equals("SDK")) {
                    OPatchEnv.setOPatchSDKMode(true);
                    CASServices.Initialize((IOracleHome)this.coh);
                }
                if (op == TwoPhaseOperations.NAPPLY) {
                    block24: {
                        OLogger.printlnOnLog("TwoPhaseOperations is NApply, start to run prepare.");
                        OLogger.printlnOnLog("Started NApplyReport, to run 'legacy napply -report'");
                        data = new NApplyData();
                        isReport = OPatchEnv.isReport();
                        isSilent = OPatchEnv.isSilent();
                        OPatchEnv.setReport(true);
                        OPatchEnv.setSilent(true);
                        isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                        if (!isConsoleOutputDisabled) {
                            OLogger.disableConsoleOutput(true);
                        }
                        try {
                            data = NApply.legacy_process(this.oh);
                            var12_17 = null;
                            ** if (isConsoleOutputDisabled) goto lbl-1000
                        }
                        catch (Throwable var11_21) {
                            var12_19 = null;
                            if (!isConsoleOutputDisabled) {
                                OLogger.enableConsoleOutput(OLogger.INFO, true);
                            }
                            throw var11_21;
                        }
lbl-1000:
                        // 1 sources

                        {
                            OLogger.enableConsoleOutput(OLogger.INFO, true);
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block24;
                            catch (Exception e) {
                                e.printStackTrace();
                                var12_18 = null;
                                if (!isConsoleOutputDisabled) {
                                    OLogger.enableConsoleOutput(OLogger.INFO, true);
                                }
                            }
                        }
                    }
                    OLogger.printlnOnLog("Finished NApplyReport, get a list of auto-rollback patches and to-apply patches.");
                    if (data != null) {
                        applyPatches = data.getApPatchObjects();
                        rollbackPatches = data.getArbPatchObjects();
                        OLogger.printlnOnLog("There are " + rollbackPatches.length + " patches to be auto-rollback.");
                        OLogger.printlnOnLog("There are " + applyPatches.length + " patches to be applied.");
                        OPatchEnv.setReport(isReport);
                        OPatchEnv.setSilent(isSilent);
                        tp.prepare(rollbackPatches, applyPatches);
                        OLogger.printlnOnLog("Finished NApply phase1.");
                    }
                } else if (op == TwoPhaseOperations.NROLLBACK) {
                    OLogger.printlnOnLog("TwoPhaseOperations is NRollback, start to run prepare.");
                    patchesToRollback = null;
                    OLogger.printlnOnLog("Started to get a list of patches to be n-rolled back.");
                    patchesToRollback = OPatchUtilHelper.getPatchesToRollback();
                    rollbackPatches = OPatchUtilHelper.getPatchesToRollback(this.oh, patchesToRollback, OPatchEnv.getNRollbackSessionName());
                    rollbackPatches = OPatchSessionHelper.sortOnOverlay(rollbackPatches, false);
                    tp.prepare(rollbackPatches, applyPatches);
                    OLogger.printlnOnLog("Finished NRollback phase1.");
                } else {
                    tBuff = new StringBuffer("OPatch/CAS only support NApply and NRollback.");
                    tBuff.append("Please pass in a valid twophase operation. ");
                    OLogger.println(tBuff.toString());
                    re = new RuntimeException(tBuff.toString());
                    throw re;
                }
                OLogger.printlnOnLog("Exit OPatchOverCAS prepare(TwoPhaseOperations op)");
                var14_22 = null;
                ** if (!OPatchEnv.getBranchKey().equals((Object)"SDK")) goto lbl-1000
            }
            catch (Throwable var13_26) {
                var14_23 = null;
                if (OPatchEnv.getBranchKey().equals("SDK")) {
                    try {
                        this.cleanupCAS();
                    }
                    catch (Exception e) {
                        OLogger.printlnOnLog("TwoPhasePatching: NApply Phase1 cleanup CAS error");
                        e.printStackTrace();
                    }
                }
                throw var13_26;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.cleanupCAS();
                }
                catch (Exception e) {
                    OLogger.printlnOnLog("TwoPhasePatching: NApply Phase1 cleanup CAS error");
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (Exception e) {
                    re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void commitOneoffPatching() {
        block10: {
            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                tBuff = new StringBuffer("OPatch cannot run CAS NApply");
                tBuff.append("in the env that is not CAS enabled. ");
                OLogger.println(tBuff.toString());
                re = new RuntimeException(tBuff.toString());
                throw re;
            }
            OLogger.printlnOnLog("Enter OPatchOverCAS commit()");
            try {
                tp = new TwoPhasePatching();
                tp.commit();
                var4_6 = null;
                ** if (!OPatchEnv.getBranchKey().equals((Object)"SDK")) goto lbl-1000
            }
            catch (Throwable var3_10) {
                var4_7 = null;
                if (OPatchEnv.getBranchKey().equals("SDK")) {
                    try {
                        this.cleanupCAS();
                    }
                    catch (Exception e) {
                        OLogger.printlnOnLog("TwoPhasePatching: NApply Phase1 cleanup CAS error");
                        e.printStackTrace();
                    }
                }
                throw var3_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.cleanupCAS();
                }
                catch (Exception e) {
                    OLogger.printlnOnLog("TwoPhasePatching: NApply Phase1 cleanup CAS error");
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block10;
                catch (Exception e) {
                    re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    OLogger.printlnOnLogAndVerbose("Restore original OH if commit fails.");
                    this.restoreOH();
                    throw re;
                }
            }
        }
        OLogger.printlnOnLog("Exit OPatchOverCAS commit()");
    }

    public void clearKeys(String oh) {
        String cacheLoc = OPatchEnv.getPrereqResultFileLoc(oh);
        File cacheLocFile = new File(cacheLoc);
        File[] listOfFiles = cacheLocFile.listFiles();
        for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
            File fv = listOfFiles[i2];
            if (fv.isDirectory()) continue;
            fv.delete();
        }
    }

    public void restoreOH() {
        ICASFileServices.PatchKey latestKey = null;
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            latestKey = casFileServices.getLatestPatch(null);
            if (latestKey != null) {
                Path path = null;
                casFileServices.restorePatchMemento(latestKey, path);
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("restore error");
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    private Map<Path, String> getCopiedFiles(String oracleHomePath) {
        HashMap<Path, String> copy = new HashMap<Path, String>();
        PatchObject[] pis = new PatchObject[]{};
        try {
            pis = OPatchUtilHelper.getPatchesToApply(this.oh, null, OPatchEnv.getNApplySessionName());
        }
        catch (Throwable e2) {
            OLogger.printlnOnLog("Converting Throwable to RuntimeException");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
        }
        for (PatchObject pi : pis) {
            ListIterator iter = pi.getAllIncludedCopyActions();
            while (iter.hasNext()) {
                CopyAction a2 = (CopyAction)iter.next();
                String f2 = a2.getFilename();
                Path p2 = Paths.get(f2, new String[0]);
                copy.put(p2, f2);
            }
        }
        return copy;
    }
}

