/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.Rac;
import oracle.opatch.Rules;
import oracle.opatch.StringPool;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.ZipUtilities;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;

public class OPatchEnv {
    private static long totalTimeSpentOnUserInput = 0L;
    private static String envOracleHome = "";
    private static String cmdOracleHome = "";
    private static String rspOracleHome = "";
    private static String oracleHome = "";
    private static String osName = System.getProperties().getProperty("os.name");
    protected static String hOracleHome = "";
    protected static String hCentralInv = "";
    protected static String hOPatchVer = "";
    protected static String hOUIVer = "";
    protected static String hOUILoc = "";
    protected static String hLogLoc = "";
    private static String hProductLoc = "";
    private static boolean isPatchStorageCreatedBySession = false;
    private static String oraInstLoc = null;
    private static String applyMake;
    private static final String PATCH_STORAGE_DIRECTORY = ".patch_storage";
    public static final String BACKUP_DIRECTORY = "backup";
    private static final String FILES_DIRECTORY = "files";
    private static final String PATCH_BACKUP = "original_patch";
    public static final String PATCH_SCRATCH = "scratch";
    private static final String PATCH_RAC = "rac";
    private static final String PATCH_RAC_FILE = "mode.txt";
    public static final String VERIFY_DIRECTORY = "verify";
    private static final String VERIFY_JAR_SUBDIR = "jar";
    private static final String VERIFY_AR_SUBDIR = "archive";
    private static final String VERIFY_COPY_SUBDIR = "copy";
    private static final String VERIFY_MAKE_SUBDIR = "make";
    private static final String VERIFY_PRE_SUBDIR = "pre";
    private static final String VERIFY_POST_SUBDIR = "post";
    private static final String VERIFY_GENERIC_SUBDIR = "generic";
    public static final String N_APPLY_SESSION_NAME = "NApply";
    public static final String N_ROLLBACK_SESSION_NAME = "NRollback";
    public static final String PATCH_UNZIP_LOCATION = "patch_unzip";
    public static final int COMPOSITE = 1;
    public static final int NAPPLY_BUNDLE = 2;
    public static final int COMBO = 3;
    public static final int ESYS = 4;
    private static String sessionType;
    private static String sessionName;
    private static String specifiedOLoggerPatchLoc;
    private static String specifiedOLoggerPatchID;
    private static boolean logFileLocationSpecified;
    private static String specifiedLogFileLocation;
    private static String cmdlineSessionLogFileLocation;
    private static boolean help;
    private static boolean fmwHelp;
    private static String jreLoc;
    private static boolean jreOptionSpecified;
    private static String jdkLoc;
    private static boolean verbose;
    private static boolean silent;
    private static boolean isBeaHome;
    private static boolean isDesiredHome;
    private static int delay;
    private static int retry;
    private static int maxLockingWait;
    private static String customLogDir;
    private static boolean isCleanupCmdLine;
    private static boolean force;
    private static boolean force_conflict;
    private static boolean optimize;
    private static boolean ohInstanceUp;
    private static boolean invPtrLocSpecified;
    private static String saSelectedProduct;
    private static String saSelectedVersion;
    private static String configFile;
    private static boolean local;
    private static boolean minDowntime;
    private static boolean allNode;
    private static boolean noPreScriptOpt;
    private static boolean noPostScriptOpt;
    private static String preopt;
    private static String initopt;
    private static String postopt;
    private static boolean nolink;
    private static boolean nopatchgen;
    private static boolean isReboot;
    private static boolean patchChecksum;
    private static int SILENT_PAUSE;
    private static String patchloc;
    private static String lsInvRegExpression;
    private static String cookedPatchID;
    private static boolean version_all;
    private static String version_v2c;
    private static String[] version_ohs;
    private static boolean lsinv_all;
    private static boolean lsinv_detail;
    private static boolean lsinv_xml;
    private static boolean xmlCompare;
    private static boolean trans_patch;
    private static String lsinv_xml_loc;
    private static String xmlCompare_loc1;
    private static String xmlCompare_loc2;
    private static boolean lsinv_patch;
    private static String lsinv_patch_order;
    private static boolean lsinv_patch_id;
    private static String lsinv_patch_id_order;
    private static boolean lsinv_inactive;
    private static boolean isSortByBugsFixed;
    private static String lsinv_bug_order;
    private static boolean lsinv_match;
    private static boolean report;
    private static boolean syntaxError;
    private static String syntaxErrorMsg;
    private static boolean argError;
    private static String argErrorMsg;
    private static String updateComponent;
    private static String updateVersion;
    private static boolean util_all;
    private static boolean isSrvmUtil;
    private static String lsp_queryfile;
    private static boolean lsp_Required;
    private static boolean lsp_Verified;
    private static boolean lsp_bugs;
    private static boolean all_Subpatches;
    private static String activeCompositeID;
    private static int patchFormat;
    private static String compositeXMLPath;
    private static String utilOption;
    private static String prereqOption;
    private static String beaHome;
    private static String profileMask;
    private static String bsuOutput;
    private static ArrayList wlsPrereqOneOffsList;
    private static boolean noBugSuperSet;
    private static boolean skipSubset;
    private static boolean skipDuplicate;
    private static boolean ignoreConflict;
    private static boolean ignoreMissingComponent;
    private static String userInputVersion;
    private static boolean groupByDate;
    private static String[] user_specified_nodes;
    private static String[] remoteNodes;
    private static String[] patchIDs;
    private static FMWClient[] allClients;
    private static ArrayList ToBeRolledBackPatchIDs;
    private static boolean isPlatformSkipValueValid;
    private static String localNode;
    private static String detectedLocalNode;
    private static boolean isCFS;
    private static boolean createRacFile;
    private static String propertyFile;
    private static Properties opatchProperties;
    private static Properties envVariables;
    private static boolean ocmResponseFile;
    private static String ocmResponseFileLoc;
    private static boolean isOcmRespFileDelete;
    private static Rac.RacType racType;
    private static boolean isEmOcmSkip;
    private static int opatchExitCode;
    private static boolean inventoryExists;
    private static boolean saHome;
    private static final String autoAns = " (auto-answered by -force, -silent)";
    private static final String autoYes = "Y (auto-answered by -silent)";
    private static final String autoNo = "N (auto-answered by -silent)";
    private static final String userYes = "User Responded with: Y";
    private static final String userNo = "User Responded with: N";
    private static final String userQuit = "User Responded with: Q";
    private static final String choiceValue = "User Responded with: ";
    private static boolean patchUnzipped;
    private static String nApplyBaseDir;
    private static String originalCommand;
    private static String[] databaseUserNames;
    private static String[] databasePasswds;
    private static String[] databaseSIDs;
    private static String[] databaseNodes;
    private static Boolean[] SIDStatus;
    private static boolean runSql;
    private static boolean sqlMigrate;
    private static boolean needProductXMLCreation;
    private static String userSpecifiedInvPtrLoc;
    private static boolean isPlatformValidationByPlatformXML;
    private static boolean isAutoRollback;
    private static String autoRollbackCookedPatchID;
    private static OneOffEntry[] autoRollbackList;
    private static boolean dbError;
    private static String subsetSIDInfo;
    private static boolean isNApply;
    private static boolean isNRollback;
    private static boolean isCompositeRollback;
    private static boolean isSqlScript;
    private static String sqlScriptFile;
    private static String ptlSchema;
    private static String ptlPassword;
    private static String ptlConnect;
    private static HashSet sidInfo;
    private static String portalPatchID;
    private static boolean isSqlPatch;
    private static boolean isFMWRollingPatch;
    private static boolean isFMWFeatureBearingPatch;
    private static boolean isRollingPatch;
    private static boolean isPortalPatch;
    private static boolean isOnlinePatch;
    private static boolean isOnline;
    private static boolean isComponent;
    private static boolean isBaseBug;
    private static boolean isAutoPatch;
    private static boolean isTranslatablePatch;
    private static boolean isPatchModel;
    private static boolean isPatchLanguage;
    private static boolean isGetProductFamily;
    private static boolean isOs;
    private static boolean isDate;
    private static boolean isSqlAction;
    private static boolean isQueryAll;
    private static boolean isGetPatchType;
    private static boolean isEngSystemPatch;
    private static boolean isPatchsetUpdate;
    private static boolean isUpdateComponent;
    private static boolean javaLog;
    private static int consoleLogLevel;
    private static int fileLogLevel;
    private static boolean isNeedToRollback;
    private static boolean isOPatchSDKApplyRollback;
    private static boolean isRunTimeExecMessageNeeded;
    private static boolean symbolResolveEnabled;
    private static boolean isAuto;
    private static boolean interactive;
    private static boolean norestart;
    private static boolean nonrolling;
    private static boolean generatesteps;
    private static boolean checkstackstatus;
    private static boolean gipatchingmode;
    private static boolean gipatchingAll;
    private static HashSet selectedDBs;
    private static boolean isCmdDatabase;
    private static HashSet targetList;
    private static String cmdTargetType;
    private static String compositeName;
    private static String compositeRev;
    private static String domaindir;
    private static String domainname;
    private static String wlsHome;
    private static String cmdMiddlewareHome;
    private static String envMiddlewareHome;
    private static String theMiddlewareHome;
    private static boolean exitWithUserReq;
    private static boolean delayCleanUp;
    private static String tempPatchLocation;
    private static boolean baseConfigPlan;
    private static OneOffEntry[] patchesToRoll;
    private static OneOffEntry[] conflictPatches;
    private static OneOffEntry[] pi;
    private static boolean hmatch;
    private static String prereqResult;
    private static boolean twoPhase;
    private static boolean CASPhase1;
    private static boolean CASPhase2;
    private static String branchKey;
    private static boolean rollbackInactivePsu;
    private static boolean LoadPoh;
    public static StringPool stringPool;
    private static boolean isRLibSuccess;
    private static String rLibBackupDir;
    private static boolean isRegenerationNeeded;
    private static PatchObject[] arbPatchObjectsForRLib;
    private static String swLibraryDir;
    private static boolean needSearchTripletID;
    private static String casViewId;
    private static String casViewPath;
    private static String casRepoPath;
    private static String invokeTs;

    private OPatchEnv() {
    }

    public static String getInterimInventoryFileLoc(String oracleHomePath) {
        StringBuffer fInterim = new StringBuffer();
        fInterim.append(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
        fInterim.append(File.separator);
        fInterim.append("interim_inventory.txt");
        return fInterim.toString();
    }

    public static String getRecordInventoryFileLoc(String oracleHomePath) {
        StringBuffer fInterim = new StringBuffer();
        fInterim.append(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
        fInterim.append(File.separator);
        fInterim.append("record_inventory.txt");
        return fInterim.toString();
    }

    public static void setFMWClients(FMWClient[] allClients) {
        OPatchEnv.allClients = allClients;
    }

    public static FMWClient[] getFMWClients() {
        return allClients;
    }

    public static void setJavaLog(boolean javaLog) {
        OPatchEnv.javaLog = javaLog;
    }

    public static boolean isBaseConfigPlanForDeploy() {
        return baseConfigPlan;
    }

    public static boolean isJavaLog() {
        return javaLog;
    }

    public static boolean isNeedToRollback() {
        return isNeedToRollback;
    }

    public static void setNeedToRollback(boolean needToRollback) {
        isNeedToRollback = needToRollback;
    }

    protected static int getConsoleLogLevel() {
        return consoleLogLevel;
    }

    protected static void setConsoleLogLevel(int logLevel) {
        consoleLogLevel = logLevel;
    }

    protected static int getFileLogLevel() {
        return fileLogLevel;
    }

    protected static void setFileLogLevel(int logLevel) {
        fileLogLevel = logLevel;
    }

    public static String getModeFileName() {
        return PATCH_RAC_FILE;
    }

    public static String getOriginalCommand() {
        return originalCommand;
    }

    public static void setOriginalCommand(String s) {
        originalCommand = s;
    }

    protected static void setAutoMode() {
        isAuto = true;
    }

    protected static void resetAutoMode() {
        isAuto = false;
    }

    protected static void setSelectedDatabases(HashSet targetList) {
        isCmdDatabase = true;
        selectedDBs = targetList;
    }

    protected static void setGIPatchingAll(boolean b2) {
        gipatchingAll = b2;
    }

    public static boolean isGIPatchingAll() {
        return gipatchingAll;
    }

    protected static void setNoRestart() {
        norestart = true;
    }

    protected static void setNonrolling() {
        nonrolling = true;
    }

    protected static void setInteractive() {
        interactive = true;
    }

    protected static void setGenerateSteps(boolean b2) {
        generatesteps = b2;
    }

    protected static void setRacType(Rac.RacType racType) {
        OPatchEnv.racType = racType;
    }

    protected static Rac.RacType getRacType() {
        return racType;
    }

    protected static void setFMWTargetList(HashSet targets) {
        targetList = targets;
    }

    protected static void setFMWCmdTargetType(String cmdTargetType) {
        OPatchEnv.cmdTargetType = cmdTargetType;
    }

    protected static void setFMWCompositeName(String compositeName) {
        OPatchEnv.compositeName = compositeName;
    }

    protected static void setFMWCompositeRevision(String compositeRev) {
        OPatchEnv.compositeRev = compositeRev;
    }

    public static void setFMWDomainName(String domainname) {
        OPatchEnv.domainname = domainname;
    }

    protected static void setFMWDomainDir(String domaindir) {
        OPatchEnv.domaindir = domaindir;
    }

    public static void setOneOffToRoll(OneOffEntry[] oEntry) {
        patchesToRoll = oEntry;
    }

    public static OneOffEntry[] getOneOffToRoll() {
        return patchesToRoll;
    }

    public static OneOffEntry[] getConflictPatches() {
        return conflictPatches;
    }

    public static void setConflictPatches(OneOffEntry[] oEntry) {
        conflictPatches = oEntry;
    }

    public static boolean isLoadPoh() {
        return LoadPoh;
    }

    public static void setLoadPoh(boolean loadPoh) {
        LoadPoh = loadPoh;
    }

    protected static void setUserInputVersion(String version) {
        userInputVersion = version;
    }

    public static String getUserInputVersion() {
        return userInputVersion;
    }

    protected static void setWlsHome(String webLogicHome) {
        String tmpS = webLogicHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        wlsHome = tmpS;
    }

    protected static void setBaseConfigPlan(boolean isBaseConfig) {
        baseConfigPlan = isBaseConfig;
    }

    protected static void setCmdMiddlewareHome(String cmdMiddlewareHome) {
        String tmpS = cmdMiddlewareHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.cmdMiddlewareHome = tmpS;
    }

    protected static void setEnvMiddlewareHome(String envMiddlewareHome) {
        String tmpS = envMiddlewareHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.envMiddlewareHome = tmpS;
    }

    public static HashSet getFMWTargetList() {
        return targetList;
    }

    static String getFMWCmdTargetType() {
        return cmdTargetType;
    }

    static String getFMWCompositeName() {
        return compositeName;
    }

    static String getFMWCompositeRevision() {
        return compositeRev;
    }

    protected static String getCmdMiddlewareHome() {
        return cmdMiddlewareHome;
    }

    protected static String getEnvMiddlewareHome() {
        return envMiddlewareHome;
    }

    public static String getMiddlewareHome() {
        if (!cmdMiddlewareHome.trim().equals("")) {
            return cmdMiddlewareHome;
        }
        if (!envMiddlewareHome.trim().equals("")) {
            return envMiddlewareHome;
        }
        String sysPropMwHome = System.getProperty("OPatch.MW_HOME");
        if (sysPropMwHome == null) {
            sysPropMwHome = "";
        }
        return sysPropMwHome;
    }

    public static String getFMWDomainDir() {
        return domaindir;
    }

    public static String getFMWDomainName() {
        return domainname;
    }

    public static String getWlsHome() {
        return wlsHome;
    }

    public static boolean getisAuto() {
        return isAuto;
    }

    public static boolean isNoRestart() {
        return norestart;
    }

    public static boolean isNonrolling() {
        return nonrolling;
    }

    public static boolean isInteractive() {
        return interactive;
    }

    public static boolean isGenerateSteps() {
        return generatesteps;
    }

    public static HashSet getSelectedDatabases() {
        return selectedDBs;
    }

    public static boolean isSetCmdDatabase() {
        return isCmdDatabase;
    }

    public static String getTmpDir() {
        String tmpDir = "/tmp";
        if (OPatchEnv.isWindows()) {
            tmpDir = "C:\\temp";
        }
        return tmpDir;
    }

    protected static boolean isTransPatch() {
        return trans_patch;
    }

    protected static void setTransPatch(boolean in) {
        trans_patch = in;
    }

    protected static void queryAll(boolean in) {
        isQueryAll = in;
    }

    protected static boolean isQueryAll() {
        return isQueryAll;
    }

    protected static boolean isComponent() {
        return isComponent;
    }

    protected static void showComponent(boolean in) {
        isComponent = in;
    }

    protected static boolean isBaseBug() {
        return isBaseBug;
    }

    protected static void showBaseBug(boolean in) {
        isBaseBug = in;
    }

    protected static boolean isAutoPatch() {
        return isAutoPatch;
    }

    protected static void setAutoPatch(boolean in) {
        isAutoPatch = in;
    }

    protected static boolean isTranslatablePatch() {
        return isTranslatablePatch;
    }

    protected static void setTranslatablePatch(boolean in) {
        isTranslatablePatch = in;
    }

    protected static boolean isPatchModel() {
        return isPatchModel;
    }

    protected static void setPatchModel(boolean in) {
        isPatchModel = in;
    }

    protected static boolean isPatchLanguage() {
        return isPatchLanguage;
    }

    protected static void setPatchLanguage(boolean in) {
        isPatchLanguage = in;
    }

    protected static boolean isDate() {
        return isDate;
    }

    protected static void showDate(boolean in) {
        isDate = in;
    }

    protected static boolean isOS() {
        return isOs;
    }

    protected static void showOS(boolean in) {
        isOs = in;
    }

    protected static boolean isSqlPatch() {
        return isSqlPatch;
    }

    protected static void showSqlPatch(boolean in) {
        isSqlPatch = in;
    }

    protected static boolean isFMWRollingPatch() {
        return isFMWRollingPatch;
    }

    protected static void showFMWRollingPatch(boolean in) {
        isFMWRollingPatch = in;
    }

    protected static boolean isFMWFeatureBearingPatch() {
        return isFMWFeatureBearingPatch;
    }

    protected static void showFMWFeatureBearingPatch(boolean in) {
        isFMWFeatureBearingPatch = in;
    }

    protected static boolean isRollingPatch() {
        return isRollingPatch;
    }

    protected static void showRollingPatch(boolean in) {
        isRollingPatch = in;
    }

    protected static boolean isPatchType() {
        return isGetPatchType;
    }

    protected static void showPatchType(boolean in) {
        isGetPatchType = in;
    }

    protected static boolean isEngSystemPatch() {
        return isEngSystemPatch;
    }

    protected static void showEngSystemPatch(boolean in) {
        isEngSystemPatch = in;
    }

    protected static boolean isProductFamily() {
        return isGetProductFamily;
    }

    protected static void showProductFamily(boolean in) {
        isGetProductFamily = in;
    }

    protected static boolean isOnlinePatch() {
        return isOnlinePatch;
    }

    protected static void showOnlinePatch(boolean in) {
        isOnlinePatch = in;
    }

    protected static boolean isOnline() {
        return isOnline;
    }

    public static void setOnline(boolean in) {
        isOnline = in;
    }

    protected static boolean isPortalPatch() {
        return isPortalPatch;
    }

    protected static void showPortalPatch(boolean in) {
        isPortalPatch = in;
    }

    protected static boolean isSqlAction() {
        return isSqlAction;
    }

    protected static void showSqlPresence(boolean in) {
        isSqlAction = in;
    }

    protected static boolean isPatchsetUpdate() {
        return isPatchsetUpdate;
    }

    protected static void setPatchsetUpdate(boolean in) {
        isPatchsetUpdate = in;
    }

    protected static boolean isUpdateComponent() {
        return isUpdateComponent;
    }

    protected static void setUpdateComponent(boolean in) {
        isUpdateComponent = in;
    }

    protected static boolean isSortByBugsFixed() {
        return isSortByBugsFixed;
    }

    protected static void setSortByBugsFixed(boolean in) {
        isSortByBugsFixed = in;
    }

    public static void setOPatchSDKMode(boolean in) {
        isOPatchSDKApplyRollback = in;
    }

    public static boolean isOPatchSDKMode() {
        return isOPatchSDKApplyRollback;
    }

    public static String getUpdateComponent() {
        return updateComponent;
    }

    static void setUpdateComponent(String in) {
        updateComponent = in;
    }

    public static String getUpdateVersion() {
        return OPatchSession.getVersion();
    }

    static void setUpdateVersion(String in) {
        updateVersion = in;
    }

    public static boolean isRunTimeExecMessageNeeded() {
        return isRunTimeExecMessageNeeded;
    }

    public static void setRunTimeExecMessageNeeded(boolean in) {
        isRunTimeExecMessageNeeded = in;
    }

    public static boolean isSymbolResolveEnabled() {
        return symbolResolveEnabled;
    }

    public static void setSymbolResolveEnabled(boolean enabled) {
        symbolResolveEnabled = enabled;
    }

    public static String getOnlinePropertyFilePath(String oracleHomePath) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        StringBuffer buff = new StringBuffer(patchStorage);
        buff.append(File.separator);
        buff.append("OnlinePatch.properties");
        return buff.toString();
    }

    public static String getSqlPropertyFilePath(String oracleHomePath, String cookedPatchID) {
        String cookedDirPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer sqlPropertyFilePath = new StringBuffer(cookedDirPath);
        sqlPropertyFilePath.append(File.separator);
        sqlPropertyFilePath.append("sqlproperties");
        return sqlPropertyFilePath.toString();
    }

    public static String getBackupSqlPropertyFilePath(String oracleHomePath, String cookedPatchID) {
        String cookedDirPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer backupSqlPropertyFilePath = new StringBuffer(cookedDirPath);
        backupSqlPropertyFilePath.append(File.separator);
        backupSqlPropertyFilePath.append("backup_sqlproperties");
        return backupSqlPropertyFilePath.toString();
    }

    protected static void setPortalPatchID(String patchID) {
        portalPatchID = patchID;
    }

    public static String getPortalPatchID() {
        return portalPatchID;
    }

    public static void setSidInformation(HashSet in) {
        sidInfo = in;
    }

    public static HashSet getSidInformation() {
        return sidInfo;
    }

    protected static long getTotalTimeSpentOnUserInput() {
        return totalTimeSpentOnUserInput;
    }

    public static String getOracleHome() throws NoSuchElementException {
        String oraHome = System.getProperty("OPatch.ORACLE_HOME");
        if (oraHome == null) {
            oraHome = "";
        } else {
            String tmpS = oraHome;
            tmpS = tmpS.trim();
            while (tmpS.endsWith(File.separator)) {
                tmpS = tmpS.substring(0, tmpS.length() - 1);
            }
            oraHome = tmpS;
        }
        if (!oracleHome.equals("")) {
            return oracleHome;
        }
        if (cmdOracleHome.equals("") && envOracleHome.equals("") && oraHome.equals("")) {
            throw new NoSuchElementException("Cannot get any Oracle Home from cmd-line or environment");
        }
        if (!cmdOracleHome.equals("")) {
            oracleHome = cmdOracleHome;
        }
        if (oracleHome.equals("") && !envOracleHome.equals("")) {
            oracleHome = envOracleHome;
        }
        return oracleHome.equals("") ? oraHome : oracleHome;
    }

    public static boolean isAutoRollbackBackup() {
        return isAutoRollback;
    }

    public static void setAutoRollbackBackup(boolean in) {
        isAutoRollback = in;
    }

    public static String getAutoRollbackCookedPatchID() {
        return autoRollbackCookedPatchID;
    }

    public static void setAutoRollbackList(OneOffEntry[] oneOffEntries) {
        autoRollbackList = oneOffEntries;
    }

    public static OneOffEntry[] getAutoRollbackList() {
        return autoRollbackList;
    }

    public static void setAutoRollbackPatchID(String in) {
        autoRollbackCookedPatchID = in;
    }

    public static void setNApply(boolean in) {
        isNApply = in;
    }

    public static boolean isNApply() {
        return isNApply;
    }

    public static void setNRollback(boolean in) {
        isNRollback = in;
    }

    public static boolean isNRollback() {
        return isNRollback;
    }

    public static void setCompositeRollback(boolean in) {
        isCompositeRollback = in;
    }

    public static boolean isCompositeRollback() {
        return isCompositeRollback;
    }

    protected static boolean isProductXMLCreationNeeded() {
        return needProductXMLCreation;
    }

    protected static void setProductXMLCreationNeeded(boolean input) {
        needProductXMLCreation = input;
    }

    public static String getPtlSchema() {
        return ptlSchema;
    }

    public static String getPtlPassword() {
        return ptlPassword;
    }

    public static String getPtlConnect() {
        return ptlConnect;
    }

    public static void setPtlSchema(String in) {
        ptlSchema = in;
    }

    public static void setPtlPassword(String in) {
        ptlPassword = in;
    }

    public static void setPtlConnect(String in) {
        ptlConnect = in;
    }

    protected static void setEnvInfo(Properties p2) {
        envVariables = p2;
    }

    protected static Properties getEnvInfo() {
        return envVariables;
    }

    protected static boolean getPatchStoragePresentValid() {
        return isPatchStorageCreatedBySession;
    }

    public static boolean isPlatformValidationFromPlatformXML() {
        return isPlatformValidationByPlatformXML;
    }

    public static void setPlatformValidationFromPlatformXML(boolean input) {
        isPlatformValidationByPlatformXML = input;
    }

    public static String getPlatformXMLLocation(String oracleHomePath) {
        StringBuffer platformXMLLocation = new StringBuffer(oracleHomePath);
        platformXMLLocation.append(File.separator);
        platformXMLLocation.append("platform.xml");
        return platformXMLLocation.toString();
    }

    protected static void setOCMResponseFileLoc(String loc) {
        if (loc != null) {
            ocmResponseFileLoc = loc;
            ocmResponseFile = true;
        }
    }

    public static String getOCMResponseFileLoc() {
        return ocmResponseFileLoc;
    }

    public static boolean isOCMResponseFile() {
        return ocmResponseFile;
    }

    protected static void setEmOcmFlag(boolean in) {
        isEmOcmSkip = in;
    }

    protected static boolean isEmOcmSkip() {
        return isEmOcmSkip;
    }

    protected static void setOcmResponseFileDelete(boolean in) {
        isOcmRespFileDelete = in;
    }

    public static boolean isOcmRespFileDelete() {
        return isOcmRespFileDelete;
    }

    protected static void setPatchStoragePresentValid(boolean val) {
        isPatchStorageCreatedBySession = val;
    }

    protected static boolean isPatchChecksum() {
        return patchChecksum;
    }

    protected static void setPatchChecksum(boolean val) {
        patchChecksum = val;
    }

    protected static boolean isUserSuppliedCFS() {
        return isCFS;
    }

    protected static void setUserSuppliedCFS(boolean b2) {
        isCFS = b2;
    }

    protected static boolean isUserSuppliedLocalNode() {
        return localNode != null && !localNode.equals("");
    }

    protected static String getProductLoc() {
        return hProductLoc;
    }

    protected static void setProductLoc(String productLoc) {
        hProductLoc = productLoc;
    }

    protected static String getSelectedProduct() {
        return saSelectedProduct;
    }

    protected static String getSelectedVersion() {
        return saSelectedVersion;
    }

    protected static void setSelectedProductVersion(String product, String version) {
        saSelectedProduct = product;
        saSelectedVersion = version;
    }

    public static String getUserSuppliedLocalNode() {
        return localNode;
    }

    protected static void setUserSuppliedLocalNode(String node) {
        localNode = node;
    }

    public static boolean isUserSuppliedRemoteNodes() {
        return remoteNodes != null && remoteNodes.length != 0 && remoteNodes[0] != null;
    }

    public static String[] getUserSuppliedRemoteNodes() {
        String[] retVal = new String[remoteNodes.length];
        for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
            retVal[i2] = remoteNodes[i2].toLowerCase();
        }
        return retVal;
    }

    protected static void setUserSuppliedRemoteNodes(String[] nodes) {
        if (nodes == null) {
            remoteNodes = null;
        } else {
            remoteNodes = new String[nodes.length];
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                OPatchEnv.remoteNodes[i2] = nodes[i2];
            }
        }
    }

    protected static void setUserSuppliedNodes(String[] nodes) {
        if (nodes == null) {
            user_specified_nodes = null;
        } else {
            user_specified_nodes = new String[nodes.length];
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                OPatchEnv.user_specified_nodes[i2] = nodes[i2];
            }
        }
    }

    public static String[] getUserSuppliedNodes() {
        return user_specified_nodes;
    }

    public static boolean isUserSuppliedNodes() {
        return user_specified_nodes != null && user_specified_nodes.length != 0 && user_specified_nodes[0] != null && !user_specified_nodes[0].equals("");
    }

    public static String[] getUserSuppliedPatchIDs() {
        String[] retVal = new String[patchIDs.length];
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            int lastIndex;
            String subStr = "_en";
            if (patchIDs[i2].endsWith(subStr) && (lastIndex = patchIDs[i2].lastIndexOf(subStr)) != -1) {
                OPatchEnv.patchIDs[i2] = patchIDs[i2].substring(0, lastIndex);
            }
            retVal[i2] = patchIDs[i2];
        }
        return retVal;
    }

    public static void setUserSuppliedPatchIDs(String[] ids) {
        patchIDs = ids;
    }

    public static boolean isUserSuppliedPatchIDs() {
        return patchIDs != null && patchIDs.length != 0;
    }

    public static void setToBeRolledBackPatchIDs(ArrayList ids) {
        ToBeRolledBackPatchIDs = ids;
    }

    public static ArrayList getToBeRolledBackPatchIDs() {
        return ToBeRolledBackPatchIDs;
    }

    protected static String getUserDefinedPlatformID() {
        String id = System.getProperties().getProperty("OPatch.PLATFORM_ID");
        if (id == null || id.equals("")) {
            return "";
        }
        return id;
    }

    protected static int getSkipPlatformId() {
        int platformSkipId;
        String platformString = null;
        try {
            platformString = opatchProperties.getProperty("OPatch.SKIP_VERIFY_PLATFORM");
        }
        catch (Exception e2) {
            isPlatformSkipValueValid = false;
            return -1;
        }
        if (platformString == null || platformString.equals("")) {
            isPlatformSkipValueValid = false;
            return -1;
        }
        try {
            StringBuffer buff = new StringBuffer("OPatchEnv::getSkipPlatformId() parse the string ");
            buff.append(platformString);
            OLogger.debug(buff);
            platformSkipId = Integer.parseInt(platformString);
        }
        catch (NumberFormatException e3) {
            isPlatformSkipValueValid = false;
            return -1;
        }
        isPlatformSkipValueValid = true;
        return platformSkipId;
    }

    protected static boolean isPlatformSkip() {
        return isPlatformSkipValueValid;
    }

    protected static void setLocalNode(String localNode) {
        detectedLocalNode = localNode;
    }

    public static String getLocalNode() {
        return detectedLocalNode;
    }

    protected static boolean isOPATCH_NO_FUSER() {
        String setStr = System.getProperties().getProperty("OPatch.NO_FUSER");
        if (setStr == null) {
            return false;
        }
        return setStr.compareToIgnoreCase("true") == 0;
    }

    protected static boolean isOPATCH_SKIP_VERIFY() {
        String setStr = opatchProperties.getProperty("OPatch.SKIP_VERIFY");
        if (setStr == null) {
            return false;
        }
        return setStr.compareToIgnoreCase("true") == 0;
    }

    protected static boolean isOPATCH_SKIP_VERIFY_SPACE() {
        String setStr = opatchProperties.getProperty("OPatch.SKIP_VERIFY_SPACE");
        if (setStr == null) {
            return false;
        }
        return setStr.compareToIgnoreCase("true") == 0;
    }

    public static long getSpaceNeeded() {
        long spaceNeeded = 0L;
        String setStr = opatchProperties.getProperty("OPatch.SPACE_NEEDED");
        if (setStr != null) {
            try {
                spaceNeeded = Long.valueOf(setStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return spaceNeeded;
    }

    public static int getRetry() {
        return retry;
    }

    public static int getMaxLockingWait() {
        return maxLockingWait;
    }

    protected static void setMaxLockingWait(int i2) {
        maxLockingWait = i2;
    }

    public static int getDelay() {
        return delay;
    }

    public static String[] getDBSIDs() {
        String[] retVal = new String[databaseSIDs.length];
        for (int i2 = 0; i2 < databaseSIDs.length; ++i2) {
            retVal[i2] = databaseSIDs[i2];
        }
        return retVal;
    }

    protected static void setDBSids(String[] sids) {
        databaseSIDs = new String[sids.length];
        for (int i2 = 0; i2 < sids.length; ++i2) {
            OPatchEnv.databaseSIDs[i2] = sids[i2];
        }
    }

    public static Boolean[] getSIDStatus() {
        Boolean[] retVal = new Boolean[SIDStatus.length];
        for (int i2 = 0; i2 < SIDStatus.length; ++i2) {
            retVal[i2] = SIDStatus[i2];
        }
        return retVal;
    }

    public static void setSIDStatus(Boolean[] status) {
        SIDStatus = new Boolean[status.length];
        for (int i2 = 0; i2 < status.length; ++i2) {
            OPatchEnv.SIDStatus[i2] = status[i2];
        }
    }

    public static String[] getDBUsers() {
        String[] retVal = new String[databaseUserNames.length];
        for (int i2 = 0; i2 < databaseUserNames.length; ++i2) {
            retVal[i2] = databaseUserNames[i2];
        }
        return retVal;
    }

    public static boolean isRunSql() {
        return runSql;
    }

    public static boolean isSqlScript() {
        return isSqlScript;
    }

    public static String getSqlScriptFilePath() {
        return sqlScriptFile;
    }

    protected static void setRunSql(boolean value) {
        runSql = value;
    }

    protected static void setSqlScriptPresence(boolean in) {
        isSqlScript = in;
    }

    protected static void setSqlScriptFilePath(String in) {
        sqlScriptFile = in;
    }

    public static boolean isSqlMigrate() {
        return sqlMigrate;
    }

    protected static void setSqlMigrate(boolean value) {
        if (value) {
            sqlMigrate = value;
        }
    }

    protected static void setDBUsers(String[] dbUnames) {
        databaseUserNames = new String[dbUnames.length];
        for (int i2 = 0; i2 < dbUnames.length; ++i2) {
            OPatchEnv.databaseUserNames[i2] = dbUnames[i2];
        }
    }

    public static String[] getDBPasswds() {
        String[] retVal = new String[databasePasswds.length];
        for (int i2 = 0; i2 < databasePasswds.length; ++i2) {
            retVal[i2] = databasePasswds[i2];
        }
        return retVal;
    }

    protected static void setDBPasswds(String[] dbPasswds) {
        databasePasswds = new String[dbPasswds.length];
        for (int i2 = 0; i2 < dbPasswds.length; ++i2) {
            OPatchEnv.databasePasswds[i2] = dbPasswds[i2];
        }
    }

    public static String[] getDBNodes() {
        String[] retVal = new String[databaseNodes.length];
        for (int i2 = 0; i2 < databaseNodes.length; ++i2) {
            retVal[i2] = databaseNodes[i2];
        }
        return retVal;
    }

    protected static void setDBNodes(String[] dbNodes) {
        databaseNodes = new String[dbNodes.length];
        for (int i2 = 0; i2 < dbNodes.length; ++i2) {
            OPatchEnv.databaseNodes[i2] = dbNodes[i2];
        }
    }

    public static boolean createNewOnlineRollbackFile(String oracleHomePath, String pchFile, String sid) {
        String deleteFilePath = OPatchEnv.getOnlineRollbackDeleteFile(oracleHomePath, pchFile, sid);
        File f2 = new File(deleteFilePath);
        try {
            if (f2.exists()) {
                f2.delete();
            }
            f2.getParentFile().getCanonicalFile().mkdirs();
            boolean ok = f2.createNewFile();
            return ok;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getOnlineRollbackDeleteFile(String oracleHomePath, String pchFile, String sid) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("hpatch");
        buff.append(File.separator);
        buff.append(pchFile);
        buff.append(sid);
        buff.append(".");
        buff.append("remove");
        return buff.toString();
    }

    public static boolean isRetry() {
        return OPatchEnv.getRetry() >= 0;
    }

    protected static boolean isReadOnlySession() {
        return true;
    }

    public static boolean isLocal() {
        return local;
    }

    public static String getCallerName() {
        return "OPatch";
    }

    public static String getCallerVersion() {
        return OPatchSession.getVersion();
    }

    public static String getOHOwner(String oracleHomePath) {
        String invPtrFile = oracleHomePath + File.separator + "oraInst.loc";
        String ohOwner = "";
        if (!OPatchEnv.isWindows()) {
            ohOwner = OUIReplacer.getFileOwnerInfo(invPtrFile);
        }
        return ohOwner;
    }

    protected static String getLogFileLocation(String oracleHomePath) {
        File f2;
        StringBuffer logFileLoc = new StringBuffer(oracleHomePath);
        logFileLoc.append(File.separator);
        logFileLoc.append(StringResource.CENTRAL_LOG_DIR);
        String customLogDir = OPatchEnv.getCustomLogDir();
        if (customLogDir != null && !customLogDir.equals("")) {
            logFileLoc.setLength(0);
            logFileLoc.append(customLogDir);
            logFileLoc.append(File.separator);
            logFileLoc.append("opatch");
        }
        if (!(f2 = new File(logFileLoc.toString())).exists()) {
            boolean isRoot = false;
            try {
                isRoot = OUIReplacer.isRootAccess(oracleHomePath);
            }
            catch (Exception e1) {
                OLogger.printStackTrace(e1);
                throw new RuntimeException("Failed to check if user is root user.", e1);
            }
            if (isRoot) {
                String ohOwner = OPatchEnv.getOHOwner(oracleHomePath);
                String mkdirCmd = "mkdir -p " + logFileLoc.toString();
                SystemCall.process(mkdirCmd, ohOwner);
            } else {
                f2.mkdirs();
            }
            OUIReplacer.changePermission(logFileLoc.toString(), 488);
        }
        return logFileLoc.toString();
    }

    protected static String getHistoryFile(String oracleHomePath) {
        File f2;
        StringBuffer logDir = new StringBuffer(oracleHomePath);
        logDir.append(File.separator);
        logDir.append(StringResource.CENTRAL_LOG_DIR);
        String customLogDir = OPatchEnv.getCustomLogDir();
        if (customLogDir != null && !customLogDir.equals("")) {
            logDir.setLength(0);
            logDir.append(customLogDir);
            logDir.append(File.separator);
            logDir.append("opatch");
        }
        if (!(f2 = new File(logDir.toString())).exists()) {
            f2.mkdirs();
            OUIReplacer.changePermission(logDir.toString(), 488);
        }
        logDir.append(File.separator);
        logDir.append("opatch_history.txt");
        return logDir.toString();
    }

    protected static String getLsInvOutputFileLocation(String baseDir) {
        StringBuffer fileLoc = new StringBuffer(OPatchEnv.getLogFileLocation(baseDir));
        fileLoc.append(File.separator);
        fileLoc.append("lsinv");
        return fileLoc.toString();
    }

    protected static String getLogFileNameAndLocation(String baseDir) {
        if (logFileLocationSpecified) {
            return specifiedLogFileLocation;
        }
        String logFileLoc = OPatchEnv.getLogFileLocation(baseDir);
        String fileName = "";
        try {
            fileName = OPatchACL.invokeOLogger(new OPatchEnv(), "getLogFileName", null).toString();
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        StringBuffer fileNamePath = new StringBuffer(logFileLoc);
        boolean isRoot = false;
        try {
            isRoot = OUIReplacer.isRootAccess(baseDir);
        }
        catch (Exception e1) {
            OLogger.printStackTrace(e1);
            throw new RuntimeException("Failed to check if user is root user.", e1);
        }
        fileNamePath.append(File.separator);
        fileNamePath.append(fileName);
        cmdlineSessionLogFileLocation = fileNamePath.toString();
        if (!new File(fileNamePath.toString()).exists() && isRoot) {
            String ohOwner = OPatchEnv.getOHOwner(baseDir);
            String newFileCmd = "touch " + fileNamePath.toString();
            SystemCall.process(newFileCmd, ohOwner);
        }
        return fileNamePath.toString();
    }

    protected static String getLogFileForJavaLog(String baseDir) {
        String logFile = OPatchEnv.getLogFileNameAndLocation(baseDir);
        StringBuffer javaLog = new StringBuffer(logFile);
        return javaLog.toString();
    }

    protected static String getOUILocation() {
        String ouiLoc = System.getProperty("oracle.installer.oui_loc");
        if (ouiLoc == null) {
            return "n/a";
        }
        return ouiLoc;
    }

    protected static void setOUILocation(String oracleHomePath, String invPtrLoc) {
        StringBuffer ouiLocation = new StringBuffer(oracleHomePath);
        ouiLocation.append(File.separator);
        ouiLocation.append("oui");
        StringBuffer buff = new StringBuffer("OPatchEnv.setOUILocation() to ");
        buff.append(ouiLocation.toString());
        OLogger.debug(buff);
        System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
        System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
    }

    public static String getSpecifiedOLoggerPatchLoc() {
        return specifiedOLoggerPatchLoc;
    }

    public static void setSpecifiedOLoggerPatchLoc(String specifiedOLoggerPatchLoc) {
        OPatchEnv.specifiedOLoggerPatchLoc = specifiedOLoggerPatchLoc;
    }

    public static String getSpecifiedOLoggerPatchID() {
        return specifiedOLoggerPatchID;
    }

    public static void setSpecifiedOLoggerPatchID(String specifiedOLoggerPatchID) {
        OPatchEnv.specifiedOLoggerPatchID = specifiedOLoggerPatchID;
    }

    public static String getSessionName() {
        return sessionName;
    }

    public static void setSessionName(String sessionName) {
        OPatchEnv.sessionName = sessionName;
    }

    public static boolean isApplyOrNApplySession() {
        return OPatchEnv.getSessionName().equalsIgnoreCase("apply") || OPatchEnv.getSessionName().equalsIgnoreCase("napply");
    }

    public static boolean isLogFileLocationSpecified() {
        return logFileLocationSpecified;
    }

    public static void setLogFileLocationSpecified(boolean in) {
        logFileLocationSpecified = in;
    }

    public static String getSpecifiedLogFileLocation() {
        return specifiedLogFileLocation;
    }

    public static void setSpecifiedLogFileLocation(String specifiedLogFileLocation) {
        OPatchEnv.specifiedLogFileLocation = specifiedLogFileLocation;
    }

    public static String getCmdlineSessionLogFileLocation() {
        return cmdlineSessionLogFileLocation;
    }

    public static void setCmdlineSessionLogFileLocation(String cmdlineSessionLogFileLocation) {
        OPatchEnv.cmdlineSessionLogFileLocation = cmdlineSessionLogFileLocation;
    }

    public static String getSessionType() {
        return sessionType;
    }

    public static void setSessionType(String sessionType) {
        OPatchEnv.sessionType = sessionType;
    }

    protected static boolean isInvExists() {
        return inventoryExists;
    }

    public static void setInvExists(boolean value) {
        inventoryExists = value;
    }

    protected static String getJdkLoc() {
        return jdkLoc;
    }

    protected static boolean isJdkOptionSpecified() {
        return !jdkLoc.equals("");
    }

    protected static String getJarCommandLoc() {
        if (jdkLoc == null || jdkLoc.equals("")) {
            return "";
        }
        StringBuffer cmd = new StringBuffer(jdkLoc);
        if (OPatchEnv.isWindows()) {
            cmd.append(StringResource.JDK_BIN_JAR_CMD_WINDOWS);
        } else {
            cmd.append(StringResource.JDK_BIN_JAR_CMD_UNIX);
        }
        File f2 = new File(cmd.toString());
        if (f2.exists()) {
            return f2.getAbsolutePath();
        }
        return "";
    }

    protected static boolean isJarCommandAvailable(String baseDir) {
        if (baseDir == null) {
            return false;
        }
        StringBuffer jar = new StringBuffer(baseDir);
        if (OPatchEnv.isWindows()) {
            jar.append(StringResource.JDK_BIN_JAR_CMD_WINDOWS);
        } else {
            jar.append(StringResource.JDK_BIN_JAR_CMD_UNIX);
        }
        File f2 = new File(jar.toString());
        return f2.exists();
    }

    protected static boolean isJarCommandAvailable() {
        String jar = null;
        OPatchProperty opp = new OPatchProperty();
        try {
            jar = opp.getJarCommand(OPatchEnv.getOracleHome());
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("OPatchProperty::getJarCommand() raised exception");
            buff.append(" so returning false");
            OLogger.debug(buff);
            return false;
        }
        return jar != null && !jar.equals("");
    }

    protected static String getJarCommand_ExtractOption() {
        if (OPatchEnv.isJarCommandAvailable()) {
            OPatchProperty opp = new OPatchProperty();
            String jar = null;
            try {
                jar = opp.getJarCommand(OPatchEnv.getOracleHome());
            }
            catch (Exception e2) {
                StringBuffer buff = new StringBuffer("OPatchProperty::getJarCommand() raised exception");
                buff.append(" so returning empty string");
                OLogger.debug(buff);
                return "";
            }
            StringBuffer jarCmd_XF = new StringBuffer(jar);
            jarCmd_XF.append(" -xf ");
            StringBuffer buff = new StringBuffer("getJarCommand_ExtractOption(): \"");
            buff.append(jarCmd_XF.toString());
            buff.append("\"");
            OLogger.debug(buff);
            return jarCmd_XF.toString();
        }
        return "";
    }

    protected static String getJarCommand_UpdateOption() {
        if (OPatchEnv.isJarCommandAvailable()) {
            OPatchProperty opp = new OPatchProperty();
            String jar = null;
            try {
                jar = opp.getJarCommand(OPatchEnv.getOracleHome());
            }
            catch (Exception e2) {
                StringBuffer buff = new StringBuffer("OPatchProperty::getJarCommand() raised exception");
                buff.append(" so returning empty string");
                OLogger.debug(buff);
                return "";
            }
            StringBuffer jarCmd_UF = new StringBuffer(jar);
            jarCmd_UF.append(" -uf ");
            StringBuffer buff = new StringBuffer("getJarCommand_UpdateOption(): \"");
            buff.append(jarCmd_UF.toString());
            buff.append("\"");
            OLogger.debug(buff);
            return jarCmd_UF.toString();
        }
        return "";
    }

    protected static void setJdkLoc(String jdkloc) {
        jdkLoc = jdkloc;
    }

    public static boolean isJreOptionSpecified() {
        return jreOptionSpecified;
    }

    public static void setJreOptionSpecified(boolean jreOption) {
        jreOptionSpecified = jreOption;
    }

    protected static String getJreLoc() {
        return jreLoc;
    }

    protected static void setJreLoc(String jreLoc) {
        OPatchEnv.jreLoc = jreLoc;
    }

    protected static void setOracleHome(String oracleHome) {
        String tmpS = oracleHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.oracleHome = tmpS;
    }

    protected static String getCmdOracleHome() {
        return cmdOracleHome;
    }

    protected static void setCmdOracleHome(String cmdOracleHome) {
        String tmpS = cmdOracleHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.cmdOracleHome = tmpS;
    }

    protected static String getEnvOracleHome() {
        return envOracleHome;
    }

    protected static void setEnvOracleHome(String envOracleHome) {
        String tmpS = envOracleHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.envOracleHome = tmpS;
    }

    protected static String getRspOracleHome() {
        return rspOracleHome;
    }

    protected static void setRspOracleHome(String rspOracleHome) {
        String tmpS = rspOracleHome;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        OPatchEnv.rspOracleHome = tmpS;
    }

    protected static boolean isInvPtrLocSpecified() {
        return invPtrLocSpecified;
    }

    protected static void setInvPtrLocSpecified() {
        invPtrLocSpecified = true;
    }

    public static String getUserSpecifiedInvPtrLoc() {
        return userSpecifiedInvPtrLoc;
    }

    public static void setUserSpecifiedInvPtrLoc(String input) {
        userSpecifiedInvPtrLoc = input;
    }

    public static String getInvPtrLoc() {
        if (oraInstLoc == null) {
            OPatchEnv.setInvPtrLoc(OPatchEnv.getDefault_OraInst());
        }
        return oraInstLoc;
    }

    protected static String getAbsoluteInvPtrLoc() {
        File f2 = new File(OPatchEnv.getInvPtrLoc());
        if (f2 == null) {
            return "";
        }
        String absOraInstLoc = "";
        try {
            absOraInstLoc = f2.getCanonicalPath();
        }
        catch (IOException e2) {
            absOraInstLoc = "";
        }
        return absOraInstLoc;
    }

    protected static void setInvPtrLoc(String invPtrLoc) {
        if (invPtrLoc != null && !invPtrLoc.equals("")) {
            OPatchEnv.setUserSpecifiedInvPtrLoc(invPtrLoc);
            File f2 = new File(invPtrLoc);
            oraInstLoc = f2.exists() && f2.canRead() ? invPtrLoc : "";
        } else {
            oraInstLoc = "";
        }
        System.setProperty("oracle.installer.invPtrLoc", oraInstLoc);
    }

    protected static boolean isVerbose() {
        return verbose;
    }

    protected static void setVerbose(boolean verbose) {
        OPatchEnv.verbose = verbose;
    }

    public static boolean isSilent() {
        return silent;
    }

    protected static void setSilent(boolean silent) {
        OPatchEnv.silent = silent;
    }

    public static boolean isForce() {
        return force;
    }

    protected static void setForce(boolean force) {
        OPatchEnv.force = force;
    }

    public static boolean isForceConflict() {
        return force_conflict;
    }

    public static void setForceConflict(boolean force_conflict) {
        OPatchEnv.force_conflict = force_conflict;
    }

    public static boolean isOptimize() {
        return optimize;
    }

    public static void setOptimize(boolean optimize) {
        if (optimize) {
            OPatchEnv.setForceConflict(true);
            OPatchEnv.setForce(true);
        }
        OPatchEnv.optimize = optimize;
    }

    public static boolean isOhInstanceUp() {
        return ohInstanceUp;
    }

    public static void setOhInstanceUp(boolean ohInstanceUp) {
        OPatchEnv.ohInstanceUp = ohInstanceUp;
    }

    protected static void setLocal(boolean local) {
        OPatchEnv.local = local;
    }

    public static String getPatchIdForApplySql() {
        return OPatchEnv.getRollbackPatchid();
    }

    public static String getRollbackPatchid() {
        if (patchIDs.length > 0) {
            int lastIndex;
            String subStr = "_en";
            if (patchIDs[0].endsWith(subStr) && (lastIndex = patchIDs[0].lastIndexOf(subStr)) != -1) {
                OPatchEnv.patchIDs[0] = patchIDs[0].substring(0, lastIndex);
            }
            return patchIDs[0];
        }
        return "";
    }

    protected static void setRollbackPatchid(String givenID) {
        if (givenID == null || givenID.equals("")) {
            patchIDs = new String[0];
        } else {
            patchIDs = new String[1];
            OPatchEnv.patchIDs[0] = givenID;
        }
    }

    protected static void setPatchloc(String patchloc) {
        String[] patchlocArray = new String[]{patchloc};
        OnlinePatchProcessor.handleOnlinePatch(patchlocArray);
        OPatchEnv.patchloc = patchlocArray[0];
    }

    public static String getCookedPatchID() {
        return cookedPatchID;
    }

    protected static void initCookedPatchID(String cookedPatchID) {
        OPatchEnv.cookedPatchID = cookedPatchID;
    }

    protected static String getPostopt() {
        return postopt;
    }

    public static boolean isNoPreScript() {
        return noPreScriptOpt;
    }

    protected static void setNoPreScriptOpt(boolean noPreScriptOpt) {
        OPatchEnv.noPreScriptOpt = noPreScriptOpt;
    }

    public static boolean isNoPostScript() {
        return noPostScriptOpt;
    }

    protected static void setNoPostScriptOpt(boolean noPostScriptOpt) {
        OPatchEnv.noPostScriptOpt = noPostScriptOpt;
    }

    protected static void setPostopt(String postopt) {
        OPatchEnv.postopt = postopt;
    }

    public static String getPreopt() {
        return preopt;
    }

    protected static void setPreopt(String preopt) {
        OPatchEnv.preopt = preopt;
    }

    protected static String getInitopt() {
        return initopt;
    }

    protected static void setInitopt(String initopt) {
        OPatchEnv.initopt = initopt;
    }

    protected static void setVersionAll(boolean versionAll) {
        version_all = versionAll;
    }

    protected static boolean isVersionAll() {
        return version_all;
    }

    protected static void setVersionV2c(String v2c) {
        version_v2c = v2c;
    }

    protected static void setVersionOhs(String[] ohs) {
        if (ohs != null && ohs.length != 0) {
            version_ohs = new String[0];
            version_ohs = ohs;
        }
    }

    protected static String getVersionV2c() {
        return version_v2c;
    }

    protected static String[] getVersionOhs() {
        return version_ohs;
    }

    public static OneOffEntry[] getPi() {
        return pi;
    }

    public static void setPi(OneOffEntry[] val) {
        pi = val;
    }

    protected static boolean isLsinv_all() {
        return lsinv_all;
    }

    protected static boolean isLsinv_detail() {
        return lsinv_detail;
    }

    protected static boolean isLsinv_inactive() {
        return lsinv_inactive;
    }

    protected static void setLsinv_inactive(boolean lsinv_inactive) {
        OPatchEnv.lsinv_inactive = lsinv_inactive;
    }

    protected static boolean isLsinv_patch() {
        return lsinv_patch;
    }

    protected static boolean isLsinv_patch_id() {
        return lsinv_patch_id;
    }

    protected static boolean isLsinv_xml() {
        return lsinv_xml;
    }

    static void setLsinv_xml(boolean b2) {
        lsinv_xml = b2;
    }

    static String getLsinv_xml_loc() {
        return lsinv_xml_loc;
    }

    static void setLsinv_xml_loc(String s) {
        lsinv_xml_loc = s;
    }

    protected static boolean isXMLCompare() {
        return xmlCompare;
    }

    static void setXMLCompare(boolean b2) {
        xmlCompare = b2;
    }

    static String getXMLCompare_loc1() {
        return xmlCompare_loc1;
    }

    static void setXMLCompare_loc1(String s) {
        xmlCompare_loc1 = s;
    }

    static String getXMLCompare_loc2() {
        return xmlCompare_loc2;
    }

    static void setXMLCompare_loc2(String s) {
        xmlCompare_loc2 = s;
    }

    static void setNoBugSuperset(boolean b2) {
        noBugSuperSet = b2;
    }

    public static boolean isNoBugSuperset() {
        return noBugSuperSet;
    }

    public static void setIgnoreConflict(boolean b2) {
        ignoreConflict = b2;
    }

    public static boolean isIgnoreConflict() {
        return ignoreConflict;
    }

    static void setIgnoreMissingComponent(boolean b2) {
        ignoreMissingComponent = b2;
    }

    public static boolean isIgnoreMissingComponent() {
        return ignoreMissingComponent;
    }

    static void setGroupByDate(boolean b2) {
        groupByDate = b2;
    }

    public static boolean isGroupByDate() {
        return groupByDate;
    }

    public static boolean isSkipSubset() {
        return skipSubset;
    }

    public static void setSkipSubset(boolean b2) {
        skipSubset = b2;
    }

    public static boolean isSkipDuplicate() {
        return skipDuplicate;
    }

    public static void setSkipDuplicate(boolean b2) {
        skipDuplicate = b2;
    }

    public static String getNApplyBaseDir() {
        return nApplyBaseDir;
    }

    protected static void setNApplyBaseDir(String completePath) {
        nApplyBaseDir = completePath;
    }

    protected static boolean isLsinv_match() {
        return lsinv_match;
    }

    static void setLsInv_match(boolean b2) {
        lsinv_match = b2;
    }

    protected static String getLsInvRegExpression() {
        return lsInvRegExpression;
    }

    protected static void setLsInvRegExpression(String exp) {
        lsInvRegExpression = exp;
    }

    protected static void setLsinv_all(boolean lsinv_all) {
        OPatchEnv.lsinv_all = lsinv_all;
    }

    protected static void setUtil_all(boolean util_all) {
        OPatchEnv.util_all = util_all;
    }

    protected static boolean isutil_all() {
        return util_all;
    }

    protected static void setIsSrvmUtil(boolean in) {
        isSrvmUtil = in;
    }

    public static boolean isSrvmUtil() {
        return isSrvmUtil;
    }

    protected static void setLsinv_detail(boolean lsinv_detail) {
        OPatchEnv.lsinv_detail = lsinv_detail;
    }

    protected static void setLsinv_patch(boolean lsinv_patch) {
        OPatchEnv.lsinv_patch = lsinv_patch;
    }

    protected static void setLsinv_patch_order(String order) {
        lsinv_patch_order = order;
    }

    protected static String getLsinv_patch_order() {
        return lsinv_patch_order;
    }

    protected static void setLsinv_patch_id(boolean lsinv_patch_id) {
        OPatchEnv.lsinv_patch_id = lsinv_patch_id;
    }

    protected static void setLsinv_patch_id_order(String order) {
        lsinv_patch_id_order = order;
    }

    protected static String getLsinv_patch_id_order() {
        return lsinv_patch_id_order;
    }

    protected static void setLsinv_bug_order(String order) {
        lsinv_bug_order = order;
    }

    protected static String getLsinv_bug_order() {
        return lsinv_bug_order;
    }

    public static String getLsp_queryfile() {
        return lsp_queryfile;
    }

    protected static void setLsp_queryfile(String lspQueryfile) {
        lsp_queryfile = lspQueryfile;
    }

    protected static boolean isLsp_Required() {
        return lsp_Required;
    }

    protected static void setLsp_Required(boolean lspRequired) {
        lsp_Required = lspRequired;
    }

    protected static boolean isLsp_Verified() {
        return lsp_Verified;
    }

    protected static void setLsp_Verified(boolean lspVerified) {
        lsp_Verified = lspVerified;
    }

    protected static boolean isLsp_bugs() {
        return lsp_bugs;
    }

    protected static void setLsp_bugs(boolean lspBugs) {
        lsp_bugs = lspBugs;
    }

    protected static int getPatchFormat() {
        return patchFormat;
    }

    protected static void setPatchFormat(int inPatchFormat) {
        patchFormat = inPatchFormat;
    }

    protected static String getCompositeXMLPath() {
        return compositeXMLPath;
    }

    protected static void setCompositeXMLPath(String compositeXMLFilePath) {
        compositeXMLPath = compositeXMLFilePath;
    }

    public static String getCompositeActiveID() {
        return activeCompositeID;
    }

    public static void setCompositeActiveID(String compositeID) {
        activeCompositeID = compositeID;
    }

    public static boolean isAll_Subpatches() {
        return all_Subpatches;
    }

    public static void setAll_Subpatches(boolean allSubpatches) {
        all_Subpatches = allSubpatches;
    }

    protected static boolean isHelp() {
        return help;
    }

    protected static void setHelp(boolean help) {
        OPatchEnv.help = help;
    }

    protected static void setFmwHelp(boolean help) {
        fmwHelp = help;
    }

    protected static boolean isFmwHelp() {
        return fmwHelp;
    }

    public static void setRetry(int retry) {
        OPatchEnv.retry = retry;
    }

    protected static void setDelay(int delay) {
        OPatchEnv.delay = delay;
    }

    public static boolean isReport() {
        return report;
    }

    protected static void setReport(boolean b2) {
        report = b2;
    }

    protected static String getOSName() {
        return osName;
    }

    protected static boolean isLinux() {
        String osName = OPatchEnv.getOSName();
        return osName.equalsIgnoreCase("linux");
    }

    public static boolean isWindows() {
        return osName.matches("[W|w]indows*.*");
    }

    public static String getPatchStorageName() {
        return PATCH_STORAGE_DIRECTORY;
    }

    public static String getPatchStorageScriptPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(OPatchEnv.getPatchStorageName());
        buff.append(File.separator);
        buff.append(cookedPatchID);
        buff.append(File.separator);
        buff.append("dbScripts");
        return buff.toString();
    }

    public static String getPatchStorageDirectoryPath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(OPatchEnv.getPatchStorageName());
        return buff.toString();
    }

    public static String getPatchStorageVeirifyDirectoryPathForJar(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        String actionType = VERIFY_JAR_SUBDIR;
        buff.append(File.separator);
        buff.append(OPatchEnv.getPatchStorageName());
        buff.append(File.separator);
        buff.append(VERIFY_DIRECTORY);
        buff.append(File.separator);
        buff.append(actionType);
        return buff.toString();
    }

    public static String getPatchStorageVeirifyDirectoryPathForArchive(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        String actionType = VERIFY_AR_SUBDIR;
        buff.append(File.separator);
        buff.append(OPatchEnv.getPatchStorageName());
        buff.append(File.separator);
        buff.append(VERIFY_DIRECTORY);
        buff.append(File.separator);
        buff.append(actionType);
        return buff.toString();
    }

    public static String getPatchStorageVerifyDirectoryPath(String oracleHomePath, PatchAction pa) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        String actionType = VERIFY_GENERIC_SUBDIR;
        if (pa instanceof CopyAction) {
            actionType = VERIFY_COPY_SUBDIR;
        } else if (pa instanceof JarAction) {
            actionType = VERIFY_JAR_SUBDIR;
        } else if (pa instanceof ArchiveAction) {
            actionType = VERIFY_AR_SUBDIR;
        } else if (pa instanceof MakeAction) {
            actionType = VERIFY_MAKE_SUBDIR;
        } else if (pa instanceof PreScriptAction) {
            actionType = VERIFY_PRE_SUBDIR;
        } else if (pa instanceof PostScriptAction) {
            actionType = VERIFY_POST_SUBDIR;
        }
        buff.append(File.separator);
        buff.append(OPatchEnv.getPatchStorageName());
        buff.append(File.separator);
        buff.append(VERIFY_DIRECTORY);
        buff.append(File.separator);
        buff.append(actionType);
        return buff.toString();
    }

    public static String getPatchStorageDirectoryPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(PATCH_STORAGE_DIRECTORY);
        buff.append(File.separator);
        buff.append(cookedPatchID);
        return buff.toString();
    }

    public static String getRacSubdirName() {
        return PATCH_RAC;
    }

    public static String getNApplySessionName() {
        return N_APPLY_SESSION_NAME;
    }

    public static String getNRollbackSessionName() {
        return N_ROLLBACK_SESSION_NAME;
    }

    public static String getPatchStorageRacDirectoryPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(PATCH_STORAGE_DIRECTORY);
        buff.append(File.separator);
        buff.append(cookedPatchID);
        buff.append(File.separator);
        buff.append(OPatchEnv.getRacSubdirName());
        return buff.toString();
    }

    protected static String getPatchStorageRacModeFile(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(PATCH_STORAGE_DIRECTORY);
        buff.append(File.separator);
        buff.append(cookedPatchID);
        buff.append(File.separator);
        buff.append(OPatchEnv.getRacSubdirName());
        buff.append(File.separator);
        buff.append(PATCH_RAC_FILE);
        return buff.toString();
    }

    public static String getPatchStorageRacModeFile(String patchStorageRacDir) {
        StringBuffer buff = new StringBuffer(patchStorageRacDir);
        buff.append(File.separator);
        buff.append(PATCH_RAC_FILE);
        return buff.toString();
    }

    public static boolean isCreateRacFile() {
        return createRacFile;
    }

    protected static void setCreateRacFile(boolean b2) {
        createRacFile = b2;
    }

    public static String getBackupDirectoryPath(String oracleHomePath, String cookedPatchID) {
        String backupDir = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer(backupDir);
        buff.append(File.separator);
        buff.append(BACKUP_DIRECTORY);
        return buff.toString();
    }

    public static String getBackupProductXMLPath(String oracleHomePath, String cookedPatchID) {
        String productXMLBackup = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer(productXMLBackup);
        buff.append(File.separator);
        buff.append("product.xml");
        return buff.toString();
    }

    public static String getPatchBackupDirectoryPath(String oracleHomePath, String cookedPatchID) {
        String backupDir = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer(backupDir);
        buff.append(File.separator);
        buff.append(PATCH_BACKUP);
        return buff.toString();
    }

    public static String getPatchScratchDirectoryPath(String oracleHomePath, String cookedPatchID) {
        String backupDir = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer(backupDir);
        buff.append(File.separator);
        buff.append(PATCH_SCRATCH);
        File fileScratch = new File(buff.toString());
        if (!fileScratch.exists()) {
            fileScratch.mkdirs();
        }
        return buff.toString();
    }

    protected static boolean setupPatchBackup(String oracleHomePath, String cookedPatchID) {
        String patchStorage = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
        File f2 = new File(patchStorage);
        boolean ok = true;
        if (!f2.exists()) {
            ok = f2.mkdirs();
        }
        return ok;
    }

    public static boolean setupScriptStorage(String oracleHomePath, String cookedPatchID) {
        boolean ok = true;
        ok = OPatchEnv.setupPatchStorage(oracleHomePath, cookedPatchID);
        if (!ok) {
            return false;
        }
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer scriptStorage = new StringBuffer(patchStorage);
        scriptStorage.append(File.separator);
        scriptStorage.append("dbScripts");
        File f2 = new File(scriptStorage.toString());
        ok = true;
        if (!f2.exists()) {
            ok = f2.mkdirs();
        }
        return ok;
    }

    protected static boolean setupPatchRestore(String oracleHomePath, String cookedPatchID) {
        String patchStorage = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        File f2 = new File(patchStorage);
        boolean ok = true;
        if (!f2.exists()) {
            ok = f2.mkdirs();
        }
        return ok;
    }

    public static String getRollbackDirectoryPath(String oracleHomePath, String cookedPatchID) {
        String backupDir = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer(backupDir);
        buff.append(File.separator);
        buff.append(FILES_DIRECTORY);
        return buff.toString();
    }

    public static String getPatchFilesDirectoryPath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append(FILES_DIRECTORY);
        return buff.toString();
    }

    protected static String getRestoreFileLPath(String oracleHomePath, String cookedPatchID) {
        boolean isWindow = OPatchEnv.isWindows();
        String rbFileLoc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer rtFilePath = new StringBuffer(rbFileLoc);
        rtFilePath.append(File.separator);
        if (isWindow) {
            rtFilePath.append("restore.bat");
        } else {
            rtFilePath.append("restore.sh");
        }
        return rtFilePath.toString();
    }

    public static String getRestoreOHCommand(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("opatch util restoreOH");
        return buff.toString();
    }

    public static String getManualMakeFile(String oracleHomePath, String cookedPatchID) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer makeFile = new StringBuffer(patchStorage);
        makeFile.append(File.separator);
        makeFile.append("make.txt");
        return makeFile.toString();
    }

    protected static String getManualAutoRollbackMakeFile(String oracleHomePath, String autorbPatchID, String cookedPatchID) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer makeFile = new StringBuffer(patchStorage);
        makeFile.append(File.separator);
        makeFile.append("make_autorb_");
        makeFile.append(autorbPatchID);
        makeFile.append(".txt");
        return makeFile.toString();
    }

    public static boolean setupPatchStorage(String oracleHomePath) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        File f2 = new File(patchStorage);
        boolean ok = true;
        if (!f2.exists()) {
            ok = f2.mkdirs();
        }
        return ok;
    }

    public static boolean setupOnlinePropertyFile(String oracleHomePath) {
        boolean ok = OPatchEnv.setupPatchStorage(oracleHomePath);
        if (!ok) {
            return false;
        }
        String onlinePropertyFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
        File f2 = new File(onlinePropertyFilePath);
        if (f2.exists()) {
            return true;
        }
        try {
            ok = f2.createNewFile();
            if (!ok) {
                return false;
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return false;
        }
        Properties prop = new Properties();
        prop.setProperty("PATCH_ID", "unknown");
        try {
            FileOutputStream fout = new FileOutputStream(f2);
            prop.store(fout, null);
            fout.close();
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            return false;
        }
        return true;
    }

    public static boolean setupSqlPropertyFile(String oracleHomePath, String cookedPatchID) {
        String cookedDirPath = "";
        boolean ok = OPatchEnv.setupPatchStorage(oracleHomePath, cookedPatchID);
        if (!ok) {
            return false;
        }
        cookedDirPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer sqlPropertyFilePath = new StringBuffer(cookedDirPath);
        sqlPropertyFilePath.append(File.separator);
        sqlPropertyFilePath.append("sqlproperties");
        File f2 = new File(sqlPropertyFilePath.toString());
        if (f2.exists()) {
            StringBuffer backupFile = new StringBuffer(cookedDirPath);
            backupFile.append(File.separator);
            backupFile.append("backup_sqlproperties");
            File bf = new File(backupFile.toString());
            try {
                SystemCall.backupFile(f2, bf);
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                return false;
            }
            return true;
        }
        try {
            ok = f2.createNewFile();
            if (!ok) {
                return false;
            }
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            return false;
        }
        Properties prop = new Properties();
        prop.setProperty("RUNSQL", "unknown");
        prop.setProperty("SID", "unknown");
        try {
            FileOutputStream fout = new FileOutputStream(f2);
            prop.store(fout, null);
            fout.close();
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
            return false;
        }
        return true;
    }

    protected static boolean setupPatchStorage(String oracleHomePath, String cookedPatchID) {
        String backup;
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        File f2 = new File(patchStorage);
        boolean ok = true;
        if (!f2.exists()) {
            ok = f2.mkdir();
            if (!ok) {
                return false;
            }
            OPatchEnv.setPatchStoragePresentValid(true);
        }
        if (!(f2 = new File(backup = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID))).exists()) {
            ok = f2.mkdirs();
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getPatchFilemapInfoLoc(String oracleHomePath, String patchID, boolean firstPattern) {
        String patchDir = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
        if (!firstPattern) {
            return new String[]{patchDir, patchID};
        }
        File f2 = new File(patchDir);
        if (f2.exists()) return new String[]{patchDir, patchID};
        File fParent = f2.getParentFile();
        if (fParent == null || !fParent.exists()) return new String[]{patchDir, patchID};
        String parentPath = "";
        try {
            parentPath = fParent.getCanonicalPath();
        }
        catch (IOException e2) {
            return new String[]{patchDir, patchID};
        }
        String[] entities = fParent.list(null);
        for (int i2 = 0; i2 < entities.length; ++i2) {
            String fullPath = parentPath + File.separator + entities[i2];
            File fp = new File(fullPath);
            if (!fp.isDirectory() || !entities[i2].startsWith(patchID)) continue;
            patchID = entities[i2];
            return new String[]{fullPath, entities[i2]};
        }
        return new String[]{patchDir, patchID};
    }

    public static String getPatchFilemapInfoLoc(String oracleHomePath, String patchID) {
        String oh = null;
        oh = oracleHomePath == null ? "" : oracleHomePath;
        StringBuffer buff = new StringBuffer(oh);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        buff.append(File.separator);
        buff.append(patchID);
        return buff.toString();
    }

    public static String getPatchloc() {
        if (patchUnzipped || patchloc.equals("")) {
            return patchloc;
        }
        File f2 = new File(patchloc);
        if (!f2.isDirectory()) {
            if (patchloc.endsWith(".zip")) {
                String topLevelDir;
                String extractLoc = OPatchEnv.getPatchUnzipLocation();
                try {
                    topLevelDir = ZipUtilities.unzip(patchloc, extractLoc);
                }
                catch (RuntimeException re) {
                    StringBuffer buff = new StringBuffer("Unable to extract the zip file : ");
                    buff.append(patchloc);
                    OLogger.println(buff.toString());
                    throw re;
                }
                String fullPath = extractLoc + File.separator + topLevelDir;
                f2 = new File(fullPath);
                if (!f2.exists() || !f2.isDirectory()) {
                    StringBuffer tBuff = new StringBuffer("The location \"");
                    tBuff.append(patchloc);
                    tBuff.append("\" is not a valid patch zip file. Its extraction ");
                    tBuff.append("did not create a directory.");
                    OLogger.println(tBuff.toString());
                    RuntimeException re = new RuntimeException(tBuff.toString());
                    throw re;
                }
                patchloc = fullPath;
                patchUnzipped = true;
            } else {
                StringBuffer tBuff = new StringBuffer("The location \"");
                tBuff.append(patchloc);
                tBuff.append("\" is not a directory or a valid patch zip file. ");
                OLogger.println(tBuff.toString());
                RuntimeException re = new RuntimeException("Invalid patch location.");
                throw re;
            }
        }
        return patchloc;
    }

    public static boolean proceedWithOperationDefaultNo(StringBuffer buff) {
        return OPatchEnv.proceedWithOperation(buff, false);
    }

    public static boolean proceedWithOperationDefaultYes(StringBuffer buff) {
        return OPatchEnv.proceedWithOperation(buff, true);
    }

    public static boolean proceedWithOperationDefaultNo(String question) {
        return OPatchEnv.proceedWithOperation(question, false);
    }

    public static boolean proceedWithOperationDefaultYes(String question) {
        return OPatchEnv.proceedWithOperation(question, true);
    }

    private static boolean proceedWithOperation(StringBuffer buff, boolean silentResult) {
        boolean result = false;
        String str = OLogger.getString("OUI-67057", new Object[]{buff.toString(), "[y|n]"});
        OLogger.println(str);
        if (OPatchEnv.isSilent()) {
            try {
                Thread.sleep(SILENT_PAUSE * 1000);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            result = silentResult;
            String autoAns = result ? autoYes : autoNo;
            OLogger.println(autoAns);
        } else {
            result = OPatchEnv.waitForUserYesNo();
        }
        if (result) {
            buff = new StringBuffer(userYes);
            OLogger.log(OLogger.INFO, buff.toString());
        } else {
            buff = new StringBuffer(userNo);
            OLogger.log(OLogger.INFO, buff.toString());
        }
        if (!exitWithUserReq) {
            exitWithUserReq = !result;
        }
        return result;
    }

    private static boolean proceedWithOperation(String question, boolean silentResult) {
        StringBuffer buff;
        boolean result = false;
        OLogger.println(question);
        if (OPatchEnv.isSilent()) {
            try {
                Thread.sleep(SILENT_PAUSE * 1000);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            result = silentResult;
            String autoAns = result ? autoYes : autoNo;
            OLogger.println(autoAns);
        } else {
            result = OPatchEnv.isInteractive() ? OPatchEnv.waitForUserYesQuit() : OPatchEnv.waitForUserYesNo();
        }
        if (result) {
            buff = new StringBuffer(userYes);
            OLogger.log(OLogger.INFO, buff.toString());
        } else if (OPatchEnv.isInteractive()) {
            buff = new StringBuffer(userQuit);
            OLogger.log(OLogger.INFO, buff.toString());
        } else {
            buff = new StringBuffer(userNo);
            OLogger.log(OLogger.INFO, buff.toString());
        }
        if (!exitWithUserReq) {
            exitWithUserReq = !result;
        }
        return result;
    }

    protected static String waitForUserInput() {
        String result = "";
        if (OPatchEnv.isSilent()) {
            try {
                Thread.sleep(SILENT_PAUSE * 1000);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result;
        }
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            StringBuffer ts = new StringBuffer("Start to wait for user-input at ");
            OLogger.logTime(ts);
            long then = System.currentTimeMillis();
            result = stdin.readLine();
            long now = System.currentTimeMillis();
            ts = new StringBuffer("Finish waiting for user-input at ");
            OLogger.logTime(ts);
            long elapsedTime = now - then;
            totalTimeSpentOnUserInput += elapsedTime;
        }
        catch (IOException e2) {
            OLogger.error("OUI-67016");
        }
        return result;
    }

    protected static boolean waitForUserYesNo() {
        String result;
        while (!(result = OPatchEnv.waitForUserInput().toUpperCase().trim()).equals("Y") && !result.equals("YES")) {
            if (result.equals("N") || result.equals("NO")) {
                return false;
            }
            OLogger.println("Could not recognize input. Please re-enter.");
        }
        return true;
    }

    protected static boolean waitForUserYesQuit() {
        String result;
        while (!(result = OPatchEnv.waitForUserInput().toUpperCase().trim()).equals("Y") && !result.equals("YES")) {
            if (result.equals("Q") || result.equals("QUIT")) {
                return false;
            }
            OLogger.println("Could not recognize input. Please re-enter.");
        }
        return true;
    }

    protected static boolean waitForUserEnter() {
        OPatchEnv.waitForUserInput();
        return true;
    }

    public static boolean isSqlDBError() {
        return dbError;
    }

    public static void setSqlDBError(boolean in) {
        dbError = in;
    }

    public static String getSIDSubsetValue() {
        return subsetSIDInfo;
    }

    public static void setSIDSubsetValue(String in) {
        StringBuffer buff = new StringBuffer();
        if (in.equals("")) {
            subsetSIDInfo = in;
        } else {
            buff.append(subsetSIDInfo);
            buff.append("  ");
            buff.append(in);
            subsetSIDInfo = buff.toString();
        }
    }

    protected static boolean promptUserSelections(ArrayList product, ArrayList version, String oracleHomePath) throws RuntimeException {
        int i2;
        String input = "";
        int intInput = -1;
        String msg = "";
        StringBuffer buff = new StringBuffer("OPatchEnv::promptUserSelections called");
        OLogger.debug(buff);
        msg = OLogger.getString("OUI-67238");
        OLogger.println(msg);
        OLogger.println("\nChoice\t\t\t\tProduct\t\t\t\tVersion");
        OLogger.println("------\t\t\t\t-------\t\t\t\t-------");
        int choiceSize = 6;
        int productSize = 7;
        for (i2 = 0; i2 < product.size(); ++i2) {
            int newLengthC = 0;
            int newLengthP = 0;
            String p2 = (String)product.get(i2);
            String v = (String)version.get(i2);
            String choice = new Integer(i2 + 1).toString();
            int tabSize = 26;
            newLengthC = choice.length() < choiceSize ? choiceSize - choice.length() + tabSize : (choice.length() > choiceSize ? tabSize - (choice.length() - choiceSize) : tabSize);
            tabSize = 25;
            newLengthP = p2.length() < productSize ? productSize - p2.length() + tabSize : (p2.length() > productSize ? tabSize - (p2.length() - productSize) : tabSize);
            OLogger.println(i2 + 1 + OPatchEnv.getSpaceString(newLengthC) + p2 + OPatchEnv.getSpaceString(newLengthP) + v);
        }
        OLogger.println("");
        msg = OLogger.getString("OUI-67240");
        OLogger.println(i2 + 1 + ". " + msg);
        msg = OLogger.getString("OUI-67239", new Object[]{new Integer(i2 + 1).toString()});
        OLogger.println(msg);
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            buff = new StringBuffer("");
            if (!Rules.shouldCreateProductByForceSilent()) {
                msg = OLogger.getString("OUI-67247");
                OLogger.log(OLogger.FINE, msg);
                intInput = i2 + 1;
                buff.append(autoAns);
            } else {
                if (!Rules.shouldCreateProductBySilent()) {
                    StringBuffer silentMsg = new StringBuffer(oracleHomePath);
                    silentMsg.append(File.separator);
                    silentMsg.append("product.xml");
                    msg = OLogger.getString("OUI-67234", new Object[]{silentMsg.toString()});
                    throw new RuntimeException(msg);
                }
                input = stdin.readLine();
                intInput = Integer.parseInt(input);
            }
            OLogger.println(choiceValue + intInput + buff.toString());
            if (intInput < 1 || intInput > i2 + 1) {
                msg = OLogger.getString("OUI-67242");
                OLogger.println(msg);
                return false;
            }
            if (intInput == i2 + 1) {
                msg = OLogger.getString("OUI-67259", new Object[]{"[y|n]"});
                boolean result = OPatchEnv.proceedWithOperationDefaultYes(msg);
                if (result) {
                    msg = OLogger.getString("OUI-67249");
                    OLogger.println(msg);
                    return true;
                }
                return false;
            }
            String selProduct = (String)product.get(intInput - 1);
            String selVersion = (String)version.get(intInput - 1);
            buff = new StringBuffer("Selected product : ");
            buff.append(selProduct);
            buff.append("\nSelected version : ");
            buff.append(selVersion);
            OLogger.debug(buff);
            OPatchEnv.setSelectedProductVersion(selProduct, selVersion);
            return true;
        }
        catch (IOException e2) {
            buff = new StringBuffer("Unable to parse the input given");
            buff.append("\n");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString(), e2);
            throw re;
        }
        catch (NumberFormatException e3) {
            OLogger.println(choiceValue + input);
            msg = OLogger.getString("OUI-67242");
            OLogger.println(msg);
            return false;
        }
    }

    protected static String getSpaceString(int size) {
        StringBuffer buff = new StringBuffer("");
        for (int i2 = 0; i2 < size; ++i2) {
            buff.append(" ");
        }
        return buff.toString();
    }

    protected static boolean isSyntaxError() {
        return syntaxError;
    }

    protected static String getSyntaxErrorMsg() {
        return syntaxErrorMsg;
    }

    protected static boolean isArgumentError() {
        return argError;
    }

    protected static String getArgumentErrorMsg() {
        return argErrorMsg;
    }

    protected static void setSyntaxError(boolean syntaxError) {
        OPatchEnv.syntaxError = syntaxError;
    }

    protected static void setSyntaxErrorMsg(String msg) {
        syntaxErrorMsg = msg;
    }

    protected static void setSyntaxError(boolean syntaxError, String msg) {
        OPatchEnv.setSyntaxError(syntaxError);
        OPatchEnv.setSyntaxErrorMsg(msg);
    }

    protected static void setArgumentError(boolean argError) {
        OPatchEnv.argError = argError;
    }

    protected static void setArgumentErrorMsg(String msg) {
        argErrorMsg = msg;
    }

    protected static void setArgumentError(boolean argError, String msg) {
        OPatchEnv.setArgumentError(argError);
        OPatchEnv.setArgumentErrorMsg(msg);
    }

    public static boolean isNolink() {
        return nolink;
    }

    protected static void setNolink(boolean b2) {
        nolink = b2;
    }

    public static boolean isNoPatchgen() {
        return nopatchgen;
    }

    protected static void setNoPatchgen(boolean b2) {
        nopatchgen = b2;
    }

    public static boolean isReboot() {
        return isReboot;
    }

    protected static void setReboot(boolean reboot) {
        isReboot = reboot;
    }

    public static boolean isMinDowntime() {
        return minDowntime;
    }

    protected static void setMinDowntime(boolean b2) {
        minDowntime = b2;
    }

    public static boolean isAllNode() {
        return allNode;
    }

    protected static void setAllNode(boolean b2) {
        allNode = b2;
    }

    protected static void setUtilOption(String option) {
        utilOption = option;
    }

    public static String getUtilOption() {
        return utilOption;
    }

    public static boolean isBeaHome() {
        return isBeaHome;
    }

    public static void setBeaHome(boolean in) {
        isBeaHome = in;
    }

    public static boolean isCleanupCmdLine() {
        return isCleanupCmdLine;
    }

    public static void setCleanupCmdLine(boolean in) {
        isCleanupCmdLine = in;
    }

    public static boolean isDesiredHome() {
        return isDesiredHome;
    }

    public static void setDesiredHome(boolean b2) {
        isDesiredHome = b2;
    }

    public static String getBeaHomePath() {
        if (beaHome == null || beaHome.equals("")) {
            return OPatchEnv.getMiddlewareHome();
        }
        return beaHome;
    }

    public static void setBeaHomePath(String in) {
        beaHome = in;
    }

    public static void setProfileMask(String s) {
        profileMask = s;
    }

    public static String getProfileMask() {
        return profileMask;
    }

    public static String getBsuCommandPath() {
        StringBuffer buff = new StringBuffer(OPatchEnv.getBeaHomePath());
        return OPatchEnv.getBsuCommandPath(buff.toString());
    }

    public static String getBsuCommandPath(String middlewareHome) {
        StringBuffer buff = new StringBuffer(middlewareHome);
        buff.append(File.separator);
        buff.append("utils");
        buff.append(File.separator);
        buff.append("bsu");
        buff.append(File.separator);
        if (OPatchEnv.isWindows()) {
            buff.append("bsu.cmd");
        } else {
            buff.append("bsu.sh");
        }
        File f2 = new File(buff.toString());
        if (f2.exists()) {
            return buff.toString();
        }
        return "";
    }

    public static String getBsuCommandDirectoryPath() {
        StringBuffer buff = new StringBuffer(OPatchEnv.getBeaHomePath());
        buff.append(File.separator);
        buff.append("utils");
        buff.append(File.separator);
        buff.append("bsu");
        return buff.toString();
    }

    public static String getBsuOutput() {
        return bsuOutput;
    }

    public static Object[] getWlsPrereqOneOffsList() {
        return wlsPrereqOneOffsList.toArray();
    }

    public static void setWlsPrereqOneOffsList(ArrayList in) {
        wlsPrereqOneOffsList = in;
    }

    protected static void setPrereqOption(String option) {
        prereqOption = option;
    }

    protected static String getPrereqOption() {
        return prereqOption;
    }

    public String toString() {
        return OPatchEnv.getToString();
    }

    protected static String getToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OPatchEnv: ");
        sb.append("OracleHome=\"");
        sb.append(OPatchEnv.getOracleHome());
        sb.append("\"");
        sb.append(", force= ");
        sb.append(OPatchEnv.isForce());
        sb.append(", report= ");
        sb.append(OPatchEnv.isReport());
        sb.append(", local mode= ");
        sb.append(OPatchEnv.isLocal());
        sb.append(", lsinv all= ");
        sb.append(OPatchEnv.isLsinv_all());
        sb.append(", lsinv detail= ");
        sb.append(OPatchEnv.isLsinv_detail());
        sb.append(", lsinv patch= ");
        sb.append(OPatchEnv.isLsinv_patch());
        sb.append(", nolink= ");
        sb.append(OPatchEnv.isNolink());
        sb.append(", Retry=");
        sb.append(OPatchEnv.getRetry());
        sb.append(", Delay=");
        sb.append(OPatchEnv.getDelay());
        sb.append(", CallerName=");
        sb.append(OPatchEnv.getCallerName());
        sb.append(", CallerVersion=");
        sb.append(OPatchEnv.getCallerVersion());
        sb.append(", SessionType=");
        sb.append(OPatchEnv.getSessionType());
        sb.append(", JdkLoc=");
        sb.append(OPatchEnv.getJdkLoc());
        sb.append(", JreLoc=");
        sb.append(OPatchEnv.getJreLoc());
        sb.append(", OracleHome via -oh=");
        sb.append(OPatchEnv.getCmdOracleHome());
        sb.append(", OracleHome via env.=");
        sb.append(OPatchEnv.getEnvOracleHome());
        sb.append(", OracleHome via response file=");
        sb.append(OPatchEnv.getRspOracleHome());
        sb.append(", OPatch recognised InvPtrLoc=");
        sb.append(OPatchEnv.getInvPtrLoc());
        sb.append(", User specified InvPtrLoc=");
        sb.append(OPatchEnv.getUserSpecifiedInvPtrLoc());
        sb.append(", No relink=");
        sb.append(OPatchEnv.isNolink());
        sb.append(", Patch ID used in Rollback=");
        sb.append(OPatchEnv.getRollbackPatchid());
        sb.append(", Patch ID with OPack timestamp=");
        sb.append(OPatchEnv.getCookedPatchID());
        sb.append(", PreOpt=");
        sb.append(OPatchEnv.getPreopt());
        sb.append(", PostOpt=");
        sb.append(OPatchEnv.getPostopt());
        sb.append(", OSName=");
        sb.append(OPatchEnv.getOSName());
        sb.append(", IsWindows=");
        sb.append(OPatchEnv.isWindows());
        sb.append(", .patch_storage=");
        sb.append(OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome()));
        sb.append(", .patch_storage/<ID>=");
        sb.append(OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome(), OPatchEnv.getCookedPatchID()));
        sb.append(", Whole patch is saved to=");
        sb.append(OPatchEnv.getPatchBackupDirectoryPath(OPatchEnv.getOracleHome(), OPatchEnv.getCookedPatchID()));
        sb.append(", Backup for Restore path=");
        sb.append(OPatchEnv.getBackupDirectoryPath(OPatchEnv.getOracleHome(), OPatchEnv.getCookedPatchID()));
        sb.append(", Backup for Rollback path=");
        sb.append(OPatchEnv.getRollbackDirectoryPath(OPatchEnv.getOracleHome(), OPatchEnv.getCookedPatchID()));
        sb.append(", FilesMap info from=");
        sb.append(OPatchEnv.getPatchFilemapInfoLoc(OPatchEnv.getOracleHome(), "<Patch_ID>"));
        sb.append(", PatchLoc=");
        sb.append(OPatchEnv.getPatchloc());
        sb.append(", SyntaxErrorMsg=");
        sb.append(OPatchEnv.getSyntaxErrorMsg());
        sb.append(" ]");
        return sb.toString();
    }

    protected static String getDefault_OraInst() {
        String oraInstLoc = "";
        try {
            File f2;
            if (OPatchEnv.isWindows()) {
                oraInstLoc = "n/a";
                return oraInstLoc;
            }
            switch (OUIReplacer.Platform.getCurrentPlatform()) {
                case 46: {
                    oraInstLoc = "/etc/oraInst.loc";
                    break;
                }
                case 198: 
                case 227: 
                case 610: {
                    oraInstLoc = "/etc/oraInst.loc";
                    break;
                }
                default: {
                    oraInstLoc = "/var/opt/oracle/oraInst.loc";
                }
            }
            if (oraInstLoc != null && (f2 = new File(oraInstLoc)).exists() && f2.canRead()) {
                return oraInstLoc;
            }
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("Exception occured while getting the default oraInst.loc");
        }
        return "";
    }

    public static String getCentralInvLoc() {
        String oracleHomePath = OPatchEnv.getOracleHome();
        String oraInstLoc = OPatchEnv.getInvPtrLoc();
        String centralInvLoc = null;
        try {
            Class<?> ngInvUtil = Class.forName("oracle.sysman.nextgen.utils.NextGenInventoryUtil");
            Method getInvLocMethod = ngInvUtil.getMethod("getInventoryLocation", String.class);
            if (getInvLocMethod.getExceptionTypes().length == 0) {
                centralInvLoc = getInvLocMethod.invoke(ngInvUtil.newInstance(), oracleHomePath).toString();
            }
        }
        catch (Throwable e2) {
            OLogger.debug("Could not get central inventory using NGOUI; " + e2.getMessage());
        }
        if (centralInvLoc == null || centralInvLoc.equals("")) {
            centralInvLoc = OPatchEnv.getCentralInvLoc(oraInstLoc);
        }
        if (centralInvLoc == null || centralInvLoc.equals("")) {
            centralInvLoc = "n/a";
        }
        return centralInvLoc;
    }

    public static String getCentralInvLoc(String oraInstLocFile) {
        OiipgPropertyLoader loader = new OiipgPropertyLoader();
        String centralInvLoc = "n/a";
        try {
            if (OPatchEnv.isWindows()) {
                Method method = loader.getClass().getMethod("getLocationFileLoc", new Class[0]);
                centralInvLoc = (String)method.invoke((Object)loader, new Object[0]);
            } else {
                Properties prop = new Properties();
                FileInputStream fis = new FileInputStream(oraInstLocFile);
                prop.load(fis);
                String key = "inventory_loc";
                centralInvLoc = prop.getProperty(key);
                fis.close();
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while getting the central inventory location.");
        }
        if (centralInvLoc == null || centralInvLoc.equals("")) {
            centralInvLoc = "n/a";
        }
        return centralInvLoc;
    }

    protected static String getSaProductXMLLocation(String oracleHomePath) {
        StringBuffer productXMLLocation = new StringBuffer("");
        productXMLLocation.append(oracleHomePath);
        productXMLLocation.append(File.separator);
        productXMLLocation.append("product.xml");
        File f2 = new File(productXMLLocation.toString());
        if (f2.exists() && f2.canRead()) {
            return productXMLLocation.toString();
        }
        return "";
    }

    protected static void dumpEnvironmentVariables() {
        Properties prop = System.getProperties();
        if (prop != null) {
            String oh = prop.getProperty("OPatch.ORACLE_HOME");
            String invPtrLoc = prop.getProperty("oracle.installer.invPtrLoc");
            String loc = prop.getProperty("oracle.installer.oui_loc");
            String libLoc = prop.getProperty("oracle.installer.library_loc");
            String startup = prop.getProperty("oracle.installer.startup_location");
            String id = prop.getProperty("OPatch.PLATFORM_ID");
            String os = prop.getProperty("os.name");
            String noFuser = prop.getProperty("OPatch.NO_FUSER");
            String skipVerify = prop.getProperty("OPatch.SKIP_VERIFY");
            String skipVerifySpace = prop.getProperty("OPatch.SKIP_VERIFY_SPACE");
            String clusterAble = prop.getProperty("oracle.installer.clusterEnabled");
            String tracingEnabled = prop.getProperty("TRACING.ENABLED");
            String tracingLevel = prop.getProperty("TRACING.LEVEL");
            String debug = prop.getProperty("OPatch.DEBUG");
            String mwHome = prop.getProperty("OPatch.MW_HOME");
            String wlHome = prop.getProperty("OPatch.WL_HOME");
            String mwCommonHome = prop.getProperty("OPatch.COMMON_COMPONENTS_HOME");
            StringBuffer buff = new StringBuffer("Environment:\n");
            buff.append("   ");
            buff.append("OPatch.ORACLE_HOME");
            buff.append("=");
            buff.append(oh);
            buff.append("\n");
            buff.append("   ");
            buff.append("oracle.installer.invPtrLoc");
            buff.append("=");
            buff.append(invPtrLoc);
            buff.append("\n");
            buff.append("   ");
            buff.append("oracle.installer.oui_loc");
            buff.append("=");
            buff.append(loc);
            buff.append("\n");
            buff.append("   ");
            buff.append("oracle.installer.library_loc");
            buff.append("=");
            buff.append(libLoc);
            buff.append("\n");
            buff.append("   ");
            buff.append("oracle.installer.startup_location");
            buff.append("=");
            buff.append(startup);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.PLATFORM_ID");
            buff.append("=");
            buff.append(id);
            buff.append("\n");
            buff.append("   ");
            buff.append("os.name");
            buff.append("=");
            buff.append(os);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.NO_FUSER");
            buff.append("=");
            buff.append(noFuser);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.SKIP_VERIFY");
            buff.append("=");
            buff.append(skipVerify);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.SKIP_VERIFY_SPACE");
            buff.append("=");
            buff.append(skipVerifySpace);
            buff.append("\n");
            buff.append("   ");
            buff.append("oracle.installer.clusterEnabled");
            buff.append("=");
            buff.append(clusterAble);
            buff.append("\n");
            buff.append("   ");
            buff.append("TRACING.ENABLED");
            buff.append("=");
            buff.append(tracingEnabled);
            buff.append("\n");
            buff.append("   ");
            buff.append("TRACING.LEVEL");
            buff.append("=");
            buff.append(tracingLevel);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.DEBUG");
            buff.append("=");
            buff.append(debug);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPATCH_VERSION");
            buff.append("=");
            buff.append(OPatchSession.getVersion());
            buff.append("\n");
            buff.append("   ");
            buff.append("Bundled OPatch Property File");
            buff.append("=");
            buff.append("properties");
            buff.append("\n");
            buff.append("   ");
            buff.append("Minimum OUI version: ");
            buff.append("10.2");
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.PATH");
            buff.append("=");
            buff.append(opatchProperties.getProperty("OPatch.PATH"));
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.MW_HOME");
            buff.append("=");
            buff.append(mwHome);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.WL_HOME");
            buff.append("=");
            buff.append(wlHome);
            buff.append("\n");
            buff.append("   ");
            buff.append("OPatch.COMMON_COMPONENTS_HOME");
            buff.append("=");
            buff.append(mwCommonHome);
            buff.append("\n\n");
            boolean isDebug = false;
            try {
                isDebug = Boolean.valueOf(OPatchACL.invokeOLogger(new OPatchEnv(), "isDebug", null).toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (isDebug) {
                OLogger.println(buff.toString());
            } else {
                OLogger.log(OLogger.FINE, buff.toString());
            }
        }
    }

    private static boolean checkNeededHeaderValidation() {
        String sessionType = OPatchEnv.getSessionType();
        String prereqOption = "";
        return sessionType == null || !sessionType.equals("prereq") || (prereqOption = OPatchEnv.getPrereqOption().toLowerCase()) == null || !prereqOption.equals("checkapplicableproduct");
    }

    public static void printOPatchHeader() throws RuntimeException {
        String ouiVer;
        String oracleHomePath = OPatchEnv.getOracleHome();
        String logFile = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        String opatchVer = OPatchSession.getVersion();
        String ouiLoc = OPatchEnv.getOUILocation();
        boolean needValidation = OPatchEnv.checkNeededHeaderValidation();
        String historyLoc = OPatchEnv.getLogFileLocation(oracleHomePath) + File.separator + "opatch_history.txt" + "\n";
        String customLogDir = OPatchEnv.getCustomLogDir();
        if (customLogDir != null && !customLogDir.equals("")) {
            historyLoc = OPatchEnv.getLogFileLocation(customLogDir) + File.separator + "opatch_history.txt" + "\n";
            logFile = OPatchEnv.getLogFileNameAndLocation(customLogDir);
        }
        hOracleHome = oracleHomePath;
        hOPatchVer = opatchVer;
        hLogLoc = logFile;
        hOUILoc = ouiLoc;
        OPatchEnv.dumpEnvironmentVariables();
        OiiiVersion ver = null;
        try {
            ResourceBundle oResBundle = ResourceBundle.getBundle("OUIVersion");
            ver = new OiiiVersion(oResBundle.getString("INSTALLER_VERSION"));
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while getting the OUI version.");
        }
        hOUIVer = ouiVer = ver != null ? ver.getVerString() : "n/a";
        String oraInstLoc = OPatchEnv.getInvPtrLoc();
        String centralInvLoc = "";
        StringBuffer centralInvDisplay = null;
        if (OPatchEnv.isInvPtrLocSpecified() && oraInstLoc.equals("")) {
            String userSupply = OPatchEnv.getUserSpecifiedInvPtrLoc();
            String error = OLogger.getString("OUI-67106", new Object[]{userSupply});
            if (needValidation) {
                OLogger.error("OUI-67106", new Object[]{userSupply});
                throw new RuntimeException(error);
            }
            OLogger.printlnOnLog(OLogger.INFO, error);
        }
        boolean badInvPtrLoc = false;
        if (OPatchEnv.isWindows() || oraInstLoc != null && !oraInstLoc.equals("")) {
            centralInvLoc = OPatchEnv.getCentralInvLoc();
            centralInvDisplay = new StringBuffer(centralInvLoc);
            if (centralInvLoc.equals("n/a")) {
                badInvPtrLoc = true;
            }
        } else {
            badInvPtrLoc = true;
            centralInvDisplay = new StringBuffer("n/a");
            if (needValidation) {
                logFile = "n/a";
            }
        }
        hCentralInv = centralInvDisplay.toString();
        String mwHome = "n/a";
        if (OPatchEnv.isBeaHome()) {
            mwHome = OPatchEnv.getMiddlewareHome();
            File mwHomeDir = new File(mwHome);
            try {
                mwHome = mwHomeDir.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OLogger.onlyLogInfo("OUI-67077", new Object[]{oracleHomePath, centralInvDisplay.toString(), oraInstLoc, opatchVer, ouiVer, ouiLoc, logFile});
        OLogger.printlnOnConsole(OLogger.getString("OUI-67918", new Object[]{oracleHomePath, centralInvDisplay.toString(), oraInstLoc, opatchVer, ouiVer, logFile}));
        OLogger.printlnOnLog("Patch history file: " + historyLoc);
        if (!mwHome.equals("n/a")) {
            OLogger.println("");
            OLogger.println("OPatch detects the Middleware Home as \"" + mwHome + "\"\n");
        }
        if (badInvPtrLoc) {
            String msg = OLogger.getString("OUI-67104");
            if (needValidation) {
                OLogger.error("OUI-67104");
                throw new RuntimeException(msg);
            }
            OLogger.printlnOnLog(OLogger.INFO, msg);
        }
    }

    public static int getOpatchExitCode() {
        if (javaLog && OPatchStateManagerFactory.getInstance().getCurrentState().getStateOrder() != 0) {
            return OPatchStateManagerFactory.getInstance().getCurrentState().getCurrentErrorCode();
        }
        return opatchExitCode;
    }

    public static void setOpatchExitCode(int opatchExitCode) {
        OPatchEnv.opatchExitCode = OPatchStateManagerFactory.getInstance().getCurrentState().getStateOrder() == 0 ? opatchExitCode : OPatchStateManagerFactory.getInstance().getCurrentState().getCurrentErrorCode();
    }

    public static String getConfigFile() {
        return configFile;
    }

    protected static void setConfigFile(String configFile) {
        OPatchEnv.configFile = configFile;
    }

    protected static String getPropertyFile() {
        return propertyFile;
    }

    protected static void setPropertyFile(String propertyFile) {
        OPatchEnv.propertyFile = propertyFile;
    }

    public static Properties getOPatchProperties() {
        return opatchProperties;
    }

    protected static void setOPatchProperties(Properties opatchProperty) {
        opatchProperties = opatchProperty;
    }

    protected static void setStandAloneHome(boolean homeType) {
        saHome = homeType;
    }

    public static String getPatchUnzipLocation() {
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome()));
        buff.append(File.separator);
        buff.append(PATCH_UNZIP_LOCATION);
        return buff.toString();
    }

    public static String getSessionProperties(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
        buff.append(File.separator);
        buff.append("LatestOPatchSession.properties");
        return buff.toString();
    }

    public static boolean getOhWritePermission() {
        File ohPathFile = new File(OPatchEnv.getOracleHome());
        return ohPathFile.canWrite();
    }

    public static boolean getLogWritePermission() {
        StringBuffer logFileLoc = new StringBuffer(OPatchEnv.getOracleHome());
        logFileLoc.append(File.separator);
        logFileLoc.append(StringResource.CENTRAL_LOG_DIR);
        File logLocFile = new File(logFileLoc.toString());
        return logLocFile.canWrite();
    }

    public static boolean getPatchStorageWritePermission() {
        String oh = OPatchEnv.getOracleHome();
        String patchStorageDirPath = OPatchEnv.getPatchStorageDirectoryPath(oh);
        File patchStorage = new File(patchStorageDirPath);
        boolean dirExist = patchStorage.exists();
        if (!dirExist) {
            return OPatchEnv.getOhWritePermission();
        }
        return patchStorage.canRead() && patchStorage.canWrite();
    }

    public static boolean canOhWriteLog() {
        String customLogDir = OPatchEnv.getCustomLogDir();
        return customLogDir != null && !customLogDir.equals("") || OPatchEnv.getLogWritePermission();
    }

    protected static void createRestoreFile(String oracleHomePath, String cookedPatchID) throws IOException {
        OPatchEnv.createRestoreFile(oracleHomePath, cookedPatchID, null);
    }

    protected static void createRestoreFile(String oracleHomePath, String cookedPatchID, String[] patchesToBeRemoved) throws IOException {
        int index;
        StringBuffer buff = new StringBuffer("OPatchEnv::createRestoreFile() ");
        OLogger.debug(buff);
        String rtFilePath = OPatchEnv.getRestoreFileLPath(oracleHomePath, cookedPatchID);
        buff = new StringBuffer("  creating file ");
        buff.append(rtFilePath);
        OLogger.debug(buff);
        buff = new StringBuffer("Creating script \"");
        buff.append(rtFilePath);
        buff.append("\"...");
        OLogger.log(OLogger.FINE, buff.toString());
        File rbFile = new File(rtFilePath);
        boolean isWindow = OPatchEnv.isWindows();
        FileWriter fw = new FileWriter(rbFile);
        StringBuffer restoreArea = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        StringBuffer rollbackArea = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        String varOH = null;
        varOH = isWindow ? "%OH%" : "$OH";
        if (oracleHomePath.endsWith("/") || oracleHomePath.endsWith("\\")) {
            oracleHomePath = oracleHomePath.substring(0, oracleHomePath.length() - 1);
        }
        if ((index = restoreArea.indexOf(oracleHomePath)) != -1) {
            restoreArea.replace(index, index + oracleHomePath.length(), varOH);
            index = restoreArea.indexOf(oracleHomePath, index);
        }
        while (index != -1 && (restoreArea.charAt(index - 1) == ' ' || restoreArea.charAt(index - 1) == '\n')) {
            restoreArea.replace(index, index + oracleHomePath.length(), varOH);
            index = restoreArea.indexOf(oracleHomePath, index);
        }
        index = rollbackArea.indexOf(oracleHomePath);
        if (index != -1) {
            rollbackArea.replace(index, index + oracleHomePath.length(), varOH);
            index = rollbackArea.indexOf(oracleHomePath, index);
        }
        while (index != -1 && (rollbackArea.charAt(index - 1) == ' ' || rollbackArea.charAt(index - 1) == '\n')) {
            rollbackArea.replace(index, index + oracleHomePath.length(), varOH);
            index = rollbackArea.indexOf(oracleHomePath, index);
        }
        String ohLiteral = "";
        StringBuffer dateAndTime = new StringBuffer("Date   Time : ");
        StringBuffer ohPath = new StringBuffer("Oracle Home : ");
        StringBuffer commandLine = new StringBuffer("Command     : ");
        if (OPatchEnv.isWindows()) {
            ohLiteral = "%OH%";
            ohPath.append(ohLiteral);
            commandLine.append("restore.bat");
            dateAndTime.append("%date% %time%");
        } else {
            ohLiteral = "$OH";
            ohPath.append(ohLiteral);
            commandLine.append("restore.sh");
            dateAndTime.append("`date`");
        }
        StringBuffer historyFilename = new StringBuffer();
        historyFilename.append(ohLiteral);
        historyFilename.append(File.separator);
        historyFilename.append(StringResource.CENTRAL_LOG_DIR);
        historyFilename.append(File.separator);
        historyFilename.append("opatch_history.txt");
        StringBuffer hBuff = new StringBuffer("\necho ");
        hBuff.append(dateAndTime);
        hBuff.append(" >> ");
        hBuff.append(historyFilename.toString());
        hBuff.append("\necho ");
        hBuff.append(ohPath);
        hBuff.append(" >> ");
        hBuff.append(historyFilename.toString());
        hBuff.append("\necho ");
        hBuff.append(commandLine);
        hBuff.append(" >> ");
        hBuff.append(historyFilename.toString());
        hBuff.append("\n\n");
        if (isWindow) {
            buff = new StringBuffer("@echo off\n");
            buff.append("REM ");
            buff.append(OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR}));
            buff.append("\n\n");
            buff.append("echo This script is going to restore the Oracle Home to the previous state.\necho It does not perform any of the following:\necho - Running init/pre/post scripts\necho - Customized steps performed manually by user\necho Please use this script with supervision from Oracle Technical Support.\n\n");
            buff.append("\n\n");
            buff.append("REM # Get ORACLE_HOME from environment variable \"ORACLE_HOME\"\nset OH=%ORACLE_HOME%\n\nREM # Error out if OH is not set\nif NOT \"$OH\" == \"\"  goto MODIFY_FILES\n    echo Oracle Home is not set.\n    echo Please set env. variable ORACLE_HOME and try again.\n    echo Script failed to proceed.\n    set %ERROR_LEVEL% = 1\n    exit %ERROR_LEVEL%\n\n:MODIFY_FILES\n\necho About to modify Oracle Home( %OH% )\necho Do you want to proceed? [Y/N]\nif \"%1\" == \"-silent\" goto PROCEED\nset /p response= ^>\n\nif \"%response%\" == \"Y\" goto PROCEED\nif \"%response%\" == \"y\" goto PROCEED\necho User responded with : %response%\nexit 0;\n\n:PROCEED\necho User responded with : Y\n\n");
            buff.append("\n\n");
            buff.append(hBuff);
            buff.append("rmdir /S /Q ");
            buff.append(rollbackArea.toString());
            buff.append("\n\n");
            if (patchesToBeRemoved != null) {
                buff.append("\n");
                for (String patchToRemoved : patchesToBeRemoved) {
                    buff.append("\\rmdir /S /Q ");
                    buff.append(IPMUtil.getOneoffsLocation(oracleHomePath));
                    buff.append(File.separator);
                    buff.append(patchToRemoved);
                    buff.append("\n\n");
                }
            }
            buff.append("xcopy ");
            buff.append(restoreArea.toString());
            buff.append(File.separator);
            buff.append("*.*");
            buff.append(" ");
            buff.append(varOH);
            buff.append(" /E /Y /C\n");
            buff.append("\n\n");
            buff.append("rmdir /S /Q ");
            buff.append(rollbackArea.toString());
            buff.append("\n");
        } else {
            buff = new StringBuffer("#!/bin/sh\n");
            buff.append("# ");
            buff.append(OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR}));
            buff.append("\n\n");
            buff.append("echo This script is going to restore the Oracle Home to the previous state.\necho It does not perform any of the following:\necho - Running init/pre/post scripts\necho - Oracle binary re-link\necho - Customized steps performed manually by user\necho Please use this script with supervision from Oracle Technical Support.\n\n");
            buff.append("\n\n");
            buff.append("# Get ORACLE_HOME from environment variable \"ORACLE_HOME\"\nOH=${ORACLE_HOME}\n\n# Error out if OH is not set\nif [ \"$OH\" = \"\" ]; then\n    echo Oracle Home is not set.\n    echo Please set env. variable ORACLE_HOME and try again.\n    echo Script failed to proceed.\n    exit 1\nfi\n\necho \"About to modify Oracle Home( $OH )\"\necho \"Do you want to proceed? [Y/N]\"\nif [ \"$1\" = \"-silent\" ]; then\n   response=\"Y\"\nelse\n    read response;\nfi\n\nif [ $response = \"y\" ] || [ $response = \"Y\" ]; then\n    echo \"User responded with : Y\"\nelse\n    echo \"User responded with : $response\"\n    exit 0\nfi\n\n");
            buff.append("\n\n");
            buff.append(hBuff);
            buff.append("\\rm -rf ");
            buff.append(rollbackArea.toString());
            buff.append("\n\n");
            if (patchesToBeRemoved != null) {
                buff.append("cd ");
                buff.append(IPMUtil.getOneoffsLocation(oracleHomePath));
                buff.append("\n");
                for (String patchToRemoved : patchesToBeRemoved) {
                    buff.append("\\rm -rf ");
                    buff.append(patchToRemoved);
                    buff.append("\n\n");
                }
            }
            buff.append("cd ");
            buff.append(restoreArea.toString());
            buff.append("\n");
            buff.append("for dname in \"`\\ls -1A`\" ; do");
            buff.append("\n");
            buff.append("    \\cp -fR $dname ");
            buff.append(varOH);
            buff.append(" ;");
            buff.append("\n");
            buff.append("done");
            buff.append("\n\n");
            buff.append("\\rm -rf ");
            buff.append(rollbackArea.toString());
            buff.append("\n");
        }
        fw.write(buff.toString());
        fw.write("\necho Restore script completed.\n");
        fw.flush();
        fw.close();
        OUIReplacer.changePermission(rtFilePath, 456);
    }

    protected static boolean isExitWithUserReq() {
        return exitWithUserReq;
    }

    public static boolean isDelayCleanUp() {
        return delayCleanUp;
    }

    public static void setDelayCleanUp(boolean in) {
        delayCleanUp = in;
    }

    public static boolean isNextGen() {
        return Boolean.valueOf(System.getProperty("isNextGen", "false"));
    }

    protected static String getTempPatchLocation() {
        return tempPatchLocation;
    }

    protected static void setTempPatchLocation(String in) {
        tempPatchLocation = in;
    }

    public static boolean isRLibSuccess() {
        return isRLibSuccess;
    }

    protected static void setRLibSuccess(boolean isRLibSuccess) {
        OPatchEnv.isRLibSuccess = isRLibSuccess;
    }

    protected static PatchObject[] getArbPatchObjectsForRLib() {
        return arbPatchObjectsForRLib;
    }

    protected static void setArbPatchObjectsForRLib(PatchObject[] arbPatchObjectsForRLib) {
        OPatchEnv.arbPatchObjectsForRLib = arbPatchObjectsForRLib;
    }

    public static void setRLibBackupDir(String rLibBackupDir) {
        OPatchEnv.rLibBackupDir = rLibBackupDir;
    }

    public static String getRLibBackupDir() {
        return rLibBackupDir;
    }

    public static void setRegenerationNeeded() {
        isRegenerationNeeded = true;
    }

    public static boolean isRegenerationNeeded() {
        return isRegenerationNeeded;
    }

    public static void setSwLibraryDir(String swLibraryDir) {
        OPatchEnv.swLibraryDir = swLibraryDir;
    }

    public static String getSwLibraryDir() {
        return swLibraryDir;
    }

    public static void setCustomLogDir(String logDir) {
        customLogDir = logDir;
    }

    public static String getCustomLogDir() {
        return customLogDir;
    }

    private static String retrieveOPatchVersion() {
        String fileName = "version.txt";
        String ver = "n/a";
        try {
            InputStream is = new OPatchEnv().getClass().getResourceAsStream("version.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String entry = null;
            while ((entry = br.readLine()) != null) {
                StringTokenizer st;
                if (!entry.startsWith("OPATCH_VERSION") || !(st = new StringTokenizer(entry, ":")).hasMoreTokens()) continue;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                ver = st.nextToken();
                ver = ver.trim();
                break;
            }
            br.close();
        }
        catch (Throwable t) {
            StringBuffer buff = new StringBuffer("OPatchEnv::getOPatchVersion() cannot read embed version file " + fileName);
            OLogger.debug(buff);
        }
        return ver;
    }

    public static boolean needSearchTripletID() {
        return needSearchTripletID;
    }

    public static void needSearchTripletID(boolean needSearchTripletID) {
        OPatchEnv.needSearchTripletID = needSearchTripletID;
    }

    private static String getOsName() {
        return System.getProperty("os.name", "");
    }

    public static boolean isAIXPlatform() {
        String osname = OPatchEnv.getOsName();
        return osname.equalsIgnoreCase("AIX");
    }

    public static boolean isHPUXPlatform() {
        String osname = OPatchEnv.getOsName();
        return osname.equalsIgnoreCase("HP-UX");
    }

    public static String getOLRLocation() {
        String osname;
        String olrLoc = "";
        olrLoc = OPatchEnv.isWindows() ? "n/a" : ((osname = OPatchEnv.getOsName()).equalsIgnoreCase("Linux") || osname.equalsIgnoreCase("AIX") ? "/etc/oracle/olr.loc" : (osname.equalsIgnoreCase("HP-UX") || osname.equalsIgnoreCase("SunOS") ? "/var/opt/oracle/olr.loc" : "n/a"));
        return olrLoc;
    }

    public static long getProcessID() {
        long pid = 0L;
        try {
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String jvmName = runtimeBean.getName();
            pid = Long.valueOf(jvmName.split("@")[0]);
        }
        catch (Exception e2) {
            pid = 0L;
        }
        return pid;
    }

    public static boolean isApplyMake() {
        if (applyMake == null) {
            return false;
        }
        return applyMake.equalsIgnoreCase("true");
    }

    public static boolean hashMatches() {
        return hmatch;
    }

    public static void setHashMatch() {
        hmatch = true;
    }

    public static void unsetHashMatch() {
        hmatch = false;
    }

    public static String getPrereqResult() {
        if (prereqResult == null || prereqResult.equals("")) {
            return "";
        }
        return prereqResult;
    }

    public static String getPrereqResultFileLoc(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        String loc = buff.toString();
        File f2 = new File(loc);
        boolean ok = true;
        if (!f2.exists()) {
            f2.mkdirs();
        }
        return loc;
    }

    public static void setPrereqResult(String in) {
        prereqResult = in;
    }

    public static boolean isFATwoPhase() {
        return twoPhase;
    }

    public static void setFATwoPhase() {
        twoPhase = true;
    }

    public static void unsetFATwoPhase() {
        twoPhase = false;
    }

    public static void setCASPhase1() {
        CASPhase1 = true;
    }

    public static void setCASPhase2() {
        CASPhase2 = true;
    }

    public static void unsetCASPhase1() {
        CASPhase1 = false;
    }

    public static void unsetCASPhase2() {
        CASPhase2 = false;
    }

    public static boolean isCASPhase1() {
        return CASPhase1;
    }

    public static boolean isCASPhase2() {
        return CASPhase2;
    }

    public static void setBranchKey(String bKey) {
        branchKey = bKey;
    }

    public static String getBranchKey() {
        return branchKey;
    }

    public static void unsetBranchKey() {
        branchKey = "";
    }

    public static void setInactivePSUTrainRollback(boolean rollback) {
        rollbackInactivePsu = rollback;
    }

    public static boolean needRollbackInactivePSUTrain() {
        return rollbackInactivePsu;
    }

    public static String getCasRepoPath() {
        return casRepoPath;
    }

    public static void setCasRepoPath(String casRepoPath) {
        OPatchEnv.casRepoPath = casRepoPath;
        OPatchEnv.setOracleHome(OPatchEnv.casRepoPath);
    }

    public static String getCasViewId() {
        return casViewId;
    }

    public static void setCasViewId(String casViewId) {
        OPatchEnv.casViewId = casViewId;
    }

    public static String getCasViewPath() {
        return casViewPath;
    }

    public static void setCasViewPath(String casViewPath) {
        OPatchEnv.casViewPath = casViewPath;
    }

    public static void setInvokeTimeStamp(String ts) {
        invokeTs = ts;
    }

    public static String getInvokeTimeStamp() {
        return invokeTs;
    }

    static {
        System.getProperties().setProperty("oracle.installer.clusterEnabled", "false");
        applyMake = System.getProperties().getProperty("OPatch.MAKE");
        sessionType = "";
        sessionName = "";
        specifiedOLoggerPatchLoc = "";
        specifiedOLoggerPatchID = "";
        logFileLocationSpecified = false;
        specifiedLogFileLocation = "";
        cmdlineSessionLogFileLocation = "";
        help = false;
        fmwHelp = false;
        jreLoc = "";
        jreOptionSpecified = false;
        jdkLoc = "";
        verbose = false;
        silent = false;
        isBeaHome = false;
        isDesiredHome = false;
        delay = 120;
        retry = 30;
        maxLockingWait = delay * retry;
        customLogDir = "";
        isCleanupCmdLine = false;
        force = false;
        force_conflict = false;
        optimize = false;
        ohInstanceUp = false;
        invPtrLocSpecified = false;
        saSelectedProduct = "";
        saSelectedVersion = "";
        configFile = "";
        local = false;
        minDowntime = false;
        allNode = false;
        noPreScriptOpt = false;
        noPostScriptOpt = false;
        preopt = "";
        initopt = "";
        postopt = "";
        nolink = false;
        nopatchgen = false;
        isReboot = false;
        patchChecksum = false;
        SILENT_PAUSE = 3;
        patchloc = "";
        lsInvRegExpression = "";
        cookedPatchID = "";
        version_all = false;
        version_v2c = "";
        version_ohs = null;
        lsinv_all = false;
        lsinv_detail = false;
        lsinv_xml = false;
        xmlCompare = false;
        trans_patch = false;
        lsinv_xml_loc = "";
        xmlCompare_loc1 = "";
        xmlCompare_loc2 = "";
        lsinv_patch = false;
        lsinv_patch_order = "desc";
        lsinv_patch_id = false;
        lsinv_patch_id_order = "asc";
        lsinv_inactive = false;
        isSortByBugsFixed = false;
        lsinv_bug_order = "desc";
        lsinv_match = false;
        report = false;
        syntaxError = false;
        syntaxErrorMsg = "";
        argError = false;
        argErrorMsg = "";
        updateComponent = "oracle.swd.opatch";
        updateVersion = "";
        util_all = false;
        isSrvmUtil = false;
        lsp_queryfile = "";
        lsp_Required = false;
        lsp_Verified = false;
        lsp_bugs = false;
        all_Subpatches = false;
        activeCompositeID = "";
        compositeXMLPath = "";
        utilOption = "";
        prereqOption = "";
        beaHome = "";
        profileMask = "";
        bsuOutput = "";
        wlsPrereqOneOffsList = new ArrayList();
        noBugSuperSet = false;
        skipSubset = false;
        skipDuplicate = false;
        ignoreConflict = false;
        ignoreMissingComponent = false;
        userInputVersion = "";
        groupByDate = false;
        user_specified_nodes = new String[0];
        remoteNodes = new String[0];
        patchIDs = new String[0];
        allClients = new FMWClient[0];
        ToBeRolledBackPatchIDs = new ArrayList();
        isPlatformSkipValueValid = false;
        localNode = "";
        detectedLocalNode = "";
        isCFS = false;
        createRacFile = true;
        propertyFile = "";
        opatchProperties = new Properties();
        envVariables = null;
        ocmResponseFile = false;
        ocmResponseFileLoc = "";
        isOcmRespFileDelete = false;
        racType = null;
        isEmOcmSkip = false;
        opatchExitCode = 0;
        inventoryExists = true;
        saHome = false;
        patchUnzipped = false;
        nApplyBaseDir = "";
        originalCommand = "";
        databaseUserNames = new String[0];
        databasePasswds = new String[0];
        databaseSIDs = new String[0];
        databaseNodes = new String[0];
        SIDStatus = new Boolean[0];
        runSql = false;
        sqlMigrate = false;
        needProductXMLCreation = false;
        userSpecifiedInvPtrLoc = "";
        isPlatformValidationByPlatformXML = false;
        isAutoRollback = false;
        autoRollbackCookedPatchID = "";
        autoRollbackList = new OneOffEntry[0];
        dbError = false;
        subsetSIDInfo = "";
        isNApply = false;
        isNRollback = false;
        isCompositeRollback = false;
        isSqlScript = false;
        sqlScriptFile = "";
        ptlSchema = "";
        ptlPassword = "";
        ptlConnect = "";
        sidInfo = new HashSet();
        portalPatchID = "";
        isSqlPatch = false;
        isFMWRollingPatch = false;
        isFMWFeatureBearingPatch = false;
        isRollingPatch = false;
        isPortalPatch = false;
        isOnlinePatch = false;
        isOnline = false;
        isComponent = false;
        isBaseBug = false;
        isAutoPatch = false;
        isTranslatablePatch = false;
        isPatchModel = false;
        isPatchLanguage = false;
        isGetProductFamily = false;
        isOs = false;
        isDate = false;
        isSqlAction = false;
        isQueryAll = true;
        isGetPatchType = false;
        isEngSystemPatch = false;
        isPatchsetUpdate = false;
        isUpdateComponent = false;
        javaLog = true;
        consoleLogLevel = 0;
        fileLogLevel = 0;
        isNeedToRollback = false;
        isOPatchSDKApplyRollback = false;
        isRunTimeExecMessageNeeded = true;
        symbolResolveEnabled = true;
        isAuto = false;
        interactive = false;
        norestart = false;
        nonrolling = false;
        generatesteps = false;
        checkstackstatus = false;
        gipatchingmode = false;
        gipatchingAll = false;
        selectedDBs = null;
        isCmdDatabase = false;
        targetList = null;
        cmdTargetType = null;
        compositeName = null;
        compositeRev = null;
        domaindir = null;
        domainname = null;
        wlsHome = null;
        cmdMiddlewareHome = "";
        envMiddlewareHome = "";
        theMiddlewareHome = "";
        exitWithUserReq = false;
        delayCleanUp = false;
        tempPatchLocation = null;
        baseConfigPlan = false;
        patchesToRoll = new OneOffEntry[0];
        conflictPatches = new OneOffEntry[0];
        pi = null;
        hmatch = false;
        prereqResult = null;
        twoPhase = false;
        CASPhase1 = false;
        CASPhase2 = false;
        branchKey = "";
        rollbackInactivePsu = false;
        stringPool = new StringPool();
        isRLibSuccess = true;
        rLibBackupDir = "";
        isRegenerationNeeded = false;
        arbPatchObjectsForRLib = new PatchObject[0];
        swLibraryDir = null;
        needSearchTripletID = true;
    }
}

