/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import oracle.opatch.Applicable;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellRunCommand;
import oracle.opatch.Rules;
import oracle.opatch.StdoutStatus;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

public class MakeAction
extends PatchAction
implements Serializable,
Applicable,
RemoteShellRunCommand,
StdoutStatus {
    private static final long serialVersionUID = 1L;
    private String changeDirectory;
    private String makeFile;
    private String makeTarget;
    private String nonApplicableDesc;

    public MakeAction(PatchComponent pc, String changeDirectory, String makeFile, String makeTarget, int lineNumber) throws Exception {
        super(pc, lineNumber);
        if (changeDirectory == null || makeFile == null || makeTarget == null) {
            String errMsg = "The make actions is null";
            if (changeDirectory == null) {
                errMsg = errMsg + "The change directory is null";
            }
            if (makeFile == null) {
                errMsg = errMsg + "The make file is null";
            }
            if (makeTarget == null) {
                errMsg = errMsg + "The make target is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.changeDirectory = PatchObjectUtil.filterString(changeDirectory);
        this.makeFile = makeFile;
        this.makeTarget = makeTarget;
    }

    public String getChangeDirectory() {
        return this.changeDirectory;
    }

    public String getMakeFile() {
        return this.makeFile;
    }

    public String getMakeTarget() {
        return this.makeTarget;
    }

    public int compareTo(Object o2) {
        int superRetCode;
        if (o2 instanceof MakeAction) {
            MakeAction ma = (MakeAction)o2;
            String changeDir = ma.getChangeDirectory();
            String makeFile = ma.getMakeFile();
            String makeTarget = ma.getMakeTarget();
            String myChangeDir = this.getChangeDirectory();
            String myMakeFile = this.getMakeFile();
            String myMakeTarget = this.getMakeTarget();
            if (myChangeDir.equals(changeDir) && myMakeFile.equals(makeFile) && myMakeTarget.equals(makeTarget)) {
                return 0;
            }
        }
        if ((superRetCode = super.compareTo(o2)) == 0) {
            return 1;
        }
        return superRetCode;
    }

    public String getParentDirPath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.changeDirectory);
        return buff.toString();
    }

    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.makeFile);
        return buff.toString();
    }

    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[2];
        s[0] = this.getMakeFile();
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getMakeTarget());
        s[1] = buff.toString();
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[MakeAction: changeDirectory=\"");
        buff.append(this.changeDirectory);
        buff.append("\", makeFile=\"");
        buff.append(this.makeFile);
        buff.append("\", makeTarget=\"");
        buff.append(this.makeTarget);
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\" rawMakeAction=\"");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("MakeAction::applicable()");
        OLogger.debug(buff);
        OPatchProperty opp = new OPatchProperty();
        if (!opp.hasMakeCommand()) {
            buff = new StringBuffer("   cannot locate executable make, hence MakeAction is not applicable.");
            OLogger.debug(buff);
            buff = new StringBuffer("Cannot locate executable 'make', hence the Make Action is not applicable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("MakeAction check on make cmd. is OK, will be invoked using \"");
        try {
            buff.append(opp.getMakeCommand());
        }
        catch (NoSuchMethodException e2) {
            buff.append(e2.getMessage());
            buff.append("\", return false, MakeAction not applicable.");
            OLogger.debug(buff);
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        buff.append("\"");
        OLogger.debug(buff);
        StringBuffer path = new StringBuffer(oracleHomePath);
        path.append(File.separator);
        path.append(this.getChangeDirectory());
        String changeDir = path.toString();
        path.append(File.separator);
        path.append(this.getMakeFile());
        String makeFile = path.toString();
        File m2 = new File(makeFile);
        File c2 = new File(changeDir);
        String osName = OPatchEnv.getOSName();
        if (m2 == null) {
            buff = new StringBuffer("    File(makeFile) is NULL");
            OLogger.debug(buff);
        }
        if (c2 == null) {
            buff = new StringBuffer("    File(changeDir) is NULL");
            OLogger.debug(buff);
        }
        if (OPatchEnv.isWindows()) {
            OLogger.error("OUI-67001", new Object[]{"Make", changeDir, makeFile, " ", osName});
            buff = new StringBuffer("MakeAction::applicable() returns false, as action is not applicable");
            OLogger.debug(buff);
            return false;
        }
        buff = new StringBuffer("  Action details: makeFile = \"");
        buff.append(makeFile);
        buff.append("\", changeDirectory = \"");
        buff.append(changeDir);
        buff.append("\"");
        OLogger.debug(buff);
        if (!m2.exists() || !m2.canRead()) {
            buff = new StringBuffer("Make Action: Make file \"");
            buff.append(makeFile);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("  checking on changeDir of make");
        OLogger.debug(buff);
        if (c2.exists() && !c2.isDirectory()) {
            buff = new StringBuffer("Make Action: Not a valid directory \"");
            buff.append(changeDir);
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("  Yes, make is applicable");
        OLogger.debug(buff);
        return true;
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("MakeAction::apply()");
        OLogger.debug(buff);
        StringBuffer path = new StringBuffer(oracleHomePath);
        path.append(File.separator);
        path.append(this.getChangeDirectory());
        String changeDir = path.toString();
        path.append(File.separator);
        path.append(this.getMakeFile());
        String makeFile = path.toString();
        String target = this.makeTarget;
        String msg = "";
        String[] bundledCmds = this.getLocalMakeCommand(oracleHomePath);
        String makeCmd = bundledCmds[0];
        String runDirPath = bundledCmds[1];
        boolean ok = true;
        buff = new StringBuffer(" MakeAction: makeFile = \"");
        buff.append(makeFile);
        buff.append("\", target = \"");
        buff.append(target);
        buff.append("\", directory = \"");
        buff.append(runDirPath);
        buff.append("\", makeCmd = \"");
        buff.append(makeCmd);
        buff.append("\"");
        OLogger.verbose(this, buff);
        try {
            StringBuffer tmp = new StringBuffer("MakeAction::apply() calling SystemCall.runMake() with ");
            tmp.append("makeCmd=\"");
            tmp.append(makeCmd);
            tmp.append("\", dir=\"");
            tmp.append(runDirPath);
            tmp.append("\"");
            OLogger.debug(tmp);
            boolean systemWrite = Rules.SystemWrite_continue();
            boolean noRelink = OPatchEnv.isNolink();
            if (systemWrite && !noRelink) {
                StringBuffer ts = new StringBuffer("Start invoking 'make' at ");
                ts.append(OPatchACL.invokeOLogger(this, "getCurrentTimeString", null).toString());
                OLogger.logTime(ts);
                SystemCall.ExecReturn ret = SystemCall.runMake(this, makeCmd, runDirPath);
                ts = new StringBuffer("Finish invoking 'make' at ");
                OLogger.logTime(ts);
                buff = new StringBuffer(ret.toString());
                OLogger.debug(buff);
                ok = ret.isOK();
                buff = new StringBuffer(ret.toString());
                OLogger.debug(buff);
                OLogger.debug(new StringBuffer("MakeAction::apply() done"));
                msg = ret.getErrorMessage();
            } else {
                buff = new StringBuffer("MakeAction::apply() skips running command ");
                buff.append(makeCmd);
                buff.append(" on directory ");
                buff.append(runDirPath);
                OLogger.debug(buff);
            }
        }
        catch (RuntimeException e2) {
            ok = false;
            OLogger.warn("OUI-67200", new Object[]{makeCmd, e2.getMessage()});
            throw e2;
        }
        catch (IllegalAccessException e3) {
            ok = false;
            OLogger.warn("OUI-67200", new Object[]{makeCmd, e3.getMessage()});
            throw new RuntimeException(e3.getMessage());
        }
        if (!ok) {
            OLogger.warn("OUI-67200", new Object[]{makeCmd, msg});
            throw new RuntimeException(msg);
        }
        int errorID = Rules.isErrorTagPresentInMakeStdErr(msg);
        if (errorID != -1) {
            buff = new StringBuffer("Stderr output:\n");
            buff.append(msg);
            OLogger.warn("OUI-67215", new Object[]{StringResource.ERROR_STRINGS[errorID], buff.toString()});
        }
        buff = new StringBuffer(" Make Action done");
        OLogger.verbose(this, buff);
    }

    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        String[] bundledCmds = this.getLocalMakeCommand(oracleHomePath);
        String makeCmd = bundledCmds[0];
        String makeTarget = this.getMakeTarget();
        StringBuffer completePathToMakeFile = new StringBuffer(oracleHomePath);
        completePathToMakeFile.append(File.separator);
        completePathToMakeFile.append(this.getChangeDirectory());
        completePathToMakeFile.append(File.separator);
        completePathToMakeFile.append(this.getMakeFile());
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67155", new Object[]{owningComp, makeTarget, completePathToMakeFile});
        return desc;
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    protected String[] getLocalMakeCommand(String oracleHomePath) {
        OPatchProperty opp = new OPatchProperty();
        String MAKE = "";
        try {
            MAKE = opp.getMakeCommand();
        }
        catch (NoSuchMethodException e2) {
            MAKE = "make ";
        }
        String dst = this.getParentDirPath(oracleHomePath);
        StringBuffer chdir = new StringBuffer(oracleHomePath);
        chdir.append(File.separator);
        chdir.append(this.getChangeDirectory());
        String makeFileNoPath = this.getMakeFile();
        StringBuffer makeFileWithPath = new StringBuffer(chdir.toString());
        makeFileWithPath.append(File.separator);
        makeFileWithPath.append(makeFileNoPath);
        String target = this.getMakeTarget();
        StringBuffer buff = new StringBuffer(MAKE);
        buff.append(" -f ");
        buff.append(makeFileNoPath);
        buff.append(" ");
        buff.append(target);
        buff.append(" ");
        buff.append("ORACLE_HOME=");
        buff.append(oracleHomePath);
        String[] bundledCommands = new String[3];
        bundledCommands[0] = buff.toString();
        bundledCommands[1] = chdir.toString();
        return bundledCommands;
    }

    protected String[] getLocalMakeCommandEntryForMakeTxt(String oracleHomePath) {
        OPatchProperty opp = new OPatchProperty();
        String MAKE = "";
        try {
            MAKE = opp.getMakeCommand();
        }
        catch (NoSuchMethodException e2) {
            MAKE = "make ";
        }
        String dst = this.getParentDirPath(oracleHomePath);
        StringBuffer chdir = new StringBuffer("$ORACLE_HOME");
        chdir.append(File.separator);
        chdir.append(this.getChangeDirectory());
        String makeFileNoPath = this.getMakeFile();
        StringBuffer makeFileWithPath = new StringBuffer(chdir.toString());
        makeFileWithPath.append(File.separator);
        makeFileWithPath.append(makeFileNoPath);
        String target = this.getMakeTarget();
        StringBuffer buff = new StringBuffer(MAKE);
        buff.append(" -f ");
        buff.append(makeFileNoPath);
        buff.append(" ");
        buff.append(target);
        buff.append(" ");
        buff.append("ORACLE_HOME=");
        buff.append("$ORACLE_HOME");
        String[] bundledCommands = new String[3];
        bundledCommands[0] = buff.toString();
        bundledCommands[1] = chdir.toString();
        return bundledCommands;
    }

    public void runRemoteCommand(String oracleHomePath, boolean patchApply, String patchID, String[] remoteNodes, String localNode) throws RuntimeException {
    }

    public String getRemoteCommand(String oracleHomePath, boolean patchApply) {
        return this.getRemoteCommand(oracleHomePath, patchApply, false);
    }

    public String getRemoteCommand(String oracleHomePath, boolean patchApply, boolean withEchoPostFix) {
        StringBuffer tmp = new StringBuffer("getRemoteCommand()");
        OLogger.debug(tmp);
        String[] bundledCmds = this.getLocalMakeCommand(oracleHomePath);
        String cmd = bundledCmds[0];
        String chDir = bundledCmds[1];
        StringBuffer buff = new StringBuffer("cd ");
        buff.append(chDir);
        buff.append("; ");
        buff.append(cmd);
        if (withEchoPostFix) {
            buff.append(" || echo REMOTE_MAKE_FAILED::>&2");
        }
        tmp = new StringBuffer("  getRemoteCommand() returns \"");
        tmp.append(buff.toString());
        tmp.append("\"");
        OLogger.debug(tmp);
        return buff.toString();
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        OLogger.debug(new StringBuffer("MakeAction::getRollbackScriptEntry() begins"));
        StringBuffer rollbackStr = new StringBuffer("\n");
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.getChangeDirectory());
        String changeDir = buff.toString();
        buff.append(File.separator);
        buff.append(this.getMakeFile());
        String makeFile = buff.toString();
        String target = this.makeTarget;
        String msg = "";
        boolean ok = true;
        String cmd = null;
        String[] cmds = new String[]{cmd};
        if (OPatchEnv.isWindows()) {
            cmd = "cmd /C type " + makeFile;
            rollbackStr.append(cmd);
            rollbackStr.append("\n");
        } else {
            buff = new StringBuffer("make -f ");
            buff.append(makeFile);
            buff.append(" ");
            buff.append(target);
            buff.append(" ");
            buff.append("ORACLE_HOME=");
            buff.append(oracleHomePath);
            cmd = buff.toString();
            rollbackStr.append(cmd);
            rollbackStr.append("\n");
        }
        rollbackStr.append("\n");
        OLogger.debug(new StringBuffer("MakeAction::getRollbackScriptEntry() done"));
        return rollbackStr.toString();
    }

    public void printStdout(SystemCall.ExecReturn ret) {
        String cmd = ret.getCommand();
        int retCode = ret.getReturnCode();
        String stdoutMsg = ret.getNormalMessage();
        String stderrMsg = ret.getErrorMessage();
        StringBuffer tmp = new StringBuffer("\nMake result:\n");
        tmp.append("  Command: ");
        tmp.append(cmd);
        tmp.append("\n");
        tmp.append("  Returned code: ");
        tmp.append(retCode);
        tmp.append("\n");
        tmp.append("  Stdout output:\n");
        tmp.append(stdoutMsg);
        tmp.append("\n");
        tmp.append("  Stderr output:\n");
        tmp.append(stderrMsg);
        tmp.append("\n");
        OLogger.verbose("MakeAction", tmp);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MakeAction) {
            String myMakeFile = this.getMakeFile();
            String myPath = this.getChangeDirectory();
            String myTarget = this.getMakeTarget();
            MakeAction ma = (MakeAction)o2;
            String itMakeFile = ma.getMakeFile();
            String itPath = ma.getChangeDirectory();
            String itTarget = ma.getMakeTarget();
            if (myMakeFile.equals(itMakeFile) && myPath.equals(itPath) && myTarget.equals(itTarget)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.makeFile.length();
        result = 37 * result + this.makeTarget.length();
        result = 37 * result + this.changeDirectory.length();
        return result;
    }

    public String getActionName() {
        return "MakeAction";
    }

    public String getActionDesc() {
        return "Build the binaries for the given target.";
    }

    public String getApplyDescription(String oracleHomePath) {
        return "Build the binaries for the given target.";
    }

    public String getChildPath() {
        return "";
    }

    public static void main(String[] args) {
        String oracleHomePath = "C:\\oracle\\product\\10.1.0\\Db_1";
        String patchLocation = "C:\\OPatch\\0118482";
        String changeDir = "tmp";
        String makeFile = "ins_rdbms.mk";
        String makeTarget = "ioracle";
        if (!OPatchEnv.isWindows()) {
            oracleHomePath = "/private/phi_local/10g_home1";
            patchLocation = "/private/phnguyen/OPatch/Code/OPatch/0118482";
            changeDir = oracleHomePath + File.separator + "rdbms/lib";
            makeFile = "ins_rdbms.mk";
            makeTarget = "ioracle";
        }
        int lineNumber = 0;
        try {
            MakeAction ma = new MakeAction(null, changeDir, makeFile, makeTarget, lineNumber);
            OPatchACL.invokeOLogger(ma, "setDebug", new Object[]{true});
            String[] bundledCmds = ma.getLocalMakeCommand(oracleHomePath);
            String makeCmd = bundledCmds[0];
            String runDir = bundledCmds[1];
            System.out.println("Make Command: \"" + makeCmd + "\" under \"" + runDir + "\"");
            boolean applicable = ma.applicable(oracleHomePath, patchLocation);
            if (applicable) {
                ma.apply(oracleHomePath, patchLocation);
            }
        }
        catch (Exception e2) {
            System.out.println("ERROR: " + e2.getMessage());
        }
    }
}

