/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.BranchInfo;
import oracle.opatch.cas.CASBranchServices;
import oracle.opatch.opatchlogger.OLogger;

public class ListSession
implements IOPatchSession {
    private boolean hasOUI = false;

    public boolean isOUIBased() {
        return this.hasOUI;
    }

    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.printlnOnLog(MessageFormat.format("ListSession process on cas_repo \"{0}\". ", oracleHome));
        try {
            try {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<Path> values = new ArrayList<Path>();
                LinkedList<Object> info = new LinkedList();
                OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
                CASBranchServices cas = new CASBranchServices();
                info = cas.listBranch(keys, values);
                int i2 = 0;
                StringBuffer buff = new StringBuffer("View information::\n");
                buff.append("----------------------------------------------------------------\n");
                for (String k2 : keys) {
                    if (!k2.equals("CLI") && !k2.equals("SDK")) {
                        buff.append("View name: " + k2 + "\n");
                        buff.append(((BranchInfo)info.get(i2)).toString());
                        buff.append("\n");
                    }
                    ++i2;
                }
                OLogger.println(buff.toString());
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var11_12 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lsviews_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

