/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionTree;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OPatchEnv;
import oracle.opatch.Rules;
import oracle.opatch.opatchlogger.OLogger;

public class JarActionHelper {
    protected static HashMap apply(String oracleHomePath, String patchLocation, JarAction jarAction) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionHelper::apply() called");
        OLogger.debug(buff.toString());
        JarActionTree.TreeNode root = JarActionTree.getRoot();
        HashMap<String, JarAction> failedMap = new HashMap<String, JarAction>();
        ArrayList failed = new ArrayList();
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The jar action tree has not been contructed.");
            OLogger.debug(buff);
            return failedMap;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        if (topLevelJars == null) {
            return failedMap;
        }
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionTree.TreeNode patchingNode;
            JarActionTree.TreeNode tn = (JarActionTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = jarAction.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(patchingNode = new JarActionTree.TreeNode(0, jarAction.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                File srcJar = new File(patchingJarFilePath);
                if (!srcJar.exists()) {
                    buff = new StringBuffer("apply() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                String dstJarFile = MultiJarUtil.patchingBaseOnJarTree(tn, patchingJarFilePath, scratchLocation, patchLocation, "", patchingJarFilePath, failed);
                if (cont) {
                    File patchedJar = new File(dstJarFile);
                    if (!patchedJar.exists()) {
                        buff = new StringBuffer("apply() failed. Applied jar file not be produced: \"");
                        buff.append(dstJarFile);
                        buff.append("\"");
                        OLogger.printlnOnLog(buff.toString());
                        throw new IOException(buff.toString());
                    }
                    buff = new StringBuffer("Copy applied Jar file from \"");
                    buff.append(dstJarFile);
                    buff.append("\" to \"" + patchingJarFilePath + "\"");
                    OLogger.debug(buff.toString());
                    MultiJarUtil.copyFile(dstJarFile, patchingJarFilePath);
                    break;
                }
                buff = new StringBuffer("Skipping the Jar Action Apply due to no sys_mod");
                OLogger.debug(buff);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Apply for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.APPLY, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failed.size(); ++i2) {
            JarAction ja = (JarAction)failed.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    protected static HashMap rollback(String oracleHomePath, String cookedPatchID, JarAction jarAction) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionHelper::rollback() called");
        OLogger.debug(buff.toString());
        HashMap<String, JarAction> failedMap = new HashMap<String, JarAction>();
        ArrayList failed = new ArrayList();
        JarActionTree.TreeNode root = JarActionTree.getRoot();
        if (root == null || root.isLeaf()) {
            return failedMap;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionTree.TreeNode rollbackNode;
            JarActionTree.TreeNode tn = (JarActionTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = jarAction.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(rollbackNode = new JarActionTree.TreeNode(0, jarAction.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                File srcJar = new File(patchingJarFilePath);
                if (!srcJar.exists()) {
                    buff = new StringBuffer("rollback() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, cookedPatchID);
                String backForRollBackPath = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
                String rollbackedJar = MultiJarUtil.rollbackBaseOnJarTree(tn, patchingJarFilePath, scratchLocation, backForRollBackPath, "", failed);
                if (cont) {
                    File patchedJar = new File(rollbackedJar);
                    if (!patchedJar.exists()) {
                        buff = new StringBuffer("rollback() failed. Rollbacked Jar file not be produced: \"");
                        buff.append(rollbackedJar);
                        buff.append("\"");
                        OLogger.printlnOnLog(buff.toString());
                        throw new IOException(buff.toString());
                    }
                    buff = new StringBuffer("Copy rollbacked Jar file from \"");
                    buff.append(rollbackedJar);
                    buff.append("\" to \"" + patchingJarFilePath + "\"");
                    OLogger.debug(buff.toString());
                    MultiJarUtil.copyFile(rollbackedJar, patchingJarFilePath);
                    break;
                }
                buff = new StringBuffer("Skipping the Jar Action Rollback due to no sys_mod");
                OLogger.debug(buff);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Rollback for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.ROLLBACK, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failed.size(); ++i2) {
            JarAction ja = (JarAction)failed.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    protected static HashMap backupForRollBack(String oracleHomePath, String cookedPatchID, JarAction jarAction) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionHelper::backupForRollBack() called");
        OLogger.debug(buff.toString());
        ArrayList failedActions = new ArrayList();
        HashMap<String, JarAction> failedMap = new HashMap<String, JarAction>();
        JarActionTree.TreeNode root = JarActionTree.getRoot();
        if (root == null || root.isLeaf()) {
            return failedMap;
        }
        ArrayList topLevelJars = root.getChilds();
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionTree.TreeNode backupNode;
            JarActionTree.TreeNode tn = (JarActionTree.TreeNode)topLevelJars.get(i2);
            String curJarPath = jarAction.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(backupNode = new JarActionTree.TreeNode(0, jarAction.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                String jarName = tn.getJarName();
                String jarPath = tn.getJarPath();
                String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
                File srcJar = new File(patchingJarFilePath);
                if (!srcJar.exists()) {
                    buff = new StringBuffer("backupForRollBack() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, cookedPatchID);
                String backForRollBackPath = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
                MultiJarUtil.backUpForRollbackBaseOnJarTree(tn, patchingJarFilePath, backForRollBackPath, scratchLocation, "", failedActions);
            }
            catch (IOException e2) {
                buff = new StringBuffer("backupForRollback for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failedActions, MultiJarUtil.JarOperation.BACKUPFORROLLBACK, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failedActions.size(); ++i2) {
            JarAction ja = (JarAction)failedActions.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    protected static HashMap verify(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("JarActionHelper::verify() called");
        OLogger.debug(buff.toString());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        JarActionTree.TreeNode root = JarActionTree.getRoot();
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The jar action tree has not been contructed.");
            OLogger.debug(buff);
            return result;
        }
        MultiJarUtil.clearEntryExistFlagRecursively(root);
        ArrayList topLevelJars = root.getChilds();
        for (int i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionTree.TreeNode tn = (JarActionTree.TreeNode)topLevelJars.get(i2);
            try {
                String jarName = tn.getJarName();
                String jarPath = tn.getJarPath();
                String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
                buff = new StringBuffer("Verify clubbed jar actions for target jar file \"");
                buff.append(patchingJarFilePath);
                buff.append("\"");
                OLogger.debug(buff.toString());
                File srcJar = new File(patchingJarFilePath);
                if (!srcJar.exists()) {
                    buff = new StringBuffer("verify() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                MultiJarUtil.verifyBaseOnJarTree(tn, result, patchingJarFilePath, scratchLocation, patchLocation, "");
                continue;
            }
            catch (IOException e2) {
                buff = new StringBuffer("Verify for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                ArrayList failed = new ArrayList();
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.VERIFY, true, e2.getMessage());
                for (int j2 = 0; j2 < failed.size(); ++j2) {
                    JarAction ja = (JarAction)failed.get(j2);
                    result.put(ja.getClassName(), new Boolean(false));
                }
            }
        }
        return result;
    }

    protected static String getTopLevelJarFilePath(String oracleHome, String jarPath, String jarName) {
        StringBuffer completeFile = new StringBuffer(oracleHome);
        if (!oracleHome.endsWith(File.separator)) {
            completeFile.append(File.separator);
        }
        completeFile.append(MultiJarUtil.combineEntry(jarPath, jarName));
        return completeFile.toString();
    }
}

