/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import oracle.opatch.ApplySession;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchObject;
import oracle.opatch.RollbackSession;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchutil.OUSession;

public class FMWHandler {
    private static FMWHandler FMWHANDLER = new FMWHandler();

    private FMWHandler() {
        OPatchSessionHelper.loadFMWRelatedLibFile();
    }

    private static void invokeOPatchAutoScriptCheck(String oper, String option) {
        StringBuilder message = new StringBuilder("");
        message.append(System.getProperty("OPatch.RUNNING_DIR")).append(File.separator);
        if (OPatchEnv.isWindows()) {
            message.append("opatchauto.bat ");
        } else {
            message.append("opatchauto ");
        }
        String cmd = OPatchEnv.getOriginalCommand();
        cmd = cmd.replaceAll("-auto", "");
        if (option != null) {
            message.append(oper).append(" -").append(cmd);
        } else {
            message.append(cmd);
        }
        OLogger.warn("OUI-68023", new Object[]{message.toString()});
    }

    public static void apply() {
        FMWHandler.invokeOPatchAutoScriptCheck("apply", null);
        FMWHandler.run(true);
    }

    public static void rollback() {
        FMWHandler.invokeOPatchAutoScriptCheck("rollback", null);
        FMWHandler.run(false);
    }

    private static void run(boolean apply) {
        try {
            OPatchACL.setLocal(FMWHANDLER, true);
        }
        catch (IllegalAccessException e2) {
            OLogger.printStackTrace(e2);
        }
        FMWClient[] allClients = FMWHandler.getAllClients(FMWHandler.getPatch(apply), apply, true);
        if (allClients == null || allClients.length == 0) {
            String msg = OLogger.getString("OUI-67727");
            throw new RuntimeException(msg);
        }
        FMWHandler.info("[FMW] Running prereq for FMW ...");
        FMWHandler.allPrereqs(allClients, apply);
        FMWHandler.info("[FMW] Running Oracle Home Operation ...");
        String name = apply ? OPatchSession.APPLY.getSessionName() : OPatchSession.ROLLBACK.getSessionName();
        String oh = OPatchEnv.getOracleHome();
        String id = OPatchEnv.getRollbackPatchid();
        String loc = OPatchEnv.getPatchloc();
        StringBuffer sb = new StringBuffer("[FMW] Running [").append(apply ? "APPLY" : "ROLLBACK").append("]\n");
        sb.append("OracleHome [").append(oh).append("]\n");
        sb.append("Patch ID   [").append(id).append("]\n");
        sb.append("Patch Loc  [").append(loc).append("]\n");
        FMWHandler.info(sb.toString());
        try {
            if (OPatchEnv.isWindows()) {
                System.setProperty("OPatch.NO_FUSER", "true");
            }
            if (apply) {
                OPatchSession.APPLY.process(loc, oh);
            } else {
                OPatchSession.ROLLBACK.process(loc, id, oh);
            }
        }
        catch (ExitOPatchException e3) {
            OLogger.error("OUI-67005", new Object[]{name, e3.getMessage()});
            OLogger.info("OUI-67035");
            String errMsg = OLogger.getString("OUI-67005", new Object[]{name, e3.getMessage()});
            throw new RuntimeException(errMsg);
        }
        catch (Error e4) {
            OLogger.error("OUI-67073", new Object[]{name, e4.getMessage()});
            OLogger.info("OUI-67036");
            String cookedPatchID = OPatchEnv.getCookedPatchID();
            try {
                if (apply) {
                    ApplySession.restoreOH(oh, cookedPatchID, name, true);
                } else {
                    RollbackSession.restoreOH(oh, cookedPatchID, name, true);
                }
            }
            catch (Throwable t) {
                OLogger.error("OUI-67115", new Object[]{oh});
            }
            throw new RuntimeException();
        }
        try {
            if (!OPatchEnv.isReport() && apply) {
                PatchObject pOriginal = new PatchObject(loc);
                allClients = FMWHandler.getAllClients(OPatchEnv.getPatchFilemapInfoLoc(oh, pOriginal.getPatchID()), false, apply, false, allClients);
            }
            OPatchStateManagerFactory.getInstance().setCurrentState("Deployment");
            FMWHandler.allConfigure(allClients, apply);
        }
        catch (NoClassDefFoundError e5) {
            OLogger.printStackTrace(e5);
            String msg = OLogger.getString("OUI-67719", new Object[]{e5.getMessage()});
            throw new RuntimeException(msg);
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            RuntimeException e6 = new RuntimeException(t);
            throw e6;
        }
        FMWHandler.info("[FMW] Done.");
    }

    private static void allPrereqs(FMWClient[] allClients, boolean apply) {
        if (allClients == null || allClients.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < allClients.length; ++i2) {
            if (allClients[i2].bipOperation()) {
                OLogger.println("[FMW] Skip prereq for BIP artifact as it is not supported in command line mode.");
                continue;
            }
            OPatchStateManagerFactory.getInstance().setCurrentState("DeploymentPreCheck");
            FMWHandler.prereq(allClients[i2], apply);
        }
    }

    private static void prereq(FMWClient client, boolean apply) {
        try {
            client.prereq(apply);
        }
        catch (RuntimeException e2) {
            client.close();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void allConfigure(FMWClient[] allClients, boolean apply) {
        block7: {
            RuntimeException re2;
            if (allClients == null || allClients.length == 0) {
                return;
            }
            boolean isError = false;
            String errorMsg = "\n";
            try {
                for (int i2 = 0; i2 < allClients.length; ++i2) {
                    try {
                        FMWHandler.configure(allClients[i2], apply, false);
                        continue;
                    }
                    catch (Throwable t) {
                        isError = true;
                        t.printStackTrace();
                        errorMsg = errorMsg + t.getMessage() + "\n";
                    }
                }
                Object var7_6 = null;
                allClients[0].close();
                if (!isError) break block7;
                re2 = new RuntimeException(errorMsg);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                allClients[0].close();
                if (isError) {
                    RuntimeException re2 = new RuntimeException(errorMsg);
                    throw re2;
                }
                throw throwable;
            }
            throw re2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configure(FMWClient client, boolean apply, boolean close) {
        try {
            FMWHandler.info("[FMW] Running configuration steps ...");
            if (client.bipOperation()) {
                OLogger.println("[FMW] BIP Operation is not supported in command line mode. Skip BIP artifact.");
            } else {
                client.configure(apply);
            }
            Object var4_3 = null;
            if (close) {
                client.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (close) {
                client.close();
            }
            throw throwable;
        }
    }

    protected static boolean applied(String loc) {
        PatchObject po = null;
        try {
            po = new PatchObject(loc);
        }
        catch (Exception e2) {
            throw new RuntimeException(OLogger.getString("OUI-67100", new Object[]{"OPatch", loc}), e2);
        }
        boolean applied = false;
        try {
            if (PrereqAPI.getInstalledOneOff(OPatchEnv.getOracleHome(), po.getPatchID()) != null) {
                applied = true;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("[FMW] Error in getting installed one-offs " + t.getMessage(), t);
        }
        return applied;
    }

    public static void deploy() {
        FMWHandler.invokeOPatchAutoScriptCheck("apply", "-deploy");
        String loc = OPatchEnv.getPatchloc();
        if (loc == null || loc.equals("")) {
            loc = FMWHandler.norm(FMWHandler.getPatch(false));
        }
        if ("".equals(loc)) {
            throw new RuntimeException("[FMW] For 'deploy', Please use '-id' option to provide the number of already applied patch\nor '-ph' option to provide the applied patch location.");
        }
        if (!FMWHandler.applied(loc)) {
            throw new RuntimeException("[FMW] Patch is not applied. Please apply the patch first.");
        }
        FMWHandler.info("[FMW] [Configure] Patch Location [" + loc + "]");
        FMWClient[] allClients = FMWHandler.getAllClients(loc, true, false);
        if (allClients == null || allClients.length == 0) {
            String postScript = PatchObject.getPostScriptFilePath(loc);
            String warnMsg = "";
            if (new File(postScript).exists()) {
                OPatchEnv.setPatchloc(loc);
                OUSession.runpostscript(OPatchEnv.getOracleHome());
                OLogger.warn("OUI-67727");
            } else {
                OLogger.warn("OUI-68026");
            }
        }
        boolean isError = false;
        String errorMsg = "\n";
        FMWHandler.allPrereqs(allClients, true);
        FMWHandler.allConfigure(allClients, true);
    }

    public static void undeploy() {
        FMWHandler.invokeOPatchAutoScriptCheck("rollback", "-undeploy");
        String loc = FMWHandler.norm(FMWHandler.getPatch(true));
        if ("".equals(loc)) {
            throw new RuntimeException("[FMW] For 'undeploy', Please use '-ph' option to provide the location of the patch");
        }
        if (FMWHandler.applied(loc)) {
            throw new RuntimeException("[FMW] Patch is still in inventory. Please rollback the patch first.");
        }
        FMWHandler.info("[FMW] [Configure] Patch Location [" + loc + "]");
        FMWClient[] allClients = FMWHandler.getAllClients(loc, false, true);
        if (allClients == null || allClients.length == 0) {
            String msg = OLogger.getString("OUI-67727");
            throw new RuntimeException(msg);
        }
        boolean isError = false;
        String errorMsg = "\n";
        FMWHandler.allPrereqs(allClients, false);
        FMWHandler.allConfigure(allClients, false);
    }

    private static String getPatch(boolean apply) {
        String loc = null;
        if (apply) {
            loc = OPatchEnv.getPatchloc();
        } else {
            String pid = FMWHandler.norm(OPatchEnv.getRollbackPatchid());
            if (!"".equals(pid)) {
                loc = OPatchEnv.getPatchFilemapInfoLoc(OPatchEnv.getOracleHome(), pid);
            }
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        FMWClient client = FMWHandler.getClient(null);
        try {
            client.prereq();
            client.start();
            Object var2_1 = null;
            client.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            client.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        FMWClient client = FMWHandler.getClient(null);
        try {
            client.prereq();
            client.stop();
            Object var2_1 = null;
            client.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            client.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startComposite() {
        FMWClient client = FMWHandler.getClient(null);
        try {
            client.prereq();
            if (!OPatchEnv.isReport()) {
                client.startComposite();
            } else if (client.lifeCycleOperation()) {
                FMWHandler.skip("START COMPOSITE");
            }
            Object var2_1 = null;
            client.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            client.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopComposite() {
        FMWClient client = FMWHandler.getClient(null);
        try {
            client.prereq();
            if (!OPatchEnv.isReport()) {
                client.stopComposite();
            } else if (client.lifeCycleOperation()) {
                FMWHandler.skip("STOP COMPOSITE");
            }
            Object var2_1 = null;
            client.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            client.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listComposites() {
        FMWClient client = FMWHandler.getClient(null);
        try {
            if (!OPatchEnv.isReport()) {
                client.listComposites();
            } else {
                FMWHandler.skip("LIST COMPOSITES");
            }
            Object var2_1 = null;
            client.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            client.close();
            throw throwable;
        }
    }

    private static FMWClient[] getAllClients(String loc, boolean isInterview, boolean apply, boolean dryRun) {
        return FMWClientFactory.getAllClients(OPatchEnv.getOracleHome(), loc, isInterview, apply, dryRun);
    }

    private static FMWClient[] getAllClients(String loc, boolean apply, boolean dryRun) {
        return FMWClientFactory.getAllClients(OPatchEnv.getOracleHome(), loc, apply, dryRun);
    }

    private static FMWClient[] getAllClients(String loc, boolean isInterview, boolean apply, boolean dryRun, FMWClient[] originalClients) {
        FMWClient[] clients = FMWClientFactory.getAllClients(OPatchEnv.getOracleHome(), loc, isInterview, apply, dryRun);
        for (int i2 = 0; i2 < clients.length; ++i2) {
            if (!clients[i2].lifeCycleOperation()) continue;
            for (int j2 = 0; j2 < originalClients.length; ++j2) {
                if (!clients[i2].equals(originalClients[j2]) || !clients[i2].getActionType().equalsIgnoreCase("start") || !originalClients[j2].operationOnAdminServer()) continue;
                clients[i2] = originalClients[j2];
                clients[i2].resetAndIgnorePreStepsForLifeCycleOperation();
            }
        }
        return clients;
    }

    private static FMWClient getClient(String loc) {
        return FMWClientFactory.getClient(OPatchEnv.getOracleHome(), loc);
    }

    private static void info(String s) {
        OLogger.printlnOnLog(s);
    }

    private static void skip(String s) {
        OLogger.println("[FMW] [Report] Skipping operation [" + s + "]");
    }

    private static String norm(String s) {
        return s == null ? "" : s.trim();
    }
}

