/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchObject;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchlogger.OLogger;

class DeploymentState
extends OPatchState {
    public DeploymentState() {
        super(20, 121, 199, "Deployment", OLogger.CONFIG, false);
    }

    public void setPresent(PatchObject[] po) {
        FMWClient[] allClients = new FMWClient[]{};
        allClients = OPatchEnv.getFMWClients();
        this.present = false;
        if (OPatchEnv.getisAuto() && OPatchEnv.isBeaHome() && allClients.length > 0) {
            this.present = true;
        }
    }

    protected String getStateAssociatedMessage(String oracleHome, PatchObject[] patchObject) {
        StringBuffer buff = new StringBuffer("");
        FMWClient[] allClients = new FMWClient[]{};
        allClients = OPatchEnv.getFMWClients();
        int numberOfLDIFF = 0;
        int numberOfSOAComposite = 0;
        int numberOfBIP = 0;
        for (int i2 = 0; i2 < allClients.length; ++i2) {
            if (allClients[i2].lifeCycleOperation()) {
                if (allClients[i2].getActionType().equalsIgnoreCase("Stop")) {
                    buff.append("Stop all related servers\n");
                }
                if (allClients[i2].getActionType().equalsIgnoreCase("Start")) {
                    buff.append("Start all related servers\n");
                }
                if (allClients[i2].getActionType().equalsIgnoreCase("Restart")) {
                    buff.append("Restart all related servers\n");
                }
            }
            if (allClients[i2].soaCompositeOperation()) {
                ++numberOfSOAComposite;
            }
            if (allClients[i2].bipOperation()) {
                ++numberOfBIP;
            }
            if (!allClients[i2].ldiffOperation()) continue;
            ++numberOfLDIFF;
        }
        if (numberOfSOAComposite != 0) {
            buff.append("Deploy " + numberOfSOAComposite + " SOA Composite(s)");
            if (numberOfBIP + numberOfLDIFF != 0) {
                buff.append(";\n");
            }
        }
        if (numberOfLDIFF != 0) {
            buff.append("Deploy " + numberOfLDIFF + " LDiff(s)");
            if (numberOfBIP != 0) {
                buff.append(";\n");
            }
        }
        if (numberOfBIP != 0) {
            buff.append("Deploy " + numberOfBIP + " BIP(s)");
        }
        buff.append(".");
        return buff.toString();
    }
}

